/* Szkic GPS
 * Za pomocą diody LED wskazuje na której półkuli znajduje się Twój moduł GPS
 */

#include "TinyGPS++.h"

// Zmień na port szeregowy, którego używa Twój GPS (Serial, Serial1, itd.)
#define GPS_SERIAL Serial

TinyGPSPlus gps; // Stwórz obiekt TinyGPS++

#define HEMISPHERE_PIN LED_BUILTIN

void setup()
{
  GPS_SERIAL.begin(9600); // Urządzenie GPS często działa z prędkością 9600
  pinMode(HEMISPHERE_PIN, OUTPUT);
  digitalWrite(HEMISPHERE_PIN, LOW); // Na początu działania programu, zgaś diodę LED
}

void loop()
{
  while (GPS_SERIAL.available())
  {
    // Za pomocą encode() przeanalizuj każdy bajt
    // Jeśli metoda zwraca "true",
    // sprawdź nową pozycję
    if (gps.encode(GPS_SERIAL.read()))
    {
      if (gps.location.isValid()) 
      {
        if (gps.location.lat() < 0) // Południowa półkula?
          blink(HEMISPHERE_PIN, 1);
        else
          blink(HEMISPHERE_PIN, 2);
      } else // Panika
        blink(HEMISPHERE_PIN, 5);
      delay(5000); // Czekaj 5 s
    }
  }
}

void blink(int pin, int count)
{
  for (int i = 0; i < count; i++)
  {
    digitalWrite(pin, HIGH);
    delay(250);
    digitalWrite(pin, LOW);
    delay(250);
  }
}
