/*
* szkic SerialParsing
 * Miganie diodą LED z częstotliwością równą wartości odebranej cyfry
*/

int blinkDelay = 0;

void setup()
{
  Serial.begin(9600); // Inicjalizacja porty szeregowego do wysyłania i odbierania danych z prędkością 9600
  pinMode(LED_BUILTIN, OUTPUT); // ustawienie pinu jako wyjście
}

const int maxChars = 5;    // stała określająca maksymalną długość łańcucha zakończonego 0
char strValue[maxChars+1]; // Tablica musi być odpowiednio duża, aby moć przechowywać cyfry i końcowy znak null.
int idx = 0;               // indeks tablicy przechowujący odebrane cyfry

void loop()
{
  if( Serial.available())
  {
    char ch = (char) Serial.read();
    if( idx < maxChars && isDigit(ch) ){
      strValue[idx++] = ch; // Dodaj znak ASCII do tablicy znaków.
    }
    else
    {
      // Kiedy bufor jest pełny lub zostanie odczytany pierwszy niebędący cyfrą znak,
      strValue[idx] = 0;           // zakończ łańcuch zerem,
      blinkDelay = atoi(strValue); // użyj atoi, aby zamienić łańuch na liczbę.
      Serial.println(blinkDelay);
      idx = 0;
    }
  }
  blink();
}

// miganie diodą LED z częstotliwością określoną przez blinkDelay
void blink()
{
  digitalWrite(LED_BUILTIN, HIGH);
  delay(blinkDelay); // długość pauzy zależna od wartości blinkDelay
  digitalWrite(LED_BUILTIN, LOW);
  delay(blinkDelay);
}
