/*
 * Szkic SerialReceiveMultipleFields
 * Wymagany to format wiadomości to: H,12,345,678
 * Kod wymaga znaku nowej linii, aby móc określić koniec wiadomości
 * Ustaw wysyłanie znaku nowej linii w monitorze portu szeregowego
 */

const int NUMBER_OF_FIELDS = 3; // Ilość danych oddzielonych przecinkiem jaka będzie odbierana
int values[NUMBER_OF_FIELDS];   // Tablica przechowująca wszystkie dane

void setup()
{
  Serial.begin(9600); // Inicjalizacja portu szeregowego do wysyłania i odbierania danych z prędkością 9600
}

void loop()
{
  if ( Serial.available())
  {
    if (Serial.read() == 'H') {

      // odczyt wartości
      for (int i = 0; i < NUMBER_OF_FIELDS; i++)
      {
        values[i] = Serial.parseInt();
      }

      // Wyświetlanie oddzielonych przecinkiem wartości
      Serial.print(values[0]); // Pierwsza wartość

      // Wyświetlanie pozostałych wartości z przecinkiem na początku
      for (int i = 1; i < NUMBER_OF_FIELDS; i++) 
      {
        Serial.print(","); Serial.print(values[i]); 
      }
      Serial.println();
    }
  }
}
