/*
 * Szkic SerialReceive
 * Miganie diodą LED z częstotliwością równą wartości odebranej cyfry
*/
int blinkDelay = 0;  // Zmienna przechowująca długość przerwy pomiędzy mignięciami

void setup()
{
  Serial.begin(9600); // Inicjalizacja portu szeregowego do wysyłania i odbierania danych z prędkością 9600
  pinMode(LED_BUILTIN, OUTPUT); // Ustawienie pinu jako wyjścia
}

void loop()
{
  if (Serial.available()) // Sprawdzenie, czy dostępny jest przynajmniej jeden znak
  {
    char ch = (char) Serial.read();
    if( isDigit(ch) ) // Czy jest to cyfra ASCII z zakresu od 0 do 9?
    {
      blinkDelay = (ch - '0');       // Zamiana wartości ASCII na wartość liczbową
      blinkDelay = blinkDelay * 100; // Pauza równa wartości cyfry pomnożonej przez 100
    }
  }
  blink();
}

// Miganie diodą LED z częstotliwością określoną przez blinkDelay
void blink()
{
  digitalWrite(LED_BUILTIN, HIGH);
  delay(blinkDelay); // Długość pauzy zależna od wartości blinkDelay
  digitalWrite(LED_BUILTIN, LOW);
  delay(blinkDelay);
}
