// Szkic bitfun
// Pokazuje jak stosować funkcje na bitach.

byte flags = 0; // Poniższe przykłady ustawiają, czyszczą lub czytają wartość bitów w zmiennej flags

// ustawienie bitu
void setFlag(int flagNumber)
{
   bitSet(flags, flagNumber);
}

// Czyszczenie bitu
void clearFlag(int flagNumber)
{
   bitClear(flags, flagNumber);
}

// Odczytanie wartości bitu na danej pozycji

int getFlag(int flagNumber)
{
   return bitRead(flags, flagNumber);
}

void setup()
{
  Serial.begin(9600);
}

void loop()
{
    flags = 0;   // Wyczyszczenie wszystkich flag
    showFlags();
    setFlag(2);  // uUstawienie kilku flag
    setFlag(5);
    showFlags();
    clearFlag(2);
    showFlags();

    delay(10000); // Bardzo długa pauza
}

// Pokazanie ustawionych flag
void showFlags()
{
    for(int flag=0; flag < 8; flag++)
    {
      if (getFlag(flag) == true)
         Serial.print("* bit ustawiony dla flagi ");     
      else
         Serial.print("bit wyczyszczony dla flagi ");

      Serial.println(flag);
    }
    Serial.println();
}
