/*
 * Szkic pushbutton2
 * Przełącznik podłączony do pinu 2 zapala wbudowaną diodę LED
 */

const int inputPin = 2;         // Określenie pinu wejścia dla przycisku

void setup() 
{
  pinMode(LED_BUILTIN, OUTPUT);     // Ustawienie pinu wbudowanej diody LED jako wyjścia
  pinMode(inputPin, INPUT_PULLUP);  // Ustawienie pinu przycisku jako wejścia
}

void loop()
{
  int val = digitalRead(inputPin);  // Odczytaj wartość wejściową
  if (val == LOW)                    // Wejście ma stan niski, kiedy przycisk jest wciśnięty
  {
    // Wykonaj poniższe polecenia, gdy val jest równa LOW.
    digitalWrite(LED_BUILTIN, HIGH); //  Włącz diodę LED, kiedy przycisk jest wciśnięty
  }
  else
  {
    // W przeciwnym wypadku, gdy pin nie ma stanu niskiego, wykonaj poniższe polecenia
    digitalWrite(LED_BUILTIN, LOW);  // Wyłącz diodę LED
  }
}
