/*
 * szkic speaker_photoresistor
 * Głośnik z fotorezystorem
 */
const int outputPin = 9;  // Głośnik podłączony do cyfrowego pinu 9
const int sensorPin = A0; // podłącz czujnik do analogowego pinu 0

const int low  = 200;
const int high = 800;

const int minDuration = 1;  // 1 ms włączony, 1 ms wyłączony (500 Hz)
const int maxDuration = 10; // 1 ms włączony, 1 ms wyłączony (50 Hz)

void setup()
{
  pinMode(outputPin, OUTPUT); // Ustawienie pinu głośnika jako wyjścia
}

void loop()
{
  int sensorReading = analogRead(sensorPin); // Odczytaj wejście analogowe
  int delayval = map(sensorReading, low, high, minDuration, maxDuration);
  delayval = constrain(delayval, minDuration, maxDuration);
  
  digitalWrite(outputPin, HIGH); // Włącz głośnik
  delay(delayval);               // Opóźnienie zależy od natężenia światła
  digitalWrite(outputPin, LOW);  // Wyłącz głośnik
  delay(delayval);
}
