/*
 * Szkic xml
 * Pobiera dane XML z http://openweathermap.org/,
 * odczytuje temperaturę z pola:  <temperature value="44.89"
 * i zapisuje ją na analogowym porcie wyjścia
*/

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

char serverName[] = "api.openweathermap.org";
String request = "GET /data/2.5/weather?q=London,UK&units=imperial&mode=xml&APPID=";
String APIkey = "TWÓJ_KLUCZ_API"; // Zobacz tekst

void setup()
{
  Serial.begin(9600);
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while (1); // zatrzymanie programu
  }
}

void loop()
{
  if (client.connect(serverName, 80) > 0)
  {
    Serial.println("Połączono");
    // Pobranie informacji o pogodzie
    client.println(request + APIkey + " HTTP/1.0");
    client.print("Host: "); client.println(serverName);
    client.println("Połączenie: zamknięte");
    client.println();
  }
  else
  {
    Serial.println(" nieudane połączenie");
  }
  
  if (client.connected())
  {
    if (client.find("<temperature value=") )
    {
      int temperature = client.parseInt();
      Serial.print("Temperatura: "); Serial.println(temperature);
    }
    else
      Serial.print("Nie udało się odnaleźć pola z wartością temperatury");

    if (client.find("<humidity value="))
    {
      int humidity = client.parseInt();
      Serial.print("Wilgotność: "); Serial.println(humidity);
    }
    else
      Serial.print("Nie udało się odnaleźć pola z wartością wilgotności");
  }
  else 
  {
    Serial.println("Rozłączono");
  }
  
  client.stop();
  client.flush();
  delay(60000); // Poczekaj minutę przed następną aktualizacją
}
