/*
 * szkic web_server_multi_page2
 * Odpowiada na żądania w adresie URL w celu wyświetlenia wartości cyfrowych i analogowych pinów wyjścia.
 * http://IP_ADDRESS/analogowy/   - wyświetla dane analogowych pinów.
 * http://IP_ADDRESS/cyfrowy/  - wyświetla dane cyfrowych pinów.
 */


// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek.
#include "USE_NINA.h"     // dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // dla płytek ESP8266

const int MAX_PAGE_NAME_LEN = 11;  // maksymalna liczba znaków w nazwie strony
char buffer[MAX_PAGE_NAME_LEN+1];  // nazwa strony + końcowy null

void setup() {
  Serial.begin(9600);
 
  if (!configureNetwork()) // uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while(1)
      delay(0); // zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  server.begin();
}

#define MSG_DELAY 10000
void loop() {
  static unsigned long nextMsgTime = 0;
  if (millis() > nextMsgTime)
  {
    Serial.print("Odwiedź http://");
    Serial.print(getIP()); Serial.println("/sterowanie/?pinD2=1");
    nextMsgTime = millis() + MSG_DELAY;
  }

  maintain(); // utrzymanie dzierżawy DHCP, jeśli jest to konieczne

  client = server.available();
  if (client) 
  {
    while (client.connected()) 
    {
      if (client.available()) 
      {
        if( client.find("GET ") ) 
        {
          // wyszukanie nazwy strony
          memset(buffer,0, sizeof(buffer)); // wyczyszczenie buforu
          if(client.find( "/"))    
            if(client.readBytesUntil('/', buffer, MAX_PAGE_NAME_LEN ))  
            {  
              if(strcmp(buffer, "analogowy") == 0)
                showAnalog();
              else if(strcmp(buffer, "cyfrowy") == 0)
                showDigital();
              // Dodaj ten kod dla nowej strony o nazwie: sterowanie
              else if(strcmp(buffer, "sterowanie") == 0)
                doUpdate();
              else
                unknownPage(buffer);
            }       
        }
        Serial.println();
        break; // wyjście z pętli while()
      }
    }
    // czas dla przeglądarki na odebranie danych
    delay(100);
    client.stop();
  }
}

void showAnalog()
{
  Serial.println("analogowy");
  sendHeader();
  client.println("<h1>Piny analogowe</h1>");
  // wyświetlenie wartości każdego analogowego pinu wejścia
  for (int i = 0; i < 6; i++) 
  {
    client.print("pin analogowy ");
    client.print(i);
    client.print(" = ");
    client.print(analogRead(i));
    client.println("<br />");
  }
}

void showDigital()
{
  Serial.println("cyfrowy");
  sendHeader();
  client.println("<h1>Piny cyfrowe</h1>");
  // wyświetlenie wartości każdego cyfrowego pinu wejścia
  for (int i = 2; i < 8; i++) 
  {
    pinMode(i, INPUT_PULLUP);
    client.print("pin cyfrowy ");
    client.print(i);
    client.print(" to ");
    if(digitalRead(i) == LOW)
      client.print("HIGH");
    else
      client.print("LOW");
    client.println("<br />");
  }
  client.println("</body></html>");
}

void unknownPage(char *page)
{
  sendHeader();
  client.println("<h1>Strona nieznana</h1>");
  client.print(page);
  client.println("<br />");
  client.println("Rozpoznane strony to:<br />");
  client.println("/analogowy/<br />");
  client.println("/cyfrowy/<br />");
  client.println("/sterowanie/<br />");
  client.println("</body></html>");
}

void sendHeader()
{
  // wysłanie standardowego nagłówka odpowiedzi HTTP
  client.println("HTTP/1.1 200 OK");
  client.println("Typ zawartości: text/html");
  client.println();
  client.println("<html><head><title>Przykład: Serwer z wieloma stronami</title>");
  client.println("<body>");
}

void doUpdate()
{
  Serial.println("update");
  sendHeader();
  // wyszukanie symboli rozpoczynających się słowem "pin" i zatrzymanie na pierwszej pustej linii
  while (client.findUntil("pin", "\n\r")) 
  {
    char type = client.read(); // D lub A
    int pin = client.parseInt();
    int val = client.parseInt();
    if ( type == 'D') 
    {
      client.print("Cyfrowy pin ");
      pinMode(pin, OUTPUT);
      digitalWrite(pin, val);
    }
    else if ( type == 'A') 
    {
      client.print("Analogowy pin ");
      analogWrite(pin, val);
    }
    else 
    {
      client.print("Typ nieznany ");
      Serial.print(type);
    }
    client.print(pin);
    client.print("=");
    client.println(val);
  }
  client.println("</body></html>");
}
