/*
 * Szkic handle_requests
 * Odpowiada na żądania w URL, które dotyczą zmiany cyfrowych i analogowych pinów wyjścia,
 * pokazuje liczbę zmienionych pinów oraz wartość analogowych pinów wejścia
 * Na przykład:
 *   wysłanie http://IP_ADDRESS/?pinD2=1 włącza cyfrowy pin 2,
 *   wysłanie http://IP_ADDRESS/?pinD2=0 wyłącza cyfrowy pin 2
 * Ten szkic pokazuje również jak analizować tekst za pomocą klasy Stream
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

void setup() {
  Serial.begin(9600);
  
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while(1)
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  server.begin();
}

#define MSG_DELAY 10000
void loop() {
  static unsigned long nextMsgTime = 0;
  if (millis() > nextMsgTime)
  {
    Serial.print("Spróbuj http://");
    Serial.print(getIP()); Serial.println("?pinD2=1");
    nextMsgTime = millis() + MSG_DELAY;
  }

  maintain(); // Utrzymanie dzierżawy DHCP, jeśli jest to konieczne

  client = server.available();
  if (client) 
  {
    while (client.connected()) 
    {
      if (client.available()) 
      {
        // Liczniki służące do pokazania liczby zmienionych pinów
        int digitalRequests = 0;  
        int analogRequests = 0;
        if( client.find("GET /") ) // Wyszukiwanie słowa 'GET'
        {  
          // Wyszukiwanie symboli zaczynających się słowem "pin" i zatrzymanie się na końcu linii
          while(client.findUntil("pin", "\r\n"))
          {  
            char type = client.read(); // D lub A
            // Następna liczba całkowita ASCII w strumieniu to numer pinu
            int pin = client.parseInt(); 
            int val = client.parseInt(); // Następna liczba całkowita to wartość
            if( type == 'D') 
            {
              Serial.print("Cyfrowy pin ");
              pinMode(pin, OUTPUT);
              digitalWrite(pin, val);
              digitalRequests++;
            }
            else if( type == 'A')
            {
              Serial.print("Analogowy pin ");
              analogWrite(pin, val);
              analogRequests++;
            }
            else 
            {
              Serial.print("Nieobsługiwany typ ");
              Serial.print(type);
            }
            Serial.print(pin);
            Serial.print("=");
            Serial.println(val);
          }
        }
        Serial.println();

        // Funkcja findUntil wykryła pustą linię (znak lf, po którym występuje znak cr)
        // co oznacza koniec żądania http i  może być wysłana odpowiedź
        // Wyślij standardowy nagłówek odpowiedzi HTML
        client.println("HTTP/1.1 200 OK");
        client.println("Typ zawartości: text/html");
        client.println();

        // Liczba pinów zmienionych przez żądanie

        client.print("liczba zmienionych pinów cyfrowych: ");
        client.print(digitalRequests);
        client.println("<br />");
        client.print("liczba zmienionych pinów analogowych: ");
        client.print(analogRequests);
        client.println("<br />");
        client.println("<br />");

        // Wartość każdego analogowego pinu wejścia
        for (int i = 0; i < 6; i++) {
          client.print("analogowe wejście ");
          client.print(i);
          client.print(" to ");
          client.print(analogRead(i));
          client.println("<br />");
        }
        break; // Wyjście z pętli while()
      }
    }
    // Czas dla przeglądarki na odebranie danych
    delay(100);
    client.stop();
  }
}
