/*
 * Szkic i2c_expander
 * Wykorzystuje ekspander wyprowadzeń I2C do sterowania wykresem słupkowym
 * Włącza proporcjonalną do wartości odczytu z czujnika analogowego liczbę diod LED
 * Zobacz recepturę 7.6
 */

#include <Wire.h>

const int address = 0x20; // Adres PCF8574; dla PCF8574A użyj 0x38 
const int NbrLEDs = 8;

const int analogInPin = A0; // Pin analogowego wejścia podłączony do rezystora nastawnego


int sensorValue = 0;    // Wartość odczytana z czujnika
int ledLevel = 0;       // Wartość czujnika zamieniona na 'słupki' z diod LED
int ledBits = 0;        // Bity dla każdej diody LED, 1 oznacza włączoną diodę

void setup()
{
  Wire.begin(); // Ustawienie wsparcia I2C dla Arduino 
}

void loop()
{
  sensorValue = analogRead(analogInPin);             // Odczyt wartości analogowej
  ledLevel = map(sensorValue, 0, 1023, 0, NbrLEDs);  // Skalowanie odczytu do liczby diod LED
  for (int led = 0; led < NbrLEDs; led++)
  {
    Wire.beginTransmission(address);
    if (led < ledLevel)
    {
      Wire.write(~ (1 << led));
    }
    else
    {
      Wire.write(0xFF); // Wyłączenie wszystkich diod LED
    }
    Wire.endTransmission(); // Wysłanie wartości do I2C
  }
}
