/*
 * Szkic rtc_set_time
 * Ustawia czas RTC za pomocą portu szeregowego; jest to uproszczona wersja przykładu TimeSerial z biblioteki Time
 *
 * Ustaw czas przez wysłanie litery T i cyfr oznaczających liczbę sekund, które upłynęły do 1 stycznia 1970,
 * na przykład T1569888000 to 12:00, 1 października 2019
 */


#include <TimeLib.h>
#include <Wire.h>
#include <DS1307RTC.h>  // Podstawowa biblioteka DS1307 zwracająca aktualną godzinę jako time_t

void setup()  {
  Serial.begin(9600);
  setSyncProvider(RTC.get);   // Funkcja pobierająca czas z zegara RTC
  if(timeStatus()!= timeSet)
     Serial.println("Nie można zsynchronizować z RTC");
  else
     Serial.println("RTC ma czas systemowy");
}

void loop()
{
  if(Serial.available())
  {
     processSyncMessage();
  }
   digitalClockDisplay();
   delay(1000);
}

// Dodanie początkowych zer do cyfr
String padDigits(int digit)
{
  String str = String("0") + digit; // Dodanie zera przez cyfrą
  return str.substring(str.length() - 2); // Usunięcie wszystkich znaków, oprócz dwóch ostatnich
}

void digitalClockDisplay(){
  String timestr = String(hour()) + ":" + padDigits(minute()) +
                   ":" + padDigits(second());
  Serial.println(timestr);
  
  String datestr = String(year()) + "-" + padDigits(month()) + 
                   "-" + padDigits(day()); 
  Serial.println(datestr);
}

#define TIME_HEADER  'T'   // Nagłówek wiadomości synchronizacji czasu

// Analiza wiadomości z godziną
void processSyncMessage() {

  time_t pctime = 0;

  if(Serial.find(TIME_HEADER)) {
     pctime = Serial.parseInt();
     setTime(pctime); // Ustawienie zegara na czas otrzymany z portu szeregowego
     RTC.set(pctime); // Ustawienie zegara RTC

  }

}
