/*
  Szkic ir_remote_detector
  Odbiornik IR jest podłączony do pinu 2
  Wbudowana dioda LED zmienia swój stan za każdym razem, gdy przycisk na pilocie zostaje wciśnięty
 */

#include <IRremote.h>           // Dodanie biblioteki do szkicu

const int irReceiverPin = 2;    // Pin odbiornika IR
const int ledPin = LED_BUILTIN;

IRrecv irrecv(irReceiverPin);   // Utworzenie obiektu IRrecv
decode_results decodedSignal;   // Zmienna przechowująca odczyty z detektora podczerwieni

void setup()
{
  pinMode(ledPin, OUTPUT);
  irrecv.enableIRIn();          // Uruchomienie odbiornika
  Serial.begin(9600);
}

int lightState = LOW;          // Zmienna przechowująca stan diody LED
unsigned long last = millis();  // Zmienna przechowująca czas otrzymania ostatniej wiadomości IR

void loop()
{
  if (irrecv.decode(&decodedSignal) == true) // Prawda, jeśli wiadomość została odebrana
                                             
  {
    if (millis() - last > 250) {       // Czy minęło 1/4 sekundy od ostatniej wiadomości?
      Serial.println(decodedSignal.value);
      if (lightState == LOW)
        lightState = HIGH;
      else
        lightState = LOW;
      digitalWrite(ledPin, lightState);
    }
    last = millis();
    irrecv.resume();                         // Czekanie na kolejną wiadomość
  }
}
