/*
 * Szkic matrix_mpx 
 *
 * Sekwencja zapalająca po kolei wszystkie  diody LED, począwszy od pierwszej kolumny i pierwszego wiersza, aż do ostatnich
 * Dzięki multipleksowaniu 64 diody LED są sterowane za pomocą 16 pinów
 */

const int columnPins[] = {2, 3, 4, 5, 6, 7, 8, 9};
const int rowPins[]    = {10,11,12,A1,A2,A3,A4,A5};

int pixel       = 0; // 0 do 63 diod LED w tablicy
int columnLevel = 0; // Wartość piksela zamieniona na kolumnę LED
int rowLevel    = 0; // Wartość piksela zamieniona na wiersz LED

void setup() 
{
  for (int i = 0; i < 8; i++)
  {
    pinMode(columnPins[i], OUTPUT);  // Ustawienie wszystkich pinów diod LED jako wyjścia
    pinMode(rowPins[i], OUTPUT);
  }
}

void loop() 
{
  pixel = pixel + 1;
  if(pixel > 63)
     pixel = 0;

  columnLevel = pixel / 8;  // Skalowanie do liczby kolumn
  rowLevel = pixel % 8;     // Oblicz wartość ułamkową

  for (int column = 0; column < 8; column++)
  {
    digitalWrite(columnPins[column], LOW);     // Podłączenie kolumny do masy
    for(int row = 0; row < 8; row++)
    {
      if (columnLevel > column)
      {
        digitalWrite(rowPins[row], HIGH);  // Podłączenie wszystkich diod LED w wierszu do napięcia
      }
      else if (columnLevel == column && rowLevel >= row)
      {
          digitalWrite(rowPins[row], HIGH);
      }
      else
      {
        digitalWrite(columnPins[column], LOW); // Wyłączenie wszystkich diod LED w wierszu
      }
      delayMicroseconds(300);    // Funkcja delay określa ramy czasowe (20 ms) dla 64 diod LED
      digitalWrite(rowPins[row], LOW);  // Wyłącz diodę LED
    }

    // Odłączenie kolumny od masy
    digitalWrite(columnPins[column], HIGH);   
  }
}
