/* Szkic vl6180x
 * Wyświetla odległość i zmienia częstotliwość migania diody LED,
 * w zależności od odległości obiektu od czujnika
 */
 
#include <Wire.h>
#include "Adafruit_VL6180X.h"

Adafruit_VL6180X sensor = Adafruit_VL6180X();

const int ledPin  = LED_BUILTIN; // Pin diody LED

void setup() {
  Serial.begin(9600);
  while (!Serial);

  if (! sensor.begin()) {
    Serial.println("Błąd inicjalizacji VL6180X");
    while (1);
  }
}

void loop() {

  // Odczytaj zakres i sprawdź status pod kątem błędów
  byte cm     = sensor.readRange();
  byte status = sensor.readRangeStatus();

  if (status == VL6180X_ERROR_NONE)
  {
    Serial.println(cm);

    digitalWrite(ledPin, HIGH);
    delay(cm * 10); // Każdy centymetr dodaje 10 ms do opóźnienia
    digitalWrite(ledPin, LOW);
    delay(cm * 10);

  }
  else
  {
    // Poważniejsze błędy, o których warto poinformować
    if  ((status >= VL6180X_ERROR_SYSERR_1) && (status <= VL6180X_ERROR_SYSERR_5)) {
      Serial.println("Błąd systemu");
    }
  }
  delay(50);
}
