/* Szkic gyro_9250
 * Odczytuje dane z żyroskopu i wyświetla prędkość na ekranie (stopnie/sekundę)
 */

#include "MPU9250.h"

//  Adres I2C IMU; jeśli poniższy adres nie zadziała, spróbuj 0x69
#define IMU_ADDRESS 0x68

MPU9250 IMU(Wire, IMU_ADDRESS); // Deklaracja obiektu IMU

void setup() {

  Serial.begin(9600);
  while(!Serial);

  // Inicjalizacja IMU
  int status = IMU.begin();
  if (status < 0) {
    Serial.println("Błąd inicjalizajci IMU");
    Serial.print("Błędna wartość: "); Serial.println(status);
    while(1); // Zatrzymanie szkicu
  }

  // Ustawienie pełnego zakresu żyroskopu: +/- 500 stopni/sekundę
  status = IMU.setGyroRange(MPU9250::GYRO_RANGE_500DPS);
  if (status < 0) {
    Serial.println("Nie udało się zmienić zakresu żyroskopu.");
    Serial.print("Błędna wartość: "); Serial.println(status);
  }
}

void loop() {

  IMU.readSensor();

  // Uzyskaj prędkość obrotową w radianach/sekundę
  float gx = IMU.getGyroX_rads();
  float gy = IMU.getGyroY_rads();
  float gz = IMU.getGyroZ_rads();

  // Wyświetl prędkość obrotową w stopniach/sekundę
  Serial.print("gx:");
  Serial.print(gx * RAD_TO_DEG, 4);
  Serial.print(",gy:");
  Serial.print(gy * RAD_TO_DEG, 4);
  Serial.print(",gz:");
  Serial.print(gz * RAD_TO_DEG, 4);
  Serial.println();
  delay(100);
}
