/*
 * Szkic Map
 * Skaluje  wartości odczytane z pinu analogowego tak, aby mieściły się w zakresie od 0 do 100
 * W rezultacie dioda LED miga z częstotliwością od 0 do 100 milisekund,
 * a pozycja pokrętła potencjometru wyświetlana jest w monitorze portu szeregowego w postaci procentowej
 */

const int potPin = A0;      // Pin wejścia potencjometru
int ledPin = LED_BUILTIN;  // Pin diody LED

void setup()
{
  pinMode(ledPin, OUTPUT);     // Ustawienie ledPin jako wyjścia
  Serial.begin(9600);
}

void loop() {
  int val;     // Wartość odczytana z czujnika
  int percent; // Przeskalowana wartość

  val = analogRead(potPin);        // Odczytanie napięcia z potencjometru (zakres val od 0 do 1023)
  percent = map(val,0,1023,0,100); // Wartość procentowa będzie wynosić od 0 do 100
  digitalWrite(ledPin, HIGH);      // Włączenie diody LED
  delay(percent);                  // Pauza równa wartości procentowej
  digitalWrite(ledPin, LOW);       // Wyłączenie diody LED
  delay(100 - percent);            // Czas wyłączenie diody LED jest równy 100 - minus czas włączenia
  Serial.println(percent);         // Wyświetlenie w monitorze portu szeregowego pozycji potencjometru w procentach 
}
