/*
  Szkic DisplayMoreThan5V
  W monitorze portu szeregowego wyświetla napięcie na pinie analogowym
  Ostrzeżenie - nie podłączaj więcej niż 5 V bezpośrednio do pinu Arduino
*/

const float referenceVolts = 5.0;  // Domyślna wartość odniesienia dla płytek 5 V
//const float referenceVolts = 3.3;  // Użyj tej linijki dla płytek 3,3V

const float R1 = 1000; // Wartość maksymalna napięcia - 10 V
const float R2 = 1000;
// Wartość określona w tabeli 5.4, zależna od dzielnika napięcia
const float resistorFactor = 1023.0 * (R2/(R1 + R2));  
const int batteryPin = 0; // +V bateria podłączona jest do analogowego pinu A0

void setup()
{
   Serial.begin(9600);
}

void loop()
{
   int val = analogRead(batteryPin);  // Odczyt wartości z czujnika
   float volts = (val / resistorFactor) * referenceVolts; // Obliczanie napięcia
   Serial.println(volts);  // Wyświetlenie wartości w woltach
}
