//Przesyłanie danych pogodowych do serwisu ThingSpeak

// Biblioteki
#include <Adafruit_CC3000.h>
#include <SPI.h>
#include "DHT.h"
#include <avr/wdt.h> //biblioteka watchdoga

// Deklaracja pinów połączonych z chipem CC3000
#define ADAFRUIT_CC3000_IRQ   3
#define ADAFRUIT_CC3000_VBAT  5
#define ADAFRUIT_CC3000_CS    10

// Czujnik temperatury i wilgotnosci (typ i nr pinu)
#define DHTPIN 7
#define DHTTYPE DHT11

// Instancja CC3000
Adafruit_CC3000 cc3000 = Adafruit_CC3000(ADAFRUIT_CC3000_CS, ADAFRUIT_CC3000_IRQ, ADAFRUIT_CC3000_VBAT,
SPI_CLOCK_DIV2); // tę szybkość zegara można zmieniać

// Parametry WLAN
#define WLAN_SSID       "Livebox-BF22"
#define WLAN_PASS       "EE0222374EE62096F13509FF1C"

#define WLAN_SECURITY   WLAN_SEC_WPA2

// Klucz API serwisu ThingSpeak
String writeAPIKey = "MLMH2BIB2YYU94BX";

uint32_t ip; //IP serwisu ThingSpeak

// Zmienne potrzebne do obsługi nieudanych prób przesłania danych do serwisu
long lastConnectionTime = 0; 
boolean lastConnected = false;
int failedCounter = 0;

// Instancja klasy DHT potrzebna do odczytania wyników pomiaru temperatury i wilgotności
DHT dht(DHTPIN, DHTTYPE);


void setup(void)
{
  // Inicjalizacja portu szeregowego
  Serial.begin(115200);
  Serial.println(F("\nZaczynam..."));
  if (!cc3000.begin())
  {
    Serial.println(F("Nie moge zaczac()! Sprawdz kabelki?"));
    while(1);
  }
  // Połączenie z siecią WiFi
  cc3000.connectToAP(WLAN_SSID, WLAN_PASS, WLAN_SECURITY);
  Serial.println(F("Jest Wi-Fi!"));

  // Jeszcze tylko żądanie DHCP
  Serial.println(F("Zapytanie DHCP"));
  while (!cc3000.checkDHCP())
  {
    delay(100);
  }  

}

void loop(void)
{
  // Odczyt pomiarów
  float h = dht.readHumidity();
  float t = dht.readTemperature();
  int l = analogRead(A0);
  
  // Wysłanie ich do portu szeregowego
  Serial.print("Temperatura = ");
  Serial.println(t);
  Serial.print("Wilgotnosc = ");
  Serial.println(h);
  Serial.print("Swiatlo = ");
  Serial.println(l);
  
  //Zamiana liczb zmiennoprzecinkowych na całkowite, a potem na łańcuchy
  int temperature = (int) t;
  int humidity = (int) h;
  String tem=String(temperature, DEC); //Strumień danych dla ThingSpeak może być tylko łańcuchowy
  String hum=String(humidity, DEC);    // Dlatego potrzebna jest konwersja danych na łańcuchy
  String lig=String(l);
  String thl="1="+tem+"&2="+hum+"&3="+lig;
  
  Serial.print(F("api.thingspeak.com -> "));
  while  (ip  ==  0)  {
    if  (!  cc3000.getHostByName("api.thingspeak.com", &ip))  {
      Serial.println(F("Nie udalo sie!, Zaczynam od nowa....."));
      wdt_enable(WDTO_8S);                  // jeśli host nie odpowiada czekaj 8 s i zacznij od nowa
      while(1){}
    }
    
    delay(500);
  }  
   cc3000.printIPdotsRev(ip); //nadaj adresowi IP postać z kropkami
  Serial.println(F(""));
   
   // Próba polączenia z serwisem ThingSpeak
  Adafruit_CC3000_Client client = cc3000.connectTCP(ip, 80);
   
  if (client.available())
  {
    char c = client.read();
    Serial.print(c);
  }

 // Wysyłanie danych do kanału ThingSpeak
  if(client.connected()) 
  {
    updateThingSpeak(thl);  // funkcja wysyłająca dane
    delay(60000);   // ThingSpeak wymaga co najmniej 15 s przerwy między kolejnymi strumieniami (tu jest 1 min). 
    failedCounter=0;

  }
  else
  {
  Serial.println(F("Polaczenie nieudalo sie"));
  failedCounter++;
  if (failedCounter==10)
  {
    Serial.println(F("Polaczenie nieudalo sie 10 razy, Zaczynam od nowa......"));
    wdt_enable(WDTO_8S);   // Po dziesięciu kolejnych nieudanych próbach wysłania danych, wszystko zacznie się od nowa.
    while(1){}
  }
  }

}

void updateThingSpeak(String thlData)
{
    Adafruit_CC3000_Client client = cc3000.connectTCP(ip, 80);
    Serial.println("Laczenie z ThingSpeak...");
    Serial.println("Wysylanie danych");
    client.print("POST /update HTTP/1.1\n");
    client.print("Host: api.thingspeak.com\n");
    client.print("Connection: close\n");
    client.print("X-THINGSPEAKAPIKEY: "+writeAPIKey+"\n");
    client.print("Content-Type: application/x-www-form-urlencoded\n");
    client.print("Content-Length: ");
    client.print(thlData.length());
    client.print("\n\n");
    client.print(thlData);
    Serial.println(F("Gotowe"));
    Serial.println(F("Czekam 60 s do nast. transmisji"));
}



