<?php

require 'angaze/om/BasePracownik.php';


/**
 * Skeleton subclass for representing a row from the 'pracownik' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    angaze
 */
class Pracownik extends BasePracownik {

	/**
	 * Initializes internal state of Pracownik object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getTytul() . ' ' . $this->getImie() . ' ' . $this->getNazwisko();
	}		
	
	
    //Parametr
    //    zimalato = 1 ===> semestr zimowy
    //    zimalato = 0 ===> semestr letni
    function zestawienieProwadzonychPrzedmiotow($zimalato = 'zima')
	{
        $c = new Criteria();

        $c->add(PracownikPeer::PRACOWNIK_ID, $this->getPracownikId());
        if ($zimalato == 'zima') {
            $c->add(PrzedmiotPeer::ZIMALATO, 1);
        } else {
            $c->add(PrzedmiotPeer::ZIMALATO, 0);
        }

	    $c->addJoin(PracownikPeer::PRACOWNIK_ID, PrzydzialPeer::PRACOWNIK_ID);
	    $c->addJoin(PrzydzialPeer::PRZEDMIOT_ID, PrzedmiotPeer::PRZEDMIOT_ID);

	    return PrzydzialPeer::doSelect($c);
	}
	
    function liczbaProwadzonychGodzin($zimalato = 'razem')
	{
       $warunek = '';	
	
	    switch ($zimalato) {
	    
	    case 'zima':
                $warunek = '(przedmiot.zimalato = 1) AND ';
	        break;
	    
	    case 'lato':
                $warunek = '(przedmiot.zimalato = 0) AND ';

	        break;
	    
	    }
	
	
	    $sql = "
	    
	    
            SELECT
                SUM(przedmiot.godz) as liczbagodzin
            FROM
                przedmiot as przedmiot,
                przydzial as przydzial,
                kierunek as kierunek
            WHERE
                kierunek.kierunek_id = przedmiot.kierunek_id AND
                przydzial.pracownik_id = {$this->getPracownikId()} AND
                przydzial.przedmiot_id = przedmiot.przedmiot_id AND
                (przedmiot.godz != 0) AND
                {$warunek}
                przedmiot.odbywa_sie = 1	    
	
            ";
            
            $connection = Propel::getConnection();
            $statement = $connection->prepare($sql);
            $statement->execute();
            $wynik = $statement->fetch();
            
            return $wynik['liczbagodzin'];
	}
	
	
	

} // Pracownik
