<?php

/**
 * Walidacja danych
 *
 * Funkcje sluzace do walidacji identyfikatorow
 * przekazywanych w adresach URL postaci:
 *     index.php?id1=12&id2=34&id3=56
 *
 * Zawartosc tablicy $_GET stanowia zawsze napisy.
 * Zatem wszystkie funkcje walidujace sprawdzaja
 * typ parametrow.
 *
 *
 * @package    WALIDACJA
 * @author     Wlodzimierz Gajda, gajdaw
 * @copyright  1997-2006 Wlodzimierz Gajda, gajdaw
 * @link       http://www.gajdaw.pl
 * @license    GPL
 * @version    walidacja.inc.php, v 1.0, 2006/03/27, 08:20
 * @link       http://www.gajdaw.pl/php/packages/walidacja.html
 */


/*
 * Maksymalna liczba calkowita
 * ma wartosc 2 147 483 647.
 *
 * Przyjmujemy: dziewiec cyfr.
 *
 */


/**
 * Maksymalna dlugosc napisu.
 *
 */
define('WALIDACJA_MAX_DL_NAPISU', 9);


/**
 * ivpi(): Is valid positive integer?
 *
 * Czy liczba jest poprawna, calkowita, nieujemna?
 * Sprawdzamy typ i dlugosc zmiennej!
 *
 * @param string badana liczba
 * @return bool czy badana liczba spelnia kryteria
 * @see ivpi
 */
function str_ivpi($ANo)
{
    if (
        is_string($ANo) &&
        (strlen($ANo) <= WALIDACJA_MAX_DL_NAPISU) &&
        ereg('^[0-9]+$', $ANo)
    ) {
        return true;
    } else {
        return false;
    }
}


/**
 * ievpi(): Is exactly valid positive integer?
 *
 * Czy liczba jest poprawna, calkowita, nieujemna?
 * Wykluczamy wiodace zera: 001, 000004.
 * Sprawdzamy typ i dlugosc zmiennej!
 *
 * @param string badana liczba
 * @return bool czy badana liczba spelnia kryteria
 * @see ievpi
 */
function str_ievpi($ANo)
{
    if (
        is_string($ANo) &&
        (strlen($ANo) <= WALIDACJA_MAX_DL_NAPISU) &&
        ereg('^(([1-9][0-9]+)|([0-9]))$', $ANo)
    ) {
        return true;
    } else {
        return false;
    }
}


/**
 * ivpifr(): Is valid positive integer from range?
 *
 * Czy liczba jest poprawna, calkowita, nieujemna i z podanego zakresu?
 * Wykluczamy wiodace zera: 001, 000004.
 *
 * @param string badana liczba
 * @param string minimalna dopuszczalna wartosc
 * @param string maksymalna dopuszczalna wartosc
 * @return bool czy badana liczba spelnia kryteria
 * @see ivpifr
 */
function str_ivpifr($ANo, $AMin, $AMax)
{
    if (
        str_ivpi($ANo) &&
        ($ANo >= $AMin) &&
        ($ANo <= $AMax)
    ) {
        return true;
    } else {
        return false;
    }
}


/**
 * ievpifr(): Is exactly valid positive integer from range?
 *
 * Czy liczba jest poprawna, calkowita, nieujemna i z podanego zakresu?
 * Wykluczamy wiodace zera: 001, 000004.
 *
 * @param string badana liczba
 * @param string minimalna dopuszczalna wartosc
 * @param string maksymalna dopuszczalna wartosc
 * @return bool czy badana liczba spelnia kryteria
 * @see ievpifr
 */
function str_ievpifr($ANo, $AMin, $AMax)
{
    if (
        str_ievpi($ANo) &&
        ($ANo >= $AMin) &&
        ($ANo <= $AMax)
    ) {
        return true;
    } else {
        return false;
    }
}


/**
 * Usuwamy z tablicy $_GET wszystkie elementy,
 * ktore nie sa zawarte w tablicy $APermitted.
 * Poprawnosc wartosci sprawdzamy funkcja ivpi()
 *
 * Konwertujemy liczby z wiodacymi zerami
 * na ich odpowiedniki bez zer wiodacych.
 *
 * <pre>
 * $t  = array('id1', 'id2');
 * clearGetArray($t);
 * </pre>
 *
 * @param array tablica dopuszczonych wartosci
 * @see clearGetArrayExactly
 */
function clearGetArray($APermitted)
{
    foreach ($_GET as $k => $v) {
        if (!in_array($k, $APermitted)) {
            unset($_GET[$k]);
        } else {

            /*
             * Konwersja:
             *    '000045'->'45'
             *    '000000'->'0'
             *
             */
            $_GET[$k] = (string)((int) $v);
        }
    }

    foreach ($_GET as $k => $v) {
        if (!ivpi($v)) {
            unset($_GET[$k]);
        }
    }
}


/**
 * Usuwamy z tablicy $_GET wszystkie elementy,
 * ktore nie sa zawarte w tablicy $APermitted.
 * Poprawnosc wartosci sprawdzamy funkcja ievpi()
 *
 * Bez zadnych konwersji.
 *
 * <pre>
 * $t  = array('id1', 'id2');
 * $ok = clearGetArrayExactly($t);
 * if ($ok === false) {
 *    echo 'Proba manipulacji zmiennymi';
 * }
 * </pre>
 *
 * @param array tablica dopuszczonych wartosci
 * @result bool czy w tablicy $_GET byly zawarte jakiekolwiek niepoprawne liczby
 * @see clearGetArray
 */
function clearGetArrayExactly($APermitted)
{
    $result = true;

    foreach ($_GET as $k => $v) {
        if (!in_array($k, $APermitted)) {
            unset($_GET[$k]);
            $result = false;
        };
    }

    foreach ($_GET as $k => $v) {
        if (!str_ievpi($v)) {
            unset($_GET[$k]);
            $result = false;
        }
    }

    return $result;
}


?>
