
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- film
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `film`;


CREATE TABLE `film`
(
	`film_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`slug` VARCHAR(128),
	PRIMARY KEY (`film_id`),
	UNIQUE KEY `film_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- aktor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `aktor`;


CREATE TABLE `aktor`
(
	`aktor_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(45),
	`nazwisko` VARCHAR(45),
	`slug` VARCHAR(128),
	PRIMARY KEY (`aktor_id`),
	UNIQUE KEY `aktor_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- film_has_aktor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `film_has_aktor`;


CREATE TABLE `film_has_aktor`
(
	`film_id` INTEGER  NOT NULL,
	`aktor_id` INTEGER  NOT NULL,
	PRIMARY KEY (`film_id`,`aktor_id`),
	CONSTRAINT `fk_film_has_aktor_film`
		FOREIGN KEY (`film_id`)
		REFERENCES `film` (`film_id`),
	INDEX `FI_film_has_aktor_aktor` (`aktor_id`),
	CONSTRAINT `fk_film_has_aktor_aktor`
		FOREIGN KEY (`aktor_id`)
		REFERENCES `aktor` (`aktor_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
