<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

header('Content-Type: text/plain');

set_time_limit(0);

define('BASE_PATH', 'openclipart-0.18-full/clipart/');

require_once 'propel/Propel.php';
require_once 'openclipart/Img.php';
Propel::init('openclipart-conf.php');

require_once 'thumbnails.inc.php';
require_once 'slugs.inc.php';
require_once 'pomocnicze.inc.php';

ImgPeer::doDeleteAll();
TagPeer::doDeleteAll();
ImgHasTagPeer::doDeleteAll();

$plks = get_file_list();

foreach ($plks as $plk) {
    $plk = trim($plk);
    flush();
    ob_flush();
    echo $plk . "\n";
    
    $parsed = parse_filename($plk);
  
    $svg_filename = BASE_PATH . $parsed['dir'] . '/' . $parsed['filename'] .  '.svg';    
    $txt_filename = BASE_PATH . $parsed['dir'] . '/' . $parsed['filename'] .  '.txt';
    $png_filename = BASE_PATH . $parsed['dir'] . '/' . $parsed['filename'] .  '.png';    

    $dane_img = array(
        'slug' => string2slug($parsed['filename']),
        'svg' => file_get_contents($svg_filename)
    );
    if (file_exists($png_filename)) {
        $dane_img['png'] = file_get_contents($png_filename);
        $dane_img['has_preview'] = 1;
    } else {
        echo '*************** brak pliku png: ' . $plk . "\n";
    }
    $objImg = ImgPeer::insert($dane_img);
    
    
    if (file_exists($txt_filename)) {
        $txt_file = file_get_contents($txt_filename);
        $tags = parse_txt_file($txt_file);
    } else {
        $tags = array();
        echo '============error: ' . $txt_filename . "\n";
    }


    $tags = array_merge($tags, $parsed['folders']);
    $tags = array_map('strtolower', $tags);
    $tags = array_unique($tags);

    

    foreach ($tags as $tag) {
        $tag = str_replace('_', ' ', $tag);    
        $tag = strtolower(trim($tag));
        
        $dane_tag = array(
            'tag' => $tag,
            'slug' => string2slug($tag)
        );
        
        $objTag = TagPeer::insertIfNotExists($dane_tag);
        
        try {
            $iht = new ImgHasTag();
            $iht->setImg($objImg);
            $iht->setTag($objTag);        
            $iht->save();        
        } catch (PropelException $e) {
            echo 'ERROR: ' . $e->getMessage() . "\n";
        }
        
    }
}

foreach (ImgPeer::doSelect(new Criteria()) as $img) {
    $img->tworzMiniature();
}

