SET NAMES utf8 COLLATE utf8_polish_ci;

DROP DATABASE IF EXISTS filmy;

CREATE DATABASE filmy DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci;

GRANT
    ALL
ON
    filmy.*
TO
    filmyadm@localhost
IDENTIFIED BY
    'filmypass';

FLUSH PRIVILEGES;

USE filmy;
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- aktor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `aktor`;


CREATE TABLE `aktor`
(
	`aktor_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(45),
	`nazwisko` VARCHAR(45),
	PRIMARY KEY (`aktor_id`),
	UNIQUE KEY `aktor_u` (`imie`, `nazwisko`)
)Type=MyISAM;

#-----------------------------------------------------------------------------
#-- film
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `film`;


CREATE TABLE `film`
(
	`film_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`kategoria_id` INTEGER  NOT NULL,
	`tytul` VARCHAR(255),
	`rok` INTEGER,
	PRIMARY KEY (`film_id`),
	UNIQUE KEY `film_u` (`tytul`),
	INDEX `FI__04` (`kategoria_id`),
	CONSTRAINT `Rel_04`
		FOREIGN KEY (`kategoria_id`)
		REFERENCES `kategoria` (`kategoria_id`)
		ON DELETE RESTRICT
)Type=MyISAM;

#-----------------------------------------------------------------------------
#-- film_has_aktor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `film_has_aktor`;


CREATE TABLE `film_has_aktor`
(
	`film_id` INTEGER  NOT NULL,
	`aktor_id` INTEGER  NOT NULL,
	PRIMARY KEY (`film_id`,`aktor_id`),
	CONSTRAINT `Rel_01`
		FOREIGN KEY (`film_id`)
		REFERENCES `film` (`film_id`)
		ON DELETE RESTRICT,
	INDEX `FI__02` (`aktor_id`),
	CONSTRAINT `Rel_02`
		FOREIGN KEY (`aktor_id`)
		REFERENCES `aktor` (`aktor_id`)
		ON DELETE RESTRICT
)Type=MyISAM;

#-----------------------------------------------------------------------------
#-- kategoria
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kategoria`;


CREATE TABLE `kategoria`
(
	`kategoria_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(255),
	PRIMARY KEY (`kategoria_id`),
	UNIQUE KEY `kategoria_u_nazwa` (`nazwa`)
)Type=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 2.11.1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 15 Maj 2008, 11:20
-- Wersja serwera: 5.0.45
-- Wersja PHP: 5.2.4

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Baza danych: `filmy`
--

--
-- Zrzut danych tabeli `aktor`
--

INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(1, 'Roy', 'Scheider');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(2, 'Robert', 'Shaw');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(3, 'Richard', 'Dreyfuss');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(4, 'Lorraine', 'Gary');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(5, 'Murray', 'Hamilton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(6, 'Steve', 'McQueen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(7, 'Robert', 'Vaughn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(8, 'Jacqueline', 'Bisset');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(9, 'Robert', 'Duvall');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(10, 'Humphrey', 'Bogart');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(11, 'Lauren', 'Bacall');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(12, 'Edward', 'Robinson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(13, 'Christian', 'Clavier');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(14, 'Gerard', 'Depardieu');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(15, 'Roberto', 'Benigni');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(16, 'John', 'Gottfried');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(17, 'Jean-Pirre', 'Castaldi');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(18, 'Laetitia', 'Costa');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(19, 'Marianne', 'Sagerbrecht');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(20, 'Mel', 'Gibson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(21, 'Jodie', 'Foster');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(22, 'James', 'Garner');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(23, 'Alfred', 'Molina');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(24, 'Goldie', 'Hawn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(25, 'David', 'Carradine');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(26, 'Joan', 'Severance');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(27, 'Stanisław', 'Tym');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(28, 'Krzysztof', 'Kowalewski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(29, 'Bronisław', 'Pawlik');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(30, 'Jerzy', 'Turek');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(31, 'Jan', 'Machulski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(32, 'Elżbieta', 'Zającówna');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(33, 'Leonard', 'Pietraszak');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(34, 'Witold', 'Pyrkosz');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(35, 'Ewa', 'Szykulska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(36, 'Robert', 'Redford');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(37, 'Paul', 'Newman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(38, 'Jean', 'Reno');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(39, 'Natalie', 'Portman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(40, 'Gary', 'Oldman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(41, 'Danny', 'Aiello');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(42, 'Peter', 'Appel');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(43, 'Bruce', 'Willis');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(44, 'Billy', 'Bob');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(45, '?', 'Thornton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(46, 'Cate', 'Blanchett');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(47, 'Alan', 'Alda');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(48, 'Woody', 'Allen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(49, 'Anjelica', 'Huston');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(50, 'Diane', 'Keaton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(51, 'Pierre', 'Richard');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(52, 'Pedro', 'Armendariz');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(53, 'Corynne', 'Charbit');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(54, 'Martiza', 'Olivares');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(55, 'Irena', 'Kwiatkowska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(56, 'Alina', 'Janowska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(57, 'Jerzy', 'Bończak');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(58, 'Marian', 'Opania');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(59, 'Bożena', 'Dykiel');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(60, 'Zofia', 'Merle');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(61, 'Małgorzata', 'Ostrowska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(62, 'Artur', 'Barciś');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(63, 'Charles', 'Chaplin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(64, 'Edna', 'Purviance');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(65, 'Jackie', 'Coogan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(66, 'Tom', 'Wilson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(67, 'Henry', 'Bergman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(68, 'Mack', 'Swain');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(69, 'Tom', 'Murray');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(70, 'Malcom', 'Waite');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(71, 'Glenn', 'Close');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(72, 'Alan', 'Bates');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(73, 'Paul', 'Scofield');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(74, 'Ian', 'Holm');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(75, 'Helena', 'Bonham-Carter');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(76, 'Stephen', 'Dillane');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(77, 'Nathaniel', 'Parker');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(78, 'Sean', 'Murray');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(79, 'Michael', 'Maloney');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(80, 'Trevor', 'Peacock');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(81, 'Richard', 'Warwick');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(82, 'Christien', 'Anholt');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(83, 'Dave', 'Duffy');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(84, 'Dustin', 'Hoffman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(85, 'Anne', 'Bancroft');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(86, 'Kaatharine', 'Ross');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(87, 'William', 'Daniels');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(88, 'Elizabeth', 'Wilson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(89, 'Tim', 'Roth');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(90, 'Pruit', 'Taylor-Vience');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(91, 'Clarence', 'Williams');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(92, 'Melanie', 'Thierry');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(93, 'Isabelle', 'Adjani');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(94, 'Daniel', 'Auteuil');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(95, 'Jean-Hughes', 'Anglade');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(96, 'Vincent', 'Perez');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(97, 'Virna', 'Lisi');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(98, 'Janusz', 'Gajos');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(99, 'Danuta', 'Szaflarska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(100, 'Krystyna', 'Janda');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(101, 'Joanna', 'Sienkiewicz');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(102, 'Małgorzata', 'Zajączkowska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(103, 'Nastassja', 'Kinski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(104, 'Peter', 'Firth');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(105, 'Leigh', 'Lawson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(106, 'John', 'Collin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(107, 'Rosemary', 'Martin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(108, 'Uma', 'Thurman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(109, 'Julian', 'Sands');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(110, 'Noah', 'Emmerich');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(111, 'Michael', 'Caine');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(112, 'Donald', 'Sutherland');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(113, 'Treat', 'Williams');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(114, 'Donald', 'Pleasence');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(115, 'Duane', 'Jones');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(116, 'Judith', 'O''Dea');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(117, 'Karl', 'Hardman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(118, 'Maryli', 'Estman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(119, 'Keith', 'Wayne');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(120, 'Judith', 'Ridley');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(121, 'Kyra', 'Schon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(122, 'Marek', 'Perepeczko');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(123, 'Ewa', 'Lemańska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(124, 'Bogusz', 'Bilewski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(125, 'Marian', 'Kociniak');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(126, 'Mieczysław', 'Czechowicz');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(127, 'Anna', 'Dymna');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(128, 'Rosanna', 'Arquette');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(129, 'Jean-Marc', 'Barr');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(130, 'Poul', 'Shenar');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(131, 'Sergio', 'Castellitto');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(132, 'Marc', 'Duret');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(133, 'Griffin', 'Dunne');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(134, 'Kevin', 'Costner');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(135, 'Graham', 'Greene');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(136, 'Rodney', 'Grant');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(137, 'Rowan', 'Atkinson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(138, 'Natalie', 'Imbruglia');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(139, 'Ben', 'Miller');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(140, 'John', 'Malkovich');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(141, 'Jerry', 'Adler');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(142, 'Bill', 'Murray');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(143, 'Richard', 'Baker');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(144, 'Richie', 'Alan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(145, 'Kimberly', 'Thornton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(146, 'Anita', 'Gillette');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(147, 'Louis', 'deFunes');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(148, '?', 'Bourvill');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(149, 'Colette', 'Brosset');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(150, 'Claudio', 'Brook');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(151, 'Andrea', 'Parisy');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(152, 'Mike', 'Marshall');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(153, 'Daniel', 'Ceccaldi');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(154, 'Mireille', 'Darc');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(155, 'Roger', 'Dumas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(156, 'Rosa-Maria', 'Rodrigues');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(157, 'Venantino', 'Venantini');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(158, 'Catherine', 'Deneuve');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(159, 'Isabelle', 'Huppert');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(160, 'Emmanuelle', 'Beart');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(161, 'Fanny', 'Ardant');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(162, 'Virginie', 'Ledoyen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(163, 'Danielle', 'Darrieux');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(164, 'Firmine', 'Richard');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(165, 'Ludivine', 'Sagnier');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(166, 'Dominique', 'Lamure');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(167, 'Olivier', 'deFunes');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(168, 'Noelle', 'Adams');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(169, 'Claude', 'Rich');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(170, 'Claude', 'Gensac');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(171, 'Agatha', 'Natanson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(172, 'Paul', 'Prebosit');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(173, 'Mario', 'David');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(174, 'Oliver', 'deFunes');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(175, 'Bernard', 'Alane');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(176, 'Michel', 'Lonsdale');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(177, 'Eileen', 'Brennan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(178, 'Truman', 'Capote');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(179, 'James', 'Coco');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(180, 'Peter', 'Falk');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(181, 'Alec', 'Guinness');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(182, 'Elsa', 'Lanchaster');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(183, 'David', 'Niven');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(184, 'Peter', 'Sellers');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(185, 'Maggie', 'Smith');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(186, 'Nancy', 'Walker');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(187, 'Cuba', 'Gooding');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(188, 'James', 'Coburn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(189, 'Martin', 'Lawrence');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(190, 'Tim', 'Robbins');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(191, 'John', 'McGinley');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(192, '?', 'Gincarlo');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(193, 'Leonardo', 'DiCaprio');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(194, 'Daniel', 'Day-Lewis');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(195, 'Cameron', 'Diaz');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(196, 'Jim', 'Broadbent');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(197, 'John', 'Reilly');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(198, 'Henry', 'Thomas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(199, 'Pierce', 'Brosnan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(200, 'Ned', 'Beatty');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(201, 'Julian', 'Glover');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(202, 'Ian', 'Richardson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(203, 'Greg', 'Kinnear');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(204, 'Willem', 'Dafoe');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(205, 'Rita', 'Wilson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(206, 'Ron', 'Leiman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(207, 'Bruce', 'Salomon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(208, 'Joe', 'Morton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(209, 'Ron', 'Rifkin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(210, 'Linda', 'Hunt');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(211, 'Kathy', 'Bates');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(212, 'Ben', 'Affleck');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(213, 'Morgan', 'Freeman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(214, 'James', 'Cromwell');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(215, 'Liev', 'Schreiber');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(216, 'Philip', 'Bakerhall');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(217, 'Bruce', 'McGill');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(218, 'Matt', 'Dilon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(219, 'James', 'Caan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(220, 'Natasha', 'McElhone');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(221, 'Stellan', 'Skargard');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(222, 'Sean', 'Connery');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(223, 'Dyan', 'Cannon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(224, 'Martin', 'Balsam');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(225, 'Alan', 'King');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(226, 'Richard', 'Schull');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(227, 'Mia', 'Kishner');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(228, 'Meredith', 'Monroe');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(229, 'Domminique', 'Swain');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(230, 'Taye', 'Diggs');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(231, 'Scott', 'Bairstow');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(232, 'Rachel', 'True');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(233, 'Eric', 'Roberts');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(234, 'Stacy', 'Keach');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(235, 'David', 'White');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(236, 'Cynthia', 'Watros');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(237, 'Al', 'Pacino');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(238, 'Robin', 'Williams');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(239, 'Hilary', 'Swank');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(240, 'Maura', 'Tierney');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(241, 'Martin', 'Donovan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(242, 'Nicky', 'Katt');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(243, 'Paul', 'Dooley');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(244, 'Melanie', 'Griffith');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(245, 'Tommy', 'LeeJones');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(246, '?', 'Sting');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(247, 'Sean', 'Bean');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(248, 'James', 'Cosmo');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(249, 'Mark', 'Long');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(250, 'Brian', 'Lewis');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(251, 'Mick', 'Hamer');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(252, 'Ian', 'Hinchcliffe');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(253, 'Andrzej', 'Borkowski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(254, 'Caroline', 'Hutchinson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(255, 'Les', 'Wilde');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(256, 'Desmond', 'Gill');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(257, 'Benny', 'Gracham');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(258, 'Derek', 'Hoxby');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(259, 'Ashley', 'Judd');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(260, 'Jim', 'Caviezel');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(261, 'Amanda', 'Peet');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(262, 'Tom', 'Bower');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(263, 'Harrison', 'Ford');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(264, 'Anne', 'Archer');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(265, 'James', 'Earl-Jones');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(266, 'Robert', 'DeNiro');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(267, 'James', 'Woods');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(268, 'Elizabeth', 'McGovern');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(269, 'Joe', 'Pesci');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(270, 'Burt', 'Young');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(271, 'Tuesday', 'Weld');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(272, 'Michael', 'Carine');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(273, 'Brendan', 'Fraser');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(274, 'Rade', 'Sherbediga');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(275, 'Armand', 'Assante');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(276, 'Jurgen', 'Prochnow');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(277, 'Ornella', 'Muti');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(278, 'Debra', 'Winger');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(279, 'Brian', 'Dennehy');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(280, 'Terence', 'Stamp');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(281, 'Steven', 'Hill');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(282, 'Andie', 'MacDowell');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(283, 'Ingrid', 'Bergman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(284, 'Paul', 'Henried');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(285, 'Caude', 'Rains');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(286, 'Whoopi', 'Goldberg');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(287, 'Danny', 'Glover');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(288, 'Adolph', 'Caesar');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(289, 'Geofrey', 'Rush');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(290, 'Christopher', 'Eccleston');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(291, 'Joseph', 'Fiennes');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(292, 'Richard', 'Attenborough');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(293, 'Fanny', 'Adant');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(294, 'Brian', 'Gibson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(295, 'Jamie', 'LeeCurtis');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(296, 'Elijah', 'Wood');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(297, 'Isabel', 'Glasser');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(298, 'David', 'Morse');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(299, 'Bonnie', 'Hunt');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(300, 'Michael', 'Duncan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(301, 'Michael', 'Jeter');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(302, 'Doug', 'Hutchison');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(303, 'Sam', 'Rockwell');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(304, 'Barry', 'Pepper');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(305, 'Dean', 'Stanton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(306, 'Tom', 'Hanks');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(307, 'James', 'Donald');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(308, 'Charles', 'Bronson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(309, 'Keanu', 'Reeves');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(310, 'Laurence', 'Fishbourne');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(311, 'Carrie-Anne', 'Moss');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(312, 'Ellen', 'Burstyn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(313, 'Max', 'vonSydow');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(314, 'Lee', 'Cobb');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(315, 'Winona', 'Ryder');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(316, 'Anthony', 'Hopkins');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(317, 'Anthony', 'Perkins');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(318, 'Vera', 'Milles');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(319, 'Janet', 'Leigh');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(320, 'David', 'Thelwis');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(321, 'Sam', 'Neil');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(322, 'Embeth', 'Davidtz');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(323, 'Wendy', 'Crewson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(324, 'Oliver', 'Platt');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(325, 'Cary', 'Grant');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(326, 'Eva-Marie', 'Saint');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(327, 'James', 'Mason');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(328, 'Landis-Fessie', 'Royce');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(329, 'Charles', 'Martin-Smith');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(330, 'Andy', 'Garcia');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(331, 'Robert', 'Hays');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(332, 'Peter', 'Graves');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(333, 'Lloyd', 'Bridges');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(334, 'William', 'Shatner');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(335, 'Chad', 'Everett');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(336, 'Sonny', 'Bono');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(337, 'Raymond', 'Burr');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(338, 'Leslie', 'Mielsen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(339, 'Priscilla', 'Presley');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(340, 'O.', 'Simpson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(341, 'Sally', 'Field');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(342, 'Havery', 'Fierstein');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(343, 'Robert', 'Prosky');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(344, 'John', 'Cusack');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(345, 'Catherine', 'Deener');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(346, 'Orson', 'Bean');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(347, 'Mary', 'Place');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(348, 'Emma', 'Thompson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(349, 'James', 'Fox');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(350, 'Chistopher', 'Reeve');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(351, 'Michelle', 'Pfeiffer');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(352, 'Bob', 'Balaban');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(353, 'Melinda', 'Dillon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(354, 'Luther', 'Adler');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(355, 'Juliette', 'Binoche');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(356, 'Lena', 'Olin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(357, 'Johnny', 'Depp');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(358, 'Judi', 'Dench');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(359, 'Leslie', 'Caron');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(360, 'Victoire', 'Thivisol');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(361, 'Hugh', 'O''Connor');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(362, 'Peter', 'Stormare');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(363, 'Gregory', 'Peck');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(364, 'Anthony', 'Quinn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(365, 'Irena', 'Pepas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(366, 'James', 'Darren');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(367, 'Stanley', 'Baker');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(368, 'Gia', 'Scala');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(369, 'Edward', 'Burns');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(370, 'Matt', 'Damon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(371, 'Tom', 'Sizemore');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(372, 'Jeremy', 'Davies');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(373, 'Adam', 'Goldberg');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(374, 'Dennis', 'Farina');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(375, 'Ted', 'Danson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(376, 'Dirk', 'Bogarde');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(377, 'Edward', 'Fox');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(378, 'Gardy', 'Kruger');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(379, 'Elliott', 'Gousd');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(380, 'Laurence', 'Oliver');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(381, 'Maximilian', 'Schell');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(382, 'Gene', 'Hackman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(383, 'Ryan', 'O''Neal');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(384, 'Liv', 'Ullmann');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(385, 'Robert', 'Tedford');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(386, 'Andrew', 'Marton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(387, 'Ken', 'Annakin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(388, 'Bernhard', 'Nicki');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(389, 'Keir', 'Dullea');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(390, 'Gary', 'Lockwood');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(391, 'Daniel', 'Ritcher');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(392, 'William', 'Sylvester');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(393, 'Richard', 'Gere');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(394, 'Mia', 'Farrow');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(395, 'John', 'Cassavetes');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(396, 'Ruth', 'Gordon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(397, 'Sidney', 'Blackmer');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(398, 'Maurice', 'Evans');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(399, 'Christina', 'Ricci');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(400, 'Miranda', 'Richardson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(401, 'Michael', 'Gambon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(402, 'Michael', 'vanDien');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(403, 'Jeffrey', 'Jones');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(404, 'Heath', 'Ledger');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(405, 'Joely', 'Richardson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(406, 'Jason', 'Isaacs');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(407, 'Chris', 'Cooper');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(408, 'Tcheky', 'Karyo');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(409, 'Rene', 'Auberjonois');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(410, 'Tom', 'Wilkinson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(411, 'Michael', 'Douglas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(412, 'Kathleen', 'Turner');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(413, 'Kanny', 'DeVito');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(414, 'Alfonso', 'Arau');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(415, 'Manuel', 'Ojeda');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(416, 'Danny', 'DeVito');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(417, 'Sophie', 'Marceau');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(418, 'Patrick', 'McGoohan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(419, 'Catherine', 'McCormack');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(420, 'Yul', 'Brynner');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(421, 'Eli', 'Wallach');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(422, 'Brad', 'Dexter');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(423, 'Wojciech', 'Pokora');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(424, 'Jolanta', 'Bohdal');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(425, 'Wiesław', 'Gołas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(426, 'Jerzy', 'Dobrowolski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(427, 'Barbara', 'Brylska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(428, 'Wojciech', 'Siemion');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(429, 'Russell', 'Crowe');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(430, 'Joguin', 'Phoenix');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(431, 'Connie', 'Nielsen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(432, 'Oliver', 'Reed');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(433, 'Derek', 'Jacobi');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(434, 'Djimon', 'Hounsou');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(435, 'Richard', 'Harris');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(436, 'Laurence', 'Olivier');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(437, 'William', 'Devane');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(438, 'Marthe', 'Keller');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(439, 'Lance', 'Henriksen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(440, 'Kathy', 'Baker');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(441, 'Graham', 'Beskel');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(442, 'Kevin', 'Conway');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(443, 'Fernando', 'Rey');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(444, 'Tony', 'Bianco');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(445, 'Marcel', 'Bozzuffi');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(446, 'Monica', 'Belluci');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(447, 'Alan', 'Chabat');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(448, 'Jamel', 'Debboze');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(449, 'Michael', 'Fox');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(450, 'Christopher', 'Lloyd');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(451, 'Lea', 'Thompson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(452, 'Crispin', 'Glover');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(453, 'Hugh', 'Grant');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(454, 'Tracey', 'Ullman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(455, 'Elaine', 'May');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(456, 'Michael', 'Rapaport');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(457, 'Tony', 'Darrow');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(458, 'Jon', 'Lovitz');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(459, 'Elaine', 'Stritch');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(460, 'George', 'Grizzard');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(461, 'Kristine', 'Nielsen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(462, 'Dan', 'Aykroyd');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(463, 'Helen', 'Hunt');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(464, 'Brian', 'Markinson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(465, 'Wallace', 'Shawn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(466, 'Meg', 'Ryan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(467, 'Hugh', 'Jackman');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(468, 'Meryl', 'Streep');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(469, 'Klaus-Maria', 'Brandauer');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(470, 'Shirley', 'MacLaine');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(471, 'Melvyn', 'Douglas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(472, 'Richard', 'Dysart');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(473, 'Richard', 'Basehart');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(474, 'Jack', 'Warden');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(475, 'Ruth', 'Attaway');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(476, 'David', 'Clennon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(477, 'Ralph', 'Fiennes');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(478, 'Kristin', 'Scott-Thomas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(479, 'Naveen', 'Andrews');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(480, 'Susan', 'Sarandon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(481, 'Geena', 'Davis');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(482, 'Harvey', 'Keitel');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(483, 'Michael', 'Madsen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(484, 'Christopher', 'McDonald');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(485, 'Stephen', 'Tobolowsky');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(486, 'Brad', 'Pitt');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(487, 'Paul', 'Hogan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(488, 'Linda', 'Koslowski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(489, 'Mark', 'Blum');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(490, 'David', 'Gulpilil');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(491, 'Michael', 'Lombard');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(492, 'John', 'Meilon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(493, 'Ritchie', 'Singer');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(494, 'Maggie', 'Blinco');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(495, 'Jeremy', 'Irons');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(496, 'Liam', 'Neeson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(497, 'Ray', 'McAnally');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(498, 'Aidan', 'Quinn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(499, 'Cherie', 'Lunghi');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(500, 'Ronald', 'Pickup');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(501, 'Nick', 'Searcy');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(502, 'Sigourney', 'Weaver');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(503, 'Angela', 'Molina');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(504, 'Michael', 'Wincott');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(505, 'John', 'Randolph');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(506, 'Jack', 'Kahoe');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(507, 'Barbara', 'Eda-Young');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(508, 'Cornella', 'Sharpe');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(509, 'Tony', 'Roberts');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(510, 'Brownie', 'McGhee');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(511, 'Michael', 'Higgins');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(512, 'Mickey', 'Rourke');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(513, 'Lisa', 'Bonet');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(514, 'Charlotte', 'Rampling');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(515, 'Noel', 'Coward');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(516, 'Benny', 'Hill');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(517, 'Raf', 'Vallone');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(518, 'Tony', 'Beckley');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(519, 'Rossano', 'Brazzi');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(520, 'Margaret', 'Blye');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(521, 'Warren', 'Beatty');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(522, 'Hume', 'Cronyn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(523, 'Paula', 'Prentiss');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(524, 'Kenneth', 'Mars');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(525, 'Walter', 'McGinn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(526, 'Kelly', 'Thordsen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(527, 'Clint', 'Eastwood');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(528, 'Kyle', 'Eastwood');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(529, 'Matt', 'Clark');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(530, 'Verna', 'Bloom');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(531, 'Alexa', 'Kenin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(532, 'Barry', 'Corbin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(533, 'Benicio', 'DelToro');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(534, 'Ron', 'Canada');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(535, 'Leslie', 'Stefanson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(536, 'John', 'Finn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(537, 'Jose', 'Zuniga');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(538, 'Wojciech', 'Pszoniak');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(539, 'Bogusław', 'Linda');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(540, 'Andrzej', 'Seweryn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(541, 'Marek', 'Kondrat');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(542, 'Patrice', 'Chereau');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(543, 'Campbell', 'Scott');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(544, 'Jill', 'Bennett');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(545, 'Timothy', 'Spall');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(546, 'Amina', 'Annabi');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(547, 'Tom', 'Novembre');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(548, 'Gary', 'Farmer');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(549, 'Gabriel', 'Byrne');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(550, 'John', 'Hurt');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(551, 'Chief', 'DanGeorge');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(552, 'Faye', 'Dunaway');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(553, 'Richard', 'Mulligan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(554, 'Orson', 'Welles');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(555, 'Joseph', 'Cotten');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(556, 'Everett', 'Sloane');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(557, 'Patricia', 'Neal');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(558, 'Brandon', 'DeWilde');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(559, 'Kenneth', 'Branagh');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(560, 'Simon', 'Shepherd');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(561, 'James', 'Lakin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(562, 'James', 'Simmons');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(563, 'Tom', 'Berenger');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(564, 'Jeff', 'Daniels');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(565, 'Martin', 'Sheen');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(566, 'Maxwell', 'Caulifield');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(567, 'Thomas', 'Howell');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(568, 'Stephen', 'Lang');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(569, 'Richard', 'Jordan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(570, 'Marlon', 'Brando');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(571, 'Dennis', 'Hopper');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(572, 'Frederic', 'Forrest');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(573, 'Albert', 'Hall');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(574, 'James', 'Madson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(575, 'David', 'Warner');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(576, 'Stenta', 'Barger');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(577, 'Tom', 'Cruise');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(578, 'Ken', 'Watanabe');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(579, 'Billy', 'Connolly');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(580, 'Tony', 'Goldwyn');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(581, 'Hiroyuki', 'Sanada');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(582, 'Masato', 'Harada');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(583, 'Karl', 'Malden');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(584, 'Brian', 'Keith');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(585, 'Arthur', 'Kennedy');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(586, 'Suzanne', 'Pleshette');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(587, 'Martin', 'Landau');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(588, 'Karen', 'Black');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(589, 'Antonio', 'Banderas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(590, 'Murray', 'Abraham');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(591, 'Feodor', 'Chalipain');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(592, 'Wiliam', 'Hickey');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(593, 'Cliff', 'Robertson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(594, 'Stanisław', 'Niwiński');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(595, 'Maciej', 'Rayzacher');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(596, 'Janusz', 'Zakrzeński');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(597, 'Grażyna', 'Długołęcka');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(598, 'Anna', 'Seniuk');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(599, 'Karol', 'Strasburger');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(600, 'Lee', 'VanCleef');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(601, 'Michael', 'Lonsdale');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(602, 'Alan', 'Badel');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(603, 'Eric', 'Porter');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(604, 'Cyril', 'Cusack');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(605, 'Delphine', 'Seyrig');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(606, 'Donald', 'Sinden');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(607, 'Tony', 'Britton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(608, 'Timothy', 'West');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(609, 'Olga', 'Georges-Picot');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(610, 'Barrie', 'Ingham');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(611, 'Maurice', 'Denham');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(612, 'Anton', 'Rodgers');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(613, 'Carroll', 'Baker');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(614, 'Henry', 'Fonda');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(615, 'Carolyn', 'Jones');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(616, 'Elizabeth', 'Taylor');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(617, 'Richard', 'Burton');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(618, 'Rex', 'Harrison');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(619, 'Telly', 'Savalas');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(620, 'Lee', 'Marvin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(621, 'Kris', 'Kristofferson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(622, 'Richard', 'Jaeckel');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(623, 'Chill', 'Wills');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(624, 'Bob', 'Dylan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(625, 'Zbigniew', 'Cybulski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(626, 'Ewa', 'Krzyżanowska');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(627, 'Adam', 'Pawlikowski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(628, 'John', 'Wayne');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(629, 'Natalie', 'Wood');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(630, 'Jeffrey', 'Hunter');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(631, 'Marek', 'Kasprzyk');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(632, 'Anna', 'Majcher');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(633, 'Beata', 'Tyszkiewicz');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(634, 'Henryk', 'Bista');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(635, 'Krystyna', 'Sznerr');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(636, 'Sergiej', 'Desnitski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(637, 'Bolesław', 'Abart');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(638, 'Władimir', 'Iwaszow');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(639, 'Aleksandr', 'Kajdanowski');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(640, 'Zbigniew', 'Lesień');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(641, 'Ferdynand', 'Matysik');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(642, 'Ali', 'MacGraw');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(643, 'Ben', 'Johnson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(644, 'Gary', 'Busey');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(645, 'Sela', 'Ward');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(646, 'Joe', 'Pantoliano');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(647, 'Julia', 'Roberts');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(648, 'George', 'Cole');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(649, 'Medeleine', 'Stowe');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(650, 'Russell', 'Meansm');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(651, 'Jodhi', 'May');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(652, 'Dean', 'Martin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(653, 'Risky', 'Nelson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(654, 'Angie', 'Dickinson');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(655, 'Walter', 'Brennan');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(656, 'Ward', 'Bond');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(657, 'Tom', 'Hulce');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(658, 'Elizabeth', 'Berredge');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(659, 'Simon', 'Callow');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(660, 'Roy', 'Dotrice');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(661, 'Christine', 'Ebersole');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(662, 'Gary', 'Cooper');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(663, 'Grace', 'Kelly');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(664, 'Thomas', 'Mitchell');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(665, 'Katy', 'Jurado');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(666, 'Otto', 'Kruger');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(667, 'Ursula', 'Adress');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(668, 'Alain', 'Delon');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(669, 'Toshiro', 'Mifune');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(670, 'Jo', 'Nieto');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(671, 'Paul', 'Bettany');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(672, 'James', 'D''Arcy');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(673, 'Edward', 'Woodall');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(674, 'Chris', 'Larkin');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(675, 'Max', 'Pirkis');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(676, 'Jesica', 'Tandy');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(677, 'Jean-Paul', 'Belmondo');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(678, 'Jean', 'Desailly');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(679, 'Robert', 'Hossein');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(680, 'Michael', 'Beaune');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(681, 'Cyrielle', 'Claire');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(682, 'Elisabeth', 'Margoni');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(683, 'Mary', 'Ure');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(684, 'Patrick', 'Wymark');
INSERT INTO `aktor` (`aktor_id`, `imie`, `nazwisko`) VALUES(685, 'Michael', 'Hordern');

--
-- Zrzut danych tabeli `film`
--

INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(1, 1, 'Szcczęki', 1975);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(2, 2, 'Bullitt', 1968);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(3, 3, 'Key Largo', 1948);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(4, 4, 'Asterix i Obelix kontra cezar', 1999);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(5, 5, 'Maverick', 1994);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(6, 6, 'Ptaszek na uwięzi', 1990);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(7, 7, 'Miś', 1981);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(8, 8, 'Vabank', 1981);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(9, 6, 'Żądło', 1973);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(10, 2, 'Leon zawodowiec', 1994);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(11, 4, 'Włamanie na śniadanie', 2001);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(12, 8, 'Tajemnica morderstwa na Manhattanie', 1993);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(13, 4, 'Pechowiec', 1981);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(14, 4, 'Rozmowy kontrolowane', 1991);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(15, 4, 'Brzdąc', 1921);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(16, 4, 'Gorączka złota', 1925);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(17, 9, 'Hamlet', 1991);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(18, 10, 'Absolwent', 1967);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(19, 10, '1900: Człowiek i legenda', 1999);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(20, 11, 'Królowa Margot', 1994);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(21, 10, 'Żółty szalik', 2000);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(22, 12, 'Tess', 1979);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(23, 9, 'Vatel', 2000);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(24, 13, 'Orzeł wylądował', 1976);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(25, 14, 'Noc żywych trupów', 1968);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(26, 15, 'Janosik', 1974);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(27, 15, 'Wielki błękit', 1988);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(28, 16, 'Tańczący z wilkami', 1990);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(29, 4, 'Johnny English', 2003);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(30, 4, 'Pięć ton i on', 1969);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(31, 4, 'Wielka włóczęga', 1966);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(32, 4, 'KoKo', 1963);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(33, 4, 'Gamoń', 1964);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(34, 8, '8 kobiet', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(35, 4, 'Człowiek orkiestra', 1969);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(36, 4, 'Oskar', 1967);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(37, 4, 'Hibernatus', 1969);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(38, 4, 'Zabity na śmierć', 1976);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(39, 17, 'Śnieżne psy', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(40, 4, 'Nic do stracenia', 1997);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(41, 9, 'Gangi Nowego Jorku', 2003);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(42, 1, 'Czwarty protokół', 1987);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(43, 9, 'Auto Focus', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(44, 14, 'Znamię', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(45, 2, 'Suma wszystkich strachów', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(46, 14, 'Miasto duchów', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(47, 2, 'Taśmy prawdy', 1971);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(48, 14, 'Przyjaciółka na śmierć i życie', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(49, 1, 'Ostatni skok', 2000);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(50, 14, 'Bezsenność', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(51, 9, 'Burzliwy poniedziałek', 1988);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(52, 14, 'Bez przedstawienia', 2001);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(53, 1, 'Stan zagrożenia', 1994);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(54, 9, 'Dawno temu w Ameryce', 1984);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(55, 1, 'Spokojny amerykanin', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(56, 1, 'Ostatnia misja', 2001);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(57, 6, 'Orły Temidy', 1986);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(58, 18, 'Dzień Świstaka', 1993);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(59, 9, 'Casablanca', 1942);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(60, 10, 'Kolor purpury', 1985);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(61, 11, 'Elizabeth', 1998);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(62, 9, 'Wiecznie młody', 1992);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(63, 9, 'Zielona Mila', 1999);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(64, 13, 'Wielka ucieczka', 1963);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(65, 2, 'Matrix', 1999);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(66, 14, 'Egzorcysta', 1973);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(67, 14, 'Dracula', 1992);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(68, 14, 'Psychoza', 1960);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(69, 19, 'Czarny Książe', 1994);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(70, 19, 'Człowiek przyszłości', 1999);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(71, 14, 'Północ północny zachód', 1959);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(72, 1, 'Nietykalni', 1987);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(73, 4, 'Spokojnie, to tylko awaria', 1982);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(74, 4, 'Naga broń: Z akt Wydziału Specjalnego', 1988);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(75, 17, 'Pani Doubtfire', 1993);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(76, 20, 'Być jak John Malkovich', 1999);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(77, 9, 'Duchy dnia', 1993);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(78, 9, 'Wiek niewinności', 1993);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(79, 10, 'Bez złych intencji', 1981);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(80, 10, 'Czekolada', 2000);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(81, 13, 'Działa Navarony', 1961);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(82, 13, 'Szeregowiec Ryan', 1998);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(83, 13, 'O jeden most za daleko', 1977);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(84, 13, 'Najdłuższy dzień', 1962);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(85, 21, '2001: Odyseja kosmiczna', 1968);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(86, 14, 'Dziecko Rosemary', 1968);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(87, 14, 'Jeździec bez głowy', 1999);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(88, 15, 'Patriota', 2000);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(89, 15, 'Miłość, szmaragd i krokodyl', 1984);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(90, 15, 'Klejnot Nilu', 1985);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(91, 15, 'Waleczne Serce', 1995);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(92, 16, 'Siedmiu wspaniałych', 1960);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(93, 7, 'Poszukiwany, poszukiwana', 1972);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(94, 15, 'Gladiator', 2000);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(95, 14, 'Maratończyk', 1976);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(96, 14, 'Jennifer 8', 1992);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(97, 14, 'Francuski łącznik', 1971);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(98, 4, 'Asterix i Obelix - Misja Kleopatra', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(99, 21, 'Powrót do przyszłości', 2002);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(100, 8, 'Drobne cwaniaczki', 2000);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(101, 4, 'Klątwa skorpiona', 2001);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(102, 18, 'Kate i Leopold', 2001);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(103, 9, 'Pożegnanie z Afryką', 1985);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(104, 9, 'Wystarczy być', 1979);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(105, 22, 'Angielski Pacjent', 1996);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(106, 9, 'Thelma i Louise', 1991);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(107, 4, 'Krokodyl Dundee', 1986);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(108, 23, 'Misja', 1986);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(109, 15, 'Poza światem', 2000);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(110, 15, '1492: Wyprawa do raju', 1992);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(111, 1, 'Seprico', 1973);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(112, 14, 'Harry Angel', 1987);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(113, 1, 'Włoska robota', 1969);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(114, 14, 'Syndykat Zbrodni', 1974);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(115, 9, 'Honkytonk Man', 1982);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(116, 2, 'Nożownik', 2003);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(117, 11, 'Danton', 1982);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(118, 9, 'Pod osłoną nieba', 1990);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(119, 10, 'Truposz', 1995);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(120, 24, 'Mały wielki człowiek', 1970);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(121, 9, 'Obywatel Kane', 1941);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(122, 16, 'Hud', 1962);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(123, 11, 'Henryk V', 2003);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(124, 13, 'Gettysburg', 1993);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(125, 9, 'Czas Apokalipsy: Powrót', 1979);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(126, 13, 'Żelazny krzyż', 1976);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(127, 15, 'Ostatni Samuraj', 2003);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(128, 16, 'Nevada Smith', 1965);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(129, 10, 'Wielki Gatsby', 1974);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(130, 10, 'Dom dusz', 1993);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(131, 14, 'Imię róży', 1986);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(132, 1, 'Trzy dni kondora', 1975);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(133, 15, 'Czarne chmury', 1973);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(134, 13, 'Czas apokalipsy', 1979);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(135, 16, 'Dobry, zły, brzydki', 1966);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(136, 1, 'Dzień szakala', 1973);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(137, 16, 'Jak zdobywano dziki zachód', 1962);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(138, 23, 'Kleopatra', 1963);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(139, 13, 'Parszywa dwunastka', 1967);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(140, 16, 'Pat Garret i Billy Kid', 1973);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(141, 25, 'Popiół i diament', 1958);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(142, 16, 'Poszukiwacze', 1956);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(143, 26, 'Śmierć dziecioroba', 1990);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(144, 21, 'Test pilota Pirxa', 1978);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(145, 2, 'Ucieczka gangstera', 1972);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(146, 27, 'Niebezpiezpieczne związki', 1988);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(147, 2, 'Zabójcza broń', 1987);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(148, 2, 'Ścigany', 1993);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(149, 14, 'Mary Reilly', 1996);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(150, 15, 'Ostatni Mohikanin', 1992);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(151, 16, 'Rio Bravo', 1959);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(152, 27, 'Amadeusz', 1984);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(153, 16, 'W samo południe', 1952);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(154, 16, 'Samuraj i kowboje', 1971);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(155, 15, 'Pan i władca: na krańcu świata', 2003);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(156, 10, 'Naiwniak', 1994);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(157, 2, 'Zawodowiec', 1981);
INSERT INTO `film` (`film_id`, `kategoria_id`, `tytul`, `rok`) VALUES(158, 13, 'Tylko dla orłów', 1968);

--
-- Zrzut danych tabeli `film_has_aktor`
--

INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(1, 1);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(1, 2);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(1, 3);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(1, 4);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(1, 5);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(2, 6);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(2, 7);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(2, 8);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(2, 9);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(3, 10);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(3, 11);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(3, 12);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(4, 13);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(4, 14);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(4, 15);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(4, 16);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(4, 17);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(4, 18);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(4, 19);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(5, 20);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(5, 21);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(5, 22);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(5, 23);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(6, 20);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(6, 24);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(6, 25);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(6, 26);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(7, 27);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(7, 28);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(7, 29);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(7, 30);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(8, 31);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(8, 32);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(8, 33);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(8, 34);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(8, 35);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(9, 2);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(9, 36);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(9, 37);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(10, 38);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(10, 39);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(10, 40);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(10, 41);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(10, 42);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(11, 43);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(11, 44);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(11, 45);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(11, 46);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(12, 47);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(12, 48);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(12, 49);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(12, 50);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(13, 14);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(13, 51);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(13, 52);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(13, 53);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(13, 54);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 27);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 28);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 30);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 55);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 56);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 57);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 58);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 59);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 60);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 61);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(14, 62);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(15, 63);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(15, 64);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(15, 65);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(15, 66);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(15, 67);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(16, 63);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(16, 67);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(16, 68);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(16, 69);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(16, 70);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 20);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 71);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 72);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 73);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 74);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 75);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 76);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 77);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 78);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 79);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 80);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 81);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 82);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(17, 83);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(18, 84);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(18, 85);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(18, 86);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(18, 87);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(18, 88);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(19, 89);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(19, 90);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(19, 91);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(19, 92);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(20, 93);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(20, 94);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(20, 95);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(20, 96);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(20, 97);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(21, 98);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(21, 99);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(21, 100);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(21, 101);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(21, 102);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(22, 103);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(22, 104);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(22, 105);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(22, 106);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(22, 107);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(23, 14);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(23, 89);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(23, 108);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(23, 109);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(23, 110);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(24, 9);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(24, 111);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(24, 112);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(24, 113);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(24, 114);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(25, 115);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(25, 116);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(25, 117);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(25, 118);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(25, 119);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(25, 120);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(25, 121);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(26, 34);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(26, 122);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(26, 123);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(26, 124);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(26, 125);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(26, 126);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(26, 127);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(27, 38);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(27, 128);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(27, 129);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(27, 130);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(27, 131);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(27, 132);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(27, 133);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(28, 134);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(28, 135);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(28, 136);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(29, 137);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(29, 138);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(29, 139);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(29, 140);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(30, 141);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(30, 142);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(30, 143);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(30, 144);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(30, 145);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(30, 146);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(31, 147);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(31, 148);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(31, 149);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(31, 150);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(31, 151);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(31, 152);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(32, 147);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(32, 153);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(32, 154);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(32, 155);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(32, 156);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(33, 147);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(33, 148);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(33, 157);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 158);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 159);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 160);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 161);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 162);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 163);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 164);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 165);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(34, 166);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(35, 147);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(35, 167);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(35, 168);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(36, 147);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(36, 169);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(36, 170);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(36, 171);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(36, 172);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(36, 173);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(37, 147);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(37, 170);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(37, 174);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(37, 175);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(37, 176);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 177);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 178);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 179);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 180);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 181);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 182);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 183);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 184);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 185);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(38, 186);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(39, 187);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(39, 188);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(40, 189);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(40, 190);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(40, 191);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(40, 192);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(41, 193);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(41, 194);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(41, 195);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(41, 196);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(41, 197);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(41, 198);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(42, 111);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(42, 199);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(42, 200);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(42, 201);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(42, 202);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(43, 203);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(43, 204);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(43, 205);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(43, 206);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(43, 207);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(44, 134);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(44, 208);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(44, 209);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(44, 210);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(44, 211);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(45, 72);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(45, 209);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(45, 212);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(45, 213);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(45, 214);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(45, 215);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(45, 216);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(45, 217);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(46, 14);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(46, 218);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(46, 219);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(46, 220);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(46, 221);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(47, 222);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(47, 223);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(47, 224);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(47, 225);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(47, 226);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(48, 227);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(48, 228);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(48, 229);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(48, 230);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(48, 231);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(48, 232);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(49, 233);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(49, 234);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(49, 235);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(49, 236);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(50, 237);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(50, 238);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(50, 239);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(50, 240);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(50, 241);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(50, 242);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(50, 243);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 244);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 245);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 246);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 247);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 248);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 249);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 250);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 251);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 252);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 253);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 254);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 255);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 256);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 257);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(51, 258);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(52, 213);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(52, 259);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(52, 260);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(52, 261);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(52, 262);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(53, 204);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(53, 263);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(53, 264);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(53, 265);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(54, 113);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(54, 266);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(54, 267);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(54, 268);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(54, 269);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(54, 270);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(54, 271);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(55, 272);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(55, 273);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(55, 274);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(56, 275);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(56, 276);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(56, 277);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(57, 36);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(57, 278);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(57, 279);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(57, 280);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(57, 281);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(58, 142);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(58, 282);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(59, 10);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(59, 283);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(59, 284);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(59, 285);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(60, 286);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(60, 287);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(60, 288);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(61, 46);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(61, 289);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(61, 290);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(61, 291);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(61, 292);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(61, 293);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(62, 294);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(62, 295);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(62, 296);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(62, 297);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 135);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 214);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 298);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 299);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 300);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 301);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 302);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 303);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 304);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 305);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(63, 306);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(64, 6);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(64, 22);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(64, 114);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(64, 188);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(64, 292);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(64, 307);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(64, 308);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(65, 309);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(65, 310);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(65, 311);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(66, 312);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(66, 313);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(66, 314);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(67, 40);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(67, 309);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(67, 315);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(67, 316);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(68, 317);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(68, 318);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(68, 319);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(69, 247);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(69, 320);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(70, 238);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(70, 321);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(70, 322);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(70, 323);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(70, 324);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(71, 325);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(71, 326);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(71, 327);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(71, 328);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(72, 134);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(72, 222);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(72, 266);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(72, 329);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(72, 330);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(73, 331);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(73, 332);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(73, 333);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(73, 334);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(73, 335);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(73, 336);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(73, 337);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(74, 338);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(74, 339);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(74, 340);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(75, 199);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(75, 238);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(75, 341);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(75, 342);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(75, 343);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(76, 140);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(76, 195);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(76, 344);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(76, 345);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(76, 346);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(76, 347);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(77, 316);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(77, 348);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(77, 349);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(77, 350);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(78, 194);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(78, 315);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(78, 351);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(79, 37);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(79, 341);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(79, 352);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(79, 353);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(79, 354);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 23);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 311);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 355);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 356);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 357);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 358);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 359);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 360);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 361);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(80, 362);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(81, 183);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(81, 363);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(81, 364);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(81, 365);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(81, 366);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(81, 367);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(81, 368);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 304);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 306);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 369);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 370);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 371);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 372);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 373);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 374);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(82, 375);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 111);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 219);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 222);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 316);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 376);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 377);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 378);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 379);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 380);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 381);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 382);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 383);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 384);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(83, 385);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(84, 386);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(84, 387);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(84, 388);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(85, 389);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(85, 390);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(85, 391);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(85, 392);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(86, 393);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(86, 394);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(86, 395);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(86, 396);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(86, 397);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(86, 398);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(87, 357);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(87, 399);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(87, 400);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(87, 401);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(87, 402);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(87, 403);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(88, 20);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(88, 404);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(88, 405);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(88, 406);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(88, 407);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(88, 408);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(88, 409);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(88, 410);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(89, 411);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(89, 412);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(89, 413);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(89, 414);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(89, 415);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(90, 411);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(90, 412);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(90, 416);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(91, 20);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(91, 417);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(91, 418);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(91, 419);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(92, 6);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(92, 7);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(92, 188);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(92, 308);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(92, 420);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(92, 421);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(92, 422);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(93, 126);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(93, 423);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(93, 424);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(93, 425);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(93, 426);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(93, 427);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(93, 428);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(94, 429);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(94, 430);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(94, 431);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(94, 432);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(94, 433);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(94, 434);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(94, 435);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(95, 1);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(95, 84);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(95, 436);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(95, 437);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(95, 438);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(96, 108);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(96, 140);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(96, 330);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(96, 439);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(96, 440);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(96, 441);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(96, 442);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(97, 1);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(97, 382);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(97, 443);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(97, 444);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(97, 445);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(98, 13);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(98, 14);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(98, 169);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(98, 446);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(98, 447);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(98, 448);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(99, 449);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(99, 450);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(99, 451);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(99, 452);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 48);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 453);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 454);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 455);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 456);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 457);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 458);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 459);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 460);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(100, 461);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(101, 48);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(101, 462);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(101, 463);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(101, 464);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(101, 465);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(102, 215);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(102, 466);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(102, 467);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(103, 36);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(103, 468);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(103, 469);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(104, 184);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(104, 470);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(104, 471);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(104, 472);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(104, 473);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(104, 474);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(104, 475);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(104, 476);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(105, 204);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(105, 276);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(105, 355);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(105, 477);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(105, 478);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(105, 479);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(106, 480);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(106, 481);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(106, 482);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(106, 483);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(106, 484);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(106, 485);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(106, 486);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(107, 487);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(107, 488);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(107, 489);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(107, 490);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(107, 491);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(107, 492);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(107, 493);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(107, 494);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(108, 266);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(108, 495);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(108, 496);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(108, 497);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(108, 498);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(108, 499);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(108, 500);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(109, 306);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(109, 463);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(109, 501);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(110, 14);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(110, 275);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(110, 408);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(110, 443);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(110, 502);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(110, 503);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(110, 504);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(111, 237);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(111, 505);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(111, 506);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(111, 507);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(111, 508);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(111, 509);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(112, 266);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(112, 510);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(112, 511);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(112, 512);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(112, 513);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(112, 514);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(113, 111);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(113, 515);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(113, 516);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(113, 517);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(113, 518);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(113, 519);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(113, 520);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(114, 87);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(114, 521);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(114, 522);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(114, 523);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(114, 524);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(114, 525);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(114, 526);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(115, 527);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(115, 528);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(115, 529);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(115, 530);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(115, 531);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(115, 532);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(116, 245);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(116, 431);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(116, 533);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(116, 534);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(116, 535);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(116, 536);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(116, 537);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(117, 14);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(117, 538);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(117, 539);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(117, 540);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(117, 541);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(117, 542);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(118, 140);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(118, 278);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(118, 543);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(118, 544);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(118, 545);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(118, 546);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(118, 547);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(119, 23);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(119, 357);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(119, 439);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(119, 504);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(119, 548);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(119, 549);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(119, 550);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(120, 84);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(120, 224);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(120, 551);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(120, 552);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(120, 553);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(121, 554);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(121, 555);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(121, 556);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(122, 37);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(122, 471);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(122, 557);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(122, 558);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(123, 74);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(123, 433);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(123, 559);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(123, 560);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(123, 561);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(123, 562);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(124, 442);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(124, 563);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(124, 564);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(124, 565);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(124, 566);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(124, 567);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(124, 568);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(124, 569);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(125, 9);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(125, 263);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(125, 310);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(125, 565);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(125, 570);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(125, 571);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(125, 572);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(125, 573);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(126, 188);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(126, 381);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(126, 574);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(126, 575);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(126, 576);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(127, 545);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(127, 577);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(127, 578);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(127, 579);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(127, 580);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(127, 581);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(127, 582);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(128, 6);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(128, 517);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(128, 583);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(128, 584);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(128, 585);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(128, 586);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(128, 587);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(129, 36);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(129, 394);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(129, 588);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(130, 71);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(130, 315);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(130, 468);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(130, 495);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(130, 589);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(131, 222);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(131, 590);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(131, 591);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(131, 592);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(132, 36);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(132, 313);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(132, 552);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(132, 593);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(133, 33);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(133, 594);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(133, 595);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(133, 596);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(133, 597);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(133, 598);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(133, 599);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(134, 9);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(134, 263);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(134, 310);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(134, 565);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(134, 570);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(134, 571);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(134, 572);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(134, 573);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(135, 421);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(135, 527);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(135, 600);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 377);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 601);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 602);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 603);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 604);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 605);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 606);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 607);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 608);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 609);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 610);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 611);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(136, 612);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(137, 314);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(137, 583);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(137, 613);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(137, 614);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(137, 615);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(138, 616);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(138, 617);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(138, 618);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(139, 112);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(139, 308);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(139, 619);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(139, 620);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(140, 529);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(140, 621);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(140, 622);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(140, 623);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(140, 624);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(141, 625);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(141, 626);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(141, 627);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(142, 628);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(142, 629);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(142, 630);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(143, 631);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(143, 632);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(143, 633);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(143, 634);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(143, 635);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(144, 636);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(144, 637);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(144, 638);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(144, 639);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(144, 640);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(144, 641);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(145, 6);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(145, 642);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(145, 643);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(146, 71);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(146, 108);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(146, 140);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(146, 309);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(146, 351);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(147, 20);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(147, 287);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(147, 644);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(148, 245);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(148, 263);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(148, 645);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(148, 646);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(149, 140);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(149, 647);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(149, 648);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(150, 194);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(150, 649);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(150, 650);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(150, 651);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(151, 628);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(151, 652);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(151, 653);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(151, 654);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(151, 655);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(151, 656);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(152, 403);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(152, 590);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(152, 657);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(152, 658);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(152, 659);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(152, 660);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(152, 661);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(153, 333);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(153, 662);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(153, 663);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(153, 664);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(153, 665);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(153, 666);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(154, 308);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(154, 667);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(154, 668);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(154, 669);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(154, 670);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(155, 429);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(155, 671);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(155, 672);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(155, 673);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(155, 674);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(155, 675);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(156, 37);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(156, 43);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(156, 244);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(156, 676);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(157, 677);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(157, 678);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(157, 679);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(157, 680);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(157, 681);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(157, 682);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(158, 527);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(158, 617);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(158, 683);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(158, 684);
INSERT INTO `film_has_aktor` (`film_id`, `aktor_id`) VALUES(158, 685);

--
-- Zrzut danych tabeli `kategoria`
--

INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(1, 'sensacyjny');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(2, 'akcja');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(3, 'kryminał');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(4, 'komedia');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(5, 'komedia przygodowa');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(6, 'komedia sensacyjna');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(7, 'komedia satyryczna');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(8, 'komedia kryminalna');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(9, 'dramat');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(10, 'obyczajowy');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(11, 'dramat historyczny');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(12, 'kostiumowy');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(13, 'wojenny');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(14, 'horror');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(15, 'przygodowy');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(16, 'western');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(17, 'komedia familijna');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(18, 'komedia romantyczna');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(19, 'familijny');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(20, 'fantasy');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(21, 'science fiction');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(22, 'melodramat');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(23, 'historyczny');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(24, 'komediodramat');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(25, 'dramat obyczajowy');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(26, 'psychologiczny');
INSERT INTO `kategoria` (`kategoria_id`, `nazwa`) VALUES(27, 'dramat kostiumowy');
