SET NAMES utf8 COLLATE utf8_polish_ci;

DROP DATABASE IF EXISTS osoby;

CREATE DATABASE osoby DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci;

GRANT
    ALL
ON
    osoby.*
TO
    osobyadm@localhost
IDENTIFIED BY
    'osobypass';

FLUSH PRIVILEGES;

USE osoby;
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- osoba
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `osoba`;


CREATE TABLE `osoba`
(
	`osoba_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(45),
	`nazwisko` VARCHAR(45),
	PRIMARY KEY (`osoba_id`)
)Type=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 2.11.1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 15 Maj 2008, 07:50
-- Wersja serwera: 5.0.45
-- Wersja PHP: 5.2.4

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Baza danych: `osoby`
--

--
-- Zrzut danych tabeli `osoba`
--

INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(1, 'Jan', 'Dąb');
INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(2, 'Adam', 'Ciećwierz');
INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(3, 'Anna', 'Gęsiowska');
INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(4, 'Tomasz', 'Żółw');
INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(5, 'Monika', 'Słoń');
INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(6, 'Ewelina', 'Kózka');
INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(7, 'Michał', 'Świnia');
INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(8, 'Marek', 'Źrebak');
INSERT INTO `osoba` (`osoba_id`, `imie`, `nazwisko`) VALUES(9, 'Jadwiga', 'Żądło');
