<?php

class Actions extends ActionsBase
{

    public function execute_list()
    {
        $kolumny = new TabelaRubryk();

        if ($kolumny->incorrectVars()) {
            $this->execute_404();
            return;
        } else if ($kolumny->correctVars()) {
            $kolumny->setIndex($_GET['orderslug']);
            $kolumny->setOrder($_GET['order']);
        }

        $kolumny->assignCurrent();
        $c = $kolumny->getCriteria();
        $kolumny->reverseOrder();
        $kolumny->addURLs('index.php?module=rubryka&action=list');

        $this->set('kolumny', $kolumny->getColumns());

        if (isset($_GET['page'])) {
            if (str_ievpi($_GET['page'])) {
                $strona = $_GET['page'];
            } else {
                $this->execute_404();
                return;
            }
        } else {
            $strona = '1';
        }

        $pager = new Pager('Rubryka', ILE_NA_STRONIE, $c);

        if ($pager->isValidPage($strona)) {
            $pager->setPage($strona);
            $pager->assignRecords();
            $pager->setBaseURL(
                'index.php?module=rubryka&action=list&order=' .
                    $kolumny->getCurrentOrder() .
                    '&orderslug=' .
                    $kolumny->getIndex() .
                    '&page='
            );

            $this->set('pager', $pager);

        } else {
            $this->execute_404();
        }

    }
    
    public function execute_show()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($rubryka = RubrykaPeer::retrieveBySlug($_GET['slug']))
        ) {

            $this->set('rubryka', $rubryka);
            $wskaznik = new WskaznikRubryki($rubryka);
            $this->set('wskaznik', $wskaznik->getPointers());


            $kolumny = new TabelaArtykulow();

            if ($kolumny->incorrectVars()) {
                $this->execute_404();
                return;
            } else if ($kolumny->correctVars()) {
                $kolumny->setIndex($_GET['orderslug']);
                $kolumny->setOrder($_GET['order']);
            }

            $kolumny->assignCurrent();

            $c = $kolumny->getCriteria();
            $kolumny->reverseOrder();
            $kolumny->addURLs('index.php?module=rubryka&action=show&slug=' . $rubryka->getSlug());
            $this->set('kolumny', $kolumny->getColumns());

            if (isset($_GET['page'])) {
                if (str_ievpi($_GET['page'])) {
                    $strona = $_GET['page'];
                } else {
                    $this->execute_404();
                    return;
                }
            } else {
                $strona = '1';
            }


            $c->addJoin(RubrykaPeer::RUBRYKA_ID, ArtykulPeer::RUBRYKA_ID);
            $c->add(RubrykaPeer::RUBRYKA_ID, $rubryka->getRubrykaId());

            $pager = new Pager('Artykul', ILE_NA_STRONIE, $c);

            if ($pager->isValidPage($strona)) {
                $pager->setPage($strona);
                $pager->assignRecords();
                $pager->setBaseURL(
                    'index.php?module=rubryka&action=show&slug=' . $rubryka->getSlug() . '&order=' .
                        $kolumny->getCurrentOrder() .
                        '&orderslug=' .
                        $kolumny->getIndex() .
                        '&page='
                );
                $this->set('pager', $pager);
            } else {
                $this->execute_404();
            }


        } else {

            $this->execute_404();

        }


    }
   
    
}