<?php



class TabelaRocznikow extends SortColumns {



    public function __construct()
    {
    
        $this->columns = array(

            'rok' => array(
                'order' => 'asc',
                'label' => 'Rok',
                'column' => RocznikPeer::ROK,
                'slug' => 'rok',
                'sortable' => 'tak'
            ),
            'lart' => array(
                'order' => 'dsc',
                'label' => 'Liczba artykułów',
                'column' => RocznikPeer::LICZBAARTYKULOW,
                'slug' => 'lart',
                'sortable' => 'tak'
            ),
            'lstr' => array(
                'order' => 'dsc',
                'label' => 'Liczba stron',
                'column' => RocznikPeer::LICZBASTRON,
                'slug' => 'lstr',
                'sortable' => 'tak'
            ),
        );            
        
        $this->setIndex('rok');
    }
    
    public function getCriteria()
    {
        $c = new Criteria();
        if ($this->columns[$this->index]['order'] == 'asc') {
            $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
        } else {
            $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
        }
        
        return $c;        
    }
    

}