set names utf8;
drop database if exists pagedarts;
create database pagedarts default character set utf8 collate utf8_polish_ci;
grant all on pagedarts.* to admin@localhost identified by 'password';
flush privileges;
use pagedarts;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- article
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `article`;


CREATE TABLE `article`
(
	`article_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`title` VARCHAR(255),
	`introduction` TEXT,
	`toc` TEXT,
	`slug` VARCHAR(128)  NOT NULL,
	`date` DATE,
	`onepage` TEXT,
	`addresses` TEXT,
	`download` TEXT,
	`examples` TEXT,
	PRIMARY KEY (`article_id`),
	UNIQUE KEY `article_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- page
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `page`;


CREATE TABLE `page`
(
	`page_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`page` TEXT,
	`article_id` INTEGER,
	`number` INTEGER,
	PRIMARY KEY (`page_id`),
	INDEX `FI_page_article` (`article_id`),
	CONSTRAINT `fk_page_article`
		FOREIGN KEY (`article_id`)
		REFERENCES `article` (`article_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- file
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `file`;


CREATE TABLE `file`
(
	`file_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`data` LONGBLOB,
	`slug` VARCHAR(128)  NOT NULL,
	`mime` VARCHAR(128),
	`article_id` INTEGER,
	PRIMARY KEY (`file_id`),
	INDEX `FI_file_article1` (`article_id`),
	CONSTRAINT `fk_file_article1`
		FOREIGN KEY (`article_id`)
		REFERENCES `article` (`article_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;



#-----------------------------------------------------------------------------
#-- triggers
#-----------------------------------------------------------------------------




-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 11:19
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `pagedarts`
--

--
-- Zrzut danych tabeli `article`
--

INSERT INTO `article` (`article_id`, `title`, `introduction`, `toc`, `slug`, `date`, `onepage`, `addresses`, `download`, `examples`) VALUES(1, 'Quirks mode, strict mode &mdash; dwa tryby pracy przeglądarek internetowych', 'Współczesne przeglądarki internetowe posiadają dwa tryby pracy:\n<em>quirks mode</em> (ang. tryb wstecznej zgodności, tryb dziwactw) oraz\n<em>strict mode</em> (ang. tryb standardów).\nMyśląc o tworzeniu witryn zgodnych ze standardami powinieneś uwzględniać tryb pracy przeglądarki.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="p1.html">1. Tryby pracy przeglądarek</a></li>\r\n<li><a href="p2.html">2. Przykładowe różnice w interpretacji CSS w trybach <em>quirks mode</em> oraz <em>strict mode</em></a></li>\r\n<li><a href="p3.html">3. Problemy z trybami pracy</a></li>\r\n<li><a href="p4.html">4. Jak stwierdzić tryb pracy przeglądarki?</a></li>\r\n<li><a href="p5.html">5. W jaki sposób przeglądarka wybiera tryb pracy?</a></li>\r\n<li><a href="p6.html">6. Problemy z <span class="program">IE</span></a></li>\r\n<li><a href="p7.html">7. Problemy z różnicami <span class="program">IE5</span>/<span class="program">IE6</span></a>\r\n<ol>\r\n<li><a href="p7.html#P7-1">7.1 Rozwiązanie pierwsze: zmiana atrybutów CSS w JavaScript</a></li>\r\n<li><a href="p7.html#P7-2">7.2 Rozwiązanie drugie: komentarze HTML będące instrukcjami dla <span class="program">IE</span></a></li>\r\n</ol>\r\n</li>\r\n<li><a href="p8.html">8. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n', 'quirks_mode_strict_mode_dwa_tryby_pracy_przegladarek_internetowych', '2007-01-01', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Tryby pracy przeglądarek</a></li>\r\n<li><a href="#R2">2. Przykładowe różnice w interpretacji CSS w trybach <em>quirks mode</em> oraz <em>strict mode</em></a></li>\r\n<li><a href="#R3">3. Problemy z trybami pracy</a></li>\r\n<li><a href="#R4">4. Jak stwierdzić tryb pracy przeglądarki?</a></li>\r\n<li><a href="#R5">5. W jaki sposób przeglądarka wybiera tryb pracy?</a></li>\r\n<li><a href="#R6">6. Problemy z <span class="program">IE</span></a></li>\r\n<li><a href="#R7">7. Problemy z różnicami <span class="program">IE5</span>/<span class="program">IE6</span></a>\r\n    <ol>\r\n        <li><a href="#P7-1">7.1 Rozwiązanie pierwsze: zmiana atrybutów CSS w JavaScript</a></li>\r\n        <li><a href="#P7-2">7.2 Rozwiązanie drugie: komentarze HTML będące instrukcjami dla <span class="program">IE</span></a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R8">8. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n<h3 id="R1">1. Tryby pracy przeglądarek</h3>\n\n<p>\nPrzeglądarki internetowe posiadają dwa tryby pracy:\ntryb <em>quirks mode</em> oraz tryb <em>strict mode</em>.\nTerminy te są tłumaczone w interfejsie przeglądarki <span class="program">Firefox</span> jako\n<em>tryb standardów</em> oraz <em>tryb wstecznej zgodności</em>.\nMożna powiedzieć, że tryb <em>quirks mode</em> jest przeznaczony do interpretacji\nstarych witryn niezgodnych ze standardami, zaś tryb <em>strict mode</em> &mdash;\ndo interpretacji witryn przestrzegających standardów W3C.\nRóżnice interpretacji witryn WWW w obu trybach\ndotyczą wyłącznie arkuszy stylów CSS.\n</p>\n\n<p>\nOba tryby są konieczne i występują we wszystkich przeglądarkach.\nObecność trybu <em>quirks mode</em> jest wymuszona\nprzez ogromną ilość stron WWW, które\nbyły przygotowane w czasach, gdy standardy sieciowe\ndopiero powstawały. Witryny takie:\n</p>\n\n<ul>\n<li>nie stosują CSS w ogóle lub w bardzo ograniczonym stopniu,</li>\n<li>arkusze stylów są często niezgodne ze specyfikacją CSS\ni opierają się na rozwiązaniach, które wystąpiły w jakiejś archaicznej już dzisiaj przeglądarce,</li>\n<li>nie zawierają deklaracji <span class="variable">DOCTYPE</span>\n(lub zawierają jedną z postaci HTML 4 Transitional),</li>\n<li>stosują tabele do układu strony,</li>\n<li>stosują różne przestarzałe znaczniki (na czele z <span class="variable">font</span> i\n<span class="variable">center</span>).</li>\n</ul>\n\n<p>\nDla przeglądarki nie pozwalającej na odwiedzanie witryn\nniezgodnych ze standardami\nniedostępna byłaby większa część internetu.\nTakie oprogramowanie byłoby bezużyteczne.\n</p>\n\n<p>\nZ drugiej strony tryb <em>strict mode</em> przeglądarek jest odbiciem\npowolnej ewolucji sieci WWW w kierunku przestrzegania standardów.\nWykonanie witryny zgodnej ze standardami i\ncałkowite przystosowanie jej do\ntrybu <em>quirks mode</em> zupełnie mijałoby się z celem.\n</p>\n\n<p>\nNajprawdopodobniej liczba witryn zgodnych ze standardami będzie\nw ciągu najbliższych lat rosła.\nCzy jednak w przyszłości nastąpi całkowite przejście na tryb <em>strict mode</em>\n(do tego stopnia, że tryb <em>quirks mode</em> zniknie z przeglądarek)?\nZ racji na ilość witryn, jakie należy poddać aktualizacji,\nraczej nie jest to perspektywa najbliższych kilku lat.\nChociaż należy zauważyć, że główny czynnik wstrzymujący przejście\nna tryb <em>strict mode</em> przestaje mieć znaczenie.\nCzynnikiem tym jest procent przeglądarek wymagających\nprzystosowania witryn do <em>quirks mode</em>.\nWedług najnowszych badań dostępnych na witrynie\n<a href="http://www.ranking.pl">http://www.ranking.pl</a>\nprzeglądarki wspierające <em>strict mode</em>\nstanowią 92,1%\n(<span class="program">MSIE 6.x</span>,\n<span class="program">Firefox 1.x</span>,\n<span class="program">Opera 9.x</span>).\n</p>\n\n<p>\nDodam jeszcze, że w obydwu tych trybach przeglądarka\nignoruje wszelkie błędy HTML oraz CSS.\nPraca w trybie <em>strict mode</em> nie oznacza, że przeglądarka informuje o błędach.\nRóżnica pracy w obu trybach polega na tym, że\nw trybie <em>strict mode</em> interpretacja CSS będzie (lub być powinna) zgodna z\nustaleniami zawartymi w specyfikacjach dostępnych na stronie W3C.\nNatomiast w trybie <em>quirks mode</em> wystąpi wiele różnic,\nktórych istnienie ma podłoże historyczne.\n</p>\n\n<h3 id="R2">2. Przykładowe różnice w interpretacji CSS w trybach <em>quirks mode</em> oraz <em>strict mode</em></h3>\n\n<p>\nPrzykładowe różnice w interpretacji stylów CSS to:\n</p>\n\n<ul>\n<li>wyznaczanie szerokości pudełka,</li>\n<li>centrowanie elementów blokowych,</li>\n<li>wyświetlanie obrazów.</li>\n</ul>\n\n<p>\nPierwszy problem polega na tym, że wpis:\n</p>\n\n<pre>\ndiv {\n    width  : 100px;\n    margin : 20px;\n}\n</pre>\n\n<p>\nbędzie błędnie interpretowany przez <span class="program">IE5</span> oraz\n<span class="program">IE6</span> (ale tylko w trybie <em>quirks mode</em>).\n<span class="program">IE5</span> ustali faktyczną szerokość elementu na 100, podczas gdy prawidłowa wartość\npowinna wynosić 140 (100 + lewy margines 20 + prawy margines 20).\n</p>\n\n<p>\nDrugi problem polega na tym, że\nwyśrodkowanie elementu blokowego wykonywane prawidłowo:\n</p>\n\n<pre>\nmargin : 0 auto;\n</pre>\n\n<p>\nnie zadziała w <span class="program">IE5</span>. W przeglądarce tej należy użyć atrybutu:\n</p>\n\n<pre>\ntext-align : center;\n</pre>\n\n<p>\nWreszcie trzeci problem, wyświetlanie obrazków, dotyczy\nwielu przeglądarek, nie tylko <span class="program">IE</span>.\nElement <span class="variable">img</span>, który pierwotnie był elementem blokowym,\npo wprowadzeniu stylów CSS został przemianowany na element tekstowy.\nPod obrazkami pojawiła się kilkupikselowa pozioma przerwa.\nWynika to z tego, że wysokość elementów tekstowych\njest tak dobrana, by w linii zmieściły się litery takie jak j, p,\nczy g sięgające poniżej linii centralnej tekstu.\nProblem ten rozwiążemy zmieniając typ elementu <span class="variable">img</span>:\n</p>\n\n<pre>\nimg {\n    display : block;\n}\n</pre>\n\n<p>\nlub wysokość linii elementu blokowego, w którym obraz został umieszczony:\n</p>\n\n<pre>\nline-height : 0;\n</pre>\n\n<h3 id="R3">3. Problemy z trybami pracy</h3>\n\n<p>\nGłównym zmartwieniem jest to, że ta sama witryna może wyglądać inaczej\nw tej samej przeglądarce. Nie mówię tutaj o zmianie wersji przeglądarki.\nO tym wiemy wszyscy, że przy przejściu z numeru <span class="program">IE5</span> do\n<span class="program">IE6</span> należy spodziewać się różnic.\nMówię o tym, że ta sama witryna\nmoże inaczej wyglądać wyświetlana w trybie <em>strict mode</em>\nw <span class="program">IE6</span>\noraz w trybie <em>quirks mode</em> w <span class="program">IE6</span>.\n</p>\n\n<p>\nCzyli do całego galimatiasu przeglądarkowego należy doliczyć jeszcze jeden czynnik:\ntryb pracy. Czynnikami, które mogą wpływać na wygląd witryny są więc:\n</p>\n\n<ul>\n<li>rodzaj przeglądarki (np. <span class="program">IE</span>/<span class="program">FF</span>/<span class="program">Netscape</span>/<span class="program">Opera</span>)</li>\n<li>wersja przeglądarki (np. <span class="program">IE5</span>, <span class="program">IE6</span> lub <span class="program">Netscape</span> 4.75, <span class="program">Netscape</span> 8),</li>\n<li>tryb pracy przeglądarki: <em>strict mode</em> lub <em>quirks mode</em>.</li>\n</ul>\n\n<p>\nCzy zdarzyło Ci się kiedyś deja-vu: strona, która przed sekundą wyglądała poprawnie,\nbez wprowadzania jakichkolwiek zmian w stylach czy w kodzie HTML nagle się rozjechała?\nJa z tym problemem spotkałem się już kilkukrotnie,\nza każdym razem kosztowało mnie to wiele dodatkowej pracy.\nPlik CSS &mdash; bez zmian. Plik HTML &mdash; prawie bez zmian.\nA układ rozjeżdża się.\n</p>\n\n<p>\nWinny był właśnie tryb pracy przeglądarki.\nWitryna, która poprawnie wygląda w trybie <em>strict mode</em> może\nrozjeżdżać się w trybie <em>quirks mode</em>. I na odwrót.\nZatem badając wygląd witryny, trzeba mieć na uwadze tryb pracy przeglądarki.\n</p>\n\n<h3 id="R4">4. Jak stwierdzić tryb pracy przeglądarki?</h3>\n\n<p>\nTryb pracy przeglądarki możemy stwierdzić wykorzystując skrypt JavaScript.\nJeśli w dokumencie HTML umieścisz kod:\n</p>\n\n<pre>\n&lt;script type=&quot;text/javascript&quot;&gt;\n    alert(document.compatMode);\n&lt;/script&gt;\n</pre>\n\n<p>\nto ujrzysz komunikat informujący o trybie pracy przeglądarki podczas interpretacji\ntego konkretnego dokumentu.\nKomunikat <span class="variable">CSS1Compat</span> oznacza, że dokument jest interpretowany w trybie standardów\n(<em>strict mode</em>).\nNatomiast komunikat <span class="variable">BackCompat</span>\noznacza, że przeglądarka działa w trybie wstecznej zgodności (<em>quirks mode</em>).\n</p>\n\n<p>\nRozwiązanie takie zadziała w przeglądarkach:\n</p>\n\n<ul>\n<li><span class="program">Firefox</span></li>\n<li><span class="program">Internet Explorer 6</span></li>\n<li><span class="program">Opera</span></li>\n<li><span class="program">Netscape</span></li>\n</ul>\n\n<p>\nnatomiast nie zadziała w <span class="program">IE5</span>.\n</p>\n\n<p>\nDodatkowo, korzystając z <span class="program">Firefoxa</span> możesz posłużyć się\noknem dialogowym\n<span class="option">Narzędzia &rarr; Informacje o stronie</span>.\nRysunek 1 przedstawia informacje o witrynie interpretowanej w trybie\n<em>strict mode</em> (Tryb standardów).\nNatomiast rysunek 2 przedstawia informacje o witrynie interpretowanej w trybie\n<em>quirks mode</em> (Tryb wstecznej zgodności).\n</p>\n\n<div class="image">\r\n    <img src="figure/1.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 1.</strong>\r\n        Informacje o stronie interpretowanej przez <span class="program">Firefoxa</span> w trybie <em>strict mode</em> (Tryb standardów)\r\n    </p>\r\n</div>\n\n<div class="image">\r\n    <img src="figure/2.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 2.</strong>\r\n        Informacje o stronie interpretowanej przez <span class="program">Firefoxa</span> w trybie <em>quirks mode</em> (Tryb wstecznej zgodności)\r\n    </p>\r\n</div>\n\n<p>\nZaletą tego rozwiązania jest fakt, że nie musisz wprowadzać\njakichkolwiek zmian w kodzie HTML. Dzięki temu, możesz zbadać tryb\nwyświetlania dowolnej witryny w internecie\n(a nie tylko stron tworzonych przez Ciebie).\n</p>\n\n<h3 id="R5">5. W jaki sposób przeglądarka wybiera tryb pracy?</h3>\n\n<p>\nDo tego służy element <span class="variable">DOCTYPE</span>.\nTechnika taka jest nazywana w terminologii anglojęzycznej <em>doctype switching</em>\nlub <em>doctype sniffing</em>.\nBrak elementu <span class="variable">DOCTYPE</span> wymusza tryb <em>quirks mode</em>.\nJeśli zatem przyzwyczaiłeś się do pomijania <span class="variable">DOCTYPE</span>,\nto pora zmienić nawyki.\nPomijając <span class="variable">DOCTYPE</span> tworzysz witryny,\nktóre są interpretowane w trybie <em>quirks mode</em>, a co za tym idzie wszelkie\nrozwiązania HTML/CSS będziesz musiał ponownie zweryfikować w trybie\nstandardów.\n</p>\n\n<p>\nW zależności od stosowanego elementu <span class="variable">DOCTYPE</span>\nróżne przeglądarki mogą pracować w różnych trybach.\nNajprostszą regułą jest:\n</p>\n\n<ul>\n<li>brak elementu <span class="variable">DOCTYPE</span> włącza tryb <em>quirks mode</em></li>\n<li>element <span class="variable">DOCTYPE</span> języka XHTML 1.0 strict włącza tryb <em>strict mode</em></li>\n</ul>\n\n<p>\nOto pełna postać elementu DOCTYPE języka XHTML 1.0 strict:\n</p>\n\n<pre>\n&lt;!DOCTYPE html PUBLIC &quot;-//W3C//DTD XHTML 1.0 Strict//EN&quot;\n    &quot;http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd&quot;&gt;\n</pre>\n\n<p>\nBardziej skomplikowane reguły\nprzełączania trybów różnych przeglądarek znajdziesz pod adresem\n<a href="http://hsivonen.iki.fi/doctype/">http://hsivonen.iki.fi/doctype/</a>.\nCo ciekawe, nowe, nieznane elementy <span class="variable">DOCTYPE</span> włączają tryb zgodności ze standardami.\n</p>\n\n<p>\nPamiętaj, że wybór trybu pracy przeglądarki dotyczy wyłącznie dokumentów\nopatrzonych nagłówkiem <span class="variable">Content-Type: text/html</span>.\nDokumenty o nagłówku <span class="variable">Content-Type: application/xhtml+xml</span> są zawsze\ninterpretowane w trybie standardów.\n</p>\n\n<h3 id="R6">6. Problemy z <span class="program">IE</span></h3>\n\n<p>\nPrzeglądarka <span class="program">Internet Explorer</span> wymaga, by element DOCTYPE był pierwszym elementem\nna stronie WWW.\nJeśli przed DOCTYPE umieścisz jakikolwiek komentarz HTML:\n</p>\n\n<pre>\n&lt;!--  opis strony  --&gt;\n&lt;!DOCTYPE html PUBLIC &quot;-//W3C//DTD XHTML 1.0 Strict//EN&quot;\n    &quot;http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd&quot;&gt;\n...\n</pre>\n\n<p>\nlub znacznik XML:\n</p>\n\n<pre>\n&lt;?xml version=&quot;1.0&quot; encoding=&quot;utf-8&quot;?&gt;\n&lt;!DOCTYPE html PUBLIC &quot;-//W3C//DTD XHTML 1.0 Strict//EN&quot;\n    &quot;http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd&quot;&gt;\n...\n</pre>\n\n<p>\nto <span class="program">Internet Explorer</span> będzie pracował\nw trybie <em>quirks mode</em>.\nMusisz zatem pilnować, by przed <span class="variable">DOCTYPE</span> nie umieszczać żadnych\nwpisów (przynajmniej w wersji wysyłanej do <span class="program">IE</span>).\n</p>\n\n<h3 id="R7">7. Problemy z różnicami <span class="program">IE5</span>/<span class="program">IE6</span></h3>\n\n<p>\nProblemy z przeglądarką <span class="program">IE</span> nie kończą się na\nzagadnieniach opisanych w poprzednim punkcie.\nZnacznie poważniejszym problemem jest wspomniany\nbłąd w interpretacji szerokości pudełka.\nOpis tego problemu znajdziesz pod adresem\n<a href="http://en.wikipedia.org/wiki/internet_explorer_box_model_bug">http://en.wikipedia.org/wiki/Internet_Explorer_box_model_bug</a>.\n</p>\n\n<p>\nW skrócie, <span class="program">Internet Explorer 5</span> wyznacza szerokość elementu\nwyłącznie na podstawie atrybutu <span class="variable">width</span>.\nPrawidłowo: powinien do atrybutu <span class="variable">width</span> dodać marginesy,\npadding oraz obramowanie.\nJeśli na przykład w kodzie HTML pojawi się element <span class="variable">div</span>:\n</p>\n\n<pre>\n&lt;div id=&quot;tekst&quot;&gt;\nLorem ipsum...\n&lt;/div&gt;\n</pre>\n\n<p>\nopatrzony stylami:\n</p>\n\n<pre>\n#tekst {\n    width   : 200px;\n    padding : 50px;\n}\n</pre>\n\n<p>\nto <span class="program">IE5</span> ustali jego szerokość na 200 pikseli,\npodczas gdy prawidłowa wartość wynosi 300 pikseli\n(tj. 200 + lewy padding 50 + prawy padding 50 = 300).\n</p>\n\n<p>\nProblem ten dotyczy <span class="program">Internet Explorera 5</span> (przeglądarka ta ma tylko\njeden tryb pracy: <em>quirks mode</em>;\nnie posiada ona trybu <em>strict mode</em>)\noraz <span class="program">Internet Explorera 6</span>\nw trybie <em>quirks mode</em> (<span class="program">Internet Explorer 6</span> w trybie <em>strict mode</em>\npoprawnie interpretuje szerokość pudełka).\n</p>\n\n<p>\nJakie są konsekwencje tego błędu?\nWbrew pozorom dość poważne. Jeśli bowiem zechcesz pracować w trybie <em>strict mode</em>\ni tworzyć witryny zgodne ze standardami to na przeszkodzie stanie przeglądarka <span class="program">IE5</span>\n(wykorzystywana &mdash; wg danych z <a href="http://ranking.pl">http://ranking.pl</a> &mdash;\nprzez 2,7% polskich internautów).\n</p>\n\n<p>\nWitryna zgodna ze standardami będzie poprawnie interpretowana przez <span class="program">IE6</span>\nzaś błędnie przez <span class="program">IE5</span>. Jak zatem przygotować arkusze stylów, które będą\ninne dla przeglądarki <span class="program">IE6</span> (i wszystkich przeglądarek\npracujących w trybie <em>strict mode</em>) a inne dla <span class="program">IE5</span>?\nCzy da się przygotować rozwiązanie powyższego problemu\nbez stosowania technik po stronie serwera (np. PHP i wartości\n<span class="variable">$_SERVER[&#39;HTTP_USER_AGENT&#39;]</span>)?\n</p>\n\n<h4 id="P7-1">7.1 Rozwiązanie pierwsze: zmiana atrybutów CSS w JavaScript</h4>\n\n<p>\nPierwsze z rozwiązań wykorzystuje skrypt JS.\nSkrypt zawiera jedną funkcję o nazwie <span class="variable">przestyluj()</span>.\nFunkcja ta jest wywoływana po pobraniu dokumentu,\nprzed wyświetleniem. Dzieje się to dzięki wykorzystaniu zdarzenia <span class="variable">onload</span>\nelementu <span class="variable">body</span>:\n</p>\n\n<pre>\n...\n&lt;body onload=&quot;przestyluj();&quot;&gt;\n..\n</pre>\n\n<p>\nWewnątrz funkcji odbywa się sprawdzenie.\nCzy przeglądarka to <span class="program">Internet Explorer</span>:\n</p>\n\n<pre>\nif (navigator.userAgent.indexOf(&quot;MSIE&quot;) != -1) {\n    ...\n}\n</pre>\n\n<p>\nJeśli tak, to dalej sprawdzamy, czy przeglądarka potrafi pracować\nw trybie <em>strict mode</em>. Fakt ten stwierdzamy\nporównując <span class="variable">document.compatMode</span> z wartością\n<span class="variable">CSS1Compat</span>.\nJeśli tak, to podajemy poprawną wartość <span class="variable">width</span> wynoszącą 200.\nW przeciwnym razie (czyli dla przeglądarki <span class="program">IE5</span>) podajemy\nbłędną wartość <span class="variable">width</span> równą 300:\n</p>\n\n<pre>\nif (document.compatMode == ''CSS1Compat'') {\n    //style dla IE w trybie strict (np. IE 6)\n    var tmp = document.getElementById("tekst");\n    tmp.style.width = 200;\n} else {\n    //style dla IE w trybie quirks (np. IE 5)\n    var tmp = document.getElementById("tekst");\n    tmp.style.width = 300;\n}\n</pre>\n\n<p>\nOczywiście rozwiązanie takie zadziała offline (nie wymaga ono\nPHP), pod warunkiem, że włączona jest interpretacja skryptów JavaScript.\n</p>\n\n<p>\nKompletny kod funkcji <span class="variable">przestyluj()</span> jest przedstawiony na listingu 1.\n</p>\n\n<div class="listing">\r\n<pre>\r\nfunction przestyluj()\n{\n    if (navigator.userAgent.indexOf(&quot;MSIE&quot;) != -1) {\n        if (document.compatMode == ''CSS1Compat'') {\n\n            //style dla IE w trybie strict (np. IE 6)\n            var tmp = document.getElementById(&quot;tekst&quot;);\n            tmp.style.width = 200;\n\n        } else {\n\n            //style dla IE w trybie quirks (np. IE 5)\n            var tmp = document.getElementById(&quot;tekst&quot;);\n            tmp.style.width = 300;\n\n        }\n    }\n}\r\n</pre>\r\n<p>\r\n<strong>Listing 1.</strong>\r\nFunkcja <span class="variable">przestyluj()</span>\r\n</p>\r\n</div>\r\n\n<div class="frame">\r\nNiektóre atrybuty CSS posiadają dwuczłonowe nazwy.\nSeparatorem członów jest dywiz (czyli znak <span class="variable">-</span>), np.\n\n<pre>\npadding-left\nmargin-right\nborder-top\n</pre>\n\nDo atrybutów takich możesz odwoływać się w JavaScript\npisząc:\n\n<pre>\ntmp.style.padding_left = 8;\ntmp.style.margin_right = 8;\ntmp.style.border_top   = 8;\n</pre>\n\n<p>\nZwróć uwagę, że znak <span class="variable">-</span> (dywiz) został zastąpiony przez\npodkreślenie <span class="variable">_</span>.\nJest to konieczne, gdyż znak - nie może być &mdash; w języku JavaScript &mdash; fragmentem identyfikatora.\nPełny opis właściwości CSS znajdziesz w dokumencie\npt. <em>Document Object Model (DOM) Level 2 Style Specification</em>\npod adresem\n<a href="http://www.w3.org/tr/dom-level-2-style">http://www.w3.org/TR/DOM-Level-2-Style</a>.\n</p>\n\n<p>\nNotacją alternatywną jest:\n</p>\n\n<pre>\ntmp.style.border = &quot;1px solid black&quot;;\ntmp.style.padding = &quot;0px 10px 20px 30px&quot;;\n</pre>\r\n</div>\n\n<h4 id="P7-2">7.2 Rozwiązanie drugie: komentarze HTML będące instrukcjami dla <span class="program">IE</span></h4>\n\n<p>\nDrugim, lepszym, sposobem dostarczenia odmiennych stylów dla <span class="program">IE5</span>\noraz <span class="program">IE6</span> jest wykorzystanie\nspecjalnych komentarzy HTML interpretowanych wyłącznie przez przeglądarki <span class="program">IE</span>.\nKomentarz taki przyjmuje postać:\n</p>\n\n<pre>\n&lt;!--[if gte IE 6]&gt;\n...\n...zawartość przeznaczona dla\n...IE w wersji od 6 wzwyż\n...\n&lt;![endif]--&gt;\n</pre>\n\n<p>\nlub\n</p>\n\n<pre>\n&lt;!--[if lt IE 6]&gt;\n...\n...zawartość przeznaczona dla\n...IE w wersji poniżej 6\n...\n&lt;![endif]--&gt;\n</pre>\n\n<p>\nKażda inna przeglądarka powinna oba powyższe wpisy potraktować\njako komentarze HTML (zwróć uwagę, że są one umieszczone\npomiędzy <span class="variable">&lt;!--</span>\noraz <span class="variable">--&gt;</span>).\nNatomiast <span class="program">IE</span> (bez względu na wersję) potraktuje je jako instrukcje <span class="variable">if</span>.\nWarunki instrukcji zawierając operatory\n<span class="variable">gte</span> oraz <span class="variable">lt</span>.\nSą to skróty od angielskich terminów <em>greater than or equal</em>\n(ang. większe lub równe niż) oraz <em>less than</em> (ang. mniejsze niż).\n</p>\n\n<p>\nJeśli więc w dokumencie HTML umieścisz wpisy:\n</p>\n\n<pre>\n&lt;!--[if gte IE 6]&gt;\n&lt;style type=&quot;text/css&quot;&gt;\n#tekst {\n    width : 200px;\n}\n&lt;/style&gt;\n&lt;![endif]--&gt;\n\n&lt;!--[if lt IE 6]&gt;\n&lt;style type=&quot;text/css&quot;&gt;\n#tekst {\n    width : 300px;\n}\n&lt;/style&gt;\n&lt;![endif]--&gt;\n</pre>\n\n<p>\nto przeglądarka <span class="program">IE6</span> otrzyma poprawną wartość 200, zaś przeglądarka\n<span class="program">IE5</span> wartość 300, uwzględniającą błąd wyznaczania szerokości pudełka.\n</p>\n\n<div class="frame">\r\nPrzeglądarka IE5 uruchamiana na komputerze,\nna którym zainstalowana jest również wersja IE6,\nprzedstawia się jako IE6.\nRozwiązanie stosujące komentarze\n<span class="variable">&lt;!--[if ...]&gt;</span>\noraz\n<span class="variable">&lt;![endif]--&gt;</span>\nbędzie sprawiało wrażenie błędnego.\nW celu oceny faktycznego zachowania opisanej\nsztuczki należy ją przeanalizować na komputerze, na którym\njedyną zainstalowaną przeglądarką IE jest wersja IE5.\r\n</div>\n\n<h3 id="R8">8. Podsumowanie</h3>\n\n<p>\nJeśli myślisz o tworzeniu witryn zgodnych ze standardami,\nto powinieneś zwrócić uwagę na tryb pracy przeglądarki.\nMyślą przyszłościowo rozsądnym rozwiązaniem wydaje mi się\nprzygotowywanie witryn, które będą interpretowane\n(przez wszystkie nowe przeglądarki) w trybie standardów (<em>strict mode</em>).\n</p>\n\n<p>\nJeśli duży procent odwiedzin odbywa się przy użyciu przeglądarki <span class="program">IE5</span>,\nto problem z wyznaczaniem szerokości pudełka rozwiążesz\nstosując specjalny skrypt JS lub komentarze\nbędące instrukcjami <span class="variable">if</span> dla <span class="program">IE</span>.\n</p>\n\n<p>\nPamiętaj, że jeśli wykonywane przez Ciebie witryny są\ninterpretowane w trybie <em>quirks mode</em>,\nto nie zbliżasz się do standardów. Przekształcenie witryny\npoprawnie wyglądającej w trybie <em>quirks mode</em>, tak by była ona interpretowana w trybie\n<em>strict mode</em> może wymagać (szczególnie w odniesieniu do <span class="program">IE</span>) wiele pracy.\n</p>\n\n\n\n', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Adres</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="http://www.quirksmode.org">quirksmode &mdash; strona Petera-Paula Kocha</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>2.</td>\r\n        <td><a href="http://www.quirksmode.org/css/quirksmode.html">Quirks mode and strict mode</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>3.</td>\r\n        <td><a href="http://hsivonen.iki.fi/">Strona domowa Henri Sivonena</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>4.</td>\r\n        <td><a href="http://hsivonen.iki.fi/doctype/">Activating the Right Layout Mode Using the Doctype Declaration<br />oraz<br />Browser comparison chart</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>5.</td>\r\n        <td><a href="http://css-discuss.incutio.com/?page=boxmodelhack">BoxModelHack</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>6.</td>\r\n        <td><a href="http://en.wikipedia.org/wiki/internet_explorer_box_model_bug">Internet Explorer Box Model Bug</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>7.</td>\r\n        <td><a href="http://developer.mozilla.org/en/docs/mozilla''s_quirks_mode">Mozilla''s Quirks Mode</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>8.</td>\r\n        <td><a href="http://developer.mozilla.org/en/docs/mozilla_quirks_mode_behavior">Mozilla Quirks Mode Behavior</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>9.</td>\r\n        <td><a href="http://lxr.mozilla.org/mozilla/source/layout/style/quirk.css">Mozilla: quirks.css</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>10.</td>\r\n        <td><a href="http://en.wikipedia.org/wiki/comparison_of_web_browsers">Przeglądarki: porównanie</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>11.</td>\r\n        <td><a href="http://en.wikipedia.org/wiki/comparison_of_layout_engines">Silniki przeglądarek</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>12.</td>\r\n        <td><a href="http://browsers.evolt.org">Przeglądarki</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>13.</td>\r\n        <td><a href="http://tantek.com">Strona domowa Tanteka Celika</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>14.</td>\r\n        <td><a href="http://msdn.microsoft.com/library/default.asp?url=/workshop/author/om/measuring.asp">MSDN: Measuring Element Dimension and Location</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>15.</td>\r\n        <td><a href="http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dnie60/html/cssenhancements.asp">MSDN: CSS Enhancements in Internet Explorer 6</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>16.</td>\r\n        <td><a href="http://msdn.microsoft.com/workshop/author/dhtml/reference/objects/doctype.asp">MSDN: !DOCTYPE</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>17.</td>\r\n        <td><a href="http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dnaspp/html/aspnetusstan.asp">MSDN: Building ASP.NET 2.0 Web Sites Using Web Standards</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>18.</td>\r\n        <td><a href="http://www.w3.org/tr/dom-level-2-style">W3C: dokumentacja DOM (padding_left)</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 2.</strong> Adresy\r\n</p>\r\n\r\n</div>', '', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Przykład</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="examples/quirksmode-examples.zip">Wszystkie przykłady</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 1.</strong>  Przykłady do pobrania\r\n</p>\r\n\r\n</div>');
INSERT INTO `article` (`article_id`, `title`, `introduction`, `toc`, `slug`, `date`, `onepage`, `addresses`, `download`, `examples`) VALUES(2, 'Obsługa błędów 404 Not Found w Apache/PHP. Przewodnik', 'Wędrując po internecie niejednokrotnie natrafimy na błędne adresy URL.\nCzasami przyczyną błędu jest przeniesienie strony WWW do innego folderu, \nkiedy indziej &mdash; literówka w adresie URL.\nJeśli adres URL wskazuje nieistniejący plik, \nwówczas internauta ujrzy komunikat o błędzie.\nArtykuł opisuje, w jaki sposób\nprzygotować własne strony błędów 404 \nwykorzystując serwer <span class="program">Apache</span> oraz skrypty PHP.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="p1.html">1. Strony wyświetlane po podaniu błędnego adresu URL</a></li>\r\n<li><a href="p2.html">2. Dyrektywa ErrorDocument</a></li>\r\n<li><a href="p3.html">3. Kody błędów protokołu HTTP</a></li>\r\n<li><a href="p4.html">4. Podglądanie odpowiedzi serwera WWW</a></li>\r\n<li><a href="p5.html">5. Dyrektywa ErrorDocument i pozostałe błędy HTTP</a></li>\r\n<li><a href="p6.html">6. Ustalanie odpowiedzi HTTP w PHP</a></li>\r\n<li><a href="p7.html">7. Usuwanie dostępu do plików</a></li>\r\n<li><a href="p8.html">8. Przykład praktyczny</a>\r\n<ol>\r\n<li><a href="p8.html#P8-1">8.1 Przykładowa witryna <em>Lorem ipsum</em></a></li>\r\n<li><a href="p8.html#P8-2">8.2 Rozwiązanie pierwsze: witryna bez przyjaznych URL-i</a></li>\r\n<li><a href="p8.html#P8-3">8.3 Rozwiązanie drugie: witryna z przyjaznymi adresami URL-i</a></li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</div>\r\n', 'obsluga_bledow_404_not_found_w_apache_php_przewodnik', '2007-12-01', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Strony wyświetlane po podaniu błędnego adresu URL</a></li>\r\n<li><a href="#R2">2. Dyrektywa ErrorDocument</a></li>\r\n<li><a href="#R3">3. Kody błędów protokołu HTTP</a></li>\r\n<li><a href="#R4">4. Podglądanie odpowiedzi serwera WWW</a></li>\r\n<li><a href="#R5">5. Dyrektywa ErrorDocument i pozostałe błędy HTTP</a></li>\r\n<li><a href="#R6">6. Ustalanie odpowiedzi HTTP w PHP</a></li>\r\n<li><a href="#R7">7. Usuwanie dostępu do plików</a></li>\r\n<li><a href="#R8">8. Przykład praktyczny</a>\r\n    <ol>\r\n        <li><a href="#P8-1">8.1 Przykładowa witryna <em>Lorem ipsum</em></a></li>\r\n        <li><a href="#P8-2">8.2 Rozwiązanie pierwsze: witryna bez przyjaznych URL-i</a></li>\r\n        <li><a href="#P8-3">8.3 Rozwiązanie drugie: witryna z przyjaznymi adresami URL-i</a></li>\r\n    </ol>\r\n</li>\r\n</ol>\r\n</div>\r\n\r\n<h3 id="R1">1. Strony wyświetlane po podaniu błędnego adresu URL</h3>\n\n<p>\nJeśli w przeglądarce internetowej \nwpiszesz nieistniejący adres URL\nto ujrzysz jeden z trzech możliwych komunikatów.\n</p>\n\n<p>\nPierwszym rodzajem błędu jest \npodanie niepoprawnego adresu serwera.\nDomena <span class="variable">lorem.ipsum.pl</span>,\nnie jest opisana w DNS,\na zatem wpisanie w przeglądarce adresu:\n</p>\n\n<pre>\nhttp://lorem.ipsum.pl/dolor/sitamet.html\n</pre>\n\n<p>\nzakończy się błędem.\nW takiej sytuacji przeglądarka \nwyświetli komunikat <em>Nie odnaleziono serwera</em>\nwidoczny na rysunku 1.\n</p>\n\n<div class="image">\r\n    <img src="figure/1.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 1.</strong>\r\n        Komunikat wyświetlany przez <span class="program">Firefoksa</span> po podaniu błędnego adresu serwera\r\n    </p>\r\n</div>\n\n<p>\nDrugim rodzajem błędu jest podanie adresu URL \nzawierającego poprawną nazwę serwera oraz błędną nazwę pliku, np.:\n</p>\n\n<pre>\nhttp://example.net/lorem/ipsum/dolor.html\n</pre>\n\n\n<p>\nDomena <span class="variable">example.net</span> jest zarejestrowana i posiada stronę WWW,\nco możemy stwierdzić odwiedzając witrynę <span class="variable">http://example.net</span>.\nJednak na serwerze nie istnieje plik o nazwie:\n</p>\n\n\n\n<pre>\n/lorem/ipsum/dolor.html\n</pre>\n\n\n\n<p>\nW tej sytuacji serwer <span class="variable">example.net</span> \nwysyła odpowiedź:\n</p>\n\n<pre>\nHTTP/1.x 404 Not Found\n</pre>\n\n<p>\nna co przeglądarka reaguje wyświetlając stronę <em>Not found</em> widoczną na rysunku 2.\n</p>\n\n<div class="image">\r\n    <img src="figure/2.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 2.</strong>\r\n        Komunikat wyświetlany przez <span class="program">Firefoksa</span> po połączeniu z serwerem, na którym nie zainstalowano obsługi błędu 404\r\n    </p>\r\n</div>\n\n<p>\nTrzecim rodzajem stron wyświetlanych \nw odpowiedzi na nieistniejące adresy URL\nsą dedykowane strony obsługi błędu 404.\nStrona taka zazwyczaj zachowuje stylistykę \nserwera, a przy tym zawiera komunikat informujący o zaistniałym błędzie.\nRysunek 3 przedstawia stronę obsługi błędu 404 na serwerze \n<span class="variable">google.pl</span> po podaniu adresu:\n</p>\n\n<pre>\nhttp://www.google.pl/lorem/ipsum/dolor.html\n</pre>\n\n<div class="image">\r\n    <img src="figure/3.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 3.</strong>\r\n        Komunikat wyświetlany przez <span class="program">Firefoksa</span> po połączeniu z serwerem, na którym zainstalowano obsługę błędu 404\r\n    </p>\r\n</div>\n\n\n\n\n<p>\nMamy zatem trzy rodzaje stron wyświetlanych \npo podaniu nieistniejącego adresu URL:\n</p>\n\n\n<ul>\n<li>błędny adres serwera,</li>\n<li>poprawny adres serwera, błędna nazwa pliku, serwer nie obsługuje błędów 404,</li>\n<li>poprawny adres serwera, błędna nazwa pliku, serwer obsługuje błędy 404.</li>\n</ul>\n\n<p>\nOczywiście w przypadku pierwszego rodzaju błędu \nza wygląd wyświetlanej strony odpowiada wyłącznie przeglądarka.\nZ punktu widzenia webmastera jest to przypadek nieciekawy.\n</p>\n\n<p>\nW artykule zajmiemy się tym, w jaki sposób \nna serwerze zainstalować obsługę błędów 404 tak,\nby zamiast komunikatu z rysunku 2\ninternauta ujrzał ładną stronę WWW z rysunku 3.\nPodane przykłady będą dotyczyły wyłącznie serwera <span class="program">Apache</span> \ni interpretatora PHP.\n</p>\n\n\n<h3 id="R2">2. Dyrektywa ErrorDocument</h3>\n\n<p>\nObsługę błędnych adresów URL przez serwer <span class="program">Apache</span> \nustalamy dyrektywą <span class="variable">ErrorDocument</span>.\nDyrektywa ta może zostać umieszczona w \nogólnym pliku konfiguracyjnym serwera <span class="program">Apache</span>\n<span class="filename">httpd.conf</span> \nlub w plikach <span class="filename">.htaccess</span>.\nPonieważ firmy hostingowe zazwyczaj nie umożliwiają modyfikowania \npliku <span class="filename">httpd.conf</span>, \nzatem w przykładach wykorzystam pliki <span class="filename">.htaccess</span>.\n</p>\n\n<p>\nUtwórz trzy pliki:\n<span class="filename">.htaccess</span>,\n<span class="filename">error-404.html</span>,\n<span class="filename">error-404.css</span>\ni umieść je w folderze głównym <span class="filename">htdocs/</span> \nserwera <span class="program">Apache</span>.\n</p>\n\n<p>\nW pliku <span class="filename">.htaccess</span> wprowadź jedną linijkę:\n</p>\n\n\n<pre>\nErrorDocument 404 /error-404.html\n</pre>\n\n<p>\nW pliku <span class="filename">error-404.html</span> \nwprowadź dowolny komunikat, zaś w stylach\n<span class="filename">error-404.css</span> dowolnie ustal wygląd witryny.\nZwróć uwagę na to, by użyte adresy URL były bezwzględne.\nAdresy występują w dwóch miejscach:\n</p>\n\n<ul>\n<li>w dyrektywie <span class="variable">ErrorDocument</span> (<span class="filename">/error-404.html</span>),</li>\n<li>w elemencie <span class="variable">link</span> (<span class="filename">/error-404.css</span>).</li>\n</ul>\n\n\n\n<p>\nJeśli teraz podasz w przeglądarce adres:\n</p>\n\n\n<pre>\nhttp://localhost/lorem/ipsum/dolor.html\n</pre>\n\n\n<p>\nujrzysz wykonaną przed chwilą stronę błędu.\n</p>\n\n<p>\nJeśli użyjesz względnych adresów URL, obsługa błędu 404 nie\nbędzie wykonana poprawnie.\nDyrektywa <span class="variable">ErrorDocument</span> \nzawierająca adres względny:\n</p>\n\n\n<pre>\nErrorDocument 404 error-404.html\n</pre>\n\n\n<p>\nnie działa, zaś użycie względnego adresu stylów:\n</p>\n\n\n\n<pre>\n&lt;link rel="stylesheet" type="text/css" href="error-404.css" /&gt;\n</pre>\n\n\n\n<p>\nspowoduje, że wyłącznie adresy URL dotyczące foldera głównego, czyli np.\n</p>\n\n\n\n\n<pre>\nhttp://localhost/a.html\n</pre>\n\n\n<p>\nbędą sformatowane zgodnie z podanymi stylami.\nW przypadku strony pochodzącej z podfolderu, np.\n</p>\n\n<pre>\nhttp://localhost/a/b/c/d.html\n</pre>\n\n\n<p>\nstyle nie zostaną odnalezione.\n</p>\n\n<p>\nOczywiście strona obsługi błędu 404 może zostać wykonana w języku PHP.\nUtwórz plik <span class="filename">error-404.php</span> z dowolnym komunikatem\npo czym zmień dyrektywę <span class="variable">ErrorDocument</span>:\n</p>\n\n<pre>\nErrorDocument 404 /error-404.php\n</pre>\n\n<h3 id="R3">3. Kody błędów protokołu HTTP</h3>\n\n<p>\nLiczba 404 pojawiająca się w dyrektywie <span class="variable">ErrorDocument</span> \njest jednym z tzw. kodów błędów protokołu HTTP.\nPrzeglądarka WWW wysyła do serwera żądania \n(zdefiniowane protokołem HTTP). W odpowiedzi, serwer \nwysyła do przeglądarki odpowiedź HTTP.\nKażda odpowiedź serwera musi rozpoczynać się od kodu. \nJeśli serwer nie może zrealizować żądań klienta, \nwówczas przeglądarka może &mdash;\nna podstawie kodu dołączonego do odpowiedzi &mdash;\nczęściowo poznać przyczyny niepowodzenia.\nKody błędów protokołu HTTP mają wartości od 400 do 417.\n\nPełną listę błędów znajdziemy w specyfikacji \nRFC 2616 pod adresem \n<a href="http://www.w3.org/protocols/rfc2616/rfc2616-sec10.html#sec10.4">http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4</a>.\n</p>\n\n<p>\nPrzykładowymi błędami są:\n</p>\n\n<ul>\n<li><span class="variable">400 Bad Request</span> &mdash; błędne zapytanie HTTP,</li>\n<li><span class="variable">401 Unauthorized</span> &mdash; strona wymaga autoryzacji,</li>\n<li><span class="variable">403 Forbidden</span> &mdash; dostęp zabroniony,</li>\n<li><span class="variable">404 Not Found</span> &mdash; plik nie został odnaleziony.</li>\n</ul>\n\n<h3 id="R4">4. Podglądanie odpowiedzi serwera WWW</h3>\n\n<p>\nDo analizy zapytań i odpowiedzi HTTP wymienianych przez \nprzeglądarkę i serwer możemy użyć wtyczki <span class="program">LiveHTTPHeaders</span> \nprzeglądarki <span class="program">Firefox</span>\ndostępnej pod adresem \n<a href="http://livehttpheaders.mozdev.org">http://livehttpheaders.mozdev.org</a>\nlub dodatku \n<span class="program">ieHTTPHeaders</span>\n<span class="filename">Internet Explorera</span>\ndostępnego pod adresem \n<a href="http://www.blunck.se/iehttpheaders/iehttpheaders.html">http://www.blunck.se/iehttpheaders/iehttpheaders.html</a>.\n</p>\n\n\n\n\n<p>\nPo zainstalowaniu \nwtyczki\n<span class="program">LiveHTTPHeaders</span>\nwybierz opcję\nmenu głównego <span class="option">Narzędzia &rarr; Live HTTP Headers</span>.\nUjrzysz zakładkę wyświetlającą zapytania i odpowiedzi HTTP wysyłane i odbierane\nprzez przeglądarkę.\n</p>\n\n\n\n\n<p>\nPo podaniu adresu:\n</p>\n\n<pre>\nhttp://google.pl\n</pre>\n\n<p>\nserwer <span class="variable">google.pl</span> wysyła do przeglądarki odpowiedź\n</p>\n\n<pre>\nHTTP/1.x 200 OK\n</pre>\n\n<p>\nwidoczną na rysunku 4.\n</p>\n\n<div class="image">\r\n    <img src="figure/4.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 4.</strong>\r\n        Nagłówki protokołu HTTP wyświetlana przez wtyczkę <span class="program">Live HTTP Headers</span>\r\n    </p>\r\n</div>\n\n<p>\nOdpowiedź wysyłana przez serwer <span class="variable">google.pl</span> \npo podaniu adresu\n(strona z rysunku 3):\n</p>\n\n<pre>\nhttp://www.google.pl/lorem/ipsum/dolor.html\n</pre>\n\n<p>\nzawiera kod 404 widoczny na rysunku 5.\n</p>\n\n<div class="image">\r\n    <img src="figure/5.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 5.</strong>\r\n        Nagłówki odpowiedzi 404\r\n    </p>\r\n</div>\n\n<p>\nW ten sposób możesz sprawdzić kod odpowiedzi HTTP\nwysyłany przez serwer WWW.\n</p>\n\n<h3 id="R5">5. Dyrektywa ErrorDocument i pozostałe błędy HTTP</h3>\n\n<p>\nPoznana wcześniej dyrektywa <span class="variable">ErrorDocument</span> zawiera dwa parametry:\nkod błędu oraz adres URL:\n</p>\n\n\n<pre>\nErrorDocument  kod-błędu  url\n</pre>\n\n<p>\nPo wystąpieniu podanego błędu serwer <span class="program">Apache</span>\nwyśle w odpowiedzi do przeglądarki stronę o podanym adresie URL.\nNa przykład dyrektywa:\n</p>\n\n<pre>\nErrorDocument  403 /brak-dostepu.html\n</pre>\n\n<p>\nbędzie powodowała wysyłanie dokumentu <span class="filename">brak-dostepu.html</span>\nw odpowiedzi na błędy 403.\n</p>\n\n\n<p>\nPrzygotuj cztery pliki:\n</p>\n\n\n<ul>\n<li><span class="filename">a/.htaccess</span></li>\n<li><span class="filename">.htaccess</span></li>\n<li><span class="filename">brak-dostepu.html</span></li>\n<li><span class="filename">brak-dostepu.css</span></li>\n</ul>\n\n<p>\ni umieść je w folderze głównym serwera <span class="program">Apache</span> zachowując strukturę\nwidoczną na rysunku 6.\n</p>\n\n<div class="image">\r\n    <img src="figure/6.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 6.</strong>\r\n        Struktura folderów przykładu obsługi błędu 403\r\n    </p>\r\n</div>\n\n\n\n<p>\nW pliku <span class="filename">a/.htaccess</span> umieść jedną linijkę:\n</p>\n\n\n<pre>\nOptions -Indexes\n</pre>\n\n<p>\nPodana dyrektywa powoduje, że odwiedzenie przeglądarką adresu:\n</p>\n\n\n<pre>\nhttp://localhost/a/\n</pre>\n\n<p>\nzakończy się komunikatem 403.\n</p>\n\n\n<p>\nW pliku <span class="filename">.htaccess</span> wprowadź natomiast  dyrektywę:\n</p>\n\n\n\n<pre>\nErrorDocument 403 /brak-dostepu.html\n</pre>\n\n\n\n\n<p>\nW ten sposób skonfigurujesz obsługę błędów 403. \nJeśli teraz odwiedzisz stronę:\n</p>\n\n\n<pre>\nhttp://localhost/a/\n</pre>\n\n<p>\nto ujrzysz treść dokumentu <span class="filename">brak-dostepu.html</span>.\n</p>\n\n\n\n<p>\nOczywiście jeden plik <span class="filename">.htaccess</span> może zawierać wiele dyrektyw\n<span class="variable">ErrorDocument</span>:\n</p>\n\n\n<pre>\nErrorDocument 403 /brak-dostepu.html\nErrorDocument 404 /error-404.html\n...\n</pre>\n\n<p>\nPonadto obsługa wielu różnych błędów może być wykonywana przez\njeden dokument:\n</p>\n\n\n<pre>\nErrorDocument 403 /blad.html\nErrorDocument 404 /blad.html\n...\n</pre>\n\n<h3 id="R6">6. Ustalanie odpowiedzi HTTP w PHP</h3>\n\n\n<p>\nW języku PHP kod odpowiedzi wysyłanej przez serwer <span class="program">Apache</span> \nmożemy zmienić wywołując funkcję <span class="variable">header()</span>:\n</p>\n\n<pre>\nheader(''HTTP/1.x 404 Not Found'');\n</pre>\n\n\n<p>\nNależy pamiętać, że przed wywołaniem funkcji <span class="variable">header()</span>\nnie może pojawić się żadna instrukcja wysyłająca dane\n(np. <span class="variable">echo</span> lub <span class="variable">print</span>).\nSkrypt:\n</p>\n\n\n<pre>\n&lt;?php\necho ''Błąd! Podana strona nie istnieje!'';\nheader(''HTTP/1.x 404 Not Found'');\n?&gt;\n</pre>\n\n<p>\njest niepoprawny.\n</p>\n\n<p>\nNiektóre witryny stosują połowiczną obsługę błędu 404 nazywaną <em>soft 404</em>.\nPolega to na tym, że strona błędu 404 jest atrakcyjnie wizualna,\nale opatrzona nagłówkiem poprawnej odpowiedzi HTTP, czyli\n</p>\n\n<pre>\nHTTP/1.x 200 OK\n</pre>\n\n<h3 id="R7">7. Usuwanie dostępu do plików</h3>\n\n<p>\nJeśli skrypt składa się z kilku plików PHP dołączanych \ninstrukcją <span class="variable">require_once</span>, \nto należy pamiętać o tym, by żadne skrypty zawierające\ntajne informacje nie były dostępne w ramach usługi WWW.\nJeśli w pliku <span class="filename">db.inc</span>\nzapiszemy hasło dostępu do bazy danych:\n</p>\n\n<pre>\n$link = mysql_connect(''localhost'', ''appadm'', ''tajnehaslo'');\n</pre>\n\n<p>\na plik umieścimy w folderze <span class="filename">include/</span>,\nto wystarczy użyć adresu:\n</p>\n\n<pre>\nhttp://example.net/include/db.inc\n</pre>\n\n<p>\nby poznać dane konta <span class="variable">appadm</span>.\n</p>\n\n\n<p>\nJeśli to tylko możliwe, to wszystkie biblioteki, szablony \ni pliki z danymi należy przenieść poza drzewo katalogów widoczne \nw ramach usługi WWW (np. poza folder <span class="filename">public_html/</span>).\nNiestety wielu dostawców hostingu nie umożliwia tego:\nwszystkie pliki nagrywane na serwerze znajdują się w folderze dostępnym \npoprzez WWW.\nW takiej sytuacji należy wykorzystać plik <span class="filename">.htaccess</span>.\n</p>\n\n\n<p>\nDyrektywa:\n</p>\n\n<pre>\n&lt;Files ~ "\\.php$"&gt;\n    Order allow,deny\n    Deny from all\n&lt;/Files&gt;\n</pre>\n\n<p>\nwyłącza dostęp do plików, których \nnazwa kończy się rozszerzeniem <span class="filename">.php</span>.\n</p>\n\n\n<p>\nW podobny sposób możemy wyłączyć:\n</p>\n\n\n<pre>\n&lt;Files ~ "\\.txt$"&gt;\n    Order allow,deny\n    Deny from all\n&lt;/Files&gt;\n</pre>\n\n\n\n\n<p>\nlub włączyć\n</p>\n\n\n\n<pre>\n&lt;Files ~ "\\.png$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n</pre>\n\n\n<p>\ndostęp do dowolnego rodzaju plików.\n</p>\n\n\n\n<h3 id="R8">8. Przykład praktyczny</h3>\n\n<p>\nJako przykład praktyczny przeanalizujmy dwie witryny WWW.\nJedna z nich będzie \nstosowała zwykłe adresy URL, a druga &mdash; adresy przyjazne.\nWitryny te są tak wykonane, by mogły zostać umieszczone\nna serwerze udostępnianym przez zewnętrzną firmę.\nZakładamy, że:\n</p>\n\n<ul>\n<li>serwer obsługuje pliki <span class="filename">.htaccess</span>,</li>\n<li>wszystkie pliki umieszczane na serwerze są dostępne poprzez WWW.</li>\n</ul>\n\n<h4 id="P8-1">8.1 Przykładowa witryna <em>Lorem ipsum</em></h4>\n\n\n<p>\nWygląd witryny jest przedstawiony na rysunku 7.\nJest ona wykonana w PHP przy wykorzystaniu szablonów \n<span class="program">Smarty</span> i plików tekstowych.\nPoziome menu witryny powstaje na podstawie pliku tekstowego\n<span class="filename">dane/menu.txt</span> o zawartości:\n</p>\n\n\n<pre>\nLorem|lorem.txt|2\nIpsum|ipsum.txt|3\nDolor|dolor.txt|4\nSit amet|sit-amet.txt|5\n</pre>\n\n\n<p>\nKażda linijka pliku opisuje jedną opcję. Kolejne kolumny\nto:\n</p>\n\n\n<ul>\n<li>tytuł opcji umieszczany w menu strony,</li>\n<li>nazwa pliku tekstowego z zawartością strony,</li>\n<li>wartość zmiennej <span class="variable">id</span> \nużytej w adresie <span class="variable">index.php?id=XXX</span>.</li>\n</ul>\n\n\n\n<p>\nCała witryna stosuje następujące adresy URL:\n</p>\n\n<pre>\nindex.php?id=1 - strona błędu 404\nindex.php?id=2 - strona lorem\nindex.php?id=3 - strona ipsum\nindex.php?id=4 - strona dolor\nindex.php?id=5 - strona sit amet\nimg/*.png      - obrazy użyte na stronie\nstyle.css      - style strony\n</pre>\n\n<p>\nDodatkowo adres <span class="variable">index.php</span>\njest przekierowaniem\ndo strony domyślnej <em>lorem</em> o adresie \n<span class="variable">index.php?id=2</span>.\n</p>\n\n\n<div class="image">\r\n    <img src="figure/7.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 7.</strong>\r\n        Przykładowa witryna\r\n    </p>\r\n</div>\n\n<p>\nWitryna składa się z plików i folderów przedstawionych na rysunku 8.\nW ramach usługi WWW dostępnymi plikami powinny być wyłącznie:\n</p>\n\n\n<pre>\nindex.php\nstyle.css\nimg/*.png\n</pre>\n\n\n\n\n<p>\nżadne pliki z folderów:\n</p>\n\n\n\n<pre>\ndane/\ninclude/\ntemplate/\ntemplate_c/\n</pre>\n\n\n\n<p>\nnie powinny być dostępne poprzez WWW.\n</p>\n\n\n<div class="image">\r\n    <img src="figure/8.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 8.</strong>\r\n        Pliki i foldery omawianego przykładu\r\n    </p>\r\n</div>\n\n<h4 id="P8-2">8.2 Rozwiązanie pierwsze: witryna bez przyjaznych URL-i</h4>\n\n<p>\nW przypadku witryny, która nie stosuje przyjaznych adresów URL\nw pliku <span class="filename">.htaccess</span> \numieszczamy następujące dyrektywy:\n</p>\n\n<ul>\n<li>ustalamy stronę domyślną,</li>\n<li>definiujemy strony błędów,</li>\n<li>wyłączamy dostęp do plików.</li>\n</ul>\n\n\n<p>\nDo ustalenia strony domyślnej stosujemy dyrektywy\n<span class="variable">Options</span> oraz <span class="variable">DirectoryIndex</span>:\n</p>\n\n\n\n<pre>\nOptions -Indexes\nDirectoryIndex index.php\n</pre>\n\n\n\n<p>\nPierwsza z nich wyłącza możliwość listowania zawartości katalogu,\na druga ustala, że adres kończący się nazwą folderu, np.\n</p>\n\n\n<pre>\nhttp://localhost/przyklad/\n</pre>\n\n\n\n<p>\nbędzie odwoływał się do pliku:\n</p>\n\n<pre>\nhttp://localhost/przyklad/index.php\n</pre>\n\n\n<p>\nNastępnie ustalamy strony błędów:\n</p>\n\n\n\n<pre>\nErrorDocument 404 /index.php?id=1\nErrorDocument 403 /index.php?id=1\n</pre>\n\n\n\n<p>\npamiętając o tym, by w skrypcie <span class="filename">index.php</span> \nużyć funkcji \n<span class="variable">header()</span> do generowania nagłówka <em>Not found</em>:\n</p>\n\n\n\n<pre>\nif ($akcja == 1) {\n    header(''HTTP/1.x 404 Not Found'');    \n} else {\n    ...\n}\n</pre>\n\n\n\n\n<p>\nNa zakończenie blokujemy dostęp do wszystkich plików:\n</p>\n\n\n<pre>\n&lt;Files ~ ".*$"&gt;\n    Order allow,deny\n    Deny from all\n&lt;/Files&gt;\n</pre>\n\n\n\n<p>\npo czym odblokowujemy dostęp do plików <span class="filename">index.php</span>,\n<span class="filename">.css</span>, <span class="filename">.png</span>\noraz do folderu:\n</p>\n\n<pre>\n&lt;Files ~ "index\\.php$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ "\\.css$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ "\\.png$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ "^$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n</pre>\n\n\n\n<p>\nPełna zawartość pliku <span class="filename">.htaccess</span> jest przedstawiona na listingu 1.\n</p>\n\n<div class="listing">\r\n<pre>\r\nOptions -Indexes\n\nDirectoryIndex index.php\n\nErrorDocument 404 /index.php?id=1\nErrorDocument 403 /index.php?id=1\n\n&lt;Files ~ &quot;.*$&quot;&gt;\n    Order allow,deny\n    Deny from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;index\\.php$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;\\.css$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;\\.png$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;^$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\r\n</pre>\r\n<p>\r\n<strong>Listing 1.</strong>\r\nPlik <span class="filename">.htaccess</span> rozwiązania bez przyjaznych adresów URL\r\n</p>\r\n</div>\r\n\n\n<h4 id="P8-3">8.3 Rozwiązanie drugie: witryna z przyjaznymi adresami URL-i</h4>\n\n\n<p>\nPrzypadek, w którym witryna stosuje przyjazne adresy URL jest nieco bardziej\nskomplikowany.\nTym razem stosujemy adresy <span class="filename">.html</span>,\nktóre będą przekierowane na skrypty PHP:\n</p>\n\n<pre>\nerror.html       -&gt;  index.php?id=1\nlorem.html       -&gt;  index.php?id=2\nipsum.html       -&gt;  index.php?id=3\ndolor.html       -&gt;  index.php?id=4\nsit-amet.html    -&gt;  index.php?id=5\n</pre>\n\n\n\n<p>\nPodobnie jak poprzednio, plik <span class="filename">.htaccess</span> \nrozpoczynamy od ustalenia strony domyślnej:\n</p>\n\n\n\n<pre>\nOptions -Indexes\nDirectoryIndex index.php\n</pre>\n\n\n\n<p>\nNastępnie dołączamy dyrektywy odpowiedzialne za translacje adresów:\n</p>\n\n\n\n<pre>\nRewriteEngine on\nRewriteRule ^error\\.html$       index.php?id=1\nRewriteRule ^lorem\\.html$       index.php?id=2\nRewriteRule ^ipsum\\.html$       index.php?id=3\nRewriteRule ^dolor\\.html$       index.php?id=4\nRewriteRule ^sit-amet\\.html$    index.php?id=5\n</pre>\n\n\n\n\n<p>\nPo czym ustalamy strony błędów:\n</p>\n\n\n<pre>\nErrorDocument 404 /error.html\nErrorDocument 403 /error.html\n</pre>\n\n\n\n\n<p>\ni blokujemy dostęp do plików:\n</p>\n\n\n\n<pre>\n&lt;Files ~ ".*$"&gt;\n    Order allow,deny\n    Deny from all\n&lt;/Files&gt;\n\n&lt;Files ~ "index\\.php$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ "\\.html$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ "\\.css$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ "\\.png$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ "^$"&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n</pre>\n\n\n\n<p>\nKompletny plik <span class="filename">.htaccess</span> \njest przedstawiony na listingu 2.\n</p>\n\n<div class="listing">\r\n<pre>\r\nOptions -Indexes\nDirectoryIndex index.php\n\nRewriteEngine on\n\nRewriteRule ^error\\.html$               index.php?id=1\nRewriteRule ^lorem\\.html$               index.php?id=2\nRewriteRule ^ipsum\\.html$               index.php?id=3\nRewriteRule ^dolor\\.html$               index.php?id=4\nRewriteRule ^sit-amet\\.html$            index.php?id=5\n\nErrorDocument 404 /error.html\nErrorDocument 403 /error.html\n\n&lt;Files ~ &quot;.*$&quot;&gt;\n    Order allow,deny\n    Deny from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;index\\.php$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;\\.html$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;\\.css$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;\\.png$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\n\n&lt;Files ~ &quot;^$&quot;&gt;\n    Order allow,deny\n    Allow from all\n&lt;/Files&gt;\r\n</pre>\r\n<p>\r\n<strong>Listing 2.</strong>\r\nPlik <span class="filename">.htaccess</span> rozwiązania stosującego przyjazne URL-e\r\n</p>\r\n</div>\r\n\n\n\n<p>\nW kodzie skryptu PHP możemy dodatkowo zablokować dostęp \ndo witryny adresami <span class="filename">index.php</span>:\n</p>\n\n\n\n<pre>\nif (preg_match(''/index\\.php/'', $_SERVER[''REQUEST_URI''])) {\n    header(''Location: http://localhost/lorem.html'');\n    header(''HTTP/1.x 301 Moved Permanently'');\n}\n</pre>\n\n\n\n\n<p>\nDzięki temu odwołania do stron:\n</p>\n\n\n<pre>\nindex.php\nindex.php?id=2\nindex.php?id=3\n...\n</pre>\n\n\n<p>\nbędą przekierowywane na stronę główną.\n</p>\n\n<div class="frame">\r\n<h5>Uwaga</h5>\n\n<p>\nPonieważ przykładowe witryny stosują adresy bezwzględne:\n</p>\n\n\n<pre>\n/style.css\n/lorem.html\n/img/logo.png\n...\n</pre>\n\n<p>\nprzykłady należy uruchamiać w folderze głównym serwera.\n</p>\r\n</div>\n\n\n\n\n', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Adres</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="http://httpd.apache.org/docs/2.0/mod/core.html#errordocument">Apache 2.0: dokumentacja dyrektywy <span class="variable">ErrorDocument</span></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>2.</td>\r\n        <td><a href="http://www.w3.org/protocols/rfc2616/rfc2616-sec10.html#sec10.4">RFC 2616: kody błędów protokołu HTTP</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>3.</td>\r\n        <td><a href="http://en.wikipedia.org/wiki/http_404">HTTP 404 &mdash; hasło w Wikipedii</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>4.</td>\r\n        <td><a href="http://pl.php.net/manual/pl/function.header.php">Dokumentacja PHP: opis funkcji <span class="variable">header()</span></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>5.</td>\r\n        <td><a href="http://www.plinko.net/404/history.asp">History of 404</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>6.</td>\r\n        <td><a href="http://www.onlamp.com/pub/a/onlamp/2003/02/13/davidsklar.html">D. Sklar: <em>Custom Error Pages with PHP and Apache</em></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>7.</td>\r\n        <td><a href="http://www.alistapart.com/articles/perfect404/">Ian Lloyd: <em>The Perfect 404</em></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>8.</td>\r\n        <td><a href="http://livehttpheaders.mozdev.org">Wtyczka <span class="program">LiveHTTPHeaders</span> przeglądarki <span class="program">Firefox</span></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>9.</td>\r\n        <td><a href="http://www.blunck.se/iehttpheaders/iehttpheaders.html">Wtyczka <span class="program">ieHTTPHeaders</span> przeglądarki <span class="program">Internet Explorer</span></a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 2.</strong> Adresy\r\n</p>\r\n\r\n</div>', '', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Przykład</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="examples/1-htaccess-html-bezwzgledne.zip">Obsługa błędu 404: plik <span class="filename">.htaccess</span>, statyczny plik <span class="filename">error-404.html</span>, bezwzględne URL-a</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>2.</td>\r\n        <td><a href="examples/2-htaccess-html-wzgledne.zip">Obsługa błędu 404: plik <span class="filename">.htaccess</span>, statyczny plik <span class="filename">error-404.html</span>, względne URL-a</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>3.</td>\r\n        <td><a href="examples/3-htaccess-php-bezwzgledne.zip">Obsługa błędu 404: plik <span class="filename">.htaccess</span>, skrypt <span class="filename">error-404.php</span>, bezwzględne URL-a</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>4.</td>\r\n        <td><a href="examples/4-blad-403.zip">Obsługa błędu 403</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>5.</td>\r\n        <td><a href="examples/5-header.zip">Zmiana nagłówka HTTP w PHP (funkcja <span class="variable">header()</span>)</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>6.</td>\r\n        <td><a href="examples/6-deny.zip">Blokada dostępu do plików (dyrektywa <span class="variable">Deny</span> w pliku <span class="filename">.htaccess</span>)</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>7.</td>\r\n        <td><a href="examples/7-szablon-html.zip">Przykładowa witryna: szablon XHTML/CSS</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>8.</td>\r\n        <td><a href="examples/8-witryna.zip">Przykładowa witryna bez obsługi błędów 403, 404</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>9.</td>\r\n        <td><a href="examples/9-bez-rewrite.zip">Przykładowa witryna z obsługą błędów 403, 404</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>10.</td>\r\n        <td><a href="examples/10-rewrite.zip">Przykładowa witryna stosująca przyjazne URL-e z obsługą błędów 403, 404</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 1.</strong>  Przykłady do pobrania\r\n</p>\r\n\r\n</div>');
INSERT INTO `article` (`article_id`, `title`, `introduction`, `toc`, `slug`, `date`, `onepage`, `addresses`, `download`, `examples`) VALUES(3, 'Pliki <span class="filename">robots.txt</span> i <span class="filename">sitemap.xml</span>. Kontrola zachowania robotów internetowych', '<strong>Roboty internetowe</strong> (ang. <em>web spiders</em>, \n<em>web crawlers</em>) przez cały czas przemierzają internet\nanalizując, archiwizując oraz indeksując znalezione zasoby.\nAdministrator serwisu WWW może w pewnym stopniu \nkontrolować zachowanie robotów odwiedzających jego witrynę.\nUmożliwiają to pliki\n<span class="filename">robots.txt</span> oraz <span class="filename">sitemap.xml</span>.\nPierwszy z nich, <span class="filename">robots.txt</span>,\npozwala na blokowanie dostępu do wybranych \npodstron serwisu dla konkretnych robotów.\nDrugi, <span class="filename">sitemap.xml</span>, zachęca roboty do szybszego \ni dokładniejszego indeksowania.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="p1.html">1. Roboty internetowe</a></li>\r\n<li><a href="p2.html">2. Plik <span class="filename">robots.txt</span></a></li>\r\n<li><a href="p3.html">3. Składnia pliku <span class="filename">robots.txt</span></a></li>\r\n<li><a href="p4.html">4. Przykładowe pliki <span class="filename">robots.txt</span></a>\r\n<ol>\r\n<li><a href="p4.html#P4-1">4.1 Przykład 1</a></li>\r\n<li><a href="p4.html#P4-2">4.2 Przykład 2</a></li>\r\n<li><a href="p4.html#P4-3">4.3 Przykład 3</a></li>\r\n<li><a href="p4.html#P4-4">4.4 Przykład 4</a></li>\r\n<li><a href="p4.html#P4-5">4.5 Przykład 5</a></li>\r\n<li><a href="p4.html#P4-6">4.6 Przykład 6</a></li>\r\n</ol>\r\n</li>\r\n<li><a href="p5.html">5. Rozszerzenia oryginalnej składni <span class="filename">robots.txt</span></a></li>\r\n<li><a href="p6.html">6. Plik <span class="filename">sitemap.xml</span></a></li>\r\n<li><a href="p7.html">7. Format pliku <span class="filename">sitemap.xml</span></a>\r\n<ol>\r\n<li><a href="p7.html#P7-1">7.1 Element <span class="variable">urlset</span></a></li>\r\n<li><a href="p7.html#P7-2">7.2 Element <span class="variable">url</span></a></li>\r\n<li><a href="p7.html#P7-3">7.3 Element <span class="variable">loc</span></a></li>\r\n<li><a href="p7.html#P7-4">7.4 Element <span class="variable">lastmod</span></a></li>\r\n<li><a href="p7.html#P7-5">7.5 Element <span class="variable">changefreq</span></a></li>\r\n<li><a href="p7.html#P7-6">7.6 Element <span class="variable">priority</span></a></li>\r\n<li><a href="p7.html#P7-7">7.7 Przykład pojedynczego pliku z mapą witryny</a></li>\r\n</ol>\r\n</li>\r\n<li><a href="p8.html">8. Lista map</a>\r\n<ol>\r\n<li><a href="p8.html#P8-1">8.1 Element <span class="variable">sitemapindex</span></a></li>\r\n<li><a href="p8.html#P8-2">8.2 Element <span class="variable">sitemap</span></a></li>\r\n<li><a href="p8.html#P8-3">8.3 Przykład mapy z indeksem</a></li>\r\n</ol>\r\n</li>\r\n<li><a href="p9.html">9. <span class="filename">robots.txt</span> + <span class="filename">sitemap.xml</span> = ułatwienie indeksacji witryny</a></li>\r\n</ol>\r\n</div>\r\n', 'pliki_robots_txt_i_sitemap_xml_kontrola_zachowania_robotow_internetowych', '2007-12-01', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Roboty internetowe</a></li>\r\n<li><a href="#R2">2. Plik <span class="filename">robots.txt</span></a></li>\r\n<li><a href="#R3">3. Składnia pliku <span class="filename">robots.txt</span></a></li>\r\n<li><a href="#R4">4. Przykładowe pliki <span class="filename">robots.txt</span></a>\r\n    <ol>\r\n        <li><a href="#P4-1">4.1 Przykład 1</a></li>\r\n        <li><a href="#P4-2">4.2 Przykład 2</a></li>\r\n        <li><a href="#P4-3">4.3 Przykład 3</a></li>\r\n        <li><a href="#P4-4">4.4 Przykład 4</a></li>\r\n        <li><a href="#P4-5">4.5 Przykład 5</a></li>\r\n        <li><a href="#P4-6">4.6 Przykład 6</a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R5">5. Rozszerzenia oryginalnej składni <span class="filename">robots.txt</span></a></li>\r\n<li><a href="#R6">6. Plik <span class="filename">sitemap.xml</span></a></li>\r\n<li><a href="#R7">7. Format pliku <span class="filename">sitemap.xml</span></a>\r\n    <ol>\r\n        <li><a href="#P7-1">7.1 Element <span class="variable">urlset</span></a></li>\r\n        <li><a href="#P7-2">7.2 Element <span class="variable">url</span></a></li>\r\n        <li><a href="#P7-3">7.3 Element <span class="variable">loc</span></a></li>\r\n        <li><a href="#P7-4">7.4 Element <span class="variable">lastmod</span></a></li>\r\n        <li><a href="#P7-5">7.5 Element <span class="variable">changefreq</span></a></li>\r\n        <li><a href="#P7-6">7.6 Element <span class="variable">priority</span></a></li>\r\n        <li><a href="#P7-7">7.7 Przykład pojedynczego pliku z mapą witryny</a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R8">8. Lista map</a>\r\n    <ol>\r\n        <li><a href="#P8-1">8.1 Element <span class="variable">sitemapindex</span></a></li>\r\n        <li><a href="#P8-2">8.2 Element <span class="variable">sitemap</span></a></li>\r\n        <li><a href="#P8-3">8.3 Przykład mapy z indeksem</a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R9">9. <span class="filename">robots.txt</span> + <span class="filename">sitemap.xml</span> = ułatwienie indeksacji witryny</a></li>\r\n</ol>\r\n</div>\r\n\r\n<h3 id="R1">1. Roboty internetowe</h3>\n\n<p>\n<strong>Roboty internetowe</strong>,\nnazywane \nw anglojęzycznej literaturze\n<em>web crawler</em>,\n<em>web spider</em>\nczy <em>web robot</em>\nto programy komputerowe \nautomatycznie przeszukujące\nzasoby sieci WWW.\nWędrują one po sieci WWW,\npobierając adresy kolejnych stron do odwiedzenia\nz hiperłączy znalezionych w dokumentach.\nRobot, który trafi na stronę główną witryny\nzawierającej kod:\n</p>\n\n\n<pre>\n&lt;body&gt;\n  ...\n  &lt;ul id="menu"&gt;\n    &lt;li&gt;&lt;a href="lorem.html"&gt;lorem&lt;/a&gt;&lt;/li&gt;\n    &lt;li&gt;&lt;a href="ipsum.html"&gt;ipsum&lt;/a&gt;&lt;/li&gt;\n    &lt;li&gt;&lt;a href="dolor.html"&gt;dolor&lt;/a&gt;&lt;/li&gt;	        \n    ...\n  &lt;/ul&gt;\n  ...\n&lt;/body&gt;\n</pre>\n\n<p>\npozna adresy podstron:\n<span class="filename">lorem.html</span>,\n<span class="filename">ipsum.html</span> i\n<span class="filename">dolor.html</span>.\nW następnym etapie pobierze wymienione trzy \ndokumenty i przeanalizuje je.\nWyszuka wszystkie występujące w nich hiperłącza,\na znalezione adresy \ndoda do listy stron, które zostaną przeszukane \nw następnym etapie.\nW ten sposób robot internetowy,\nrozpoczynając wędrówkę od strony głównej,\nmoże wędrować po wszystkich podstronach serwisu,\na także &mdash; w przypadku hiperłączy prowadzących do \ninnych witryn &mdash; przemieszczać się \npomiędzy różnymi domenami.\n</p>\n\n<p>\nKażdy robot jest identyfikowany \npoprzez nazwę przekazywaną w \nparametrze <span class="variable">User-Agent</span> protokołu HTTP:\n</p>\n\n<pre>\nUser-Agent: CERN-LineMode/2.15 libwww/2.17b3\n</pre>\n\n<p>\nZatem dostęp do stron serwisu możemy \nblokować wybranym robotom na podstawie ich nazwy.\n(Obszerna baza danych \nz nazwami robotów jest dostępna pod adresem \n<a href="http://www.user-agents.org">http://www.user-agents.org</a>.\nNazwy robotów Google są zawarte w ramce.)\n</p>\n\n<div class="frame">\r\n<p>\nNazwy robotów Google:\n</p>\n\n<ul>\n<li><strong>Googlebot</strong> &mdash; przemierza strony uwzględniane w indeksie witryn internetowych i Google News</li>\n<li><strong>Googlebot-Mobile</strong> &mdash; przemierza strony uwzględniane w indeksie witryn komórkowych</li>\n<li><strong>Googlebot-Image</strong> &mdash; przemierza strony uwzględniane w indeksie grafiki</li>\n<li><strong>Mediapartners-Google</strong> &mdash; przemierza strony w celu ustalenia treści AdSense. Ten robot jest stosowany tylko do przemierzania witryn, w których wyświetlane są reklamy AdSense.</li>\n<li><strong>Adsbot-Google</strong> &mdash; przemierza strony w celu oceny jakości strony docelowej AdWords. Ten robot jest stosowany tylko do indeksowania witryn reklamowanych w programie Google AdWords. Dodatkowe informacje o tym robocie i sposobach blokowania mu dostępu do części witryny.</li>\n</ul>\r\n</div>\n\n<p>\nZadania realizowane przez robota mogą być różne: \nod utworzenia kopii serwisu,\nprzez audyt i walidację aż po utworzenie indeksu \npodstron na potrzeby wyszukiwarki.\nBez wątpienia najważniejszą grupą\nsą <strong>roboty wyszukiwarek internetowych</strong>,\nodpowiedzialne za indeksację witryny.\nGoogle, Onet, Yahoo, WP &mdash; wszystkie \nwyszukiwarki dysponują własnymi robotami,\nktóre bezustannie przeszukują internet\ni uaktualniają bazę danych wyszukiwarki.\nTo, na ile witryna jest przyjazna robotom wyszukiwarek,\nmoże mieć wpływ na pozycjonowanie.\n</p>\n\n<p>\nDwie podstawowe techniki ułatwiania dostępu do podstron witryny robotom\nwyszukiwarek to czytelne hiperłącza i strona z mapą witryny.\nMetody te warto wzbogacić o \npliki <span class="filename">robots.txt</span> oraz \n<span class="filename">sitemap.xml</span>.\nW ten sposób zyskamy dodatkowe możliwości poinformowania robotów \no pełnej zawartości serwisu.\nUłatwi to indeksację nowych podstron oraz aktualizację danych \nstron już zaindeksowanych.\n</p>\n\n<h3 id="R2">2. Plik <span class="filename">robots.txt</span></h3>\n\n<p>\nPlik <span class="filename">robots.txt</span> pozwala na zablokowanie \ndostępu do stron WWW robotom internetowym.\nNależy go umieścić w folderze głównym serwisu WWW.\nNa przykład dla witryny <span class="variable">http://www.example.net</span>\nplik <span class="filename">robots.txt</span> powinien być dostępny pod adresem\n<span class="variable">http://www.example.net/robots.txt</span>.\n</p>\n\n<p>\nBrak pliku <span class="filename">robots.txt</span> lub plik \n<span class="filename">robots.txt</span> o pustej zawartości\npozwalają wszystkim robotom\nna pełny dostęp do wszystkich dokumentów na serwerze.\n</p>\n\n<p>\nW zależności od robota, plik <span class="variable">robots.txt</span> \nmoże być pobierany \nw różnych odstępach czasu.\nNa przykład roboty Google \npobierają plik <span class="filename">robots.txt</span> raz na dobę.\n(Datę i godzinę ostatniego pobrania pliku <span class="filename">robots.txt</span>\nprzez robota Google możemy \nsprawdzić w <span class="option">Narzędziach Webmastera</span> dostarczanych\nprzez Google\n<a href="http://www.google.com/webmasters/">http://www.google.com/webmasters/</a>.)\nIlustruje to rysunek 1.\n</p>\n\n<div class="image">\r\n    <img src="figure/1.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 1.</strong>\r\n        Data i godzina ostatniego pobrania pliku <span class="filename">robots.txt</span>\r\n    </p>\r\n</div>\n\n<p>\nKażda domena ma oddzielny plik <span class="filename">robots.txt</span>.\nDla domen:\n</p>\n\n<pre>\nexample.net\na.example.net\nb.example.net\n</pre>\n\n<p>\nroboty będą szukały plików:\n</p>\n\n<pre>\nhttp://example.net/robots.txt\nhttp://a.example.net/robots.txt\nhttp://b.example.net/robots.txt\n</pre>\n\n<p>\nNależy pamiętać, że robot może nie stosować się do zaleceń\nzawartych w pliku <span class="filename">robots.txt</span>.\nPlik ten <strong>nie może być traktowany</strong> jako mechanizm zabezpieczania \ndostępu do tajnych danych.\n</p>\n\n<div class="frame">\r\n<h5>Robots Exclusion Protocol</h5>\n\n<p>\nProtokół <strong>Robots Exclusion Protocol</strong>\n(nazywany również <strong>Robots Exclusion Standard</strong>\nlub <strong>robots.txt Protocol</strong>)\npozwala na ochronę zawartości całości lub fragmentów \npublicznie dostępnego serwisu WWW przed robotami internetowymi.\n</p>\n\n<p>\nPowstał w 1994 lecz pomimo powszechnego użycia \naż do dzisiaj nie doczekał się\noficjalnej specyfikacji czy dokumentu RFC.\nNajpełniejsze informacje dotyczące\nprotokołu są zawarte na stronach\n<strong>The Web Robots Pages</strong>\npod adresem \n<a href="http://www.robotstxt.org/wc/robots.html">http://www.robotstxt.org/wc/robots.html</a>.\n</p>\r\n</div>\n\n<h3 id="R3">3. Składnia pliku <span class="filename">robots.txt</span></h3>\n\n<p>\nPierwotnie, pliki <span class="filename">robots.txt</span> \nmogły zawierać wyłącznie dwa rodzaje wpisów:\n</p>\n\n<pre>\nUser-agent\nDisallow\n</pre>\n\n<p>\nBłędem jest na przykład użycie \n<span class="variable">Allow</span>:\n</p>\n\n<pre>\n<strong>PRZYKŁAD BŁĘDNY</strong>\nAllow\n</pre>\n\n<p>\nCo ciekawe, wpisy <span class="variable">Allow</span> występują w \npliku <a href="http://www.google.com/robots.txt">http://www.google.com/robots.txt</a>.\n</p>\n\n<p>\nPierwszy z wpisów, <span class="variable">User-agent</span>, \nustala nazwę robota, np.:\n</p>\n\n<pre>\nUser-agent: *\nUser-agent: Slurp\nUser-agent: Googlebot\n</pre>\n\n<p>\nDrugi wpis, <span class="variable">Disallow</span>, \npodaje nazwę pliku lub folderu,\ndo którego dostęp ma być zablokowany, np.:\n</p>\n\n<pre>\nDisallow: /\nDisallow: /tmp/\nDisallow: /info.html\nDisallow: /me.jpg\n</pre>\n\n<p>\nWpis <span class="variable">User-agent</span> występuje jako pierwszy,\na po nim następuje jeden lub kilka wpisów <span class="variable">Disallow</span>, np.:\n</p>\n\n<pre>\nUser-agent: Googlebot\nDisallow: /cgi/\nDisallow: /tmp/\nDisallow: /data/photos/\nDisallow: /data/texts/\n</pre>\n\n<p>\nW pliku <span class="filename">robots.txt</span> \nmogą występować jednolinijkowe komentarze rozpoczynające się\nznakiem <span class="variable">#</span> (haszmark):\n</p>\n\n<pre>\n# Ogolne\nUser-agent: *\nDisallow: /\n</pre>\n\n<p>\nUwaga: znak <span class="variable">*</span> nie jest dozwolony w ścieżkach. \nCzęść robotów może go nie interpretować, przez co uzyskają dostęp do \nzasobów, które miały być zablokowane.\nZamiast:\n</p>\n\n<pre>\n<strong>PRZYKŁAD BŁĘDNY</strong>\nDisallow: /tmp/*\n</pre>\n\n<p>\nnależy pisać:\n</p>\n\n<pre>\nDisallow: /tmp/\n</pre>\n\n<h3 id="R4">4. Przykładowe pliki <span class="filename">robots.txt</span></h3>\n\n<h4 id="P4-1">4.1 Przykład 1</h4>\n\n<p>\nWszystkie roboty mogą odwiedzać wszystkie pliki:\n</p>\n\n<pre>\nUser-agent: *\nDisallow:\n</pre>\n\n<p>\nTen sam efekt da pusty plik <span class="filename">robots.txt</span> \nlub brak pliku <span class="filename">robots.txt</span>.\n</p>\n\n<h4 id="P4-2">4.2 Przykład 2</h4>\n\n<p>\nZakaz pobierania czegokolwiek przez kogokolwiek:\n</p>\n\n<pre>\nUser-agent: *\nDisallow: /\n</pre>\n\n<h4 id="P4-3">4.3 Przykład 3</h4>\n\n<p>\nŻaden robot nie może zaglądać do żadnego z trzech folderów:\n</p>\n\n<pre>\nUser-agent: *\nDisallow: /cgi/\nDisallow: /private/\nDisallow: /tmp/\n</pre>\n\n<h4 id="P4-4">4.4 Przykład 4</h4>\n\n<p>\nKonkretny robot ma zakazany wstępu do konkretnego folderu:\n</p>\n\n<pre>\nUser-agent: Googlebot-Image\nDisallow: /photos/\n</pre>\n\n<h4 id="P4-5">4.5 Przykład 5</h4>\n\n<p>\nŻaden robot nie powinien pobierać pliku\n<span class="filename">file.html</span>:\n</p>\n\n<pre>\nUser-agent: *\nDisallow: /directory/file.html\n</pre>\n\n<h4 id="P4-6">4.6 Przykład 6</h4>\n\n<p>\nZakaz dostępu do serwisu\ndla pięciu wybranych programów kopiujących \ncałe witryny WWW:\n</p>\n\n<pre>\nUser-agent: WebStripper\nDisallow: /\n\nUser-agent: WebCopier\nDisallow: /\n\nUser-agent: TeleportPro\nDisallow: /\n\nUser-agent: HTTrack\nDisallow: /\n\nUser-agent: wget\nDisallow: /\n</pre>\n\n<h3 id="R5">5. Rozszerzenia oryginalnej składni <span class="filename">robots.txt</span></h3>\n\n<p>\nNajważniejszym rozszerzeniem składni \npliku <span class="filename">robots.txt</span> \njest dyrektywa <span class="variable">Sitemap</span>.\nSłuży ona do wskazania pliku zawierającego mapę witryny.\nParametrem dyrektywy jest adres URL mapy:\n</p>\n\n<pre>\nSitemap: http://www.example.com/sitemap.xml\n</pre>\n\n<p>\nDyrektywa <span class="variable">Sitemap</span>\njest niezależna od dyrektywy <span class="variable">User-agent</span> i \nmoże być obecna w dowolnym miejscu pliku <span class="filename">robots.txt</span>.\nNa stronach wyszukiwarki Google znajdują się informacje \nmówiące o tym, że roboty Google \nrespektują dyrektywę <span class="variable">Sitemap</span>.\n</p>\n\n<p>\nKolejnymi rozszerzeniami są\ndyrektywy <span class="variable">Request-rate</span> oraz \n<span class="variable">Visit-time</span>.\nPierwsza z nich ustala maksymalne tempo, w jakim\nrobot może przeszukiwać cały serwis,\na drugi wskazuje godziny, w których robot może \nwędrować po serwisie.\nNa przykład wpis:\n</p>\n\n<pre>\nUser-agent: *\nRequest-rate: 1/5       \nVisit-time: 0600-0845\n</pre>\n\n<p>\nogranicza tempo pobierania do jednej strony na pięć sekund\nw godzinach pomiędzy 6:00 a 8:45.\nPowyższe informacje pochodzą z Wikipedii.\nNa stronach wyszukiwarki Google nie znalazłem potwierdzenia, \nże powyższe dyrektywy są respektowane.\n</p>\n\n<p>\nPonadto niektóre roboty, na przykład Googlebot,\nwprowadziły interpretację znaków <span class="variable">*</span> oraz \n<span class="variable">?</span> w nazwach plików i folderów.\n</p>\n\n<div class="table">\r\n    <table>\r\n        <tr>\r\n                            <th>lp.</th>\r\n                                        <th>Dyrektywa</th>\r\n                            <th>Wartość</th>\r\n                            <th>Czy obsługiwane przez Google?</th>\r\n                    </tr>\r\n                    <tr>\r\n                                    <td>1.</td>\r\n                \r\n                                    <td><span class="variable">User-agent</span></td>\r\n                                    <td>Nazwa robota</td>\r\n                                    <td>Tak</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>2.</td>\r\n                \r\n                                    <td><span class="variable">Disallow</span></td>\r\n                                    <td>Folder, do którego dostęp ma być zabroniony</td>\r\n                                    <td>Tak</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>3.</td>\r\n                \r\n                                    <td><span class="variable">Sitemap</span></td>\r\n                                    <td>Nazwa pliku z mapą witryny</td>\r\n                                    <td>Tak</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>4.</td>\r\n                \r\n                                    <td><span class="variable">Request-rate</span></td>\r\n                                    <td>Maksymalna prędkość wędrowania robota po witrynie</td>\r\n                                    <td>?</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>5.</td>\r\n                \r\n                                    <td><span class="variable">Visit-time</span></td>\r\n                                    <td>Godziny, w których robot może odwiedzać witrynę</td>\r\n                                    <td>?</td>\r\n                            </tr>\r\n            </table>\r\n    <p>\r\n        <strong>Tabela 1.</strong>\r\n        Dyrektywy pliku <span class="filename">robots.txt</span>\r\n    </p>\r\n</div>\n\n<h3 id="R6">6. Plik <span class="filename">sitemap.xml</span></h3>\n\n<p>\nPlik <span class="filename">sitemap.xml</span> \nułatwia indeksację witryny WWW.\nZawiera on adresy URL podstron serwisu wraz z informacjami\no dacie ostatniej modyfikacji.\nDzięki temu roboty szybciej odnajdą i zaindeksują \nnowe podstrony, jakie pojawiły się w serwisie.\n</p>\n\n<p>\nPlik <span class="filename">sitemap.xml</span> wykorzystuje format XML.\nNależy stosować kodowanie utf-8, zaś wszystkie \nwystąpienia znaków\n<span class="variable">&lt;&gt;&amp;''"</span>\nnależy zastąpić encjami:\n</p>\n\n<pre>\n&lt;  -  &amp;lt;\n&gt;  -  &amp;gt;\n&amp;  -  &amp;amp;\n''  -  &amp;apos;\n"  -  &amp;quot;\n</pre>\n\n<p>\nPojedynczy plik\n<span class="filename">sitemap.xml</span> \nmusi być mniejszy niż 10 MB\ni może zawierać co najwyżej 10 000 adresów URL.\n</p>\n\n<p>\nPlik z mapą witryny \nnie może być umieszczony na innym serwerze\nani wewnątrz drzewa katalogów.\nPlik:\n</p>\n\n<pre>\nhttp://www.example.net/art/new/sitemap.xml\n</pre>\n\n<p>\nmoże wyłącznie dotyczyć adresów URL zawartych wewnątrz:\n</p>\n\n<pre>\nhttp://www.example.net/art/new/\n</pre>\n\n<p>\nNie może dotyczyć adresów z wyższego folderu, np.:\n</p>\n\n<pre>\nhttp://www.example.net/other/\n</pre>\n\n<p>\nani tym bardziej z innej domeny.\n</p>\n\n<h3 id="R7">7. Format pliku <span class="filename">sitemap.xml</span></h3>\n\n<p>\nPlik <span class="filename">sitemap.xml</span> zawiera następujące elementy XML:\n<span class="variable">urlset</span>,\n<span class="variable">url</span>,\n<span class="variable">loc</span>,\n<span class="variable">lastmod</span>,\n<span class="variable">changefreq</span> i\n<span class="variable">priority</span>.\n</p>\n\n<h4 id="P7-1">7.1 Element <span class="variable">urlset</span></h4>\n\n<p>\nElement <span class="variable">urlset</span> jest wymagany.\nZawiera on wewnątrz wszystkie adresy URL,\njakie są zawarte w mapie witryny. Atrybut <span class="variable">xmlns</span> \nustala wersję protokołu sitemap:\n</p>\n\n<pre>\n&lt;urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"&gt;\n  &lt;url&gt;...&lt;/url&gt;\n  &lt;url&gt;...&lt;/url&gt;\n  ...  \n&lt;/urlset&gt;\n</pre>\n\n<h4 id="P7-2">7.2 Element <span class="variable">url</span></h4>\n\n<p>\nElement <span class="variable">url</span> jest wymagany. \nWystępuje wyłącznie wewnątrz <span class="variable">urlset</span>.\nOpisuje on pojedynczy adres URL.\nZawiera elementy: <span class="variable">loc</span>, \n<span class="variable">lastmod</span>, \n<span class="variable">changefreq</span> oraz \n<span class="variable">priority</span>.\n</p>\n\n<pre>\n&lt;url&gt;\n  &lt;loc&gt;...&lt;/loc&gt;\n  &lt;lastmod&gt;...&lt;/lastmod&gt;  \n  &lt;changefreq&gt;...&lt;/changefreq&gt;    \n  &lt;priority&gt;...&lt;/priority&gt;    \n&lt;/url&gt;\n</pre>\n\n<h4 id="P7-3">7.3 Element <span class="variable">loc</span></h4>\n\n<p>\nElement wymagany. \nWystępuje wyłącznie wewnątrz <span class="variable">url</span>.\nUstala adres URL pojedynczego wpisu mapy.\nPodany adres musi rozpoczynać się od przedrostka \n(np. <span class="variable">http://</span>), np.:\n</p>\n\n<pre>\n&lt;loc&gt;http://www.gajdaw.pl/nowosci.html&lt;/loc&gt;\n</pre>\n\n<p>\nW adresie należy stosować encje oraz kodowanie URL.\nNa przykład adres:\n</p>\n\n<pre>\nhttp://www.example.com/ümlat.php&q=name\n</pre>\n\n<p>\nnależy zakodować jako:\n</p>\n\n<pre>\nhttp://www.example.com/%C3%BCmlat.php&amp;q=name\n</pre>\n\n<p>\nZnak <span class="variable">&amp;</span> \nzapisano w postaci encji <span class="variable">&amp;amp;</span>,\nzaś literę <span class="variable">ü</span>\nzakodowano w utf-8 i przedstawiono w postaci\n<span class="variable">%C3%BC</span>.\n</p>\n\n<p>\nPojedynczy adres URL być krótszy niż 2048 znaków.\n</p>\n\n<h4 id="P7-4">7.4 Element <span class="variable">lastmod</span></h4>\n\n<p>\nElement opcjonalny. \nWystępuje wyłącznie wewnątrz <span class="variable">url</span>.\nUstala datę ostatniej modyfikacji \ndokumentu, którego adres URL jest podany w elemencie <span class="variable">url</span>.\nData powinna być w formacie \nW3C opisanym w dokumencie <a href="http://www.w3.org/TR/NOTE-datetime">http://www.w3.org/TR/NOTE-datetime</a>.\nW skróconej postaci (tj. bez godziny) data \njest zapisywana jako \n<span class="variable">YYYY-MM-DD</span>, np. 2007-11-02:\n</p>\n\n<pre>\n&lt;lastmod&gt;2007-11-02&lt;/lastmod&gt;\n</pre>\n\n<p>\nFormatem pełnym daty \njest <span class="variable">YYYY-MM-DDTgg:mm:ss</span>,\nnp. 2007-11-02T18:50:24:\n</p>\n\n<pre>\n&lt;lastmod&gt;2007-11-02T18:50:24&lt;/lastmod&gt;\n</pre>\n\n<h4 id="P7-5">7.5 Element <span class="variable">changefreq</span></h4>\n\n<p>\nElement opcjonalny. \nWystępuje wyłącznie wewnątrz <span class="variable">url</span>.\nUstala częstotliwość zmian dokumentu.\nPoprawnymi wartościami są:\n</p>\n\n<pre>\nalways\nhourly\ndaily\nweekly\nmonthly\nyearly\nnever\n</pre>\n\n<p>\nWartość <span class="variable">always</span> oznacza, że dokument podlega zmianom \nprzy każdej próbie dostępu.\n</p>\n\n<p>\nPrzykładowy wpis:\n</p>\n\n<pre>\n&lt;changefreq&gt;daily&lt;changefreq&gt;\n</pre>\n\n<h4 id="P7-6">7.6 Element <span class="variable">priority</span></h4>\n\n<p>\nElement opcjonalny. \nWystępuje wyłącznie wewnątrz <span class="variable">url</span>.\nUstala umowną ważność strony\nwzględem innych podstron serwisu.\nWartość powinna być z zakresu od 0 do 1.\nWartością domyślną jest 0.5.\n</p>\n\n<pre>\n&lt;priority&gt;0.8&lt;/priority&gt;\n</pre>\n\n<h4 id="P7-7">7.7 Przykład pojedynczego pliku z mapą witryny</h4>\n\n<p>\nPrzykładowy pojedynczy plik \nz mapą witryny \njest przedstawiony na listingu 1,\nzaś tabela 2 zawiera pełne zestawienie elementów\nXML, które mogą wystąpić w pliku z mapą witryny.\n</p>\n\n<div class="listing">\r\n<pre>\r\n&lt;?xml version=&quot;1.0&quot; encoding=&quot;utf-8&quot;?&gt;\n&lt;urlset xmlns=&quot;http://www.sitemaps.org/schemas/sitemap/0.9&quot;&gt;\n  &lt;url&gt;\n    &lt;loc&gt;http://www.gajdaw.pl/nowosci.html&lt;/loc&gt;\n    &lt;lastmod&gt;2007-11-02&lt;/lastmod&gt;    \n    &lt;changefreq&gt;daily&lt;/changefreq&gt;\n    &lt;priority&gt;0.7&lt;/priority&gt;\n  &lt;/url&gt;\n  &lt;url&gt;\n    &lt;loc&gt;http://www.gajdaw.pl/php/pear-auth/index.html&lt;/loc&gt;\n    &lt;lastmod&gt;2007-11-02&lt;/lastmod&gt;    \n    &lt;changefreq&gt;monthly&lt;/changefreq&gt;\n    &lt;priority&gt;0.6&lt;/priority&gt;\n  &lt;/url&gt;  \n  &lt;url&gt;\n    &lt;loc&gt;http://www.gajdaw.pl/gimp/gimp-kurs-3/index.html&lt;/loc&gt;\n    &lt;lastmod&gt;2007-10-31&lt;/lastmod&gt;    \n    &lt;changefreq&gt;monthly&lt;/changefreq&gt;\n    &lt;priority&gt;0.6&lt;/priority&gt;\n  &lt;/url&gt;    \n  ...\n&lt;/urlset&gt;\r\n</pre>\r\n<p>\r\n<strong>Listing 1.</strong>\r\nPrzykładowy pojedynczy plik z mapą witryny\r\n</p>\r\n</div>\r\n\n<div class="table">\r\n    <table>\r\n        <tr>\r\n                            <th>lp.</th>\r\n                                        <th>Element</th>\r\n                            <th>Może wystąpić w</th>\r\n                            <th>Może zawierać</th>\r\n                            <th>Wymagany/Opcjonalny</th>\r\n                            <th>Znaczenie</th>\r\n                    </tr>\r\n                    <tr>\r\n                                    <td>1.</td>\r\n                \r\n                                    <td><span class="variable">urlset</span></td>\r\n                                    <td>-</td>\r\n                                    <td><span class="variable">url</span></td>\r\n                                    <td>wymagany</td>\r\n                                    <td>Zawiera listę adresów URL.</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>2.</td>\r\n                \r\n                                    <td><span class="variable">url</span></td>\r\n                                    <td><span class="variable">urlset</span></td>\r\n                                    <td><span class="variable">loc</span>, <span class="variable">lastmod</span>, <span class="variable">changefreq</span>, <span class="variable">priority</span></td>\r\n                                    <td>wymagany</td>\r\n                                    <td>Opisuje pojedynczą stronę WWW.</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>3.</td>\r\n                \r\n                                    <td><span class="variable">loc</span></td>\r\n                                    <td><span class="variable">url</span></td>\r\n                                    <td>-</td>\r\n                                    <td>wymagany</td>\r\n                                    <td>Adres dokumentu.</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>4.</td>\r\n                \r\n                                    <td><span class="variable">lastmod</span></td>\r\n                                    <td><span class="variable">url</span></td>\r\n                                    <td>-</td>\r\n                                    <td>opcjonalny</td>\r\n                                    <td>Data ostatniej modyfikacji.</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>5.</td>\r\n                \r\n                                    <td><span class="variable">changefreq</span></td>\r\n                                    <td><span class="variable">url</span></td>\r\n                                    <td>-</td>\r\n                                    <td>opcjonalny</td>\r\n                                    <td>Informacje o tym, jak często dokument podlega zmianom.</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>6.</td>\r\n                \r\n                                    <td><span class="variable">priority</span></td>\r\n                                    <td><span class="variable">url</span></td>\r\n                                    <td>-</td>\r\n                                    <td>opcjonalny</td>\r\n                                    <td>Waga dokumentu względem innych stron (na tym samym serwerze).</td>\r\n                            </tr>\r\n            </table>\r\n    <p>\r\n        <strong>Tabela 2.</strong>\r\n        Elementy XML występujące w mapie witryny <span class="filename">sitemap.xml</span>\r\n    </p>\r\n</div>\n\n<h3 id="R8">8. Lista map</h3>\n\n<p>\nMapa witryny może być zapisana w jednym pliku\nlub może być podzielona na wiele plików.\nW przypadku podzielenia mapy witryny\nna wiele plików należy także przygotować <strong>indeks map witryny</strong>.\nIndeks \nmap jest plikiem XML, w którym występują elementy:\n<span class="variable">sitemapindex</span>,\n<span class="variable">sitemap</span>,\n<span class="variable">loc</span>\noraz\n<span class="variable">lastmod</span>.\n</p>\n\n<p>\nPojedynczy plik z indeksem może zawierać informacje o 1000 map.\n</p>\n\n<p>\nZatem wielkość mapy podzielonej na wiele plików jest ograniczona do:\n</p>\n\n<pre>\n1 000 * 50 000 = 50 000 000\n</pre>\n\n<p>\nadresów URL.\n</p>\n\n<h4 id="P8-1">8.1 Element <span class="variable">sitemapindex</span></h4>\n\n<p>\nElement <span class="variable">sitemapindex</span> jest wymagany.\nZawiera on adresy map witryny. \nAtrybut <span class="variable">xmlns</span> \nustala wersję protokołu sitemap:\n</p>\n\n<pre>\n&lt;sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"&gt;\n  &lt;sitemap&gt;...&lt;/sitemap&gt;\n  &lt;sitemap&gt;...&lt;/sitemap&gt;\n  ...  \n&lt;/sitemapindex&gt;\n</pre>\n\n<h4 id="P8-2">8.2 Element <span class="variable">sitemap</span></h4>\n\n<p>\nElement <span class="variable">sitemap</span> jest wymagany. \nWystępuje wyłącznie wewnątrz <span class="variable">sitemapindex</span>.\nOpisuje on pojedynczy plik z mapą witryny.\nZawiera elementy: <span class="variable">loc</span> oraz\n<span class="variable">lastmod</span>.\n</p>\n\n<p>\nElement <span class="variable">loc</span> jest wymagany. \nWystępuje wyłącznie wewnątrz <span class="variable">sitemap</span>\ni ustala adres URL pojedynczego pliku z mapą witryny.\n</p>\n\n<p>\nElement <span class="variable">lastmod</span> jest opcjonalny.\nUstala on datę ostatniej modyfikacji \npodanego pliku z mapą witryny:\n</p>\n\n<pre>\n&lt;sitemap&gt;\n  &lt;loc&gt;http://www.example.pl/artykuly.xml&lt;/loc&gt;\n  &lt;lastmod&gt;2007-10-20&lt;/lastmod&gt;\n&lt;/sitemap&gt;  \n</pre>\n\n<div class="table">\r\n    <table>\r\n        <tr>\r\n                            <th>lp.</th>\r\n                                        <th>Element</th>\r\n                            <th>Może wystąpić w</th>\r\n                            <th>Może zawierać</th>\r\n                            <th>Wymagany/Opcjonalny</th>\r\n                            <th>Znaczenie</th>\r\n                    </tr>\r\n                    <tr>\r\n                                    <td>1.</td>\r\n                \r\n                                    <td><span class="variable">sitemapindex</span></td>\r\n                                    <td>-</td>\r\n                                    <td><span class="variable">sitemap</span></td>\r\n                                    <td>wymagany</td>\r\n                                    <td>Zawiera listę adresów URL.</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>2.</td>\r\n                \r\n                                    <td><span class="variable">sitemap</span></td>\r\n                                    <td><span class="variable">sitemapindex</span></td>\r\n                                    <td><span class="variable">loc</span>, <span class="variable">lastmod</span></td>\r\n                                    <td>wymagany</td>\r\n                                    <td>Opisuje pojedynczą stronę WWW.</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>3.</td>\r\n                \r\n                                    <td><span class="variable">loc</span></td>\r\n                                    <td><span class="variable">sitemap</span></td>\r\n                                    <td>-</td>\r\n                                    <td>wymagany</td>\r\n                                    <td>Adres dokumentu.</td>\r\n                            </tr>\r\n                    <tr>\r\n                                    <td>4.</td>\r\n                \r\n                                    <td><span class="variable">lastmod</span></td>\r\n                                    <td><span class="variable">sitemap</span></td>\r\n                                    <td>-</td>\r\n                                    <td>opcjonalny</td>\r\n                                    <td>Data ostatniej modyfikacji.</td>\r\n                            </tr>\r\n            </table>\r\n    <p>\r\n        <strong>Tabela 3.</strong>\r\n        Elementy XML występujące w indeksie map\r\n    </p>\r\n</div>\n\n<h4 id="P8-3">8.3 Przykład mapy z indeksem</h4>\n\n<p>\nMapa stosująca indeks składa się z wielu plików XML.\nW przykładzie plikami tymi są:\n<span class="filename">sitemapindex.xml</span>, \n<span class="filename">artykuly.xml</span> oraz \n<span class="filename">przyklady.xml</span>.\nW pliku <span class="filename">sitemapindex.xml</span>\nwymieniamy wszystkie mapy,\nzaś w plikach \n<span class="filename">artykuly.xml</span>\noraz <span class="filename">przyklady.xml</span>\nwymieniamy poszczególne podstrony.\nPrzykładowa mapa witryny podzielona na dwa pliki\njest przedstawiona na listingu 2.\n</p>\n\n<div class="listing">\r\n<pre>\r\nsitemapindex.xml\n----------------\n&lt;?xml version=&quot;1.0&quot; encoding=&quot;utf-8&quot;?&gt;\n&lt;sitemapindex xmlns=&quot;http://www.sitemaps.org/schemas/sitemap/0.9&quot;&gt;\n  &lt;sitemap&gt;\n    &lt;loc&gt;http://www.example.com/artykuly.xml&lt;/loc&gt;\n    &lt;lastmod&gt;2007-10-20&lt;/lastmod&gt;\n  &lt;/sitemap&gt;\n  &lt;sitemap&gt;\n    &lt;loc&gt;http://www.example.com/przyklady.xml&lt;/loc&gt;\n    &lt;lastmod&gt;2007-11-01&lt;/lastmod&gt;\n  &lt;/sitemap&gt;\n&lt;/sitemapindex&gt;\n\n\nartykuly.xml\n------------\n&lt;?xml version=&quot;1.0&quot; encoding=&quot;utf-8&quot;?&gt;\n&lt;urlset xmlns=&quot;http://www.sitemaps.org/schemas/sitemap/0.9&quot;&gt;\n  &lt;url&gt;\n    &lt;loc&gt;http://www.gajdaw.pl/art1.html&lt;/loc&gt;\n    &lt;lastmod&gt;2007-11-02&lt;/lastmod&gt;    \n    &lt;changefreq&gt;daily&lt;/changefreq&gt;\n    &lt;priority&gt;0.7&lt;/priority&gt;\n  &lt;/url&gt;\n  ...\n&lt;/urlset&gt;\n\n\nprzyklady.xml\n------------\n&lt;?xml version=&quot;1.0&quot; encoding=&quot;utf-8&quot;?&gt;\n&lt;urlset xmlns=&quot;http://www.sitemaps.org/schemas/sitemap/0.9&quot;&gt;\n  &lt;url&gt;\n    &lt;loc&gt;http://www.gajdaw.pl/p1.html&lt;/loc&gt;\n    &lt;lastmod&gt;2007-10-25&lt;/lastmod&gt;    \n    &lt;changefreq&gt;daily&lt;/changefreq&gt;\n    &lt;priority&gt;0.7&lt;/priority&gt;\n  &lt;/url&gt;\n  ...\n&lt;/urlset&gt;\r\n</pre>\r\n<p>\r\n<strong>Listing 2.</strong>\r\nPrzykładowa mapa witryny podzielona na dwa pliki\r\n</p>\r\n</div>\r\n\n<h3 id="R9">9. <span class="filename">robots.txt</span> + <span class="filename">sitemap.xml</span> = ułatwienie indeksacji witryny</h3>\n\n<p>\nWykorzystując pliki <span class="filename">robots.txt</span> oraz \n<span class="filename">sitemap.xml</span> ułatwiamy indeksację \nzawartości serwisu robotom internetowym.\nW pliku <span class="filename">robots.txt</span> należy umieścić \ndyrektywę <span class="variable">Sitemap</span> wskazującą plik\nz mapą witryny (lub z indeksem map):\n</p>\n\n<pre>\n<strong>robots.txt</strong>\n<strong>----------</strong>\nSitemap: http://www.example.net/sitemap.xml\n</pre>\n\n<p>\nNatomiast w pliku <span class="filename">sitemap.xml</span>\numieszczamy mapę witryny:\n</p>\n\n<pre>\n<strong>sitemap.xml</strong>\n<strong>----------</strong>\n&lt;urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"&gt;\n  ...\n&lt;/urlset&gt;\n</pre>\n\n<p>\nRobot odwiedzający witrynę \npobierze plik <span class="filename">robots.txt</span>.\nNa jego podstawie pozna adres \npliku z mapą witryny.\nPo pobraniu mapy <span class="filename">sitemap.xml</span>,\nrobot uzyska pełne informacje \no podstronach witryny.\n</p>\n\n<p>\nNajważniejszy z robotów,\nGooglebot,\npobiera plik <span class="filename">robots.txt</span> raz na dobę.\n</p>', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Adres</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="http://en.wikipedia.org/wiki/Web_crawler">Web crawler &mdash; hasło w Wikipedii</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>2.</td>\r\n        <td><a href="http://www.user-agents.org/index.shtml">Nazwy robotów</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>3.</td>\r\n        <td><a href="http://www.google.com/support/webmasters/bin/answer.py?answer=40364&amp;topic=8846">Nazwy robotów Google</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>4.</td>\r\n        <td><a href="http://en.wikipedia.org/wiki/Robots.txt">Robots Exclusion Standard &mdash; hasło w Wikipedii (en)</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>5.</td>\r\n        <td><a href="http://pl.wikipedia.org/wiki/Robots_Exclusion_Protocol">Robots Exclusion Protocol &mdash; hasło w Wikipedii (pl)</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>6.</td>\r\n        <td><a href="http://www.robotstxt.org/wc/robots.html">The Web Robots Pages</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>7.</td>\r\n        <td><a href="http://www.spiders.pl">spiders.pl &mdash; Wszystko o robotach wyszukiwarek</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>8.</td>\r\n        <td><a href="http://www.google.com/support/webmasters/bin/topic.py?topic=8843">Rozszerzenia składni robots.txt robota Google</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>9.</td>\r\n        <td><a href="http://en.wikipedia.org/wiki/Sitemaps">Sitemaps &mdash; hasło w Wikipedii</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>10.</td>\r\n        <td><a href="http://www.sitemaps.org/">Sitemaps.org</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 5.</strong> Adresy\r\n</p>\r\n\r\n</div>', '', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Przykład</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="examples/robots-txt-sitemap-xml-zestawienie.zip">Przykłady omówione w artykule</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 4.</strong>  Przykłady do pobrania\r\n</p>\r\n\r\n</div>');
INSERT INTO `article` (`article_id`, `title`, `introduction`, `toc`, `slug`, `date`, `onepage`, `addresses`, `download`, `examples`) VALUES(4, 'Propel. Porady', '<span class="program">Propel</span>, najbardziej popularny system mapowania relacyjno-obiektowego\nw PHP, w sposób bardzo istotny skraca cykl produkcyjny \naplikacji internetowej. Poradnik zawiera zestawienie \npopularnych problemów, z jakimi borykają się początkujący \nużytkownicy <span class="program">Propel-a</span>.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="p1.html">1. Porada #1: Kodowanie znaków</a></li>\r\n<li><a href="p2.html">2. Porada #2: Korzystanie z kilku baz danych</a></li>\r\n<li><a href="p3.html">3. Porada #3: Pobieranie tylko wybranych kolumn</a></li>\r\n<li><a href="p4.html">4. Porada #4: Konwersje toArray(), fromArray()</a></li>\r\n<li><a href="p5.html">5. Porada #5: Wydawanie zapytań SQL</a></li>\r\n<li><a href="p6.html">6. Porada #6: Zliczanie</a></li>\r\n<li><a href="p7.html">7. Porada #7: Stronicowanie</a></li>\r\n<li><a href="p8.html">8. Porada #8: Pobieranie jednego rekordu</a></li>\r\n<li><a href="p9.html">9. Porada #9: Relacja 1:n, metoda getXs()</a></li>\r\n<li><a href="p10.html">10. Porada #10: Relacja n:m, metody getXHasYsJoinX(), getXHasYsJoinY()</a></li>\r\n<li><a href="p11.html">11. Porada #11: Pobieranie zawartości całej bazy danych</a></li>\r\n<li><a href="p12.html">12. Porada #12: Smarty i wielokrotne wywoływanie metod</a></li>\r\n<li><a href="p13.html">13. Porada #13: Metoda __toString()</a></li>\r\n<li><a href="p14.html">14. Porada #14: Wyjątki</a></li>\r\n<li><a href="p15.html">15. Porada #15: Sortowanie wyników wg wybranych kolumn</a></li>\r\n<li><a href="p16.html">16. Uruchamianie przykładowych rozwiązań</a></li>\r\n</ol>\r\n</div>\r\n', 'propel_porady', '2008-07-01', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Porada #1: Kodowanie znaków</a></li>\r\n<li><a href="#R2">2. Porada #2: Korzystanie z kilku baz danych</a></li>\r\n<li><a href="#R3">3. Porada #3: Pobieranie tylko wybranych kolumn</a></li>\r\n<li><a href="#R4">4. Porada #4: Konwersje toArray(), fromArray()</a></li>\r\n<li><a href="#R5">5. Porada #5: Wydawanie zapytań SQL</a></li>\r\n<li><a href="#R6">6. Porada #6: Zliczanie</a></li>\r\n<li><a href="#R7">7. Porada #7: Stronicowanie</a></li>\r\n<li><a href="#R8">8. Porada #8: Pobieranie jednego rekordu</a></li>\r\n<li><a href="#R9">9. Porada #9: Relacja 1:n, metoda getXs()</a></li>\r\n<li><a href="#R10">10. Porada #10: Relacja n:m, metody getXHasYsJoinX(), getXHasYsJoinY()</a></li>\r\n<li><a href="#R11">11. Porada #11: Pobieranie zawartości całej bazy danych</a></li>\r\n<li><a href="#R12">12. Porada #12: Smarty i wielokrotne wywoływanie metod</a></li>\r\n<li><a href="#R13">13. Porada #13: Metoda __toString()</a></li>\r\n<li><a href="#R14">14. Porada #14: Wyjątki</a></li>\r\n<li><a href="#R15">15. Porada #15: Sortowanie wyników wg wybranych kolumn</a></li>\r\n<li><a href="#R16">16. Uruchamianie przykładowych rozwiązań</a></li>\r\n</ol>\r\n</div>\r\n\r\n<h3 id="R1">1. Porada #1: Kodowanie znaków</h3>\n\n<p>\nKlasy dostępu do bazy danych mogą stosować dowolne\nkodowanie znaków, niezależne od ustawień serwera.\n</p>\n\n<p>\nPrzed uruchomieniem generatora <span class="program">Propel</span>\n(tj. skryptu <span class="filename">propel-gen.bat</span>)\nw pliku \n<span class="filename">runtime-conf.xml</span>\nustalamy kodowanie znaków dla połączenia:\n</p>\n\n<pre>\n&lt;connection&gt;\n  ...\n  &lt;encoding&gt;utf8&lt;/encoding&gt;\n&lt;/connection&gt;\n</pre>\n\n<p>\nWygenerowane klasy będą stosowały podane kodowanie.\nRozwiązanie takie ma dwie zalety:\n</p>\n\n<ul>\n<li>skrypty PHP korzystające z klas nie muszą zawierać żadnych \ninstrukcji ustalających kodowanie,</li>\n<li>konfiguracja kodowania znaków serwera <span class="program">MySQL</span> \nnie ma wpływu na skrypty.</li>\n</ul>\n\n<h3 id="R2">2. Porada #2: Korzystanie z kilku baz danych</h3>\n\n<p>\nSkrypt PHP może &mdash; za pośrednictwem propelowych obiektów &mdash;\nłączyć się z wieloma bazami danych.\n</p>\n\n<p>\nPrzed uruchomieniem generatora klas\n(tj. skryptu <span class="filename">propel-gen.bat</span>)\nw pliku <span class="filename">runtime-conf.xml</span>\nnależy wymienić wszystkie bazy danych:\n</p>\n\n<pre>\n&lt;datasources default="osoby"&gt;\n  &lt;datasource id="osoby"&gt;\n    &lt;adapter&gt;mysql&lt;/adapter&gt;\n    &lt;connection&gt;\n      &lt;phptype&gt;mysqli&lt;/phptype&gt;\n      &lt;hostspec&gt;localhost&lt;/hostspec&gt;\n      &lt;database&gt;osoby&lt;/database&gt;\n      &lt;username&gt;osobyadm&lt;/username&gt;\n      &lt;password&gt;osobypass&lt;/password&gt;\n      &lt;encoding&gt;utf8&lt;/encoding&gt;                    \n    &lt;/connection&gt;\n  &lt;/datasource&gt;\n  &lt;datasource id="wyrazy"&gt;\n    &lt;adapter&gt;mysql&lt;/adapter&gt;\n    &lt;connection&gt;\n      &lt;phptype&gt;mysqli&lt;/phptype&gt;\n      &lt;hostspec&gt;localhost&lt;/hostspec&gt;\n      &lt;database&gt;wyrazy&lt;/database&gt;\n      &lt;username&gt;wyrazyadm&lt;/username&gt;\n      &lt;password&gt;wyrazypass&lt;/password&gt;\n      &lt;encoding&gt;utf8&lt;/encoding&gt;                    \n    &lt;/connection&gt;\n  &lt;/datasource&gt;            \n&lt;/datasources&gt;\n</pre>\n\n<p>\nDla każdego wymienionego źródła danych\nprzygotowujemy osobny plik XML z opisem\nstruktury bazy, np.\n</p>\n\n<pre>\nwyrazy-schema.xml\nosoby-schema.xml\n</pre>\n\n<p>\nTak skonfigurowany <span class="program">Propel</span> wygeneruje\nplik konfiguracyjny <span class="filename">-conf.php</span>,\numożliwiający łączenie się obiektów z wieloma bazami,\nprzy czym wszystkie wygenerowane klasy trafią do jednego folderu.\n</p>\n\n<p>\nJeśli w pliku <span class="filename">build.properties</span> dodasz wpis:\n</p>\n\n<pre>\npropel.packageObjectModel = true\n</pre>\n\n<p>\nzaś w plikach <span class="filename">-schema.xml</span> umieścisz atrybut\n<span class="filename">package</span>:\n</p>\n\n<pre>\n&lt;database package="wyrazy" name="wyrazy" ... &gt;\n</pre>\n\n<p>\nto generowane klasy zostaną umieszczone w osobnych folderach.\nAtrybut <span class="variable">package</span>\nzawierający kropkę:\n</p>\n\n<pre>\npackage="core.system"\n</pre>\n\n<p>\nspowoduje dalszy podział generowanych folderów\nna podfoldery:\n</p>\n\n<pre>\ncore/system\n</pre>\n\n\n\n<p>\nW skrypcie PHP, który korzysta z kilku połączeń \nnależy najpierw wywołać metodę <span class="variable">init()</span>:\n</p>\n\n\n\n<pre>\nPropel::init(''dwiebazy-conf.php'');\n</pre>\n\n\n\n<p>\na następnie utworzyć zmienne \numożliwiające korzystanie z połączeń:\n</p>\n\n\n<pre>\n$con_osoby = Propel::getConnection(''osoby'');\n$con_wyrazy = Propel::getConnection(''wyrazy'');\n</pre>\n\n\n\n<p>\nMetody pobierające rekordy z baz danych \notrzymają dodatkowy parametr\nustalający połączenie:\n</p>\n\n\n\n<pre>\n$wyrazy = WyrazPeer::doSelect(new Criteria, $con_wyrazy);\n$osoby = OsobaPeer::doSelect(new Criteria, $con_osoby);\n</pre>\n\n\n\n<p>\nPierwsza z powyższych instrukcji pobiera dane z bazy \no nazwie <span class="variable">wyrazy</span>, \na druga &mdash; z bazy o nazwie <span class="variable">osoby</span>.\n</p>\n\n<p>\nUtworzone obiekty nie wymagają podawania \npołączenia. Korzystamy z nich identycznie jak w skryptach,\nktóre stosowały jedną bazę danych:\n</p>\n\n\n<pre>\necho $osoby[0]-&gt;getImie()\n\n$wyrazy[0]-&gt;setWyraz(''Lorem'');\n$wyrazy[0]-&gt;save();\n</pre>\n\n\n\n\n\n<h3 id="R3">3. Porada #3: Pobieranie tylko wybranych kolumn</h3>\n\n<p>\nObiekty tworzone na podstawie informacji\nzapisanych w bazie, \nnp. metodą <span class="variable">retrieveByPK()</span>,\npobierają z bazy danych wszystkie kolumny.\nTo prowadzi do dużych \nnieoptymalności.\nWyświetlenie tytułów artykułów \n(np. lista nowości na stronie) będzie powodowało\npobieranie kompletnych artykułów.\n</p>\n\n<p>\nKolumny, które powinny być pobrane,\nmożemy wskazać korzystając z metod \nklasy <span class="variable">Criteria()</span>.\nUtworzona poniżej tablica <span class="variable">$studenci</span>\nzawiera tylko imiona studentów:\n</p>\n\n<pre>\n$c = new Criteria();\n$c-&gt;clearSelectColumns();\n$c-&gt;addSelectColumn(StudentPeer::IMIE);\n$rs = StudentPeer::doSelectRS($c);\n$studenci = array();\nwhile($rs-&gt;next()) {\n  $tmp = array(\n    ''imie'' =&gt; $rs-&gt;get(1),\n  );\n  $studenci[] = $tmp;\n}\n</pre>\n\n<p>\nTak wygenerowane wyniki\nnie mogą być wykorzystane do \noperacji <span class="variable">save()</span> czy \n<span class="variable">delete()</span>, gdyż nie są \nobiektami, a stringami.\n</p>\n\n<p>\nKod zwracający wyłącznie wybrane kolumny \ndodajemy w postaci nowych metod do wygenerowanych klas.\nMetody te mogą przyjmować parametr klasy <span class="variable">Criteria</span>,\nktóry pozwoli na wskazywanie wybranych wierszy i sortowanie wyników.\n</p>\n\n<h3 id="R4">4. Porada #4: Konwersje toArray(), fromArray()</h3>\n\n<p>\nMetody <span class="filename">toArray()</span> oraz \n<span class="filename">fromArray()</span>\npozwalają na konwersje obiektów w tablice i na odwrót.\n</p>\n\n\n<p>\nW celu przekształcenia obiektu <span class="variable">$student</span>:\n</p>\n\n\n<pre>\n$student = StudentPeer::retrieveByPK(2);\n</pre>\n\n\n<p>\nw tablicę wywołujemy metodę <span class="variable">toArray()</span>:\n</p>\n\n\n\n\n<pre>\n$t = $student-&gt;toArray(BasePeer::TYPE_FIELDNAME);\n</pre>\n\n<p>\nJeśli jako parametr podamy stałą <span class="variable">TYPE_FIELDNAME</span>,\nto indeksami tablicy będą nazwy kolumn w bazie danych.\n</p>\n\n\n\n<p>\nKonwersję odwrotną realizuje metoda <span class="variable">fromArray()</span>:\n</p>\n\n\n<pre>\n$t = array(\n  ''imie'' =&gt; ''Tomasz'',\n  ''nazwisko'' =&gt; ''Nijaki'',    \n  ''plec'' =&gt; ''M'',    \n  ''wiek'' =&gt; ''33'',    \n  ''numerindeksu'' =&gt; ''00000000001'',    \n  ''kierunek'' =&gt; ''marketing'',    \n);\n\n$s2 = new Student();\n$s2-&gt;fromArray($t, BasePeer::TYPE_FIELDNAME);\n$s2-&gt;save();\n</pre>\n\n\n\n<p>\nMetody \n<span class="variable">toArray()</span>\noraz \n<span class="variable">fromArray()</span>\nmożemy wykorzystać w połączeniu z klasami\n<span class="variable">XML_Serializer</span>\noraz \n<span class="variable">XML_Unserializer</span>.\nW ten sposób możemy:\n</p>\n\n<ul>\n<li>obiekty konwertować do XML (<span class="variable">toArray()</span>, <span class="variable">XML_Serializer</span>),</li>\n<li>na podstawie danych XML tworzyć obiekty (<span class="variable">XML_Unserializer</span>, <span class="variable">fromArray()</span>).</li>\n</ul>\n\n\n\n<p>\nOto, jak przebiega konwersja obiektu na XML:\n</p>\n\n\n<pre>\n$s = StudentPeer::retrieveByPK(1);\n$t = $s-&gt;toArray(BasePeer::TYPE_FIELDNAME);\n\n$serializer = new XML_Serializer();\n$serializer-&gt;serialize($t);\n\n$wynik = $serializer-&gt;getSerializedData();\n</pre>\n\n\n\n\n\n<h3 id="R5">5. Porada #5: Wydawanie zapytań SQL</h3>\n\n<p>\nNiekiedy zachodzi konieczność wykonania \nkonkretnych zapytań SQL.\nW takiej sytuacji należy wykorzystać \nstatyczną metodę <span class="variable">getConnection()</span>.\nObiekt zwracany przez tę metodę\npozwala na wysyłanie do serwera bazy danych zapytań w języku SQL:\n</p>\n\n\n<pre>\n$con = Propel::getConnection(''produkty'');\n$sql = ''SELECT SUM(ilosc * cena) as wartosc FROM produkt'';\n$rs = $con-&gt;executeQuery($sql);\n$rs-&gt;next();\n$wartosc = $rs-&gt;getString(''wartosc'');\n</pre>\n\n<p>\nPodane wyżej zapytanie wyznacza wartość towaru \nzapisanego w bazie danych\n(tj. sumę iloczynów: liczba sztuk * cena jednostki).\nWykonanie takiego zadania za pośrednictwem \nobiektów byłoby znacznie bardziej czasochłonne.\n</p>\n\n<h3 id="R6">6. Porada #6: Zliczanie</h3>\n\n<p>\nSzczególnym przypadkiem zapytań SQL jest zliczanie rekordów.\nW tym celu nie musimy jednak uciekać się do języka SQL, \ngdyż generowane klasy zawierają metody <span class="variable">doCount()</span>.\n</p>\n\n<p>\nOto, w jaki sposób możemy wyznaczyć liczbę wierszy \nzapisanych w bazie danych:\n</p>\n\n<pre>\n$ile = WyrazPeer::doCount(new Criteria);\n</pre>\n\n<h3 id="R7">7. Porada #7: Stronicowanie</h3>\n\n\n<p>\nStronicowanie wyników wykonujemy stosując metody \n<span class="variable">setLimit()</span> oraz \n<span class="variable">setOffset()</span> klasy <span class="variable">Criteria</span>.\nPierwsza z nich ustala liczbę zwracanych rekordów,\na druga &mdash; numer pierwszego zwracanego rekordu:\n</p>\n\n\n\n<pre>\n$c = new Criteria();\n$c-&gt;setLimit(4);\n$c-&gt;setOffset(2);\n\n$wyrazy = WyrazPeer::doSelect($c);\n</pre>\n \n<h3 id="R8">8. Porada #8: Pobieranie jednego rekordu</h3>\n\n<p>\nGdy zachodzi konieczność pobrania dokładnie jednego rekordu,\nprzydatna okazuje się metoda <span class="variable">doSelectOne()</span>.\nZ sytuacją taką mamy do czynienia np. wtedy, gdy chcemy do bazy danych\nwstawić rekord, pod warunkiem, że takiego rekordu nie było.\nNależy najpierw wyszukać rekord, a następnie\nużyć instrukcji <span class="variable">if</span> do zbadania, \nczy obiekt został utworzony:\n</p>\n\n<pre>\n$c = new Criteria();\n$c-&gt;add(WyrazPeer::WYRAZ, ''lorem'');\n$wyraz = WyrazPeer::doSelectOne($c);\n\nif (!$wyraz) {\n  $wyraz = new Wyraz();\n  $wyraz-&gt;setWyraz($n);\n  $wyraz-&gt;save();\n}\n</pre>\n\n<h3 id="R9">9. Porada #9: Relacja 1:n, metoda getXs()</h3>\n\n<p>\nObiekty połączone relacją 1:n są wyposażone w metody,\no nazwie <span class="variable">getXs()</span> udostępniające dane stojące w relacji.\nLitera X w nazwie metody jest zastępowana nazwą odpowiedniej tabeli.\n</p>\n\n<p>\nJeśli tabele <span class="variable">poeta</span> i \n<span class="variable">wiersz</span> połączymy relacją 1:n\n(każdy poeta może być autorem wielu wierszy),\nto w klasie <span class="variable">Poeta</span> \npojawi się metoda <span class="variable">getWierszs()</span>.\nMetoda ta będzie zwracała obiekty klasy <span class="variable">Wiersz</span>:\n</p>\n\n<p>\nOto skrypt drukujący tytuły wierszy poety o identyfikatorze 3:</p>\n\n<pre>\n$poeta = PoetaPeer::retrieveByPK(3);\nforeach ($poeta-&gt;getWierszs() as $wiersz) {\n  echo $wiersz-&gt;getTytul();\n}\n</pre>\n\n\n<p>\nMetoda <span class="variable">getWierszs()</span> zwraca wyniki nieuporządkowane.\nMożemy ją nadpisać w klasie <span class="variable">Poeta</span>,\nby w rezultacie otrzymać metodę <span class="variable">getWierszs()</span>,\nktóra zachowując pełną funkcjonalność domyślnie zwraca wyniki\nposortowane alfabetycznie.\n</p>\n\n<p>\nW drugą stronę korzystamy z odwołań kaskadowych.\nOto jak ustalić nazwisko poety,\nktóry napisał wiersz o identyfikatorze 7:\n</p>\n\n<pre>\n$wiersz = WierszPeer::retrieveByPK(7);\necho $wiersz-&gt;getPoeta()-&gt;getImie();\n</pre>\n\n\n<h3 id="R10">10. Porada #10: Relacja n:m, metody getXHasYsJoinX(), getXHasYsJoinY()</h3>\n\n<p>\nObiekty stojące w relacji n:m również mają metody \ndostępu do skorelowanych danych.\nMetody te nazywają się zgodnie ze schematem\n</p>\n\n\n\n<pre>\ngetZsJoinX() (w klasie X)\ngetZsJoinY() (w klasie Y)\n</pre>\n\n<p>\ngdzie <span class="variable">Z</span> \njest nazwą tabeli haszującej, a \n<span class="variable">X</span> oraz \n<span class="variable">Y</span> &mdash; nazwami tabel\npołączonych relacją.\n</p>\n\n<p>\nJeśli tabele <span class="variable">film</span> oraz \n<span class="variable">aktor</span> połączymy relacją \n<span class="variable">n:m</span>\ni tabelę haszującą nazwiemy \n<span class="variable">film_has_aktor</span>, to \n<span class="program">Propel</span> wygeneruje \ntrzy klasy:\n<span class="variable">Film</span>, \n<span class="variable">Aktor</span> oraz \n<span class="variable">FilmHasAktor</span>.\nW klasie <span class="variable">Film</span> znajdziemy metodę \n<span class="variable">getFilmHasAktorsJoinAktor()</span>,\na w klasie <span class="variable">Aktor</span> &mdash; metodę \n<span class="variable">getFilmHasAktorsJoinFilm()</span>.\nMetody te będą zwracały obiekty \ntabeli <span class="variable">film_has_aktor</span>.\n</p>\n\n\n\n<p>\nOto skrypt drukujący \ntytuły wszystkich filmów, w których wystąpił aktor o identyfikatorze 1:\n</p>\n\n\n<pre>\n$aktor = AktorPeer::retrieveByPK(1);\n$c = new Criteria();\n$objs = $aktor-&gt;getFilmHasAktorsJoinFilm($c);\nforeach ($objs as $obj) {\n  echo $obj-&gt;getFilm()-&gt;getTytul();\n}\n</pre>\n\n\n\n<p>\noraz skrypt, który drukuje nazwiska wszystkich aktorów\ngrających w filmie o identyfikatorze 7:\n</p>\n\n\n\n<pre>\n$film = FilmPeer::retrieveByPK(7);\n$c = new Criteria();\n$objs = $film-&gt;getFilmHasAktorsJoinAktor($c);\nforeach ($objs as $obj) {\n  echo $obj-&gt;getAktor()-&gt;getNazwisko();\n}\n</pre>\n\n\n\n<p>\nKorzystając z powyższych metod możemy \nopracować własne metody, których wyniki, \nbędą obiektami klas <span class="variable">Film</span> lub \n<span class="variable">Aktor</span>.\nPrzykładem takiej metody jest <span class="variable">getFilmsByAktor()</span>\n(nowa metoda, ręcznie dodana w klasie <span class="variable">Aktor</span>),\nktórej użycie upraszcza kod skryptu:\n</p>\n\n\n<pre>\n$aktor = AktorPeer::retrieveByPK(1);\n$c = new Criteria;\n$filmy = $aktor-&gt;getFilmsByAktor($c);\nforeach ($filmy as $film) {\n  ...\n}\n</pre>\n\n    \n\n\n\n<h3 id="R11">11. Porada #11: Pobieranie zawartości całej bazy danych</h3>\n\n\n<p>\nCiekawym efektem ubocznym metod <span class="variable">getXs()</span>\noraz <span class="variable">getZsJoinX()</span>\njest to, że jeden obiekt może dać dostęp \ndo całej bazy danych.\n</p>\n\n<p>\nUmieśćmy w bazie danych książki\npodzielone na rozdziały, które z kolei zawierają zadania.\nOtrzymamy trzy tabele:\n<span class="variable">ksiazka</span>, \n<span class="variable">rozdzial</span> oraz \n<span class="variable">zadanie</span>. Relacją 1:n łączymy tabele\n<span class="variable">ksiazka</span> i <span class="variable">rozdzial</span>\n(każda książka zawiera wiele rozdziałów)\noraz <span class="variable">rozdzial</span> i \n<span class="variable">zadanie</span> \n(każdy rozdział zawiera wiele zadań).\n<span class="program">Propel</span> wygeneruje klasy:\n</p>\n\n\n<pre>\nKsiazka\n  metoda getRozdzials()\n  \nRozdzial\n  metoda getZadanies()\n  \nZadanie\n</pre>\n\n\n\n<p>\nJeśli w bazie danych znajduje się jeden rekord o identyfikatorze \n1 (zbiór zadań z programowania w języku C++),\nto wywołanie:\n</p>\n\n\n<pre>\n$ksiazka = KsiazkaPeer::retrieveByPK(1);\n</pre>\n\n<p>\nzapewni dostęp do całej bazy danych.\nPodwójna pętla <span class="variable">foreach</span> wydrukuje całą książkę \n(wszystkie rozdziały i wszystkie zadania):\n</p>\n\n\n<pre>\nforeach ($ksiazka-&gt;getRozdzials() as $rozdzial) {\n  echo $rozdzial-&gt;getTytul();\n  foreach ($rozdzial-&gt;getZadanies() as $zadanie) {\n    echo $zadanie-&gt;getTekst();\n  }\n}\n</pre>\n\n<h3 id="R12">12. Porada #12: Smarty i wielokrotne wywoływanie metod</h3>\n\n\n<p>\nSzablony <span class="program">Smarty</span> \ndomyślnie nie pozwalają na wielokrotne wywoływanie metod.\nInstrukcje szablonu:\n</p>\n\n<pre>\n<strong>PRZYKŁAD NIEPOPRAWNY</strong>\n{$wiersz-&gt;getAutor()-&gt;getImie()}\n</pre>\n\n<p>\nbędą powodowały błąd.\nW celu ominięcia tego problemu możemy zmodyfikować klasę \n<span class="variable">Smarty_Compiler</span>.\nJeśli w pliku \n<span class="filename">Smarty_Compiler.class.php</span>\nwymienisz wyrażenie regularne zawarte w linijce 155 i w miejsce:\n</p>\n\n\n<pre>\n...$this-&gt;_dvar_guts_regexp . '')'';\n</pre>\n\n\n<p>\nwpiszesz:\n</p>\n\n\n<pre>\n..$this-&gt;_dvar_guts_regexp . ''(?:\\(\\))?)'';        \n</pre>\n\n<p>\nwielokrotne wywołanie metod będzie działało poprawnie.\n</p>\n\n\n<p>\nPowyższa niedogodność sytemu <span class="program">Smarty</span> \njest na tyle dokuczliwa,\nże rozsądnym wydaje się rezygnacja z szablonów <span class="program">Smarty</span> \nna rzecz surowych szablonów PHP.\n</p>\n\n\n\n<h3 id="R13">13. Porada #13: Metoda __toString()</h3>\n\n<p>\nMetoda <span class="variable">__toString()</span> \nsłuży do konwersji obiektu na typ string.\nJeśli wygenerowane klasy wzbogacisz \no metody <span class="variable">__toString()</span>,\nto będziesz mógł stosować obiekty jako parametry \ninstrukcji <span class="variable">echo</span>, np.:\n</p>\n\n\n\n<pre>\n$poeta = PoetaPeer::retrieveByPK(3);\necho $poeta;\nforeach ($poeta-&gt;getWierszs() as $wiersz) {\n    echo $wiersz;\n}\n</pre>\n\n\n\n<p>\nInstrukcje:\n</p>\n\n\n<pre>\necho $poeta;\necho $wiersz;\n</pre>\n\n\n\n\n\n<p>\nbędą działały poprawnie, pod warunkiem, że w klasach \n<span class="variable">Poeta</span>\noraz \n<span class="variable">Wiersz</span> dodasz \nmetody <span class="variable">__toString()</span>:\n</p>\n\n<pre>\nclass Poeta extends BasePoeta {\n  function __toString()\n  {\n    return $this-&gt;getImie() . '' '' . \n        $this-&gt;getNazwisko();\n  }\n}\n\nclass Wiersz extends BaseWiersz {\n  function __toString()\n  {\n    return $this-&gt;getTytul();\n  }\n}\n</pre>\n\n\n\n<h3 id="R14">14. Porada #14: Wyjątki</h3>\n\n<p>\nW przypadku wystąpienia błędów, \nobiekty <span class="program">Propel-a</span> generują wyjątki.\nObsługę wyjątków realizujemy \ninstrukcją <span class="variable">try-catch</span>.\nMetody obiektu <span class="variable">$e</span> pozwalają poznać przyczynę błędu:\n</p>\n\n<pre>\n$wyraz = new Wyraz();\n$wyraz-&gt;setWyraz(''żółw'');\n\ntry {\n  $wyraz-&gt;save();\n} catch (PropelException $e) {\n  $c = $e-&gt;getCause();\n  $komunikat = $c-&gt;getNativeError();\n  echo $komunikat;\n}\n</pre>\n\n\n<h3 id="R15">15. Porada #15: Sortowanie wyników wg wybranych kolumn</h3>\n\n<p>\nPorządek sortowania zwracanych wyników\nustalamy, korzystając z metod\n<span class="variable">addAscendingOrderByColumn()</span>\noraz \n<span class="variable">addDescentingOrderByColumn()</span>\nklasy <span class="variable">Criteria</span>:\n</p>\n\n\n<pre>\n$c = new Criteria();\n$c-&gt;addAscendingOrderByColumn(StudentPeer::NAZWISKO);\n$c-&gt;addDescendingOrderByColumn(StudentPeer::IMIE);\n$studenci = StudentPeer::doSelect($c);\n</pre>\n\n\n\n\n<h3 id="R16">16. Uruchamianie przykładowych rozwiązań</h3>\n\n<p>\nKażda z powyższych porad jest zilustrowana przykładami.\nPojedynczy przykład składa się ze skryptów tworzących \nbazę danych (pliki <span class="filename">.sql</span> i <span class="filename">.bat</span>)\noraz ze skryptów PHP, które pobierają dane z bazy\ni prezentują je w postaci strony WWW.\n</p>\n\n<p>\nUruchamianie każdego przykładu należy rozpocząć od utworzenia bazy danych.\nNastępnie przeglądarką odwiedzamy stronę <span class="filename">skrypt.php</span>.\n</p>\n\n\n<p>\nOto jak przebiega uruchomienie przykładu jedenastego.\nW folderze <span class="filename">11-cala-zawartosc/</span>\nznajdziemy dwa podfoldery,\na w nich pliki:\n</p>\n\n<pre>\n11-cala-zawartosc/\n    1-zrzut-db/\n        tworz-baze-cpp.bat\n        baza-cpp.sql\n    2-skrypt/\n        skrypt.php\n</pre>\n\n\n<p>\nW pliku <span class="filename">tworz-baze-cpp.bat</span>,\nw miejsce napisu <span class="variable">AX1BY2CZ3</span> umieść hasło administratora\nserwera <span class="program">MySQL</span>:\n</p>\n\n\n<pre>\nc:\\mysql\\bin\\mysql -uroot -pAX1BY2CZ3 &lt; baza-cpp.sql\n</pre>\n\n\n\n<p>\nNastępnie uruchom skrypt <span class="filename">tworz-baze-cpp.bat</span>,\npo czym &mdash; wykorzystując aplikację \n<span class="program">phpMyAdmin</span> \n&mdash; sprawdź, czy baza danych o nazwie \n<span class="variable">cpp</span> została utworzona.\nNazwę tworzonej bazy danych znajdziesz \nw skrypcie <span class="filename">baza-cpp.sql</span>:\n</p>\n\n<pre>\n...\nDROP DATABASE IF EXISTS cpp;\n...\n</pre>\n\n\n<p>\nPowinieneś otrzymać bazę danych <span class="variable">cpp</span> \nwstępnie wypełnioną pewną liczbą rekordów, co ilustruje rysunek 1.\n</p>\n\n<div class="image">\r\n    <img src="figure/1.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 1.</strong>\r\n        Sprawdzanie poprawności tworzenia bazy danych o nazwie <span class="variable">cpp</span> programem <span class="program">phpMyAdmin</span>\r\n    </p>\r\n</div>\n\n<p>\nNastępnie przeglądarką WWW odwiedź plik <span class="filename">skrypt.php</span>.\nUjrzysz stronę przedstawioną na rysunku 2.\n</p>\n\n<div class="image">\r\n    <img src="figure/2.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 2.</strong>\r\n        Przykład 11: zbiór zadań z podstaw programowania w języku C++\r\n    </p>\r\n</div>\n\n\n<p>\nSzczegóły rozwiązania poznasz analizując\nplik <span class="filename">skrypt.php</span>.\n</p>', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Adres</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="http://propel.phpdb.org/trac/">Propel &mdash; strona domowa</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>2.</td>\r\n        <td><a href="http://gajdaw.pl/bd/propel-tutorial/"><em>&bdquo;Propel. Tutorial&rdquo;</em> &mdash; artykuł wprowadzający w świat Propel-a</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>3.</td>\r\n        <td><a href="http://gajdaw.pl/bd/propel-dbdesigner/"><em>&bdquo;DBDesigner i Propel&rdquo;</em> &mdash; artykuł opisujący jak połączyć dwie wymienione aplikacje</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>4.</td>\r\n        <td><a href="http://gajdaw.pl/bd/propel-i-dbdesigner-w-akcji/"><em>&bdquo;Mistrzostwa świata w piłce nożnej, czyli Propel i DBDesigner w akcji&rdquo;</em></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>5.</td>\r\n        <td><a href="http://gajdaw.pl/bd/propel-na-serwer/"><em>&bdquo;Instalacja aplikacji wykorzystującej biblioteki Propel i Creole na serwerze hostingowym&rdquo;</em></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>6.</td>\r\n        <td><a href="http://en.wikipedia.org/wiki/Object-relational_mapping">Wikipedia, hasło ORM</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>7.</td>\r\n        <td><a href="http://www.phpdoctrine.org">Doctrine &mdash; alternatywny ORM w PHP</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 2.</strong> Adresy\r\n</p>\r\n\r\n</div>', '', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Przykład</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="examples/propel-porady.zip">Propel. Porady. Przykładowe skrypty</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 1.</strong>  Przykłady do pobrania\r\n</p>\r\n\r\n</div>');
INSERT INTO `article` (`article_id`, `title`, `introduction`, `toc`, `slug`, `date`, `onepage`, `addresses`, `download`, `examples`) VALUES(5, 'Google Chart API &mdash; prosty sposób umieszczania wykresów na stronach WWW', 'Usługa Google Chart API służy do generowania wykresów.\nParametry wykresu przekazujemy w adresie URL,\nzwracany wykres jest obrazem PNG.\nW stosunku do bibliotek stosowanych po stronie serwera\n(np. ChartDirector, JpGraph) Google Chart API ma dwie ważne zalety:\njest niezależna od platformy oraz nie wymaga \ninstalacji żadnego oprogramowania.\nBiorąc pod uwagę fakt, że dostęp do Google Chart API jest bezpłatny\ni nieograniczony, z pewnością warto poznać tę metodę generowania wykresów.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="p1.html">1. Pierwszy wykres w Google Chart API</a></li>\r\n<li><a href="p2.html">2. Adresy URL</a></li>\r\n<li><a href="p3.html">3. Parametry wykresów</a></li>\r\n<li><a href="p4.html">4. Rodzaje wykresów</a></li>\r\n<li><a href="p5.html">5. Kodowanie danych</a></li>\r\n<li><a href="p6.html">6. Przykłady</a>\r\n<ol>\r\n<li><a href="p6.html#P6-1">6.1 Przykład pierwszy</a></li>\r\n<li><a href="p6.html#P6-2">6.2 Przykład drugi</a></li>\r\n<li><a href="p6.html#P6-3">6.3 Przykład trzeci</a></li>\r\n<li><a href="p6.html#P6-4">6.4 Przykład czwarty</a></li>\r\n<li><a href="p6.html#P6-5">6.5 Przykład piąty</a></li>\r\n<li><a href="p6.html#P6-6">6.6 Przykład szósty</a></li>\r\n<li><a href="p6.html#P6-7">6.7 Przykład siódmy</a></li>\r\n<li><a href="p6.html#P6-8">6.8 Przykład ósmy</a></li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</div>\r\n', 'google_chart_api_prosty_sposob_umieszczania_wykresow_na_stronach_www', '2008-08-01', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Pierwszy wykres w Google Chart API</a></li>\r\n<li><a href="#R2">2. Adresy URL</a></li>\r\n<li><a href="#R3">3. Parametry wykresów</a></li>\r\n<li><a href="#R4">4. Rodzaje wykresów</a></li>\r\n<li><a href="#R5">5. Kodowanie danych</a></li>\r\n<li><a href="#R6">6. Przykłady</a>\r\n    <ol>\r\n        <li><a href="#P6-1">6.1 Przykład pierwszy</a></li>\r\n        <li><a href="#P6-2">6.2 Przykład drugi</a></li>\r\n        <li><a href="#P6-3">6.3 Przykład trzeci</a></li>\r\n        <li><a href="#P6-4">6.4 Przykład czwarty</a></li>\r\n        <li><a href="#P6-5">6.5 Przykład piąty</a></li>\r\n        <li><a href="#P6-6">6.6 Przykład szósty</a></li>\r\n        <li><a href="#P6-7">6.7 Przykład siódmy</a></li>\r\n        <li><a href="#P6-8">6.8 Przykład ósmy</a></li>\r\n    </ol>\r\n</li>\r\n</ol>\r\n</div>\r\n\r\n<h3 id="R1">1. Pierwszy wykres w Google Chart API</h3>\n\n<p>\nPo umieszczeniu na stronie WWW znacznika:\n</p>\n\n<pre>\n&lt;img src="http://chart.apis.google.com/chart?chs=400x200&amp;cht=p3&amp;chd=t:1,5&amp;chl=Węże|Żółwie" /&gt;\n</pre>\n\n<p>\notrzymasz wykres przedstawiony na rysunku 1.\n</p>\n\n<div class="image">\r\n    <img src="figure/1.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 1.</strong>\r\n        Pierwszy wykres w Google Chart API\r\n    </p>\r\n</div>\n\n<p>\nW tak prosty sposób działa usługa o nazwie Google Chart API.\nOsadzanie wykresów na stronie WWW sprowadza się\ndo przygotowania odpowiedniego adresu URL, \nktóry będzie zawierał dane i ustalał właściwości wykresu.\nNie wymaga to ani instalacji żadnego oprogramowania\nani nawet rejestracji i uzyskiwania kluczy dostępu do usługi.\nRozwiązanie takie jest niezależne od platformy\nsprzętowej i stosowanego oprogramowania.\nRównie dobrze może być wykorzystywane \nna statycznych stronach WWW,\nw skryptach PHP, Perla czy ASP.\nDodatkowym plusem jest licencja,\nktóra pozwala na wykorzystywanie Google Chart API\ndo dowolnych celów bez ograniczeń transferu.\n</p>\n\n<p>\nDziałanie Google Chart API możemy sprawdzić w praktyce\nodwiedzając serwis Google Finance\n(<a href="http://finance.google.com/finance">http://finance.google.com/finance</a>).\nWszystkie widoczne tam wykresy są generowane \nz wykorzystaniem Google Chart API.\nJeśli chcesz się dowiedzieć, w jaki sposób \nwykres został wykonany, to &mdash; korzystając z Firefoksa &mdash;\nkolejno:\n</p>\n\n<ul>\n<li>kliknij w wykres prawym przyciskiem myszy,</li>\n<li>z menu kontekstowego wybierz opcję <span class="option">Pokaż obrazek</span>\n(rysunek 2).</li>\n</ul>\n\n\n<p>\nWówczas przeglądarka Firefox wyświetli wyłącznie wykres,\na w pasku adresu widoczny będzie URL wykresu,\nzawierający wszystkie parametry (rysunek 3).\n</p>\n\n<div class="image">\r\n    <img src="figure/2.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 2.</strong>\r\n        W Firefoksie menu kontekstowe zawiera opcję <span class="option">Pokaż obrazek</span>\r\n    </p>\r\n</div>\n\n<div class="image">\r\n    <img src="figure/3.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 3.</strong>\r\n        W adresie strony zawarte są wszystkie parametry obrazu\r\n    </p>\r\n</div>\n\n<h3 id="R2">2. Adresy URL</h3>\n\n<p>\nAnalizując adres użyty w pierwszym przykładzie \nmożemy wyodrębnić następujące fragmenty:\n</p>\n\n<pre>\nhttp://chart.apis.google.com/chart?\n    chs=400x200&amp;\n    cht=p3&amp;\n    chd=t:1,5&amp;\n    chl=Węże|Żółwie\n</pre>\n\n\n<p>\nBazowym adresem usługi Chart API jest więc:\n</p>\n\n\n<pre>\nhttp://chart.apis.google.com/chart\n</pre>\n\n\n\n<p>\nPo nim umieszczamy znak zapytania i serię parametrów \noddzielonych znakiem <span class="variable">&amp;</span>\n(ich kolejność może być dowolna).\nPierwszy z użytych parametrów ustala wymiary wykresu.\nPisząc:\n</p>\n\n\n<pre>\nchs=400x200\n</pre>\n\n\n\n<p>\notrzymamy wykres, który jest obrazem PNG o szerokości 400 i wysokości 200 pikseli.\n</p>\n\n\n<div class="frame">\r\n<p>\nWykresy generowane przez Google Chart API zawsze są w formacie PNG.\nWymiary obrazów podlegają dwóm ograniczeniom:\n</p>\n\n<ul>\n<li>maksymalna wysokość to 1000 pikseli,</li>\n<li>obraz może mieć co najwyżej 300 tysięcy pikseli.</li>\n</ul>\n\n\n<p>\nNajwiększymi dopuszczalnymi wymiarami są więc:\n1000x300, 300x1000, 600x500, 500x600, 800x375 i 375x800.\n</p>\r\n</div>\n\n\n\n<p>\nDrugi parametr <span class="variable">cht</span> \no wartości <span class="variable">p3</span> ustala typ wykresu.\nWykres oznaczany symbolem <span class="variable">p3</span> \njest trójwymiarowym \nwykresem kołowym (ang. <em>pie chart</em>).\nKolejny parametr <span class="variable">chd</span> definiuje dane wykresu.\nZapis:\n</p>\n\n\n<pre>\nchd=t:1,5\n</pre>\n\n<p>\npowoduje, że pierwszy wycinek koła zajmie 1/6 część całości,\na drugi &mdash; 5/6.\nWreszcie ostatni z parametrów:\n</p>\n\n<pre>\nchl=Węże|Żółwie\n</pre>\n\n<p>\nzawiera etykiety wycinków koła.\nPolskie znaki kodujemy w standardzie utf-8.\n</p>\n\n<div class="frame">\r\n<p>\nJeśli chcesz, by adres:\n</p>\n\n<pre>\n...chart?chs=400x200&amp;cht=p3&amp;chd=t:1,5&amp;chl=Węże|Żółwie\n</pre>\n\n<p>\nnie powodował ostrzeżeń podczas walidacji kodu rozszerzeniem\nHTML Validator przeglądarki Firefox, jako separatora użyj encji\n<span class="variable">&amp;amp;</span>\nzaś polskie znaki kodowane w UTF-8 \nzapisz wykorzystując notację <span class="variable">%HH</span>:\n</p>\n\n<pre>\n...chart?chs=400x200&amp;amp;chl=W%C4%99%C5%BCe%7C%C5%BB%C3%B3%C5%82wie\n</pre>\n\n<p>\nPolskie napisy możesz zakodować wykorzystując \nw PHP funkcję <span class="variable">urlencode()</span>:\n</p>\n\n<pre>\n&lt;?php\necho urlencode(''Węże|Żółwie'');\n?&gt;\n</pre>\n\n\n<p>\nlub w JavaScript funkcję <span class="variable">escape()</span>:\n</p>\n\n\n<pre>\n&lt;script type="text/javascript"&gt;\n  alert(escape(''Węże|Żółwie''));    \n&lt;/script&gt;\n</pre>\r\n</div>\n\n<h3 id="R3">3. Parametry wykresów</h3>\n\n<p>\nTrzy pierwsze parametry podane w \nomówionym przykładzie są obowiązkowe i zawsze muszą wystąpić.\nSą to:\n</p>\n\n\n<ul>\n<li><span class="variable">chs</span> &mdash; wymiary wykresu</li>\n<li><span class="variable">cht</span>  &mdash; typ wykresu</li>\n<li><span class="variable">chd</span> &mdash; dane wykresu</li>\n</ul>\n\n\n<p>\nPozostałe parametry są opcjonalne.\nIch występowanie zależy od rodzaju wykresu.\n</p>\n\n\n<ul>\n<li><span class="variable">chco</span> (chart color) &mdash; kolory</li>\n<li><span class="variable">chf</span> (chart fill) &mdash; tło, które może być gradientem lub zawierać pasy</li>\n<li><span class="variable">chds</span> (data scaling) &mdash; skalowanie danych</li>\n<li><span class="variable">chtt</span> (chart title) &mdash; tytuł</li>\n<li><span class="variable">chdl</span> (chart legend) &mdash; legenda</li>\n<li><span class="variable">chxt</span> (multiple axis labels) &mdash; etykiety osi</li>\n<li><span class="variable">chg</span> (grid lines) &mdash; siatka</li>\n<li><span class="variable">chm</span> (shape markers) &mdash; punkty</li>\n<li><span class="variable">chls</span> (line styles) &mdash; styl linii</li>\n<li><span class="variable">chbh</span> (bar width and spacing) &mdash; grubość słupków wykresów słupkowych</li>\n<li><span class="variable">chp</span> (bar chart zero line) &mdash; położenie osi wykresu słupkowego</li>\n<li><span class="variable">chl</span> (chart labels) &mdash; etykiety</li>\n</ul>\n\n<h3 id="R4">4. Rodzaje wykresów</h3>\n\n\n<p>\nUsługa Google Chart API udostępnia dziewięć rodzajów wykresów.\nSą to:\n</p>\n\n\n<ul>\n<li>liniowe (ang. <em>line chart</em>) &mdash; typy <span class="variable">lc</span> oraz <span class="variable">lxy</span></li>\n<li>kardiogramy (ang. <em>sparkline chart</em>) &mdash; typ <span class="variable">ls</span></li>\n<li>słupkowe (ang. <em>bar chart</em>) &mdash; typy <span class="variable">bhs</span>, <span class="variable">bvs</span>, <span class="variable">bhg</span>, <span class="variable">bvg</span></li>\n<li>kołowe (ang. <em>pie chart</em>) &mdash; typy <span class="variable">p</span> oraz <span class="variable">p3</span></li>\n<li>diagramy Venna (ang. <em>Venn diagram</em>) &mdash; typ <span class="variable">v</span></li>\n<li>wykresy bąbelkowe (ang. <em>scatter plot</em>) &mdash; typ <span class="variable">s</span></li>\n<li>wykresy radarowe (ang. <em>radar chart</em>) &mdash; typ <span class="variable">r</span></li>\n<li>mapy (ang. <em>map</em>) &mdash; typ <span class="variable">t</span></li>\n<li>wskaźniki (org. <em>Google-o-meter</em>) &mdash; typ <span class="variable">gom</span></li>\n</ul>\n\n\n<p>\nKażdy z rodzajów jest identyfikowany parametrem <span class="variable">cht</span>.\nNa przykład \ndiagram Venna będzie miał parametr \n<span class="variable">cht=v</span>, \na wykres liniowy &mdash; <span class="variable">cht=lc</span> lub <span class="variable">cht=lxy</span>.\n</p>\n\n<h3 id="R5">5. Kodowanie danych</h3>\n\n<p>\nDane do wykresu mogą być zakodowane na jeden z czterech sposobów\nnazywanych:\n</p>\n\n<ul>\n<li>kodowaniem tekstowym,</li>\n<li>kodowaniem tekstowym ze skalowaniem,</li>\n<li>kodowaniem prostym,</li>\n<li>oraz kodowaniem rozszerzonym.</li>\n</ul>\n\n\n\n<p>\nW <em>kodowaniu tekstowym</em> wymieniamy wartości oddzielając je przecinkami.\nDopuszczalnymi wartościami są liczby od 0 do 100.\nDo podziału danych na kilka serii stosujemy znak <span class="variable">|</span>:\n</p>\n\n\n<pre>\nchd=t:10.0,58.0,95.0|30.0,8.0,63.0\n</pre>\n\n\n\n<p>\n<em>Kodowanie tekstowe ze skalowaniem</em>\npozwala podać minimalne i maksymalne wartości w ciągach danych.\nDane zakodowane tekstowo (parametr <span class="variable">chd=t:</span>)\nrozszerzamy o parametr <span class="variable">chds</span>, który podaje minimalną wartość \nw ciągu (w przykładzie: -80) oraz wartość maksymalną\n(w przykładzie: 140):\n</p>\n\n\n\n<pre>\nchd=t:30,-60,110&amp;chds=-80,140\n</pre>\n\n\n<p>\nObliczamy długość przedziału 140 * 80 = 220,\na następnie skalujemy podane wartości: \n</p>\n\n\n\n<pre>\n 30:   30+80 = 110,  110/220 * 100 = 50\n-60:  -60+80 =  20,   20/220 * 100 =  9\n110:  110+80 = 190,  190/220 * 100 = 86\n</pre>\n\n\n<p>\nZatem podany ciąg możemy przedstawić jako kodowanie tekstowe\nbez skalowania:\n</p>\n\n<pre>\nchd=t:50,9,86\n</pre>\n\n\n<p>\nW <em>kodowaniu prostym</em> do zapisu wartości liczbowych \nstosujemy duże i małe litery alfabetu łacińskiego oraz cyfry.\nDuże litery to wartości od 0 do \n25\n(A=0, B=1, C=2, ..., Z=25),\n\nmałe litery kodują liczby od 26 do 51 \n(a=26, b=27, c=28, ..., z=51),\nzaś cyfry reprezentują wartości\nod 52 do 61 (0=52, 1=53, 2=54, ..., 9=61).\nNajmniejszą liczbą w tym ciągu jest 0,\na największą &mdash; 61.\n</p>\n\n\n<p>\nWartość <span class="variable">ATB19</span>:\n</p>\n\n<pre>\nchd=s:ATb19\n</pre>\n\n\n<p>\nreprezentuje ciąg\n0 (A), 19 (T), 27 (b), 53 (1), 61 (9).\nPo przeliczeniu:\n</p>\n\n\n\n\n<pre>\n 0/61 * 100 = 0\n19/61 * 100 = 31\n27/61 * 100 = 44\n53/61 * 100 = 87\n61/61 * 100 = 100\n</pre>\n\n\n\n<p>\notrzymamy następujący kod tekstowy:\n</p>\n\n\n<pre>\nchd=t:0,31,44,87,100\n</pre>\n\n\n<p>\nW przypadku kodowania prostego serie danych oddzielamy znakiem przecinka,\nnp.:\n</p>\n\n\n<pre>\nchd=s:ATb19,Mn5tz \n</pre>\n\n\n<p>\nOstatni rodzaj kodowania, <em>kodowanie rozszerzone</em>,\ndo reprezentacji wartości liczbowych\nwykorzystuje dwuznakowe kombinacje liter, cyfr oraz znaków \nkropki, przecinka, dywizu i podkreślenia.\nOto, w jaki sposób kombinacje znaków odpowiadają wartościom liczbowym:\n</p>\n\n<pre>\nAA =  0,  AB =  1,  ...  AZ = 25,\nAa = 26,  Ab = 27,  ...  Az = 51,\nA0 = 52,  A1 = 53,  ...  A9 = 61\nA- = 62   A. = 63\n\nBA =  64,  BB =  65,  ... \n\n...\n</pre>\n\n\n\n<p>\nWartością najmniejszą jest AA (0), \na największą .. (4095).\nWartości te przeliczamy podobnie jak kodowanie proste,\ntym razem jednak liczby dzielimy przez 4095.\n</p>\n\n\n<p>\nParametr:\n</p>\n\n\n<pre>\nchd=e:C99AKA\n</pre>\n\n\n\n\n\n<p>\nreprezentuje ciąg wartości 189 (C9), 3904 (9A),\n640 (KA).\nPo przeliczeniu:\n</p>\n\n<pre>\n189/4095 * 100 = 5\n3904/4095 * 100 = 95\n640/4095 * 100 = 16\n</pre>\n\n\n<p>\nten sam ciąg możemy zakodować tekstowo:\n</p>\n\n\n<pre>\nchd=t:5,95,16\n</pre>\n\n\n\n\n<p>\nDo konwersji danych liczbowych na \nkodowanie proste można wykorzystać funkcję \n<span class="variable">simpleEncode()</span>\nprzedstawioną na listingu 1.\nSposób konwersji tablicy wartości do kodowania prostego,\nwykorzystujący \nfunkcję <span class="variable">simpleEncode()</span>\noraz bibliotekę jQuery\nzostał przedstawiony na listingu 2.\n</p>\n\n<div class="listing">\r\n<pre>\r\nvar simpleEncoding = ''ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'';\n \nfunction simpleEncode(valueArray, maxValue) {\n\nvar chartData = [''s:''];\n  for (var i = 0; i &lt; valueArray.length; i++) {\n    var currentValue = valueArray[i];\n    if (!isNaN(currentValue) &amp;&amp; currentValue &gt;= 0) {\n    chartData.push(simpleEncoding.charAt(Math.round((simpleEncoding.length-1) * currentValue / maxValue)));\n    }\n      else {\n      chartData.push(''_'');\n      }\n  }\nreturn chartData.join('''');\n}\r\n</pre>\r\n<p>\r\n<strong>Listing 1.</strong>\r\nFunkcja <span class="variable">simpleEncode()</span>\r\n</p>\r\n</div>\r\n\n<div class="listing">\r\n<pre>\r\n&lt;head&gt;\n  &lt;script type=&quot;text/javascript&quot;&gt;\n  var valueArray = new Array(0,1,4,43,59,65);\n  var maxValue = 70; \n  var kod = simpleEncode(valueArray,maxValue);    \n  var url = ''http://chart.apis.google.com/chart?cht=lc&amp;chs=200x125&amp;chd='' + kod;\n    \n  $(document).ready(function(){\n    $(''img'').attr(''src'', url);\n  });\n  &lt;/script&gt;\n&lt;/head&gt;    \n\n&lt;body&gt;\n  &lt;p&gt;\n    &lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;\n  &lt;/p&gt;\n&lt;/body&gt;\r\n</pre>\r\n<p>\r\n<strong>Listing 2.</strong>\r\nKonwersja tablicy wartości do kodu prostego\r\n</p>\r\n</div>\r\n\n\n\n\n<h3 id="R6">6. Przykłady</h3>\n\n<h4 id="P6-1">6.1 Przykład pierwszy</h4>\n\n<div class="image">\r\n    <img src="figure/4.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 4.</strong>\r\n        Tytułu wykresu ustalamy parametrami <span class="variable">chtt</span> oraz <span class="variable">chts</span>, a kolory &mdash; parametrem <span class="variable">chco</span>\r\n    </p>\r\n</div>\n\n<p>\nWykres widoczny na rysunku 6 ma parametry:\n</p>\n\n<pre>\ncht=bvs\nchd=s:YUVmw1\nchco=0000FF\nchs=200x100\nchtt=Poziom+sprzeda%C5%BCy\nchts=00aaFF,16\nchbh=20,8\n</pre>\n\n\n<p>\nJest to wykres słupkowy pionowy (<span class="variable">cht=bvs</span>)\no wymiarach 200x100 (<span class="variable">chs=200x100</span>),\nktórego dane zostały zakodowany w sposób prosty \n(<span class="variable">chd=s:</span>).\nSłupki mają szerokość 20 pikseli i są odległe \nod siebie o 8 pikseli (<span class="variable">chbh=20,8</span>).\nKolor słupków jest niebieski (<span class="variable">chco=0000FF</span>).\nTytuł wykresu jest ustalony parametrami \n<span class="variable">chtt</span> oraz \n<span class="variable">chts</span>.\nPierwszy z nich zawiera tekst <em>Poziom sprzedaży</em>\n(spacje kodujemy znakiem <span class="variable">+</span>),\na drugi ustala kolor (<span class="variable">00aaFF</span>) oraz wielkość czcionki\n(16 pikseli).\n</p>\n\n\n\n<p>\nTytuł wykresu jest ustalony parametrem <span class="variable">chtt</span>.\n</p>\n\n\n\n<h4 id="P6-2">6.2 Przykład drugi</h4>\n\n<div class="image">\r\n    <img src="figure/5.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 5.</strong>\r\n        Modyfikacja tła i grubości linii\r\n    </p>\r\n</div>\n\n\n<p>\nWykres liniowy z rysunku 5 powstaje po ustaleniu następujących parametrów:\n</p>\n\n\n<pre>\ncht=lc\nchs=400x300\nchd=s:pqokeYONOMEBAKPOQVTXZdecaZcglprqxuux393ztpoonkeggjp\nchco=FF0000\nchls=6\nchxt=x,y\nchxl=0:|Jun|July|Aug|1:||20|30|40|50\nchf=bg,s,efefef\n</pre>\n\n\n\n<p>\nLinia wykresu ma grubość 6 pikseli \n(<span class="variable">chls=6</span>) i czerwony kolor (<span class="variable">chco=FF0000</span>).\nWykres ma etykiety obu osi (<span class="variable">chxt=x,y</span>).\nTreść etykiet jest ustalona w parametrze <span class="variable">chxl</span>.\nTło obrazu jest wypełnione szarym kolorem\n(<span class="variable">chf=bg,s,efefef</span>).\n</p>\n\n\n<h4 id="P6-3">6.3 Przykład trzeci</h4>\n\n<div class="image">\r\n    <img src="figure/6.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 6.</strong>\r\n        Wielokrotne serie danych i markery\r\n    </p>\r\n</div>\n\n\n<p>\nWykres liniowy z rysunku 6 ma parametry:\n</p>\n\n\n<pre>\ncht=lxy\nchs=500x300\nchd=t:10,30,60,70,90,95,100|20,30,40,50,60,70,80|10,30,40,45,52|30,90,40,20,10|-1|5,33,50,55,7\nchco=3072F3,ff0000,00aaaa\nchls=2,4,1\nchm=s,FF0000,0,-1,8|c,0000ff,1,-1,15|a,00aa00,2,-1,5\n</pre>\n\n\n\n<p>\nParametr <span class="variable">chd</span> \ndefiniuje trzy serie danych, zakodowane tekstowo.\nPierwszą serię tworzą punkty o współrzędnych:\n</p>\n\n\n<pre>\n(10,20) (30,30) (60,40)\n(70,50) (90,60) (95,70)\n(100,80)\n</pre>\n\n\n<p>\nPowstają one przez połączenie dwóch pierwszych ciągów:\n<span class="variable">10,30,60,70,90,95,100</span>\noraz <span class="variable">20,30,40,50,60,70,80</span>.\n</p>\n\n\n<p>\nDrugą serię tworzą punkty:\n</p>\n\n\n\n<pre>\n(10,30) (30,90) (40,40) ...\n</pre>\n\n\n\n<p>\nNatomiast punkty trzeciej serii są równo oddzielone na osi X\n(wartość -1). Ich wartości na osi Y to\n5,33,50,55,7.\n</p>\n\n\n<p>\nKolory i grubość poszczególnych linii wykresu \nustalamy parametrami <span class="variable">chco</span> oraz <span class="variable">chls</span>.\n</p>\n\n\n<p>\nOstatni parametr <span class="variable">chm</span> definiuje markery \numieszczone na liniach wykresu.\nTyp markera oznaczamy literą,\nnp. \n<span class="variable">s</span> jest prostokątem,\n<span class="variable">c</span> &mdash; krzyżykiem,\nzaś <span class="variable">a</span> &mdash; strzałką.\nParametr:\n</p>\n\n\n<pre>\na,00aa00,2,-1,5\n</pre>\n\n\n\n<p>\ndefiniuje marker w kształcie strzałki (<span class="variable">a</span>),\nkoloru zielonego (<span class="variable">00aa00</span>)\ndla drugiej serii danych.\nMarkery będą umieszczone na wszystkich punktach \nserii danych (wartość -1).\nMarker będzie miał rozmiar 5.\nJeśli zechcesz umieścić jeden marker \nw kształcie krzyżyka czerwonego koloru o wielkości 12\npomiędzy trzecim a czwartym punktem piątej serii danych\nużyj parametru:\n</p>\n\n\n\n<pre>\nc|ff0000|5|3.5|12\n</pre>\n\n\n\n\n\n<h4 id="P6-4">6.4 Przykład czwarty</h4>\n\n<div class="image">\r\n    <img src="figure/7.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 7.</strong>\r\n        Wykres bąbelkowy z gradientem w tle\r\n    </p>\r\n</div>\n\n\n<p>\nPrzykład czwarty, przedstawiony na rysunku 7, \nprezentuje wykres bąbelkowy.\nParametrami wykresu są:\n</p>\n\n<pre>\ncht=s\nchs=400x300\nchd=t:10,20,60,90|10,60,5,90|100,40,60,90\nchxt=x,y\nchxl=0:|0|1|2|3|4|5|6|7|8|9|10|1:|0|25|50|75|100\nchm=o,000000,1,-1,30\nchf=c,lg,90,76A4FB,0.5,ffffff,0|bg,s,EFEFEF\n</pre>\n\n\n<p>\nTrzy serie danych wykresu interpretujemy \njako cztery następujące punkty:\n</p>\n\n<ul>\n<li>punkt o współrzędnych (10,10) i wielkości 100</li>\n<li>punkt o współrzędnych (20,60) i wielkości 40</li>\n<li>punkt o współrzędnych (60,5) i wielkości 60</li>\n<li>punkt o współrzędnych (90,90) i wielkości 90</li>\n</ul>\n\n\n<p>\nMaksymalna wielkość punktu jest ustalana \nparametrem <span class="variable">chm</span>.\nPunkty będą okręgami (<span class="variable">o</span>)\nkoloru czarnego (<span class="variable">000000</span>)\no maksymalnej wielkości 30 pikseli.\n</p>\n\n\n<p>\nTło wykresu i gradient są ustalone parametrem <span class="variable">chf</span>.\nCały obraz ma jednolite tło o kolorze szarym (<span class="variable">bg,s,EFEFEF</span>).\nNatomiast obszar wykresu jest wypełniony liniowym gradientem :\n</p>\n\n\n<pre>\nc      - obszar wykresu\nlg     - gradient liniowy\n90     - kąt gradientu (gradient pionowy)\n76A4FB - kolor początkowy gradientu\n0.5    - gradient rozpoczyna się w połowie wykresu\nffffff - kolor końcowy gradientu\n0      - gradient trwa do dolnej krawędzi wykresu\n</pre>\n\n\n\n<p>\nWykres zawiera etykiety obu osi (<span class="variable">chxt</span>).\nLiczby wyświetlane na osiach \nsą dwoma seriami danych\nzdefiniowanymi parametrem <span class="variable">chxl</span>:\n</p>\n\n\n\n\n<h4 id="P6-5">6.5 Przykład piąty</h4>\n\n<div class="image">\r\n    <img src="figure/8.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 8.</strong>\r\n        Legenda i styl linii\r\n    </p>\r\n</div>\n\n\n<p>\nNa rysunku 8 przedstawiony jest wykres liniowy\nz legendą.\nUżyte parametry to:\n</p>\n\n\n<pre>\ncht=lc\nchs=400x300\nchd=s:93zy...\nchls=3,6,4|1,1,0\nchdl=Niebieskie|Czerwone\nchco=0000ff,ff0000\nchxt=x,y\n</pre>\n\n\n<p>\nLegendę dodajemy parametrem <span class="variable">chdl</span>\nzaś styl linii ustalamy parametrem <span class="variable">chls</span>.\nWartość <span class="variable">3,6,4</span>\nto pogrubiona linia przerywana.\nGrubość linii wynosi 6,\npojedyncza kreska ma 6 pikseli, a przerwa między kreskami &mdash; 4 piksele.\nDruga linia ma grubość 1 i jest ciągła \n(<span class="variable">1,1,0</span>).\n</p>\n\n\n\n<h4 id="P6-6">6.6 Przykład szósty</h4>\n\n<div class="image">\r\n    <img src="figure/9.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 9.</strong>\r\n        Podwójny wykres słupkowy z siatką\r\n    </p>\r\n</div>\n\n\n<p>\nWykres umieszczony na rysunku 6 powstał \nprzy użyciu parametrów:\n</p>\n\n<pre>\ncht=bhs\nchs=400x400\nchd=t:10,40,60|10,15,30\nchco=4d89f9,c6d9fd\nchg=10,20,1,4\nchxt=y,x\nchxl=0:|Marzec|Luty|Styczeń|1:|0|20|40|60|80|100\nchbh=60,40\n</pre>\n\n\n\n<p>\nDwie serie danych służą do ustalenia wysokości \nsłupków. Pierwsza seria definiuje wysokości ciemniejszych \nfragmentów słupków, a druga &mdash; jaśniejszych.\n</p>\n\n\n<p>\nSiatka wykresu jest rysowana dzięki parametrowi <span class="variable">chg</span>.\nPoziome odstępy wynoszą 10, a pionowe &mdash; 20.\nLinia siatki jest przerywana w stosunku 1 do 4.\n</p>\n\n\n\n\n<h4 id="P6-7">6.7 Przykład siódmy</h4>\n\n<div class="image">\r\n    <img src="figure/10.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 10.</strong>\r\n        Wykres radarowy\r\n    </p>\r\n</div>\n\n<p>\nWykres radarowy z rysunku 10 ma parametry:\n</p>\n\n<pre>\ncht=r\nchs=400x400\nchd=t:77,66,15,0,31,48,100,77|20,36,100,2,0,100\nchco=FF0000,FF9900\nchls=2.0,4.0,0.0|2.0,4.0,0.0\nchxt=x\nchxl=0:|0|45|90|135|180|225|270|315\nchxr=0,0.0,360.0\nchg=25.0,25.0,4.0,4.0\nchm=B,FF000080,0,1.0,5.0|B,FF990080,1,1.0,5.0\n</pre>\n\n\n<p>\nLinia o kolorze czerwonym obrazuje pierwszą serię danych,\na pomarańczowa &mdash; drugą.\nObszary czerwony i pomarańczowy są zaznaczone parametrem <span class="variable">chm</span>.\nWartości kolorów zawierają trzy składowe oraz kanał alfa,\ndzięki czemu wypełnienie jest nieco przezroczyste.\nPierwszy z kolorów\n<span class="variable">FF000080</span>\nto kolor czerwony (<span class="variable">FF0000</span>) \no przezroczystości <span class="variable">80</span>.\n</p>\n\n\n\n\n<h4 id="P6-8">6.8 Przykład ósmy</h4>\n\n<div class="image">\r\n    <img src="figure/11.png" alt="" />\r\n    <p>\r\n        <strong>Rysunek 11.</strong>\r\n        Mapa Europy\r\n    </p>\r\n</div>\n\n\n<p>\nMapa przedstawiona na rysunku 11 ma parametry:\n</p>\n\n\n<pre>\ncht=t\nchs=440x220\nchd=s:Af9\nchco=ffffff,ffdfbf,512800\nchld=PLDEFR\nchtm=europe\nchf=bg,s,EAF7FE\n</pre>\n\n\n<p>\nMapa przedstawia Europę (<span class="variable">chtm</span>).\nKolor morza ustalamy parametrem <span class="variable">chf</span>.\nKody państw, które należy pokolorować\nsą zawarte w parametrze <span class="variable">chld</span>.\nPokolorowano Polskę (<span class="variable">PL</span>), \nNiemcy (<span class="variable">DE</span>) i \nFrancję (<span class="variable">FR</span>).\nWszystkie pozostałe Państwa mają kolor biały,\no czym decyduje pierwsza z wartości \n<span class="variable">ffffff</span>\nparametru <span class="variable">chco</span>.\nKolor państw PL, DE oraz FR zależy od\nwartości parametrów <span class="variable">chco</span> oraz <span class="variable">chd</span>.\nW parametrze <span class="variable">chco</span> ustalamy gradient liniowy\nprzebiegający od koloru \n<span class="variable">ffdfbf</span> do koloru \n<span class="variable">512800</span>.\nPoszczególne państwa będą pokolorowane \njednym z odcieni tego gradientu.\nNasycenie gradientu zależy od wartości <span class="variable">chd</span>.\n</p>\n\n\n<p>\nKolor Polski jest wyznaczony przez wartość A,\nktóra w kodowaniu prostym jest równa 0.\nZatem Polska jest pokolorowana kolorem startowym gradientu.\n</p>\n\n\n<p>\nKolor drugiego kraju, Niemiec, \npowstaje jako 31/61 nasycenie gradientu,\ngdyż litera f w kodowaniu prostym to właśnie 31,\na największą wartością jest 61.\n</p>\n\n\n\n<p>\nKolorem Francji jest zdefiniowany w ciągu danych \ncyfrą 9, która w kodowaniu prostym ma wartość 61.\nOtrzymujemy więc ułamek 61/61, czyli 1.\nFrancja jest więc pokolorowana ciemniejszym kolorem gradientu.\n</p>\n\n<p>\nNajwiększy możliwy wymiar mapy wynosi 440x220 pikseli.\n</p>', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Adres</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="http://code.google.com/apis/chart/">Google Chart API &mdash; developer''s guide</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>2.</td>\r\n        <td><a href="http://finance.google.com/finance">Przykład użycia: Google Finance</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>3.</td>\r\n        <td><a href="http://google-code-updates.blogspot.com/2007/12/embed-charts-in-webpages-with-one-of.html">Google Code Blog: <em>&bdquo;Embed charts in webpages with one of our simplest APIs yet&rdquo;</em></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>4.</td>\r\n        <td><a href="http://groups.google.com/group/google-chart-api">Chart API Group</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>5.</td>\r\n        <td><a href="http://gajdaw.pl/varia/chartdirector/">Włodzimierz Gajda: <em>&bdquo;Profesjonalne wykresy na stronach WWW. Biblioteka ChartDirector&rdquo;</em></a></td>\r\n</tr>\r\n    <tr>\r\n        <td>6.</td>\r\n        <td><a href="http://www.advsofteng.com/">Biblioteka ChartDirector</a></td>\r\n</tr>\r\n    <tr>\r\n        <td>7.</td>\r\n        <td><a href="http://www.aditus.nu/jpgraph/">Biblioteka jpgraph</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 2.</strong> Adresy\r\n</p>\r\n\r\n</div>', '', '<div class="table">\r\n\r\n<table>\r\n\r\n<tr>\r\n    <th>lp.</th>    \r\n    <th>Przykład</th>    \r\n</tr>\r\n    <tr>\r\n        <td>1.</td>\r\n        <td><a href="examples/google-chart-api-przyklady.zip">Google Chart API &mdash; wszystkie przykłady</a></td>\r\n</tr>\r\n    </table>\r\n\r\n<p>\r\n<strong>Tabela 1.</strong>  Przykłady do pobrania\r\n</p>\r\n\r\n</div>');

--
-- Zrzut danych tabeli `file`
--

INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(1, 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, '1.png', 'png', 1);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(2, 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, '2.png', 'png', 1);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(3, 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, 'quirksmode-examples.zip', 'zip', 1);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(4, 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, '1.png', 'png', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(5, 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, '2.png', 'png', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(6, 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, '3.png', 'png', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(7, 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, '4.png', 'png', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(8, 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, '5.png', 'png', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(9, 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, '6.png', 'png', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(10, 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, '7.png', 'png', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(11, 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, '8.png', 'png', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(12, 0x504b0304140000000800444f1d37b8be50bb210000002300000025000000312d68746163636573732d68746d6c2d62657a777a676c65646e652f2e6874616363657373732d2aca2f72c94f2ecd4dcd2b5130313051d04f0509e902997a1925b939bc5c00504b030414000000080033b11c377dd5077d6e0000008300000029000000312d68746163636573732d68746d6c2d62657a777a676c65646e652f6572726f722d3430342e6373732d8a410ac2301000ef81fc61a95703f61adfe0493f90dd6c6a30ee4292428bf87703768e33831a77f8580383a4d25d0aef5c760fd3a332aef4e40eb7fb748616a4b9c635a7ebffeebc75174a5ec403b174ae47c040afa5ea2ad1c32921469a8f425ab40e897ca1390cf9b5c69a1f504b03041400000008003c4f1d376f5ff45633010000eb0100002a000000312d68746163636573732d68746d6c2d62657a777a676c65646e652f6572726f722d3430342e68746d6c754fcb4ec33010bc23f10f8befc9366a0fb4383d34ad0452810a82806348b675c04d82bd90f68ac49fc17fe13cca09e4c3ccae776667e5c9fc3a8a1f570b50bcd5b0ba9b2d2f22101ee2fd30429cc77378388f2f9710f803b86593a78cb8b8122014733541acebdaaf877e693618dfe0ae71091a594f3ddb6afc8c33313d3e92ed96dd561736fcc321188fc79d503443139d149b5054aefa65ce04402a4ab29639ce396b9acebe3fbe3eb3095465961409b8b5a5832227c82d3b782689dd642fdb1227d044f0e8f52d7f0f4554164c057bf1be22016957858269c7d8443a835425c612876fbcf64e05e0c14ae7c50b18d2a1b0bcd76415110b60e7d3cb536b052843eb502019531a6f3418f96db73391d85f249fca6cefb0795205fd59ee3b689bb272b0faf744df4d60759063ef25dbf8d31f504b03040a0000000000384f1d370000000000000000000000001c000000312d68746163636573732d68746d6c2d62657a777a676c65646e652f504b01021400140000000800444f1d37b8be50bb2100000023000000250000000000000001002000b68100000000312d68746163636573732d68746d6c2d62657a777a676c65646e652f2e6874616363657373504b0102140014000000080033b11c377dd5077d6e00000083000000290000000000000001002000b68164000000312d68746163636573732d68746d6c2d62657a777a676c65646e652f6572726f722d3430342e637373504b010214001400000008003c4f1d376f5ff45633010000eb0100002a0000000000000001002000b68119010000312d68746163636573732d68746d6c2d62657a777a676c65646e652f6572726f722d3430342e68746d6c504b010214000a0000000000384f1d370000000000000000000000001c0000000000000000001000ff4194020000312d68746163636573732d68746d6c2d62657a777a676c65646e652f504b050600000000040004004c010000ce0200000000, '1-htaccess-html-bezwzgledne.zip', 'zip', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(13, 0x504b030414000000080058501d378f0c14a8200000002200000022000000322d68746163636573732d68746d6c2d777a676c65646e652f2e6874616363657373732d2aca2f72c94f2ecd4dcd2b5130313051480589e802597a1925b939bc5c00504b030414000000080033b11c377dd5077d6e0000008300000026000000322d68746163636573732d68746d6c2d777a676c65646e652f6572726f722d3430342e6373732d8a410ac2301000ef81fc61a95703f61adfe0493f90dd6c6a30ee4292428bf87703768e33831a77f8580383a4d25d0aef5c760fd3a332aef4e40eb7fb748616a4b9c635a7ebffeebc75174a5ec403b174ae47c040afa5ea2ad1c32921469a8f425ab40e897ca1390cf9b5c69a1f504b030414000000080060501d370dfb536033010000ea01000027000000322d68746163636573732d68746d6c2d777a676c65646e652f6572726f722d3430342e68746d6c754fcb4ec33010bc23f10f8befc9366a0fb4383d34ad0452810a82806348b675c04d82bd90f68ac49fc17fe13cca09e4c3ccae776667e5c9fc3a8a1f570b50bcd5b0ba9b2d2f22101ee2fd30429cc77378388f2f9710f803b86593a78cb8b8122014733541acebdaaf877e693618dfe0ae71091a594f3ddb6afc8c33313d3e92ed96dd561736fcc321188fc79d503443139d149b5054aefa65ce04402a4ab29639ce396b9acebe3fbe3eb3095465961409b8b5a5832227c82d3b782689dd642fdb1227d044f0e8f52d7f0f4554164c057bf1be22016957858269c7d8443a835425c612876fbcf64e05e0c14ae7c50b18d2a1b0bcd76415110b60e7d3cb536b052843eb509031a5f1468391df363b0f89fd41f2a9ccf60e9b2755d05fe5be83b6292b07ab7f2ff4dd04560739f65eb24d3ffd01504b03040a000000000056501d3700000000000000000000000019000000322d68746163636573732d68746d6c2d777a676c65646e652f504b0102140014000000080058501d378f0c14a82000000022000000220000000000000001002000b68100000000322d68746163636573732d68746d6c2d777a676c65646e652f2e6874616363657373504b0102140014000000080033b11c377dd5077d6e00000083000000260000000000000001002000b68160000000322d68746163636573732d68746d6c2d777a676c65646e652f6572726f722d3430342e637373504b0102140014000000080060501d370dfb536033010000ea010000270000000000000001002000b68112010000322d68746163636573732d68746d6c2d777a676c65646e652f6572726f722d3430342e68746d6c504b010214000a000000000056501d37000000000000000000000000190000000000000000001000ff418a020000322d68746163636573732d68746d6c2d777a676c65646e652f504b0506000000000400040040010000c10200000000, '2-htaccess-html-wzgledne.zip', 'zip', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(14, 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, '3-htaccess-php-bezwzgledne.zip', 'zip', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(15, 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, '4-blad-403.zip', 'zip', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(16, 0x504b03041400000008001d5c1d375bb3b85df60000005601000013000000352d6865616465722f6865616465722e7068702d8fd14fc23010c6df49f81fcebea00fdd31c104a583c40d0309c28235eae3dc1abb04d6b91d6efcf7b66c2fbdefbef6eef7552c4b5d0e07c3815649a6aadbd15aca187daf85e9780a3b43f062ce4536ba9bbb47cb853bc54db40fe557bc024da723c4efcfdb4d088c237e4c42c44846f0b996af5bf0bd31bc5195a784b8da31609aa87c426c9ac66b269ea97e501eb0755b7c37d64b5e5f67bc8c326681c299b6020817f2aaaca69c8e6a61530aec64ef9f1425e0405cfd9ef3bf8085a62055109797523148bb2e60a45a42b77a0ea94eaa5a5190d786cf660f8ffc9e017644ec91e2db6497eef7daefa8b6bade3ad85f0aeca3fe03504b03040a0000000000e15b1d3700000000000000000000000009000000352d6865616465722f504b010214001400000008001d5c1d375bb3b85df600000056010000130000000000000001002000b68100000000352d6865616465722f6865616465722e706870504b010214000a0000000000e15b1d37000000000000000000000000090000000000000000001000ff4127010000352d6865616465722f504b05060000000002000200780000004e0100000000, '5-header.zip', 'zip', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(17, 0x504b0304140000000800e95c1537cac8d3fd3b0000004500000010000000362d64656e792f2e6874616363657373b371cbcc492d56a853508ad12bc8285051b2e3e5520002ffa294d42285c49c9cfc729d94d4bc4a88a80b90a59056949f0b92e1e5b2d107ebb60300504b0304140000000800585c1d37d06e922bf30000006b0100000e000000362d64656e792f7374722e7068706d8ecb4ec3301045f795fa0f83375dc543d40d69ed5422a90452810a828065484c1d292f922949ff1edb8958b1f2b9f27d8cb88a9fa2e4e3b8074d5509c7d7dbc37d04cc437c5b47887112c3fb5df270009f5fc30b75454688fb47064c13b51bc46118f8b0e64d77c2e41947dbe2dbd88c5eef323ca79c85cb85702b6355d6bdfca7c10f82600a326bda94697d92ac35ea8f4c0980d02acd1d19a6824a159adb9a3a1538a9f9ab5294829df1d4f7b9f8912c6a6a523579c9a5550cb24949466a24b4b35bc874daf58ae499bebc1b0638ede13c283e9bfc625e43bb56b71654a61b58f56e9e73beda2e17bbc981b359b8eaf017504b03040a0000000000515c1d3700000000000000000000000007000000362d64656e792f504b01021400140000000800e95c1537cac8d3fd3b00000045000000100000000000000001002000b68100000000362d64656e792f2e6874616363657373504b01021400140000000800585c1d37d06e922bf30000006b0100000e0000000000000001002000b68169000000362d64656e792f7374722e706870504b010214000a0000000000515c1d37000000000000000000000000070000000000000000001000ff4188010000362d64656e792f504b05060000000003000300af000000ad0100000000, '6-deny.zip', 'zip', 2);
INSERT INTO `file` (`file_id`, `data`, `slug`, `mime`, `article_id`) VALUES(18, 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