<?php

require 'records/om/BaseSongPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'song' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    records
 */
class SongPeer extends BaseSongPeer {

    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        $criteria->addAscendingOrderByColumn(SongPeer::TITLE);
        return parent::doSelect($criteria, $con);
    }

    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }
    
    public static function insert($dane)
    {
        $tmp = new Song();
        $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
        $tmp->save();
        return $tmp;
    }
    

} // SongPeer
