<?php

require 'zengardencss/om/BaseCzcionka.php';


/**
 * Skeleton subclass for representing a row from the 'czcionka' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    zengardencss
 */
class Czcionka extends BaseCzcionka {

	/**
	 * Initializes internal state of Czcionka object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getNazwa();
	}	
	
	public function projektyCzcionki()
	{
	    $c = new Criteria();
	    $c->addAscendingOrderByColumn(ProjektPeer::NAZWA);
	    $tmp = $this->getProjektHasCzcionkasJoinProjekt($c);
	    $wynik = array();
	    foreach ($tmp as $phcz) {
	        $wynik[] = $phcz->getProjekt();
	    }
	    return $wynik;
	}	
	
	public function ustalLiczbeProjektow()
	{
        $c = new Criteria();
        $c->add(ProjektHasCzcionkaPeer::CZCIONKA_ID, $this->getCzcionkaId());
        $liczba_projektow = ProjektHasCzcionkaPeer::doCount($c);
        $this->setLiczbaprojektow($liczba_projektow);
        $this->save();
	}
	

} // Czcionka
