<?php


class Pager 
{
    private $klasa = '';
    private $klasaPeer = '';    
    

    private $liczba_wszystkich_rekordow = 0;
    private $liczba_rekordow_na_stronie = 12;
    private $liczba_stron = 0;
    private $numer_strony = 0;
    private $numer_pierwszego_rekordu = 0;
    private $szerokosc = 11;

    
    private $base_url;
    
    private $rekordy;
    
    private $criteria = null;
    
    public function __construct($klasa, $liczba_rekordow_na_stronie = 10, $criteria = null, $szerokosc = 11)
    {
        if (is_null($criteria)) {
            $this->criteria = new Criteria();        
        } else {
            $this->criteria = clone $criteria;        
        }    
    
        $this->klasa = $klasa;
        $this->klasaPeer = $klasa . 'Peer';
        $this->liczba_rekordow_na_stronie = $liczba_rekordow_na_stronie;
        $this->przeliczLiczbeRekordow();
        $this->przeliczLiczbeStron();
        $this->szerokosc = $szerokosc;
    }
    
    public function przeliczLiczbeRekordow()
    {
        $this->liczba_wszystkich_rekordow =
            call_user_func($this->klasaPeer . '::doCount', $this->criteria);
    }

    public function przeliczLiczbeStron()
    {
        $this->liczba_stron = (int)ceil(
          $this->liczba_wszystkich_rekordow / $this->liczba_rekordow_na_stronie
        );
    }
    
    public function isValidPage($page)
    {
        return str_ievpifr($page, 1, $this->liczba_stron);
    }    
    
    public function setPage($page)
    {
        if ($this->isValidPage($page)) {
            $this->numer_strony = $page;
            $this->numer_pierwszego_rekordu = ($page - 1) * $this->liczba_rekordow_na_stronie;
        }
    }

    public function getPages($szerokosc = false)
    {
        if ($szerokosc) {
            $this->setWidth($szerokosc);
        }

        $polowa = (int)floor($this->szerokosc / 2);

        $minimum = $this->numer_strony;
        $minimum = $minimum - $polowa;
        $minimum = max($minimum, 1);
        
        $maksimum = $minimum + $this->szerokosc - 1;

        $za_duzo = $maksimum - $this->liczba_stron;
        if ($za_duzo > 0) {
            $minimum = $minimum - $za_duzo;
            $minimum = max($minimum, 1);
        }

        $maksimum = min($minimum + $this->szerokosc - 1, $this->liczba_stron);

        $pages = array();

        for ($i = $minimum; $i <= $maksimum; $i++) {
            $pages[] = $i;
        }
        return $pages;
    }


    
    public function assignRecords()
    {
        $this->criteria->setLimit($this->liczba_rekordow_na_stronie);
        $this->criteria->setOffset($this->numer_pierwszego_rekordu);

        $tmp = call_user_func($this->klasaPeer . '::doSelect', $this->criteria);

        $i = $this->numer_pierwszego_rekordu + 1;

        $this->rekordy = array();
        foreach ($tmp as $obj) {
            $this->rekordy[$i] = $obj;
            $i++;
        }
    }

    public function getRecords()
    {
        return $this->rekordy;
    }
    
    public function setBaseURL($url)
    {
        return $this->base_url = $url;
    }

    public function getPageURL($page)
    {
        if ($page !== false) {
            return $this->base_url . $page;
        } else {
            return '';
        }
    }

    
    public function getPage()
    {
        return $this->numer_strony;
    }

    public function getFirstPage()
    {
        if ($this->liczba_stron > 0) {
            return 1;
        } else {
            return false;
        }

    }
    
    public function getLastPage()
    {
        if ($this->liczba_stron > 0) {
            return $this->liczba_stron;
        } else {
            return false;
        }

    }    
    
    public function getPreviousPage()
    {
        if ($this->numer_strony > 1) {
            return $this->numer_strony - 1;
        } else {
            return false;
        }

    }        
    
    public function getNextPage()
    {
        if ($this->numer_strony < $this->liczba_stron) {
            return $this->numer_strony + 1;
        } else {
            return false;
        }
    }            
    
    public function getFirstPageURL()
    {
        return $this->getPageURL($this->getFirstPage());
    }

    public function getPreviousPageURL()
    {
        return $this->getPageURL($this->getPreviousPage());
    }

    public function getNextPageURL()
    {
        return $this->getPageURL($this->getNextPage());
    }

    public function getLastPageURL()
    {
        return $this->getPageURL($this->getLastPage());
    }
    
    public function isPager()
    {
        return ($this->liczba_stron > 1);
    }
    
    public function isCurrentPage($strona)
    {
        return ($strona == $this->getPage());
    }

    public function getNbPages()
    {
        return $this->liczba_stron;
    }
    
    public function leftDots($szerokosc = false)
    {
        if ($szerokosc) {
            $this->setWidth($szerokosc);
        }
    
        $polowa = (int)floor($this->szerokosc / 2);
        
        $minimum = $this->numer_strony;    
        
        $minimum = $minimum - $polowa;        
        
        $minimum = max($minimum, 1);
        
        $maksimum = $minimum + $this->szerokosc - 1;
        
        $za_duzo = $maksimum - $this->liczba_stron;
        if ($za_duzo > 0) {
            $minimum = $minimum - $za_duzo;
            $minimum = max($minimum, 1);        
        }
        
        return ($minimum > 1);
        
    }
    
    public function rightDots($szerokosc = false)
    {
    
        if ($szerokosc) {
            $this->setWidth($szerokosc);
        }
    
        $polowa = (int)floor($this->szerokosc / 2);

        $minimum = $this->numer_strony;

        $minimum = $minimum - $polowa;

        $minimum = max($minimum, 1);

        $maksimum = $minimum + $this->szerokosc - 1;

        $za_duzo = $maksimum - $this->liczba_stron;
        if ($za_duzo > 0) {
            $minimum = $minimum - $za_duzo;
            $minimum = max($minimum, 1);
        }

        $maksimum = min($minimum + $this->szerokosc - 1, $this->liczba_stron);
        return $maksimum < $this->liczba_stron;

    }
    
    

    public function setWidth($width)
    {
        return $this->szerokosc = $width;
    }

    


}