<?php

require 'imiona/om/BaseImiePeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'imie' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    imiona
 */
class ImiePeer extends BaseImiePeer {


    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        $criteria->addAscendingOrderByColumn(self::IMIE);
        return parent::doSelect($criteria, $con);
    }


    public function podajLitery ()
    {
        $query = '
            SELECT DISTINCT
                LEFT(imie, 1) as litera
            FROM
                imie
            ORDER BY
                imie
        ';
        
        $connection = Propel::getConnection();
        $statement = $connection->prepare($query);
        $statement->execute();
        $statement->setFetchMode(PDO::FETCH_ASSOC);
        $wyn = $statement->fetchAll();

        /*
         *  Uycie funkcji urlencode w zapytaniach SQL:
         *
         *  http://brunovernay.wordpress.com/2007/04/11/urldecode-for-mysql/
         */


        $ile = count($wyn);
        for ($i = 0; $i < $ile; $i++) {
            $wyn[$i]['kod'] = urlencode($wyn[$i]['litera']);
        }

        return $wyn;
        
    }

    public static function insert($dane)
    {
        $tmp = new Imie();
        $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
        $tmp->save();
        return $tmp;
    }



} // ImiePeer
