<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'slugs.inc.php';

require_once 'propel/Propel.php';
require_once 'treny/Tren.php';
Propel::init('treny-conf.php');

$plks = glob('treny/*.txt');
shuffle($plks);
foreach ($plks as $plk) {

    $path_parts = pathinfo($plk);
    $numer = ltrim($path_parts['filename'], '0');

    $p = file($plk);
    $tytul = trim($p[0]);
    $slug = string2slug($tytul);
    $p[0] = '';
    $tresc = trim(implode('', $p));
    
    $tren = new Tren();
    $tren->setTytul($tytul);
    $tren->setTresc($tresc);
    $tren->setSlug($slug);
    $tren->setNumer($numer);
    $tren->save();
}