SELECT
    przedmiot.nazwa as przedmiot_nazwa,
    rodzaj.skrot as rodzaj_skrot,
    przedmiot.godz as przedmiot_godz,
    kierunek.nazwa as kierunek_nazwa,
    IF (
        rodzaj.grupy,
        przydzial.numergrupy,
        0
    ) as grupa,
    floor((przedmiot.semestr + 1) / 2) as rok,
    przedmiot.semestr,
    przedmiot.slug as przedmiot_slug,
    kierunek.slug as kierunek_slug
FROM
    przedmiot as przedmiot,
    przydzial as przydzial,
    kierunek as kierunek,
    rodzajzajec as rodzaj
WHERE
    kierunek.kierunek_id = przedmiot.kierunek_id AND
    przydzial.pracownik_id = 20 AND
    przydzial.przedmiot_id = przedmiot.przedmiot_id AND
    (przedmiot.godz != 0) AND
    (przedmiot.zimalato = 1) AND
    rodzaj.rodzajzajec_id = przedmiot.rodzajzajec_id AND
    przedmiot.odbywa_sie = 1
ORDER BY
    kierunek.kierunek_id,
    przedmiot.semestr,
    rodzaj.sortowanie,
    grupa


============================================================================================



SELECT
    SUM(przedmiot.godz)
FROM
    przedmiot as przedmiot,
    przydzial as przydzial,
    kierunek as kierunek
WHERE
    kierunek.kierunek_id = przedmiot.kierunek_id AND
    przydzial.pracownik_id = 20 AND
    przydzial.przedmiot_id = przedmiot.przedmiot_id AND
    (przedmiot.godz != 0) AND
    (przedmiot.zimalato = 1) AND
    przedmiot.odbywa_sie = 1



============================================================================================



SELECT
    przedmiot.slug,
    przedmiot.nazwa,
    rodzaj.skrot,
    przedmiot.godz,
    przedmiot.liczbagrup,
    przedmiot.skrot,
    przedmiot.odbywa_sie
FROM
    przedmiot as przedmiot,
    rodzajzajec as rodzaj
WHERE
    przedmiot.kierunek_id = 1 AND
    przedmiot.semestr = 3 AND
    rodzaj.rodzajzajec_id = przedmiot.rodzajzajec_id
ORDER BY
    rodzaj.sortowanie,
    przedmiot.nazwa



============================================================================================



SELECT
    przydzial.przydzial_id,
    przydzial.przedmiot_id,
    przydzial.pracownik_id,
    przydzial.numergrupy,
    IF (
        przydzial.pracownik_id,
        pracownik.imie,
        NULL
    ) as imie,
    IF (
        przydzial.pracownik_id,
        pracownik.nazwisko,
        NULL
    ) as nazwisko,
    IF (
        przydzial.pracownik_id,
        pracownik.skrot,
        NULL
    ) as skrot,
    IF (
        przydzial.pracownik_id,
        pracownik.slug,
        NULL
    ) as slug
FROM
    przydzial as przydzial,
    pracownik as pracownik
WHERE
    przydzial.przedmiot_id = 2 AND
    przydzial.pracownik_id = pracownik.pracownik_id
ORDER BY
    przydzial.numergrupy
    
    

============================================================================================




SELECT
    pracownik.pracownik_id,
    pracownik.tytul,
    pracownik.imie,
    pracownik.nazwisko,
    SUM(przedmiot.godz) as sumagodzin,
    stanowisko.pensum as pensum,
    SUM(przedmiot.godz) - stanowisko.pensum as nadgodziny,
    kierunek.rodzajstudiow_id
FROM
    pracownik as pracownik,
    przedmiot as przedmiot,
    przydzial as przydzial,
    stanowisko as stanowisko,
    kierunek as kierunek
WHERE
    pracownik.pracownik_id = przydzial.pracownik_id AND
    przedmiot.przedmiot_id = przydzial.przedmiot_id AND
    stanowisko.stanowisko_id = pracownik.stanowisko_id AND
    przedmiot.odbywa_sie = 1 AND
    przedmiot.kierunek_id = kierunek.kierunek_id

GROUP BY
    pracownik.pracownik_id
    
ORDER BY
    sumagodzin DESC