set names utf8;
drop database if exists autokomis;
create database autokomis default character set utf8 collate utf8_polish_ci;
grant all on autokomis.* to admin@localhost identified by 'password';
flush privileges;
use autokomis;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- marka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `marka`;


CREATE TABLE `marka`
(
	`marka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`marka_id`),
	UNIQUE KEY `marka_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- model
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `model`;


CREATE TABLE `model`
(
	`model_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`marka_id` INTEGER  NOT NULL,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`model_id`),
	UNIQUE KEY `model_U_1` (`slug`(128)),
	INDEX `FI_model_marka` (`marka_id`),
	CONSTRAINT `fk_model_marka`
		FOREIGN KEY (`marka_id`)
		REFERENCES `marka` (`marka_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- wyposazenie
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `wyposazenie`;


CREATE TABLE `wyposazenie`
(
	`wyposazenie_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`skrot` VARCHAR(20),
	`opis` VARCHAR(255),
	`slug` VARCHAR(20)  NOT NULL,
	PRIMARY KEY (`wyposazenie_id`),
	UNIQUE KEY `wyposazenie_U_1` (`slug`(20))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- auto
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `auto`;


CREATE TABLE `auto`
(
	`auto_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rocznik` INTEGER,
	`cena` INTEGER,
	`pojemnosc` FLOAT,
	`przebieg` INTEGER,
	`kolor` VARCHAR(255),
	`typ` VARCHAR(20),
	`paliwo` VARCHAR(20),
	`uwagi` TEXT,
	`slug` VARCHAR(255)  NOT NULL,
	`model_id` INTEGER  NOT NULL,
	PRIMARY KEY (`auto_id`),
	UNIQUE KEY `auto_U_1` (`slug`(255)),
	INDEX `FI_auto_model1` (`model_id`),
	CONSTRAINT `fk_auto_model1`
		FOREIGN KEY (`model_id`)
		REFERENCES `model` (`model_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- auto_has_wyposazenie
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `auto_has_wyposazenie`;


CREATE TABLE `auto_has_wyposazenie`
(
	`auto_id` INTEGER  NOT NULL,
	`wyposazenie_id` INTEGER  NOT NULL,
	PRIMARY KEY (`auto_id`,`wyposazenie_id`),
	CONSTRAINT `fk_auto_has_wyposazenie_auto1`
		FOREIGN KEY (`auto_id`)
		REFERENCES `auto` (`auto_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_auto_has_wyposazenie_wyposazenie1` (`wyposazenie_id`),
	CONSTRAINT `fk_auto_has_wyposazenie_wyposazenie1`
		FOREIGN KEY (`wyposazenie_id`)
		REFERENCES `wyposazenie` (`wyposazenie_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 10:29
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `autokomis`
--

--
-- Zrzut danych tabeli `auto`
--

INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(1, 2004, 22300, 2.6, 279000, 'bordowy metalik', 'kombi', 'TD', '', 'ford-probe-kombi-2004-bordowy-metalik-2-6', 1);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(2, 1999, 67900, 1.7, 291000, 'srebrny metalik', 'hatchback', 'BG', '', 'audi-a3-hatchback-1999-srebrny-metalik-1-7', 2);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(3, 2004, 28600, 3.8, 47000, 'czerwony metalik', 'kabriolet', 'B', 'pierwszy właściciel', 'honda-vt-800-kabriolet-2004-czerwony-metalik-3-8', 3);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(4, 2004, 9600, 2.6, 211000, 'bordowy metalik', 'kabriolet', '', '', 'pontiac-firo-kabriolet-2004-bordowy-metalik-2-6', 4);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(5, 1995, 35900, 2.8, 13000, 'granatowy', 'sedan', '', 'sprowadzany', 'opel-ascona-sedan-1995-granatowy-2-8', 5);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(6, 1994, 43100, 2.4, 181000, 'kość słoniowa', 'sedan', '', 'cena do uzgodnienia, garażowany, pierwszy właściciel, sprowadzany', 'renault-safrane-sedan-1994-kosc-sloniowa-2-4', 6);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(7, 1992, 26900, 2.4, 51000, 'zielony metalik', '', 'B', 'garażowany, sprowadzany', 'opel-ascona-1992-zielony-metalik-2-4', 5);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(8, 1996, 49900, 3.5, 322000, 'kość słoniowa', '', 'TD', 'cena do uzgodnienia, garażowany, sprowadzany', 'nissan-terrano-1996-kosc-sloniowa-3-5', 7);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(9, 2003, 64500, 3.2, 304000, 'zielony metalik', 'kabriolet', '', 'cena do uzgodnienia, garażowany, możliwa wymiana', 'mercedes-c-180-kabriolet-2003-zielony-metalik-3-2', 8);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(10, 2002, 15900, 1.3, 131000, 'grafitowy', 'kabriolet', 'D', '', 'volksvagen-polo-kabriolet-2002-grafitowy-1-3', 9);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(11, 1996, 28500, 3.2, 123000, 'bordowy', '', 'BG', 'garażowany, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'opel-ascona-1996-bordowy-3-2', 5);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(12, 1994, 12700, 3.1, 193000, 'grafitowy metalik', '', 'D', '', 'opel-senator-1994-grafitowy-metalik-3-1', 10);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(13, 2005, 39400, 3.4, 206000, 'grafitowy', 'kombi', 'BG', 'garażowany, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'nissan-laurel-kombi-2005-grafitowy-3-4', 11);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(14, 1999, 92200, 4.4, 152000, 'granatowy metalik', 'kabriolet', 'BG', 'garażowany, pierwszy właściciel, sprowadzany', 'volksvagen-caravelle-kabriolet-1999-granatowy-metalik-4-4', 12);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(15, 1999, 81900, 1.2, 230000, 'grafitowy metalik', 'kabriolet', 'G', 'pierwszy właściciel', 'fiat-125p-kabriolet-1999-grafitowy-metalik-1-2', 13);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(16, 2004, 86300, 2.3, 101000, 'kość słoniowa', 'kabriolet', 'TD', 'gotowy do rejestracji, pierwszy właściciel', 'peugeot-806-kabriolet-2004-kosc-sloniowa-2-3', 14);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(17, 2002, 84500, 4, 154000, 'żółty', 'hatchback', '', 'cena do uzgodnienia, garażowany, gotowy do rejestracji', 'opel-kadet-hatchback-2002-zolty-4', 15);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(18, 1994, 55700, 2.3, 249000, 'grafitowy', 'sedan', 'TD', '', 'honda-prelude-sedan-1994-grafitowy-2-3', 16);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(19, 2001, 15100, 3.9, 19000, 'pomarańczowy', 'kabriolet', 'BG', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'ford-mondeo-kabriolet-2001-pomaranczowy-3-9', 17);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(20, 2004, 16200, 3.8, 43000, 'zielony metalik', 'sedan', '', 'cena do uzgodnienia, garażowany, sprowadzany', 'opel-astra-sedan-2004-zielony-metalik-3-8', 18);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(21, 2002, 44900, 1.1, 149000, 'zielony metalik', 'hatchback', 'B', 'garażowany, sprowadzany', 'mercedes-c-200-hatchback-2002-zielony-metalik-1-1', 19);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(22, 1999, 63800, 4.5, 262000, 'zielony metalik', 'kabriolet', 'D', 'możliwa wymiana, pierwszy właściciel', 'bmw-525-kabriolet-1999-zielony-metalik-4-5', 20);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(23, 2000, 82200, 3.5, 34000, 'grafitowy metalik', 'sedan', 'TD', '', 'chrysler-vision-sedan-2000-grafitowy-metalik-3-5', 21);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(24, 1994, 62100, 3.5, 152000, 'żółty', 'sedan', 'TD', 'gotowy do rejestracji, sprowadzany', 'renault-espace-ii-sedan-1994-zolty-3-5', 22);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(25, 1991, 97700, 4.2, 128000, 'srebrny metalik', 'sedan', 'B', 'garażowany, możliwa wymiana, sprowadzany', 'opel-zafira-sedan-1991-srebrny-metalik-4-2', 23);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(26, 2001, 29700, 2, 267000, 'zielony metalik', '', '', 'garażowany, możliwa wymiana, sprowadzany', 'fiat-marea-2001-zielony-metalik-2', 24);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(27, 1999, 55500, 2.8, 206000, 'czerwony', 'kabriolet', 'G', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana', 'daewoo-nubira-kabriolet-1999-czerwony-2-8', 25);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(28, 2002, 75500, 3.8, 202000, 'czarna perła', '', 'B', 'cena do uzgodnienia, pierwszy właściciel', 'mercedes-123-2002-czarna-perla-3-8', 26);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(29, 2003, 85000, 3.9, 283000, 'czarny', '', '', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'honda-concerto-2003-czarny-3-9', 27);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(30, 1996, 63800, 4.2, 45000, 'czarny', 'kombi', 'B', 'garażowany, gotowy do rejestracji, sprowadzany', 'mercedes-e-klasse-kombi-1996-czarny-4-2', 28);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(31, 1990, 41700, 2.6, 298000, 'żółty', 'kabriolet', 'BG', 'pierwszy właściciel, sprowadzany', 'fiat-stilo-kabriolet-1990-zolty-2-6', 29);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(32, 1995, 21600, 1, 172000, 'czarny', 'hatchback', 'G', '', 'mitshubishi-pajero-long-hatchback-1995-czarny-1', 30);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(33, 2002, 11400, 3, 190000, 'zielony', 'hatchback', 'D', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'nissan-240-sx-hatchback-2002-zielony-3', 31);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(34, 1997, 73800, 1.7, 38000, 'czarny', 'kombi', 'B', '', 'skoda-superb-kombi-1997-czarny-1-7', 32);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(35, 2003, 64700, 3.2, 233000, 'czerwony', 'hatchback', '', 'pierwszy właściciel, sprowadzany', 'bmw-635-hatchback-2003-czerwony-3-2', 33);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(36, 1994, 72300, 4.4, 101000, 'biały', 'sedan', 'D', 'pierwszy właściciel', 'chrysler-pt-cruiser-sedan-1994-bialy-4-4', 34);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(37, 1994, 46900, 2.1, 226000, 'granatowy metalik', 'hatchback', 'TD', 'garażowany, gotowy do rejestracji', 'seat-ibiza-hatchback-1994-granatowy-metalik-2-1', 35);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(38, 1993, 64100, 2.6, 72000, 'czarna perła', 'kabriolet', 'TD', 'pierwszy właściciel, sprowadzany', 'rover-45-kabriolet-1993-czarna-perla-2-6', 36);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(39, 1992, 11600, 2.1, 114000, 'żółty', 'kabriolet', 'G', 'gotowy do rejestracji, sprowadzany', 'bmw-730-kabriolet-1992-zolty-2-1', 37);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(40, 2003, 73100, 1.2, 83000, 'grafitowy metalik', 'sedan', 'B', 'cena do uzgodnienia, sprowadzany', 'dodge-stratus-sedan-2003-grafitowy-metalik-1-2', 38);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(41, 1993, 55500, 3.5, 238000, 'zielony', 'kombi', 'BG', 'pierwszy właściciel', 'rover-416-kombi-1993-zielony-3-5', 39);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(42, 1991, 39000, 1.3, 277000, 'zielony', 'hatchback', 'G', 'garażowany, pierwszy właściciel, sprowadzany', 'dodge-dynasty-hatchback-1991-zielony-1-3', 40);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(43, 2002, 70800, 4.4, 72000, 'grafitowy', '', 'D', '', 'mitshubishi-space-wagon-2002-grafitowy-4-4', 41);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(44, 2003, 36400, 1.9, 110000, 'srebrny metalik', '', 'D', 'gotowy do rejestracji', 'rover-75-2003-srebrny-metalik-1-9', 42);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(45, 2005, 14800, 4.4, 280000, 'kość słoniowa', 'kabriolet', 'G', 'pierwszy właściciel', 'saab-9000-kabriolet-2005-kosc-sloniowa-4-4', 43);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(46, 1999, 7600, 4.2, 324000, 'czerwony', 'kabriolet', 'D', 'gotowy do rejestracji, sprowadzany', 'citroen-xsara-picasso-kabriolet-1999-czerwony-4-2', 44);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(47, 2000, 6700, 1.1, 348000, 'kość słoniowa', '', 'BG', 'garażowany, możliwa wymiana, sprowadzany', 'chrysler-neon-2000-kosc-sloniowa-1-1', 45);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(48, 1995, 67600, 2.7, 134000, 'grafitowy metalik', 'sedan', 'TD', 'pierwszy właściciel', 'fiat-cinquecento-sedan-1995-grafitowy-metalik-2-7', 46);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(49, 1992, 31200, 3.1, 214000, 'grafitowy metalik', 'sedan', 'D', 'gotowy do rejestracji', 'skoda-105-sedan-1992-grafitowy-metalik-3-1', 47);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(50, 1991, 62000, 1, 169000, 'pomarańczowy', 'hatchback', 'B', 'garażowany', 'opel-kadet-hatchback-1991-pomaranczowy-1', 15);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(51, 1990, 26900, 2.2, 148000, 'granatowy', 'sedan', '', '', 'mitshubishi-colt-sedan-1990-granatowy-2-2', 48);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(52, 2000, 12100, 3.8, 292000, 'czarna perła', 'hatchback', 'G', 'cena do uzgodnienia, garażowany, pierwszy właściciel, sprowadzany', 'ford-escort-hatchback-2000-czarna-perla-3-8', 49);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(53, 1998, 31400, 2.3, 138000, 'czerwony', 'kombi', 'G', 'cena do uzgodnienia, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'honda-accord-kombi-1998-czerwony-2-3', 50);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(54, 2003, 84200, 1.7, 252000, 'bordowy metalik', '', 'BG', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel, sprowadzany', 'rover-820-2003-bordowy-metalik-1-7', 51);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(55, 1998, 70500, 3, 176000, 'czarna perła', 'kabriolet', 'D', 'pierwszy właściciel', 'rover-416-kabriolet-1998-czarna-perla-3', 39);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(56, 2003, 72800, 2.5, 46000, 'kość słoniowa', '', '', '', 'chrysler-neon-2003-kosc-sloniowa-2-5', 45);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(57, 2003, 98500, 3.5, 94000, 'czerwony', '', 'D', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'suzuki-grand-2003-czerwony-3-5', 52);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(58, 1994, 22900, 4.1, 348000, '', 'sedan', 'G', 'pierwszy właściciel', 'rover-400-sedan-1994-4-1', 53);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(59, 2003, 70500, 3.3, 89000, 'zielony', 'kombi', 'D', 'możliwa wymiana, pierwszy właściciel', 'renault-19-kombi-2003-zielony-3-3', 54);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(60, 1999, 13500, 3.2, 261000, 'grafitowy', '', 'BG', 'garażowany, możliwa wymiana, sprowadzany', 'seat-toledo-ii-1999-grafitowy-3-2', 55);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(61, 2004, 37700, 2.8, 9000, 'grafitowy metalik', 'kabriolet', 'D', 'gotowy do rejestracji, pierwszy właściciel', 'chrysler-stratus-kabriolet-2004-grafitowy-metalik-2-8', 56);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(62, 2003, 89000, 1.1, 40000, 'granatowy metalik', '', 'G', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, sprowadzany', 'renault-espace-ii-2003-granatowy-metalik-1-1', 22);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(63, 1993, 81000, 1, 330000, 'biały', 'sedan', 'G', 'gotowy do rejestracji', 'jeep-grand-cherokee-sedan-1993-bialy-1', 57);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(64, 1991, 59700, 4.2, 158000, 'bordowy metalik', 'sedan', 'D', '', 'volksvagen-passat-sedan-1991-bordowy-metalik-4-2', 58);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(65, 1996, 49000, 1.4, 156000, 'czerwony', '', 'D', 'możliwa wymiana', 'renault-safrane-1996-czerwony-1-4', 6);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(66, 2001, 60200, 2.3, 103000, 'granatowy', '', '', 'możliwa wymiana, pierwszy właściciel, sprowadzany', 'volksvagen-golf-ii-2001-granatowy-2-3', 59);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(67, 1998, 68800, 3.7, 348000, 'czarna perła', 'sedan', 'G', 'cena do uzgodnienia, garażowany, pierwszy właściciel, sprowadzany', 'bmw-728-sedan-1998-czarna-perla-3-7', 60);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(68, 2005, 62200, 4.3, 87000, '', '', 'BG', 'garażowany', 'ford-sierra-2005-4-3', 61);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(69, 1995, 55000, 2.7, 202000, 'zielony', '', 'D', 'możliwa wymiana, sprowadzany', 'volksvagen-caddy-1995-zielony-2-7', 62);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(70, 2000, 78500, 2.5, 97000, 'bordowy', 'kombi', 'B', '', 'nissan-skyline-kombi-2000-bordowy-2-5', 63);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(71, 1996, 91000, 2.2, 19000, 'srebrny metalik', 'kabriolet', 'D', 'cena do uzgodnienia, możliwa wymiana, sprowadzany', 'bmw-735-kabriolet-1996-srebrny-metalik-2-2', 64);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(72, 2003, 44900, 3.5, 95000, 'żółty', 'kombi', 'B', 'gotowy do rejestracji, pierwszy właściciel', 'dodge-neon-kombi-2003-zolty-3-5', 65);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(73, 1996, 24500, 3.5, 284000, 'srebrny metalik', 'sedan', 'B', '', 'daihatsu-move-sedan-1996-srebrny-metalik-3-5', 66);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(74, 2003, 82400, 1.3, 235000, 'kość słoniowa', 'kabriolet', 'B', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel, sprowadzany', 'nissan-almera-kabriolet-2003-kosc-sloniowa-1-3', 67);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(75, 2000, 95900, 3.1, 116000, 'kość słoniowa', 'kombi', 'B', 'garażowany, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'daewoo-nubira-kombi-2000-kosc-sloniowa-3-1', 25);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(76, 1990, 24800, 1.9, 67000, '', 'hatchback', 'BG', 'sprowadzany', 'kia-clarus-hatchback-1990-1-9', 68);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(77, 2000, 85700, 2.2, 167000, 'czerwony metalik', 'hatchback', 'BG', 'garażowany, możliwa wymiana, sprowadzany', 'rover-820-hatchback-2000-czerwony-metalik-2-2', 51);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(78, 1992, 18400, 3.2, 11000, 'srebrny metalik', 'kombi', 'BG', '', 'toyota-rav4-kombi-1992-srebrny-metalik-3-2', 69);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(79, 1997, 76800, 2.9, 259000, 'grafitowy metalik', '', 'TD', '', 'bmw-328-1997-grafitowy-metalik-2-9', 70);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(80, 1999, 45100, 2, 328000, 'kość słoniowa', 'sedan', '', 'cena do uzgodnienia, możliwa wymiana', 'daewoo-nexia-sedan-1999-kosc-sloniowa-2', 71);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(81, 1998, 24300, 3.8, 24000, 'srebrny metalik', 'kombi', '', 'cena do uzgodnienia, pierwszy właściciel', 'mercedes-170-kombi-1998-srebrny-metalik-3-8', 72);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(82, 2001, 7700, 2, 47000, 'czarna perła', 'kombi', 'D', '', 'ford-escort-kombi-2001-czarna-perla-2', 49);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(83, 2004, 60000, 2.6, 184000, 'czerwony', 'hatchback', 'G', '', 'citroen-xsara-ii-hatchback-2004-czerwony-2-6', 73);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(84, 1990, 76600, 3.6, 20000, 'zielony metalik', 'sedan', 'B', '', 'bmw-316i-sedan-1990-zielony-metalik-3-6', 74);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(85, 1992, 44000, 3, 211000, 'bordowy metalik', 'kabriolet', 'B', '', 'bmw-325-kabriolet-1992-bordowy-metalik-3', 75);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(86, 1998, 76200, 2, 320000, 'pomarańczowy', 'hatchback', 'G', 'gotowy do rejestracji', 'chrysler-300t-hatchback-1998-pomaranczowy-2', 76);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(87, 1990, 69900, 3.8, 286000, 'grafitowy metalik', 'hatchback', 'D', 'cena do uzgodnienia, gotowy do rejestracji', 'fiat-tipo-hatchback-1990-grafitowy-metalik-3-8', 77);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(88, 1993, 63100, 1.8, 139000, 'zielony metalik', 'hatchback', 'B', 'cena do uzgodnienia, pierwszy właściciel, sprowadzany', 'honda-prelude-hatchback-1993-zielony-metalik-1-8', 16);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(89, 1999, 48200, 3.2, 343000, 'czerwony', 'sedan', 'B', 'możliwa wymiana, sprowadzany', 'renault-kangoo-sedan-1999-czerwony-3-2', 78);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(90, 1990, 25800, 2.6, 341000, 'czerwony', '', 'G', 'cena do uzgodnienia, pierwszy właściciel, sprowadzany', 'seat-leon-1990-czerwony-2-6', 79);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(91, 1998, 37300, 1.3, 75000, 'czerwony', 'kabriolet', 'TD', 'cena do uzgodnienia, możliwa wymiana', 'alfa-romeo-gtv-kabriolet-1998-czerwony-1-3', 80);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(92, 2005, 23100, 2.4, 130000, 'zielony metalik', 'kombi', 'B', 'cena do uzgodnienia, garażowany, możliwa wymiana', 'volvo-940-kombi-2005-zielony-metalik-2-4', 81);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(93, 1999, 92800, 2.9, 254000, '', 'hatchback', '', 'cena do uzgodnienia, gotowy do rejestracji, sprowadzany', 'trabant-601-hatchback-1999-2-9', 82);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(94, 1990, 57400, 2.6, 326000, 'zielony', '', '', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel, sprowadzany', 'citroen-xsara-break-1990-zielony-2-6', 83);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(95, 2000, 62300, 1.5, 22000, 'czerwony', 'kombi', '', 'możliwa wymiana, pierwszy właściciel', 'alfa-romeo-155-kombi-2000-czerwony-1-5', 84);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(96, 2001, 99000, 4.4, 239000, 'bordowy metalik', 'kabriolet', 'G', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel, sprowadzany', 'mercedes-c-180-kabriolet-2001-bordowy-metalik-4-4', 8);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(97, 1997, 97700, 3.3, 329000, 'bordowy', 'sedan', '', '', 'ford-escort-sedan-1997-bordowy-3-3', 49);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(98, 1995, 81600, 2.2, 280000, 'grafitowy metalik', 'kabriolet', 'TD', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'daewoo-matiz-kabriolet-1995-grafitowy-metalik-2-2', 85);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(99, 1997, 8000, 2.7, 253000, 'żółty', '', '', '', 'mercedes-ml-1997-zolty-2-7', 86);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(100, 1993, 76300, 1.7, 200000, 'granatowy metalik', 'sedan', 'BG', 'cena do uzgodnienia, sprowadzany', 'mercedes-210-sedan-1993-granatowy-metalik-1-7', 87);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(101, 1993, 16200, 1.7, 217000, 'czarna perła', '', 'TD', 'garażowany, gotowy do rejestracji, możliwa wymiana', 'mercedes-c-klasse-1993-czarna-perla-1-7', 88);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(102, 1993, 45000, 1.5, 171000, 'pomarańczowy', 'hatchback', 'G', '', 'daewoo-nubira-hatchback-1993-pomaranczowy-1-5', 25);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(103, 1991, 7200, 2.6, 282000, 'srebrny metalik', '', 'B', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel, sprowadzany', 'fiat-marea-1991-srebrny-metalik-2-6', 24);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(104, 1991, 47900, 1.5, 229000, 'zielony metalik', 'kabriolet', 'TD', 'cena do uzgodnienia', 'honda-vt-800-kabriolet-1991-zielony-metalik-1-5', 3);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(105, 1990, 42300, 2.3, 112000, 'grafitowy', '', 'B', 'cena do uzgodnienia, gotowy do rejestracji, pierwszy właściciel', 'mitshubishi-space-wagon-1990-grafitowy-2-3', 41);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(106, 2004, 55700, 4.3, 309000, 'czarny', 'sedan', 'BG', '', 'renault-11-sedan-2004-czarny-4-3', 89);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(107, 1998, 73900, 3, 336000, 'bordowy metalik', 'sedan', 'D', '', 'citroen-xsara-break-sedan-1998-bordowy-metalik-3', 83);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(108, 1992, 65900, 3.1, 295000, 'czerwony metalik', 'hatchback', 'BG', 'cena do uzgodnienia, sprowadzany', 'renault-laguna-hatchback-1992-czerwony-metalik-3-1', 90);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(109, 1992, 34200, 4.4, 93000, 'grafitowy metalik', 'kombi', 'B', 'garażowany, możliwa wymiana', 'bmw-320i-kombi-1992-grafitowy-metalik-4-4', 91);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(110, 2000, 80800, 2.8, 108000, 'bordowy metalik', 'kabriolet', 'G', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'fiat-stilo-kabriolet-2000-bordowy-metalik-2-8', 29);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(111, 2003, 21900, 2.7, 285000, 'kość słoniowa', 'kabriolet', 'B', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, sprowadzany', 'toyota-picnic-kabriolet-2003-kosc-sloniowa-2-7', 92);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(112, 1991, 98100, 3.9, 13000, 'grafitowy', 'kabriolet', '', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, sprowadzany', 'ford-fusion-kabriolet-1991-grafitowy-3-9', 93);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(113, 2003, 81500, 2.8, 69000, 'czerwony', 'kabriolet', '', '', 'pontiac-trans-sport-kabriolet-2003-czerwony-2-8', 94);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(114, 1997, 73100, 4.3, 197000, 'grafitowy', 'sedan', 'B', 'cena do uzgodnienia, garażowany, pierwszy właściciel', 'skoda-105-sedan-1997-grafitowy-4-3', 47);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(115, 1993, 16600, 2.8, 336000, 'czarna perła', 'sedan', 'B', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel, sprowadzany', 'peugeot-106-sedan-1993-czarna-perla-2-8', 95);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(116, 1995, 91200, 4.5, 127000, 'grafitowy metalik', 'hatchback', 'TD', 'garażowany, gotowy do rejestracji, pierwszy właściciel', 'opel-record-hatchback-1995-grafitowy-metalik-4-5', 96);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(117, 1994, 25500, 4.2, 315000, 'żółty', 'kabriolet', 'BG', 'garażowany, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'nissan-almera-kabriolet-1994-zolty-4-2', 67);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(118, 1992, 92900, 1.2, 340000, 'pomarańczowy', '', 'TD', '', 'renault-laguna-1992-pomaranczowy-1-2', 90);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(119, 1998, 29600, 2.9, 174000, 'pomarańczowy', 'sedan', 'G', 'możliwa wymiana, pierwszy właściciel, sprowadzany', 'hyundai-atos-sedan-1998-pomaranczowy-2-9', 97);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(120, 1990, 35400, 2.5, 107000, 'czarna perła', 'kombi', 'D', 'cena do uzgodnienia, pierwszy właściciel', 'daewoo-tico-kombi-1990-czarna-perla-2-5', 98);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(121, 2004, 54900, 2.1, 278000, 'bordowy metalik', 'sedan', 'TD', '', 'chrysler-le-baron-sedan-2004-bordowy-metalik-2-1', 99);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(122, 2002, 24100, 1.8, 133000, 'granatowy metalik', '', '', 'garażowany, sprowadzany', 'mitshubishi-carisma-2002-granatowy-metalik-1-8', 100);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(123, 2003, 21700, 1.6, 95000, 'bordowy', 'sedan', 'D', '', 'ford-fusion-sedan-2003-bordowy-1-6', 93);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(124, 1996, 65000, 1.4, 249000, '', 'kombi', 'TD', '', 'mercedes-170-kombi-1996-1-4', 72);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(125, 1995, 82100, 4.4, 246000, '', 'kombi', 'G', 'cena do uzgodnienia, możliwa wymiana, sprowadzany', 'volksvagen-caddy-kombi-1995-4-4', 62);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(126, 1998, 35200, 4.4, 129000, 'czerwony metalik', '', 'D', 'sprowadzany', 'citroen-xm-1998-czerwony-metalik-4-4', 101);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(127, 2000, 52000, 3, 19000, 'czarny', 'kabriolet', '', 'cena do uzgodnienia, garażowany, możliwa wymiana, pierwszy właściciel', 'fiat-tempra-kabriolet-2000-czarny-3', 102);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(128, 1992, 75700, 1.8, 71000, 'czarny', 'kombi', 'BG', 'garażowany, możliwa wymiana, pierwszy właściciel, sprowadzany', 'renault-thalia-kombi-1992-czarny-1-8', 103);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(129, 1990, 43500, 1.9, 55000, 'granatowy', '', '', 'możliwa wymiana, sprowadzany', 'mitshubishi-space-star-1990-granatowy-1-9', 104);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(130, 1992, 75300, 4.3, 159000, 'bordowy metalik', 'kabriolet', 'BG', 'cena do uzgodnienia, możliwa wymiana, sprowadzany', 'ford-escort-kabriolet-1992-bordowy-metalik-4-3', 49);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(131, 1998, 65800, 2.4, 127000, 'żółty', 'kabriolet', 'BG', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'toyota-celica-kabriolet-1998-zolty-2-4', 105);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(132, 2002, 45100, 2.2, 339000, 'granatowy metalik', '', 'G', 'garażowany, możliwa wymiana', 'bmw-518-2002-granatowy-metalik-2-2', 106);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(133, 1993, 45300, 2.6, 290000, 'bordowy metalik', 'kombi', 'D', 'garażowany, pierwszy właściciel', 'ford-taurus-kombi-1993-bordowy-metalik-2-6', 107);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(134, 2004, 80500, 4.4, 82000, 'zielony', 'kombi', 'D', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'audi-c4-kombi-2004-zielony-4-4', 108);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(135, 2000, 49300, 4, 313000, 'kość słoniowa', 'hatchback', 'B', 'sprowadzany', 'mercedes-200-hatchback-2000-kosc-sloniowa-4', 109);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(136, 1994, 11600, 1.1, 304000, '', 'kabriolet', '', 'garażowany, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'volksvagen-bora-kabriolet-1994-1-1', 110);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(137, 2005, 11500, 3.2, 337000, 'czarna perła', 'sedan', 'G', '', 'renault-clio-sedan-2005-czarna-perla-3-2', 111);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(138, 2003, 14500, 1.9, 26000, 'biały', 'hatchback', 'BG', '', 'chrysler-le-baron-hatchback-2003-bialy-1-9', 99);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(139, 1995, 22700, 3, 158000, 'grafitowy', 'kombi', 'BG', '', 'daewoo-nexia-kombi-1995-grafitowy-3', 71);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(140, 1993, 65300, 2.2, 14000, 'biały', 'kabriolet', 'BG', 'cena do uzgodnienia, garażowany, pierwszy właściciel', 'rover-623-kabriolet-1993-bialy-2-2', 112);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(141, 1991, 78300, 4.3, 217000, 'zielony', 'sedan', 'B', 'cena do uzgodnienia', 'mercedes-124-sedan-1991-zielony-4-3', 113);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(142, 1990, 25400, 4, 168000, 'czarna perła', '', '', 'cena do uzgodnienia, gotowy do rejestracji, sprowadzany', 'jeep-grand-cherokee-1990-czarna-perla-4', 57);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(143, 1990, 43400, 1.9, 261000, '', 'sedan', 'D', 'gotowy do rejestracji, pierwszy właściciel', 'fiat-croma-sedan-1990-1-9', 114);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(144, 2002, 94500, 3.8, 120000, 'żółty', 'sedan', 'TD', 'garażowany, pierwszy właściciel, sprowadzany', 'citroen-xsara-ii-sedan-2002-zolty-3-8', 73);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(145, 1995, 49800, 2.3, 24000, '', 'sedan', 'BG', 'garażowany, pierwszy właściciel, sprowadzany', 'fiat-bravo-sedan-1995-2-3', 115);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(146, 1994, 74500, 3.6, 58000, 'srebrny metalik', 'kombi', '', 'garażowany, gotowy do rejestracji', 'nissan-100-kombi-1994-srebrny-metalik-3-6', 116);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(147, 2000, 76000, 1, 239000, 'czarna perła', 'kabriolet', 'G', 'cena do uzgodnienia', 'ford-puma-kabriolet-2000-czarna-perla-1', 117);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(148, 1997, 62400, 3.6, 21000, 'czarny', 'sedan', 'D', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'renault-scenic-sedan-1997-czarny-3-6', 118);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(149, 1999, 76400, 4.4, 330000, 'zielony metalik', 'kabriolet', 'B', 'cena do uzgodnienia, garażowany, pierwszy właściciel, sprowadzany', 'renault-laguna-kabriolet-1999-zielony-metalik-4-4', 90);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(150, 1999, 66000, 1.2, 138000, 'czarny', 'sedan', 'TD', 'garażowany', 'mercedes-200-sedan-1999-czarny-1-2', 109);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(151, 2001, 17900, 4, 256000, 'granatowy', 'kabriolet', 'G', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'renault-21-kabriolet-2001-granatowy-4', 119);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(152, 2004, 67000, 2.4, 325000, 'czarny', 'kombi', '', 'garażowany, gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'seat-alhambra-kombi-2004-czarny-2-4', 120);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(153, 1992, 61100, 2.6, 111000, 'grafitowy metalik', 'kombi', 'TD', 'cena do uzgodnienia, garażowany', 'mitshubishi-lancer-kombi-1992-grafitowy-metalik-2-6', 121);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(154, 1999, 8300, 1.6, 301000, 'bordowy', '', 'B', 'gotowy do rejestracji', 'mercedes-270-1999-bordowy-1-6', 122);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(155, 1999, 50600, 1, 201000, 'granatowy', '', 'BG', 'garażowany, gotowy do rejestracji, sprowadzany', 'volvo-v70-1999-granatowy-1', 123);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(156, 1999, 41400, 2.2, 212000, 'grafitowy metalik', 'hatchback', 'BG', 'możliwa wymiana, pierwszy właściciel', 'renault-espace-hatchback-1999-grafitowy-metalik-2-2', 124);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(157, 1990, 35100, 3.9, 69000, 'czerwony metalik', 'hatchback', 'BG', 'cena do uzgodnienia, garażowany', 'chevrolet-camaro-hatchback-1990-czerwony-metalik-3-9', 125);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(158, 1997, 90900, 2.4, 334000, 'bordowy metalik', 'sedan', 'TD', '', 'nissan-sunny-sedan-1997-bordowy-metalik-2-4', 126);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(159, 1994, 75300, 3.3, 349000, 'biały', 'kabriolet', 'BG', 'gotowy do rejestracji, możliwa wymiana, sprowadzany', 'chevrolet-evanda-kabriolet-1994-bialy-3-3', 127);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(160, 1991, 41600, 3.9, 325000, 'żółty', 'kabriolet', 'TD', 'sprowadzany', 'bmw-320i-kabriolet-1991-zolty-3-9', 91);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(161, 1990, 41200, 1.5, 44000, 'czerwony', 'kabriolet', 'BG', '', 'suzuki-swift-kabriolet-1990-czerwony-1-5', 128);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(162, 1993, 62600, 3.2, 173000, 'granatowy metalik', 'kombi', '', '', 'peugeot-605-kombi-1993-granatowy-metalik-3-2', 129);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(163, 2003, 46000, 3.1, 245000, 'pomarańczowy', 'kabriolet', 'BG', 'możliwa wymiana', 'volvo-740-kabriolet-2003-pomaranczowy-3-1', 130);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(164, 2003, 32900, 3.3, 319000, 'czerwony metalik', 'kabriolet', 'G', 'cena do uzgodnienia, garażowany, sprowadzany', 'chrysler-town-country-kabriolet-2003-czerwony-metalik-3-3', 131);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(165, 1995, 89300, 1.6, 28000, 'czerwony metalik', 'sedan', 'B', 'garażowany, możliwa wymiana', 'honda-crv-sedan-1995-czerwony-metalik-1-6', 132);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(166, 2005, 82200, 3.9, 154000, 'czerwony', 'sedan', 'B', 'cena do uzgodnienia, gotowy do rejestracji', 'rover-45-sedan-2005-czerwony-3-9', 36);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(167, 2005, 55400, 4.5, 11000, 'zielony metalik', '', 'D', '', 'opel-ascona-2005-zielony-metalik-4-5', 5);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(168, 1995, 54700, 2.8, 344000, 'kość słoniowa', 'kabriolet', 'D', 'garażowany', 'renault-thalia-kabriolet-1995-kosc-sloniowa-2-8', 103);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(169, 2001, 33400, 1.8, 41000, 'czerwony metalik', 'kombi', 'G', 'garażowany, pierwszy właściciel, sprowadzany', 'rover-400-kombi-2001-czerwony-metalik-1-8', 53);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(170, 1997, 16000, 2.1, 65000, 'czerwony', 'kombi', 'B', 'cena do uzgodnienia, pierwszy właściciel', 'nissan-100-kombi-1997-czerwony-2-1', 116);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(171, 1997, 91600, 4.5, 229000, 'bordowy', 'hatchback', 'G', 'możliwa wymiana, sprowadzany', 'toyota-camry-hatchback-1997-bordowy-4-5', 133);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(172, 1996, 70600, 2.8, 203000, 'czerwony metalik', 'kombi', 'BG', 'cena do uzgodnienia, sprowadzany', 'fiat-seicento-kombi-1996-czerwony-metalik-2-8', 134);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(173, 2001, 74400, 2.9, 232000, 'pomarańczowy', '', '', 'cena do uzgodnienia, garażowany, gotowy do rejestracji', 'renault-clio-2001-pomaranczowy-2-9', 111);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(174, 2005, 70300, 1.2, 296000, 'biały', 'hatchback', 'D', 'cena do uzgodnienia, garażowany', 'peugeot-205-hatchback-2005-bialy-1-2', 135);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(175, 2002, 26700, 4.4, 181000, 'bordowy metalik', 'hatchback', '', 'możliwa wymiana', 'ford-probe-hatchback-2002-bordowy-metalik-4-4', 1);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(176, 1993, 47800, 2.9, 230000, 'kość słoniowa', 'sedan', 'B', 'cena do uzgodnienia, sprowadzany', 'opel-record-sedan-1993-kosc-sloniowa-2-9', 96);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(177, 2004, 17200, 2.1, 30000, 'czerwony metalik', 'hatchback', 'D', 'garażowany, możliwa wymiana, pierwszy właściciel', 'fiat-panda-hatchback-2004-czerwony-metalik-2-1', 136);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(178, 1993, 57100, 1.7, 12000, 'czarna perła', 'kombi', 'G', 'gotowy do rejestracji, możliwa wymiana', 'citroen-xsara-picasso-kombi-1993-czarna-perla-1-7', 44);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(179, 1992, 53600, 1.8, 58000, 'pomarańczowy', 'hatchback', 'BG', 'pierwszy właściciel', 'mercedes-210-hatchback-1992-pomaranczowy-1-8', 87);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(180, 2005, 8600, 3.1, 305000, 'bordowy', 'hatchback', 'G', 'garażowany, gotowy do rejestracji, pierwszy właściciel', 'bmw-320i-hatchback-2005-bordowy-3-1', 91);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(181, 2003, 21700, 2.7, 14000, 'pomarańczowy', 'sedan', 'B', 'garażowany, możliwa wymiana, pierwszy właściciel, sprowadzany', 'fiat-uno-sedan-2003-pomaranczowy-2-7', 137);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(182, 2000, 98900, 4.3, 201000, 'czerwony', '', 'B', 'gotowy do rejestracji, sprowadzany', 'chrysler-town-country-2000-czerwony-4-3', 131);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(183, 2003, 24700, 1.6, 262000, 'pomarańczowy', 'kabriolet', '', 'możliwa wymiana, pierwszy właściciel, sprowadzany', 'fiat-panda-kabriolet-2003-pomaranczowy-1-6', 136);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(184, 2003, 59800, 3.8, 174000, 'grafitowy', 'kabriolet', 'D', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'nissan-primera-kabriolet-2003-grafitowy-3-8', 138);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(185, 2003, 32300, 1.1, 217000, 'bordowy metalik', 'sedan', '', 'garażowany, gotowy do rejestracji, pierwszy właściciel', 'citroen-ax-sedan-2003-bordowy-metalik-1-1', 139);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(186, 1994, 47100, 3.2, 74000, 'czarna perła', '', 'BG', 'sprowadzany', 'honda-crx-1994-czarna-perla-3-2', 140);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(187, 1993, 92400, 2.7, 141000, 'czarna perła', 'hatchback', '', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana', 'seat-arosa-hatchback-1993-czarna-perla-2-7', 141);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(188, 2005, 36100, 2.2, 56000, 'czerwony', 'kombi', 'G', 'cena do uzgodnienia, sprowadzany', 'rover-414-kombi-2005-czerwony-2-2', 142);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(189, 1991, 73500, 1.3, 87000, 'kość słoniowa', '', 'D', 'gotowy do rejestracji, sprowadzany', 'mitshubishi-space-star-1991-kosc-sloniowa-1-3', 104);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(190, 2002, 86300, 3.3, 117000, '', '', 'B', 'gotowy do rejestracji, sprowadzany', 'nissan-silvia-2002-3-3', 143);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(191, 2000, 56000, 3.9, 254000, 'grafitowy', 'hatchback', 'BG', 'cena do uzgodnienia, możliwa wymiana', 'volksvagen-vento-hatchback-2000-grafitowy-3-9', 144);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(192, 1994, 63700, 1.7, 268000, 'grafitowy metalik', '', 'B', 'pierwszy właściciel', 'chrysler-neon-1994-grafitowy-metalik-1-7', 45);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(193, 2004, 77300, 3.3, 274000, 'granatowy metalik', 'kabriolet', 'G', 'możliwa wymiana, sprowadzany', 'daewoo-tico-kabriolet-2004-granatowy-metalik-3-3', 98);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(194, 1998, 34400, 2.3, 304000, 'srebrny metalik', 'sedan', 'BG', '', 'ford-expedition-sedan-1998-srebrny-metalik-2-3', 145);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(195, 2004, 91000, 2.8, 149000, 'kość słoniowa', 'kabriolet', 'G', 'cena do uzgodnienia, gotowy do rejestracji', 'nissan-serena-kabriolet-2004-kosc-sloniowa-2-8', 146);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(196, 2002, 94700, 1.3, 103000, 'biały', 'kombi', 'G', 'garażowany, pierwszy właściciel', 'bmw-316i-kombi-2002-bialy-1-3', 74);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(197, 2000, 61800, 1.7, 137000, 'pomarańczowy', 'kabriolet', 'B', 'garażowany, pierwszy właściciel', 'ford-escort-kabriolet-2000-pomaranczowy-1-7', 49);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(198, 2002, 86200, 3.3, 324000, 'żółty', 'sedan', 'TD', 'cena do uzgodnienia, sprowadzany', 'fiat-uno-sedan-2002-zolty-3-3', 137);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(199, 1998, 54500, 3.1, 83000, 'żółty', 'sedan', 'BG', '', 'audi-a3-sedan-1998-zolty-3-1', 2);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(200, 2002, 87700, 2.7, 222000, 'bordowy metalik', 'hatchback', 'B', 'możliwa wymiana, sprowadzany', 'hyundai-lantra-hatchback-2002-bordowy-metalik-2-7', 147);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(201, 1996, 96200, 2.7, 61000, 'czarna perła', 'kabriolet', 'B', 'garażowany, gotowy do rejestracji, możliwa wymiana', 'mazda-121-kabriolet-1996-czarna-perla-2-7', 148);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(202, 1992, 9400, 4.2, 320000, 'bordowy', 'sedan', '', 'cena do uzgodnienia, pierwszy właściciel', 'renault-espace-iii-sedan-1992-bordowy-4-2', 149);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(203, 1991, 59600, 4.2, 22000, 'zielony metalik', 'hatchback', '', 'garażowany, pierwszy właściciel, sprowadzany', 'opel-record-hatchback-1991-zielony-metalik-4-2', 96);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(204, 1991, 35400, 3.8, 269000, 'pomarańczowy', 'kombi', 'B', 'garażowany, możliwa wymiana, sprowadzany', 'fiat-palio-kombi-1991-pomaranczowy-3-8', 150);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(205, 1999, 63900, 4.4, 191000, 'czerwony', 'hatchback', 'D', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'peugeot-306-hatchback-1999-czerwony-4-4', 151);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(206, 2004, 46400, 3, 238000, 'grafitowy', 'kabriolet', 'G', 'cena do uzgodnienia, garażowany, możliwa wymiana, pierwszy właściciel', 'jeep-grand-cherokee-kabriolet-2004-grafitowy-3', 57);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(207, 2004, 50300, 1.6, 23000, 'czerwony', 'kabriolet', '', 'cena do uzgodnienia', 'mercedes-e-klasse-kabriolet-2004-czerwony-1-6', 28);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(208, 1990, 46900, 4.2, 52000, 'czerwony', 'kombi', 'B', '', 'volksvagen-golf-kombi-1990-czerwony-4-2', 152);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(209, 2005, 87800, 2.9, 27000, 'pomarańczowy', 'sedan', 'D', 'sprowadzany', 'mitshubishi-pajero-long-sedan-2005-pomaranczowy-2-9', 30);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(210, 1999, 79000, 3.4, 36000, 'kość słoniowa', 'sedan', '', '', 'mitshubishi-lancer-sedan-1999-kosc-sloniowa-3-4', 121);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(211, 2003, 59100, 4.1, 18000, 'żółty', 'kombi', 'TD', 'garażowany, gotowy do rejestracji', 'ford-fusion-kombi-2003-zolty-4-1', 93);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(212, 2004, 69700, 3.8, 113000, 'czarny', '', 'BG', 'cena do uzgodnienia, sprowadzany', 'opel-tigra-2004-czarny-3-8', 153);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(213, 2004, 52900, 4.2, 71000, 'srebrny metalik', 'sedan', 'G', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'ford-ka-sedan-2004-srebrny-metalik-4-2', 154);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(214, 1995, 38300, 4.3, 78000, 'biały', 'hatchback', 'TD', 'garażowany, sprowadzany', 'nissan-240-sx-hatchback-1995-bialy-4-3', 31);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(215, 1990, 12400, 4.1, 36000, 'czerwony metalik', 'kombi', 'G', 'cena do uzgodnienia, gotowy do rejestracji, pierwszy właściciel', 'toyota-rav4-kombi-1990-czerwony-metalik-4-1', 69);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(216, 1996, 65800, 1, 198000, 'srebrny metalik', 'kabriolet', 'G', 'garażowany', 'bmw-320-kabriolet-1996-srebrny-metalik-1', 155);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(217, 1992, 94200, 4.3, 77000, 'pomarańczowy', 'kabriolet', 'G', 'gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'audi-b4-kabriolet-1992-pomaranczowy-4-3', 156);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(218, 1994, 11000, 1.4, 283000, 'czerwony', 'sedan', 'TD', 'gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'volksvagen-vento-sedan-1994-czerwony-1-4', 144);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(219, 2000, 49500, 4, 242000, 'srebrny metalik', 'kabriolet', 'B', 'pierwszy właściciel', 'bmw-520-kabriolet-2000-srebrny-metalik-4', 157);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(220, 1995, 51400, 1.7, 58000, 'czarna perła', 'sedan', 'D', 'garażowany', 'opel-vectra-sedan-1995-czarna-perla-1-7', 158);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(221, 2004, 35800, 3.5, 117000, 'kość słoniowa', 'kombi', 'BG', 'gotowy do rejestracji', 'nissan-primera-kombi-2004-kosc-sloniowa-3-5', 138);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(222, 2001, 24400, 2.8, 350000, 'zielony', 'hatchback', 'D', '', 'nissan-terrano-hatchback-2001-zielony-2-8', 7);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(223, 1991, 93900, 3.1, 191000, 'zielony', 'kombi', 'TD', '', 'bmw-735-kombi-1991-zielony-3-1', 64);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(224, 2001, 7800, 1.9, 183000, '', 'hatchback', '', 'cena do uzgodnienia, garażowany, pierwszy właściciel, sprowadzany', 'nissan-terrano-hatchback-2001-1-9', 7);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(225, 1996, 47200, 2.1, 57000, 'czerwony', 'kabriolet', 'G', 'garażowany, gotowy do rejestracji, możliwa wymiana', 'mazda-xedos-kabriolet-1996-czerwony-2-1', 159);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(226, 2005, 42600, 2.1, 68000, 'granatowy', 'sedan', '', 'gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'opel-tigra-sedan-2005-granatowy-2-1', 153);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(227, 2000, 29100, 2.2, 344000, 'czarna perła', 'kombi', 'D', 'cena do uzgodnienia, garażowany', 'daihatsu-charade-kombi-2000-czarna-perla-2-2', 160);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(228, 1999, 11500, 2.8, 109000, 'zielony metalik', '', 'TD', 'możliwa wymiana, pierwszy właściciel, sprowadzany', 'fiat-tempra-1999-zielony-metalik-2-8', 102);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(229, 1998, 86500, 2.9, 269000, 'zielony metalik', 'hatchback', 'TD', 'sprowadzany', 'mitshubishi-galant-hatchback-1998-zielony-metalik-2-9', 161);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(230, 1996, 8100, 1.4, 19000, 'czerwony', 'kombi', 'BG', 'garażowany, pierwszy właściciel', 'bmw-325-kombi-1996-czerwony-1-4', 75);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(231, 1996, 44900, 4.2, 128000, 'grafitowy metalik', 'kombi', 'TD', 'cena do uzgodnienia, możliwa wymiana, sprowadzany', 'saab-900-kombi-1996-grafitowy-metalik-4-2', 162);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(232, 1997, 18400, 2.4, 212000, 'bordowy', 'kombi', 'B', '', 'mitshubishi-pajero-kombi-1997-bordowy-2-4', 163);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(233, 2000, 17600, 4.1, 56000, 'bordowy', 'kabriolet', 'G', 'cena do uzgodnienia, garażowany, pierwszy właściciel, sprowadzany', 'mitshubishi-lancer-kabriolet-2000-bordowy-4-1', 121);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(234, 1991, 6900, 3.9, 244000, 'granatowy', 'kabriolet', '', '', 'citroen-ax-kabriolet-1991-granatowy-3-9', 139);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(235, 1996, 94700, 4.4, 81000, 'bordowy', 'kombi', 'B', 'garażowany, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'ford-mondeo-kombi-1996-bordowy-4-4', 17);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(236, 1996, 88400, 4.4, 231000, 'srebrny metalik', 'kombi', 'BG', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'fiat-croma-kombi-1996-srebrny-metalik-4-4', 114);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(237, 2004, 10200, 1.2, 177000, 'grafitowy', 'hatchback', 'B', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'hyundai-atos-hatchback-2004-grafitowy-1-2', 97);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(238, 1992, 43400, 4.5, 109000, 'granatowy', 'hatchback', 'D', 'garażowany, pierwszy właściciel, sprowadzany', 'bmw-520-hatchback-1992-granatowy-4-5', 157);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(239, 1997, 67800, 1.6, 253000, 'czarny', 'kabriolet', 'TD', 'gotowy do rejestracji', 'opel-zafira-kabriolet-1997-czarny-1-6', 23);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(240, 2002, 38300, 2.4, 263000, '', 'sedan', 'B', 'cena do uzgodnienia, garażowany, sprowadzany', 'ford-fusion-sedan-2002-2-4', 93);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(241, 2001, 72100, 2.6, 221000, 'bordowy metalik', 'kabriolet', 'BG', 'cena do uzgodnienia, pierwszy właściciel, sprowadzany', 'audi-a6-kabriolet-2001-bordowy-metalik-2-6', 164);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(242, 1998, 76800, 4.2, 80000, 'zielony metalik', 'kabriolet', 'D', 'garażowany, pierwszy właściciel', 'chevrolet-corsica-kabriolet-1998-zielony-metalik-4-2', 165);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(243, 1992, 21300, 4.5, 303000, 'kość słoniowa', 'hatchback', '', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'mitshubishi-carisma-hatchback-1992-kosc-sloniowa-4-5', 100);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(244, 1992, 9900, 2.8, 286000, 'kość słoniowa', '', 'BG', '', 'kia-clarus-1992-kosc-sloniowa-2-8', 68);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(245, 2003, 64600, 2, 179000, 'granatowy metalik', 'kombi', 'G', 'gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'seat-toledo-kombi-2003-granatowy-metalik-2', 166);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(246, 1998, 66200, 2.2, 219000, 'czarna perła', 'kabriolet', 'TD', 'cena do uzgodnienia', 'fiat-cinquecento-kabriolet-1998-czarna-perla-2-2', 46);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(247, 1994, 20800, 1.2, 320000, 'zielony metalik', 'hatchback', 'BG', 'cena do uzgodnienia, garażowany, możliwa wymiana, pierwszy właściciel, sprowadzany', 'volksvagen-lupo-hatchback-1994-zielony-metalik-1-2', 167);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(248, 1992, 54900, 2.5, 55000, 'czerwony metalik', 'sedan', 'B', 'garażowany, możliwa wymiana, pierwszy właściciel', 'rover-218-sedan-1992-czerwony-metalik-2-5', 168);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(249, 1992, 37100, 3.3, 206000, 'granatowy metalik', 'hatchback', 'D', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, możliwa wymiana', 'renault-safrane-hatchback-1992-granatowy-metalik-3-3', 6);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(250, 2003, 56400, 4, 122000, 'biały', 'kombi', 'B', 'cena do uzgodnienia, gotowy do rejestracji, sprowadzany', 'volvo-850-kombi-2003-bialy-4', 169);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(251, 1998, 9200, 1.1, 277000, 'grafitowy metalik', 'kabriolet', 'B', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'mitshubishi-space-wagon-kabriolet-1998-grafitowy-metalik-1-1', 41);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(252, 1993, 37700, 3.1, 128000, 'granatowy', 'kabriolet', '', 'garażowany, gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'rover-414-kabriolet-1993-granatowy-3-1', 142);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(253, 1993, 28500, 3, 112000, 'grafitowy metalik', '', 'D', 'możliwa wymiana, pierwszy właściciel, sprowadzany', 'rover-214-1993-grafitowy-metalik-3', 170);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(254, 1995, 27400, 1.2, 28000, 'czerwony metalik', 'kombi', 'B', 'możliwa wymiana, sprowadzany', 'citroen-c15-kombi-1995-czerwony-metalik-1-2', 171);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(255, 1990, 44400, 2.7, 194000, 'czerwony', 'kabriolet', 'G', 'pierwszy właściciel, sprowadzany', 'peugeot-306-kabriolet-1990-czerwony-2-7', 151);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(256, 2001, 9400, 1.3, 217000, 'czarna perła', 'hatchback', '', 'garażowany, gotowy do rejestracji, możliwa wymiana', 'alfa-romeo-164-hatchback-2001-czarna-perla-1-3', 172);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(257, 1992, 59100, 3.3, 83000, 'granatowy', 'kabriolet', '', 'garażowany, możliwa wymiana, pierwszy właściciel, sprowadzany', 'pontiac-firo-kabriolet-1992-granatowy-3-3', 4);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(258, 1995, 39700, 1.3, 346000, 'zielony', 'kombi', 'D', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel, sprowadzany', 'kia-sorento-kombi-1995-zielony-1-3', 173);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(259, 1994, 87400, 3.5, 190000, 'bordowy metalik', '', 'B', 'cena do uzgodnienia, gotowy do rejestracji', 'bmw-530-1994-bordowy-metalik-3-5', 174);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(260, 2000, 62100, 2.8, 255000, 'bordowy metalik', '', 'TD', '', 'lada-niva-2000-bordowy-metalik-2-8', 175);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(261, 1994, 11400, 3.6, 114000, 'grafitowy metalik', 'sedan', 'BG', 'pierwszy właściciel', 'ford-scorpio-sedan-1994-grafitowy-metalik-3-6', 176);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(262, 2000, 35700, 2, 285000, 'żółty', 'kabriolet', 'G', 'sprowadzany', 'peugeot-605-kabriolet-2000-zolty-2', 129);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(263, 1992, 51000, 2.8, 10000, 'granatowy metalik', '', 'D', 'cena do uzgodnienia, sprowadzany', 'peugeot-406-1992-granatowy-metalik-2-8', 177);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(264, 1999, 15700, 1.1, 191000, 'czerwony', 'hatchback', 'TD', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'mercedes-270-hatchback-1999-czerwony-1-1', 122);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(265, 1991, 16600, 3.8, 146000, 'biały', 'sedan', 'B', '', 'subaru-legacy-sedan-1991-bialy-3-8', 178);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(266, 1999, 99400, 1.6, 140000, 'zielony', 'kombi', 'B', 'garażowany, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'bmw-530-kombi-1999-zielony-1-6', 174);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(267, 1993, 92000, 2.8, 283000, 'grafitowy metalik', 'hatchback', 'B', '', 'opel-tigra-hatchback-1993-grafitowy-metalik-2-8', 153);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(268, 1994, 60600, 4.1, 47000, 'grafitowy metalik', 'kabriolet', 'D', '', 'volksvagen-country-kabriolet-1994-grafitowy-metalik-4-1', 179);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(269, 1995, 11300, 1.3, 348000, 'granatowy metalik', 'kombi', 'B', 'cena do uzgodnienia, garażowany, możliwa wymiana', 'seat-arosa-kombi-1995-granatowy-metalik-1-3', 141);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(270, 1995, 37300, 3.5, 146000, 'czarny', 'kabriolet', 'BG', '', 'citroen-saxo-kabriolet-1995-czarny-3-5', 180);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(271, 2001, 84500, 3.9, 45000, 'grafitowy metalik', 'hatchback', 'BG', 'cena do uzgodnienia, garażowany, sprowadzany', 'skoda-felicia-hatchback-2001-grafitowy-metalik-3-9', 181);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(272, 1995, 75800, 3.2, 136000, 'srebrny metalik', 'hatchback', 'BG', 'cena do uzgodnienia, garażowany, pierwszy właściciel, sprowadzany', 'suzuki-swift-hatchback-1995-srebrny-metalik-3-2', 128);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(273, 2001, 24800, 3.8, 126000, 'czerwony metalik', 'hatchback', 'B', '', 'renault-thalia-hatchback-2001-czerwony-metalik-3-8', 103);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(274, 2003, 95700, 2.2, 144000, 'grafitowy metalik', 'sedan', 'G', 'garażowany, możliwa wymiana', 'daewoo-polonez-sedan-2003-grafitowy-metalik-2-2', 182);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(275, 2005, 46400, 3.1, 347000, 'czarna perła', 'kabriolet', 'D', 'cena do uzgodnienia, garażowany, możliwa wymiana', 'citroen-zx-kabriolet-2005-czarna-perla-3-1', 183);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(276, 1997, 54800, 1.7, 121000, 'grafitowy', 'hatchback', 'D', 'garażowany, możliwa wymiana', 'chrysler-neon-hatchback-1997-grafitowy-1-7', 45);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(277, 1996, 8200, 1.4, 154000, 'granatowy metalik', 'hatchback', 'G', 'garażowany, gotowy do rejestracji, możliwa wymiana', 'ford-sierra-hatchback-1996-granatowy-metalik-1-4', 61);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(278, 1998, 11800, 2.6, 64000, 'grafitowy metalik', 'sedan', 'D', 'możliwa wymiana, pierwszy właściciel', 'hyundai-accent-sedan-1998-grafitowy-metalik-2-6', 184);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(279, 2000, 24700, 1.4, 45000, 'czarna perła', 'kombi', 'TD', '', 'renault-espace-kombi-2000-czarna-perla-1-4', 124);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(280, 1994, 33800, 1.1, 111000, 'żółty', 'kabriolet', 'D', 'garażowany, sprowadzany', 'lada-2107-kabriolet-1994-zolty-1-1', 185);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(281, 1993, 11900, 3.3, 341000, 'zielony', '', 'B', '', 'audi-b3-1993-zielony-3-3', 186);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(282, 2003, 23100, 3.4, 282000, 'czarny', 'kombi', '', 'możliwa wymiana, pierwszy właściciel', 'citroen-bx-kombi-2003-czarny-3-4', 187);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(283, 2005, 84500, 1.8, 83000, 'bordowy', 'hatchback', 'D', 'cena do uzgodnienia, garażowany, możliwa wymiana, sprowadzany', 'lada-niva-hatchback-2005-bordowy-1-8', 175);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(284, 1992, 7300, 2.6, 319000, 'czerwony', 'kombi', 'G', 'gotowy do rejestracji', 'opel-omega-kombi-1992-czerwony-2-6', 188);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(285, 1993, 90100, 2.3, 130000, 'zielony metalik', 'sedan', 'BG', 'cena do uzgodnienia, garażowany', 'chrysler-300m-sedan-1993-zielony-metalik-2-3', 189);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(286, 2002, 72400, 3.8, 106000, 'granatowy', '', 'TD', 'cena do uzgodnienia, pierwszy właściciel, sprowadzany', 'volvo-340-2002-granatowy-3-8', 190);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(287, 1993, 38300, 1.7, 230000, 'bordowy metalik', 'sedan', 'TD', 'cena do uzgodnienia, gotowy do rejestracji, sprowadzany', 'rover-218-sedan-1993-bordowy-metalik-1-7', 168);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(288, 2004, 90600, 4.2, 319000, 'czarny', '', 'B', 'garażowany', 'citroen-xsara-2004-czarny-4-2', 191);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(289, 2005, 97800, 3.9, 46000, 'srebrny metalik', 'kombi', 'BG', '', 'honda-hrv-kombi-2005-srebrny-metalik-3-9', 192);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(290, 1990, 78500, 2.9, 119000, 'biały', 'kombi', 'G', '', 'fiat-ulysse-kombi-1990-bialy-2-9', 193);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(291, 1997, 71700, 1.3, 92000, 'biały', 'kombi', '', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'audi-b4-kombi-1997-bialy-1-3', 156);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(292, 2001, 12500, 2.5, 231000, 'pomarańczowy', 'hatchback', 'B', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel, sprowadzany', 'mercedes-170-hatchback-2001-pomaranczowy-2-5', 72);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(293, 2002, 52700, 1.7, 158000, '', 'kabriolet', 'BG', 'możliwa wymiana, sprowadzany', 'opel-zafira-kabriolet-2002-1-7', 23);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(294, 2004, 44600, 3.7, 275000, 'srebrny metalik', 'sedan', 'G', '', 'lancia-thema-sedan-2004-srebrny-metalik-3-7', 194);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(295, 1995, 39100, 3.9, 163000, 'czerwony', 'sedan', 'D', 'cena do uzgodnienia, możliwa wymiana', 'jeep-cherokee-sedan-1995-czerwony-3-9', 195);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(296, 1999, 7400, 1.9, 80000, 'czerwony', 'hatchback', 'G', 'garażowany, sprowadzany', 'honda-accord-hatchback-1999-czerwony-1-9', 50);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(297, 2001, 95700, 4.4, 214000, 'pomarańczowy', 'sedan', 'D', 'sprowadzany', 'hyundai-atos-sedan-2001-pomaranczowy-4-4', 97);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(298, 1999, 44700, 4.5, 210000, 'grafitowy', '', 'D', 'gotowy do rejestracji, możliwa wymiana', 'bmw-520i-1999-grafitowy-4-5', 196);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(299, 1997, 84300, 1.3, 24000, 'bordowy metalik', 'kabriolet', 'B', 'cena do uzgodnienia, gotowy do rejestracji', 'honda-hrv-kabriolet-1997-bordowy-metalik-1-3', 192);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(300, 2005, 85700, 2.5, 80000, '', 'sedan', 'BG', '', 'renault-kangoo-sedan-2005-2-5', 78);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(301, 1994, 59300, 3.4, 257000, 'biały', 'sedan', 'B', 'garażowany, możliwa wymiana, sprowadzany', 'ford-scorpio-sedan-1994-bialy-3-4', 176);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(302, 1999, 61000, 3.1, 339000, 'grafitowy metalik', 'kabriolet', 'G', 'garażowany', 'volvo-740-kabriolet-1999-grafitowy-metalik-3-1', 130);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(303, 1996, 57200, 1.9, 158000, 'kość słoniowa', 'hatchback', '', 'garażowany, gotowy do rejestracji, pierwszy właściciel', 'ford-mondeo-hatchback-1996-kosc-sloniowa-1-9', 17);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(304, 2002, 64800, 3, 260000, 'grafitowy metalik', '', 'G', '', 'nissan-terrano-2002-grafitowy-metalik-3', 7);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(305, 2001, 62600, 3.8, 303000, 'czarna perła', 'kabriolet', 'BG', '', 'citroen-saxo-kabriolet-2001-czarna-perla-3-8', 180);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(306, 1999, 46900, 2.4, 346000, 'bordowy metalik', 'hatchback', 'B', 'cena do uzgodnienia, możliwa wymiana', 'lada-samara-hatchback-1999-bordowy-metalik-2-4', 197);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(307, 1991, 72600, 4.1, 290000, '', 'hatchback', 'TD', 'cena do uzgodnienia', 'lada-niva-hatchback-1991-4-1', 175);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(308, 1996, 22000, 4.5, 30000, 'kość słoniowa', 'kombi', 'TD', 'garażowany, sprowadzany', 'renault-clio-kombi-1996-kosc-sloniowa-4-5', 111);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(309, 2001, 87900, 1.4, 124000, 'żółty', 'kabriolet', '', 'gotowy do rejestracji, możliwa wymiana, sprowadzany', 'daewoo-tico-kabriolet-2001-zolty-1-4', 98);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(310, 2002, 22000, 2.6, 312000, 'czarna perła', 'hatchback', '', 'cena do uzgodnienia, gotowy do rejestracji, sprowadzany', 'hyundai-galloper-hatchback-2002-czarna-perla-2-6', 198);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(311, 1998, 85600, 3.2, 184000, 'granatowy metalik', 'kombi', 'G', 'garażowany, możliwa wymiana, sprowadzany', 'renault-19-kombi-1998-granatowy-metalik-3-2', 54);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(312, 1999, 98200, 3.3, 18000, 'biały', 'kombi', 'B', 'cena do uzgodnienia, garażowany', 'chrysler-neon-kombi-1999-bialy-3-3', 45);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(313, 2002, 89000, 3.4, 13000, 'granatowy metalik', '', 'TD', 'cena do uzgodnienia, garażowany, możliwa wymiana, pierwszy właściciel', 'volvo-s40-2002-granatowy-metalik-3-4', 199);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(314, 1991, 9000, 1.9, 245000, 'grafitowy metalik', 'hatchback', 'B', 'możliwa wymiana, pierwszy właściciel, sprowadzany', 'dodge-dynasty-hatchback-1991-grafitowy-metalik-1-9', 40);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(315, 1994, 79200, 4.2, 107000, 'granatowy metalik', 'kabriolet', 'B', 'garażowany, pierwszy właściciel, sprowadzany', 'mazda-626-kabriolet-1994-granatowy-metalik-4-2', 200);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(316, 2003, 94000, 1.6, 289000, 'grafitowy metalik', 'sedan', '', '', 'rover-45-sedan-2003-grafitowy-metalik-1-6', 36);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(317, 2004, 17000, 3.5, 128000, 'granatowy', '', 'G', 'cena do uzgodnienia, garażowany, możliwa wymiana, pierwszy właściciel', 'lada-niva-2004-granatowy-3-5', 175);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(318, 2005, 22300, 2.7, 45000, 'granatowy metalik', 'kabriolet', 'BG', 'możliwa wymiana, pierwszy właściciel', 'chrysler-300t-kabriolet-2005-granatowy-metalik-2-7', 76);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(319, 1996, 5900, 1, 144000, 'granatowy', 'sedan', 'B', 'garażowany', 'peugeot-106-sedan-1996-granatowy-1', 95);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(320, 2002, 40100, 1.7, 226000, 'granatowy', 'kombi', 'B', 'gotowy do rejestracji, możliwa wymiana, sprowadzany', 'fiat-stilo-kombi-2002-granatowy-1-7', 29);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(321, 1995, 5500, 3.6, 231000, 'czerwony', 'sedan', '', 'garażowany, możliwa wymiana, pierwszy właściciel', 'daewoo-polonez-caro-sedan-1995-czerwony-3-6', 201);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(322, 1997, 91400, 2.1, 219000, 'biały', '', 'D', '', 'fiat-croma-1997-bialy-2-1', 114);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(323, 1999, 47800, 2.1, 224000, 'czerwony metalik', '', 'D', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'nissan-primera-1999-czerwony-metalik-2-1', 138);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(324, 1992, 52400, 3.5, 143000, 'czerwony', 'kombi', 'G', '', 'dodge-neon-kombi-1992-czerwony-3-5', 65);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(325, 2002, 84500, 1.6, 72000, 'grafitowy metalik', 'hatchback', 'TD', 'garażowany, sprowadzany', 'nissan-skyline-hatchback-2002-grafitowy-metalik-1-6', 63);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(326, 1994, 14300, 3.7, 145000, 'bordowy metalik', '', 'BG', 'garażowany, możliwa wymiana, sprowadzany', 'audi-80-1994-bordowy-metalik-3-7', 202);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(327, 1991, 61700, 3.5, 50000, '', 'sedan', 'D', 'cena do uzgodnienia, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'mercedes-190-sedan-1991-3-5', 203);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(328, 2005, 84700, 1.7, 12000, 'czarna perła', '', 'D', '', 'audi-coupe-2005-czarna-perla-1-7', 204);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(329, 2002, 54300, 3.5, 274000, 'czerwony metalik', 'kabriolet', 'G', 'pierwszy właściciel', 'bmw-328-kabriolet-2002-czerwony-metalik-3-5', 70);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(330, 2005, 54700, 1.2, 197000, 'zielony', 'kombi', 'G', 'gotowy do rejestracji', 'ford-sierra-kombi-2005-zielony-1-2', 61);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(331, 1998, 96800, 1.3, 65000, '', 'sedan', '', 'cena do uzgodnienia, garażowany', 'mercedes-e-klasse-sedan-1998-1-3', 28);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(332, 2000, 10500, 4.4, 257000, '', 'hatchback', 'TD', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'volksvagen-jetta-hatchback-2000-4-4', 205);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(333, 2000, 96900, 2.7, 130000, 'czarna perła', '', '', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'opel-sintra-2000-czarna-perla-2-7', 206);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(334, 1994, 9300, 3.2, 32000, 'srebrny metalik', 'kombi', 'TD', 'garażowany, gotowy do rejestracji, sprowadzany', 'daihatsu-rocky-kombi-1994-srebrny-metalik-3-2', 207);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(335, 1997, 18900, 1, 178000, 'kość słoniowa', 'hatchback', 'D', 'cena do uzgodnienia, garażowany, sprowadzany', 'fiat-125p-hatchback-1997-kosc-sloniowa-1', 13);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(336, 1996, 39300, 2.7, 173000, 'żółty', 'kombi', 'G', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, możliwa wymiana', 'audi-a4-kombi-1996-zolty-2-7', 208);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(337, 2002, 31700, 1.3, 294000, 'pomarańczowy', 'kabriolet', 'TD', 'cena do uzgodnienia, możliwa wymiana', 'chevrolet-evanda-kabriolet-2002-pomaranczowy-1-3', 127);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(338, 1996, 41000, 4.5, 83000, 'zielony', 'hatchback', 'G', 'możliwa wymiana', 'renault-espace-ii-hatchback-1996-zielony-4-5', 22);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(339, 1997, 43200, 3.7, 39000, 'żółty', 'kabriolet', 'BG', 'cena do uzgodnienia, możliwa wymiana', 'chrysler-vision-kabriolet-1997-zolty-3-7', 21);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(340, 2001, 85300, 2.4, 76000, 'czerwony metalik', 'hatchback', '', 'cena do uzgodnienia, garażowany, możliwa wymiana', 'jeep-liberty-hatchback-2001-czerwony-metalik-2-4', 209);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(341, 2005, 77500, 2, 78000, 'granatowy', '', 'TD', 'cena do uzgodnienia, możliwa wymiana, sprowadzany', 'chrysler-grand-voyager-2005-granatowy-2', 210);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(342, 2000, 11800, 2.7, 173000, 'żółty', 'sedan', 'B', 'możliwa wymiana, sprowadzany', 'citroen-cx-sedan-2000-zolty-2-7', 211);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(343, 2005, 15300, 2.9, 40000, 'biały', 'sedan', 'TD', 'cena do uzgodnienia, garażowany, możliwa wymiana', 'rover-75-sedan-2005-bialy-2-9', 42);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(344, 1994, 23700, 3.7, 91000, 'grafitowy metalik', 'sedan', 'TD', 'cena do uzgodnienia', 'opel-astra-sedan-1994-grafitowy-metalik-3-7', 18);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(345, 1990, 86100, 2.4, 280000, 'bordowy', 'hatchback', 'BG', 'cena do uzgodnienia, garażowany', 'toyota-previa-hatchback-1990-bordowy-2-4', 212);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(346, 1997, 16900, 4.2, 232000, 'grafitowy', 'hatchback', 'BG', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'kia-sportage-hatchback-1997-grafitowy-4-2', 213);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(347, 1992, 91500, 1.8, 235000, 'czerwony metalik', 'kombi', 'D', 'garażowany', 'volksvagen-jetta-kombi-1992-czerwony-metalik-1-8', 205);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(348, 1994, 70700, 1.4, 67000, 'żółty', 'hatchback', 'BG', '', 'rover-200-hatchback-1994-zolty-1-4', 214);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(349, 2003, 9400, 1.4, 119000, 'srebrny metalik', 'sedan', 'B', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana', 'bmw-328-sedan-2003-srebrny-metalik-1-4', 70);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(350, 1992, 89300, 1.4, 18000, 'granatowy metalik', 'sedan', 'BG', '', 'mercedes-e-klasse-sedan-1992-granatowy-metalik-1-4', 28);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(351, 1998, 7300, 1.8, 178000, 'czerwony metalik', 'kombi', 'TD', '', 'fiat-siena-kombi-1998-czerwony-metalik-1-8', 215);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(352, 2005, 78100, 4.2, 180000, 'pomarańczowy', 'hatchback', 'D', 'cena do uzgodnienia', 'chevrolet-evanda-hatchback-2005-pomaranczowy-4-2', 127);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(353, 1995, 28900, 1.9, 296000, 'czerwony', '', 'B', '', 'audi-a3-1995-czerwony-1-9', 2);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(354, 1997, 51700, 1.7, 25000, 'bordowy metalik', 'hatchback', 'B', 'garażowany, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'nissan-silvia-hatchback-1997-bordowy-metalik-1-7', 143);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(355, 1992, 45500, 3.7, 137000, 'grafitowy metalik', 'sedan', 'B', 'cena do uzgodnienia, garażowany, gotowy do rejestracji', 'volksvagen-golf-sedan-1992-grafitowy-metalik-3-7', 152);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(356, 1999, 49600, 3.8, 269000, 'czerwony', 'kombi', '', 'cena do uzgodnienia, garażowany, możliwa wymiana, sprowadzany', 'nissan-micra-kombi-1999-czerwony-3-8', 216);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(357, 2001, 76800, 3.3, 36000, 'granatowy', '', 'B', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'renault-11-2001-granatowy-3-3', 89);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(358, 1993, 53800, 4.2, 69000, 'zielony', '', 'TD', '', 'bmw-728-1993-zielony-4-2', 60);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(359, 1998, 30500, 1.5, 341000, 'żółty', '', '', '', 'fiat-brava-1998-zolty-1-5', 217);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(360, 1992, 91000, 3.2, 269000, 'biały', '', 'BG', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, możliwa wymiana', 'daewoo-polonez-caro-1992-bialy-3-2', 201);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(361, 1998, 80000, 4.2, 311000, 'grafitowy', 'kombi', 'D', 'garażowany, gotowy do rejestracji, sprowadzany', 'volksvagen-vento-kombi-1998-grafitowy-4-2', 144);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(362, 2004, 98500, 1.2, 121000, 'czerwony', '', 'TD', 'garażowany, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'opel-calibra-2004-czerwony-1-2', 218);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(363, 2004, 9000, 4.1, 315000, 'pomarańczowy', 'hatchback', 'G', 'garażowany, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'jeep-grand-cherokee-hatchback-2004-pomaranczowy-4-1', 57);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(364, 1992, 41400, 1.6, 82000, 'bordowy metalik', 'hatchback', '', 'cena do uzgodnienia, garażowany, pierwszy właściciel', 'daewoo-tico-hatchback-1992-bordowy-metalik-1-6', 98);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(365, 1992, 90500, 2.1, 221000, 'zielony metalik', 'sedan', 'TD', 'gotowy do rejestracji, możliwa wymiana, pierwszy właściciel, sprowadzany', 'mercedes-170-sedan-1992-zielony-metalik-2-1', 72);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(366, 2002, 50000, 2.7, 317000, 'czerwony metalik', 'kabriolet', '', '', 'mitshubishi-pajero-kabriolet-2002-czerwony-metalik-2-7', 163);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(367, 1996, 23100, 1.7, 98000, 'czerwony metalik', 'kabriolet', 'TD', '', 'hyundai-santa-kabriolet-1996-czerwony-metalik-1-7', 219);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(368, 1997, 99500, 1.5, 167000, 'czerwony', 'hatchback', '', '', 'nissan-skyline-hatchback-1997-czerwony-1-5', 63);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(369, 1991, 84300, 3.2, 84000, '', '', 'G', 'garażowany, gotowy do rejestracji, pierwszy właściciel', 'renault-11-1991-3-2', 89);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(370, 1998, 93100, 4, 237000, 'czarna perła', 'kabriolet', 'B', 'cena do uzgodnienia, pierwszy właściciel, sprowadzany', 'rover-200-kabriolet-1998-czarna-perla-4', 214);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(371, 1999, 8100, 4.1, 111000, 'czarna perła', 'hatchback', 'D', 'możliwa wymiana, sprowadzany', 'volksvagen-sharan-hatchback-1999-czarna-perla-4-1', 220);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(372, 2004, 77500, 3.2, 339000, 'bordowy', '', 'BG', 'możliwa wymiana, pierwszy właściciel', 'bmw-735-2004-bordowy-3-2', 64);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(373, 1999, 66800, 2.1, 141000, 'zielony metalik', 'sedan', 'B', 'garażowany, gotowy do rejestracji, sprowadzany', 'fiat-tipo-sedan-1999-zielony-metalik-2-1', 77);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(374, 1996, 10800, 4, 203000, 'bordowy metalik', 'kabriolet', 'TD', 'sprowadzany', 'citroen-c2-kabriolet-1996-bordowy-metalik-4', 221);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(375, 1997, 17600, 1.4, 100000, 'kość słoniowa', 'kombi', 'B', 'cena do uzgodnienia, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'volvo-740-kombi-1997-kosc-sloniowa-1-4', 130);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(376, 1993, 62900, 4.3, 156000, 'pomarańczowy', '', 'B', 'cena do uzgodnienia, garażowany, sprowadzany', 'mitshubishi-colt-1993-pomaranczowy-4-3', 48);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(377, 1996, 87100, 3.7, 234000, 'czerwony', 'kabriolet', 'BG', 'cena do uzgodnienia, garażowany, możliwa wymiana, sprowadzany', 'alfa-romeo-spider-kabriolet-1996-czerwony-3-7', 222);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(378, 2003, 44900, 2.4, 177000, 'zielony metalik', 'kombi', 'D', 'cena do uzgodnienia, gotowy do rejestracji', 'fiat-marea-kombi-2003-zielony-metalik-2-4', 24);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(379, 2000, 85200, 1.2, 120000, 'granatowy metalik', 'kabriolet', 'G', 'sprowadzany', 'bmw-520i-kabriolet-2000-granatowy-metalik-1-2', 196);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(380, 2001, 97500, 3.7, 178000, 'czerwony', 'kombi', 'D', '', 'honda-accord-kombi-2001-czerwony-3-7', 50);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(381, 1995, 70600, 2.7, 94000, 'żółty', 'hatchback', 'TD', 'garażowany, pierwszy właściciel', 'mercedes-a-klasse-hatchback-1995-zolty-2-7', 223);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(382, 1997, 76400, 1.9, 347000, 'bordowy', '', 'TD', 'możliwa wymiana', 'opel-omega-1997-bordowy-1-9', 188);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(383, 2001, 26300, 4.5, 188000, 'kość słoniowa', 'kombi', 'D', 'cena do uzgodnienia', 'toyota-picnic-kombi-2001-kosc-sloniowa-4-5', 92);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(384, 2000, 94100, 1.3, 71000, 'bordowy', '', 'TD', 'możliwa wymiana', 'daewoo-polonez-caro-2000-bordowy-1-3', 201);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(385, 2005, 17200, 3.4, 57000, 'czerwony metalik', 'kombi', 'G', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'audi-coupe-kombi-2005-czerwony-metalik-3-4', 204);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(386, 1990, 79200, 1.5, 14000, 'czarny', 'kabriolet', '', 'cena do uzgodnienia, garażowany, gotowy do rejestracji', 'nissan-serena-kabriolet-1990-czarny-1-5', 146);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(387, 1997, 70000, 2, 128000, 'bordowy metalik', 'sedan', 'G', 'cena do uzgodnienia', 'bmw-323-sedan-1997-bordowy-metalik-2', 224);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(388, 1997, 55600, 2.6, 124000, 'czerwony', 'hatchback', '', '', 'volvo-440-hatchback-1997-czerwony-2-6', 225);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(389, 1993, 17000, 3.8, 248000, 'bordowy metalik', 'sedan', 'BG', 'gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'bmw-530-sedan-1993-bordowy-metalik-3-8', 174);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(390, 1992, 31300, 3.1, 143000, 'bordowy metalik', 'kabriolet', 'D', 'gotowy do rejestracji, możliwa wymiana, sprowadzany', 'jeep-grand-cherokee-kabriolet-1992-bordowy-metalik-3-1', 57);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(391, 2002, 16400, 2.3, 178000, 'srebrny metalik', 'kombi', '', '', 'peugeot-106-kombi-2002-srebrny-metalik-2-3', 95);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(392, 1992, 48100, 3.9, 239000, 'grafitowy metalik', 'hatchback', '', 'gotowy do rejestracji, pierwszy właściciel', 'alfa-romeo-spider-hatchback-1992-grafitowy-metalik-3-9', 222);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(393, 1996, 83700, 1.4, 101000, 'pomarańczowy', 'hatchback', 'TD', 'garażowany, możliwa wymiana, sprowadzany', 'ford-probe-hatchback-1996-pomaranczowy-1-4', 1);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(394, 1990, 31900, 3.9, 316000, 'biały', 'hatchback', 'G', 'gotowy do rejestracji', 'nissan-laurel-hatchback-1990-bialy-3-9', 11);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(395, 1991, 67400, 2.5, 194000, 'granatowy', 'kombi', 'G', 'garażowany, możliwa wymiana, pierwszy właściciel', 'seat-toledo-ii-kombi-1991-granatowy-2-5', 55);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(396, 2001, 63900, 3.4, 39000, 'czarna perła', 'hatchback', 'D', 'cena do uzgodnienia', 'mazda-mx6-hatchback-2001-czarna-perla-3-4', 226);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(397, 1994, 42300, 3.8, 150000, 'granatowy metalik', 'sedan', 'BG', 'gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'citroen-c2-sedan-1994-granatowy-metalik-3-8', 221);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(398, 1993, 10200, 1.6, 90000, 'żółty', 'sedan', 'B', 'garażowany, gotowy do rejestracji, możliwa wymiana, pierwszy właściciel', 'ford-explorer-sedan-1993-zolty-1-6', 227);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(399, 1994, 39300, 3.8, 325000, 'czerwony', 'kombi', 'G', 'cena do uzgodnienia, gotowy do rejestracji, pierwszy właściciel', 'daewoo-musso-kombi-1994-czerwony-3-8', 228);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(400, 1990, 41600, 2.6, 163000, 'czerwony', '', 'G', 'gotowy do rejestracji, możliwa wymiana', 'audi-100-1990-czerwony-2-6', 229);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(401, 2000, 36300, 4.2, 45000, 'czarny', 'sedan', 'D', '', 'peugeot-405-sedan-2000-czarny-4-2', 230);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(402, 2001, 85000, 2.5, 11000, '', '', 'D', 'gotowy do rejestracji, sprowadzany', 'mitshubishi-lancer-2001-2-5', 121);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(403, 2000, 8500, 4, 311000, 'czerwony', 'kombi', 'D', 'możliwa wymiana, pierwszy właściciel', 'bmw-735-kombi-2000-czerwony-4', 64);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(404, 1997, 14100, 2.8, 173000, '', 'kombi', '', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'audi-a3-kombi-1997-2-8', 2);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(405, 2002, 17600, 4.2, 301000, 'grafitowy', 'kombi', '', 'pierwszy właściciel, sprowadzany', 'opel-calibra-kombi-2002-grafitowy-4-2', 218);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(406, 1990, 75600, 2.9, 88000, 'zielony', 'kabriolet', 'G', 'garażowany, gotowy do rejestracji, możliwa wymiana', 'opel-tigra-kabriolet-1990-zielony-2-9', 153);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(407, 2002, 93200, 4.2, 41000, 'żółty', 'hatchback', 'D', 'cena do uzgodnienia, gotowy do rejestracji, sprowadzany', 'toyota-starlet-hatchback-2002-zolty-4-2', 231);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(408, 1997, 42100, 2.9, 313000, 'biały', 'kombi', 'D', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, sprowadzany', 'mazda-121-kombi-1997-bialy-2-9', 148);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(409, 1992, 31800, 1.7, 316000, 'granatowy metalik', 'kabriolet', 'B', 'cena do uzgodnienia, możliwa wymiana', 'seat-leon-kabriolet-1992-granatowy-metalik-1-7', 79);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(410, 1999, 14300, 1.7, 86000, 'srebrny metalik', '', 'D', 'cena do uzgodnienia, garażowany, możliwa wymiana, pierwszy właściciel', 'peugeot-806-1999-srebrny-metalik-1-7', 14);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(411, 1994, 74200, 3.7, 335000, 'granatowy', 'hatchback', 'D', 'pierwszy właściciel', 'peugeot-806-hatchback-1994-granatowy-3-7', 14);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(412, 1991, 53700, 1.7, 292000, 'czerwony metalik', 'hatchback', 'TD', 'garażowany, gotowy do rejestracji, możliwa wymiana, sprowadzany', 'renault-chamade-hatchback-1991-czerwony-metalik-1-7', 232);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(413, 1990, 81100, 4.4, 249000, 'biały', 'kabriolet', '', 'gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'chrysler-stratus-kabriolet-1990-bialy-4-4', 56);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(414, 2004, 76400, 2.4, 271000, 'czerwony metalik', 'kabriolet', 'D', 'możliwa wymiana, pierwszy właściciel', 'jeep-grand-cherokee-kabriolet-2004-czerwony-metalik-2-4', 57);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(415, 1993, 9400, 4.3, 86000, 'granatowy', 'hatchback', 'TD', 'pierwszy właściciel', 'mercedes-170-hatchback-1993-granatowy-4-3', 72);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(416, 1995, 24500, 2.3, 122000, 'czerwony metalik', 'sedan', 'BG', '', 'citroen-xsara-break-sedan-1995-czerwony-metalik-2-3', 83);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(417, 1999, 59100, 1.4, 268000, 'czerwony metalik', 'kombi', 'D', 'pierwszy właściciel', 'lada-niva-kombi-1999-czerwony-metalik-1-4', 175);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(418, 1994, 61500, 3.8, 132000, 'pomarańczowy', 'kombi', 'BG', 'gotowy do rejestracji, pierwszy właściciel', 'rover-214-kombi-1994-pomaranczowy-3-8', 170);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(419, 1996, 12900, 4.4, 284000, 'czarny', 'hatchback', 'BG', 'cena do uzgodnienia, garażowany, sprowadzany', 'fiat-palio-hatchback-1996-czarny-4-4', 150);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(420, 1992, 46100, 3.4, 293000, 'czarny', 'hatchback', 'G', '', 'citroen-saxo-hatchback-1992-czarny-3-4', 180);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(421, 2003, 19900, 2.3, 132000, 'zielony', 'kombi', 'D', 'cena do uzgodnienia, gotowy do rejestracji, pierwszy właściciel, sprowadzany', 'ford-taunus-kombi-2003-zielony-2-3', 233);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(422, 2005, 58400, 3.4, 259000, 'zielony metalik', 'hatchback', 'D', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, sprowadzany', 'nissan-primera-hatchback-2005-zielony-metalik-3-4', 138);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(423, 1991, 83900, 2.2, 172000, 'żółty', '', 'G', 'garażowany, możliwa wymiana', 'fiat-marea-1991-zolty-2-2', 24);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(424, 2003, 72200, 1.5, 340000, '', 'hatchback', 'D', 'cena do uzgodnienia, garażowany, możliwa wymiana, sprowadzany', 'hyundai-sonata-hatchback-2003-1-5', 234);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(425, 1999, 92600, 1.8, 271000, 'granatowy metalik', '', '', 'pierwszy właściciel, sprowadzany', 'bmw-320i-1999-granatowy-metalik-1-8', 91);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(426, 2005, 45200, 3.6, 62000, '', 'kabriolet', 'G', 'cena do uzgodnienia, możliwa wymiana, sprowadzany', 'citroen-xsara-picasso-kabriolet-2005-3-6', 44);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(427, 1995, 52600, 2.4, 55000, 'grafitowy', '', 'BG', 'cena do uzgodnienia, garażowany, możliwa wymiana', 'volksvagen-golf-ii-1995-grafitowy-2-4', 59);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(428, 1999, 36200, 2.9, 88000, 'zielony', 'kombi', 'B', 'cena do uzgodnienia, garażowany, sprowadzany', 'ford-mondeo-kombi-1999-zielony-2-9', 17);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(429, 1992, 55300, 3.6, 174000, 'czerwony', 'hatchback', 'G', 'cena do uzgodnienia, możliwa wymiana, sprowadzany', 'volksvagen-bora-hatchback-1992-czerwony-3-6', 110);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(430, 2002, 65900, 1.5, 13000, 'zielony metalik', 'hatchback', '', 'cena do uzgodnienia, gotowy do rejestracji, możliwa wymiana', 'bmw-320-hatchback-2002-zielony-metalik-1-5', 155);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(431, 1994, 52000, 1.4, 214000, 'żółty', 'kombi', 'BG', 'garażowany', 'volksvagen-caddy-kombi-1994-zolty-1-4', 62);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(432, 1998, 75200, 1.2, 45000, 'bordowy metalik', 'kabriolet', 'D', 'cena do uzgodnienia', 'renault-kangoo-kabriolet-1998-bordowy-metalik-1-2', 78);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(433, 2001, 72500, 3.6, 133000, 'biały', 'kabriolet', 'D', 'cena do uzgodnienia, garażowany, gotowy do rejestracji, sprowadzany', 'lada-niva-kabriolet-2001-bialy-3-6', 175);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(434, 1990, 34800, 2.8, 86000, 'bordowy', '', 'B', 'cena do uzgodnienia', 'fiat-bravo-1990-bordowy-2-8', 115);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(435, 1998, 62400, 2.5, 309000, 'czerwony', 'hatchback', 'BG', 'garażowany', 'mazda-mx6-hatchback-1998-czerwony-2-5', 226);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(436, 1993, 34800, 4.2, 16000, 'kość słoniowa', '', 'TD', '', 'bmw-635-1993-kosc-sloniowa-4-2', 33);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(437, 1991, 61900, 1, 33000, 'czarna perła', 'kombi', 'TD', 'garażowany, możliwa wymiana, sprowadzany', 'ford-ka-kombi-1991-czarna-perla-1', 154);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(438, 1990, 5900, 3, 203000, 'srebrny metalik', 'sedan', 'G', 'cena do uzgodnienia, możliwa wymiana, pierwszy właściciel', 'volvo-v40-sedan-1990-srebrny-metalik-3', 235);
INSERT INTO `auto` (`auto_id`, `rocznik`, `cena`, `pojemnosc`, `przebieg`, `kolor`, `typ`, `paliwo`, `uwagi`, `slug`, `model_id`) VALUES(439, 1993, 41500, 2.9, 38000, 'czarna perła', 'sedan', 'B', '', 'nissan-100-sedan-1993-czarna-perla-2-9', 116);

--
-- Zrzut danych tabeli `auto_has_wyposazenie`
--

INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(19, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(81, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(107, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(163, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(245, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(268, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(332, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(376, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(402, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(423, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(436, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 1);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(15, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(37, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(50, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(58, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(81, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(97, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(100, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(122, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(140, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(310, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(385, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 2);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(33, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(40, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(50, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(92, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(100, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(126, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(215, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(232, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(259, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(263, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(435, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 3);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(37, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(79, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(94, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(104, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(126, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(131, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(263, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(278, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(376, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(380, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(423, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 4);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(50, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(74, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(79, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(81, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(177, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(300, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(386, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(402, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(404, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(408, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(409, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 5);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(81, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(107, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(259, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(268, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(278, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(313, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(332, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(349, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(389, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(397, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(404, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 6);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(40, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(79, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(163, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(268, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(278, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(291, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(294, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(358, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(376, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(385, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(408, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 7);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(37, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(55, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(92, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(163, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(245, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(313, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(385, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(405, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(409, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(414, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 8);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(19, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(32, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(38, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(81, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(107, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(313, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(332, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(384, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(386, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 9);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(38, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(140, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(278, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(282, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(340, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(359, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(386, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(425, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 10);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(56, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(342, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(385, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(435, 11);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(19, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(38, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(40, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(70, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(74, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(79, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(177, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(245, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(268, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(332, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 12);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(32, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(126, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(225, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(232, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(358, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(425, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(438, 13);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(15, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(32, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(38, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(56, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(65, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(92, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(104, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(168, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(291, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(310, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(384, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 14);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(47, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(81, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(94, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(163, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(322, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(340, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(358, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(385, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 15);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(15, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(38, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(79, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(126, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(177, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(359, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(423, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(438, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 16);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(47, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(104, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(107, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(126, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(131, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(177, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(245, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(314, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(376, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(409, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(436, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 17);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(65, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(92, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(225, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(342, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(402, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(409, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 18);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(33, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(96, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(225, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(332, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 19);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(65, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(189, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(218, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(268, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(291, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(358, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 20);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(23, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(32, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(40, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(97, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(100, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(126, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(147, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(168, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(259, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(310, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(327, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(404, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(405, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(408, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 21);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(56, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(65, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(107, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(131, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(140, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(147, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(177, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(259, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 22);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(23, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(32, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(37, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(79, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(122, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(140, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(163, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(332, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(342, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(358, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(404, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 23);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(56, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(92, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(232, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(259, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(397, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(409, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 24);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(38, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(55, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(121, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(310, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(332, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(385, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(397, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(404, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(405, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(414, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(423, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(435, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 25);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(23, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(147, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(163, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(177, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(225, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(268, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(278, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(364, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(414, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(433, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(436, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(438, 26);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(127, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(177, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(225, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(384, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(402, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(408, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 27);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(15, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(19, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(55, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(79, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(100, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(163, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(215, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(263, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(310, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 28);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(23, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(70, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(92, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(189, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(215, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(270, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(342, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(355, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(358, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(397, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 29);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(2, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(50, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(147, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(173, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(342, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(349, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(397, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 30);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(32, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(38, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(62, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(65, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(147, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(173, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(310, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(342, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(377, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(384, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(397, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(409, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(425, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(433, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(436, 31);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(19, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(33, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(40, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(55, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(97, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(313, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(358, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(384, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(423, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 32);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(15, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(23, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(52, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(62, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(81, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(97, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(119, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(342, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(346, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(389, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(397, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(423, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(435, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 33);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(40, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(68, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(79, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(82, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(92, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(94, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(126, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(131, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(268, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(291, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(312, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(322, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(384, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(386, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(408, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 34);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(37, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(113, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(122, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(147, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(160, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(168, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(171, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(261, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(294, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(356, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(376, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(423, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(424, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(435, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(436, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(438, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 35);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(74, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(92, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(97, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(121, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(159, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(174, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(182, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(187, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(218, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(307, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(322, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(364, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(378, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(379, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(408, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(409, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 36);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(29, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(51, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(56, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(77, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(114, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(131, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(159, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(189, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(245, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(287, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(318, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(376, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(402, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 37);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(17, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(32, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(34, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(45, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(55, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(56, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(62, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(94, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(126, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(141, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(194, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(202, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(207, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(212, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(214, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(217, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(225, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(232, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(244, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(246, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(313, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(320, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(342, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(411, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(438, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 38);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(24, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(37, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(46, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(50, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(65, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(73, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(128, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(148, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(149, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(211, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(219, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(225, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(229, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(238, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(239, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(245, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(259, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(271, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(273, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(291, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(292, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(301, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(316, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(332, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(357, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(366, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(393, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(394, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(400, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(409, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(417, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(436, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(439, 39);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(9, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(13, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(23, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(30, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(33, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(36, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(54, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(62, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(69, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(72, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(78, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(81, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(83, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(103, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(110, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(111, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(115, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(120, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(124, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(129, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(137, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(143, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(158, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(165, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(169, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(175, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(186, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(189, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(190, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(201, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(216, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(221, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(222, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(232, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(233, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(247, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(249, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(250, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(256, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(265, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(274, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(289, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(290, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(302, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(303, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(304, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(305, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(306, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(310, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(321, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(331, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(333, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(368, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(369, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(371, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(374, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(384, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(391, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(392, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(398, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(405, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(407, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(408, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(427, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(429, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 40);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(4, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(5, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(10, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(12, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(14, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(18, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(20, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(22, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(28, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(31, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(35, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(37, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(39, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(41, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(42, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(43, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(44, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(57, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(58, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(66, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(67, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(71, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(80, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(86, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(93, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(99, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(102, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(105, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(109, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(118, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(123, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(133, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(136, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(153, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(193, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(198, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(200, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(203, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(209, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(220, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(235, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(242, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(254, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(264, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(269, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(272, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(281, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(285, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(317, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(319, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(323, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(324, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(335, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(341, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(343, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(348, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(351, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(360, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(362, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(375, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(384, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(388, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(395, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(396, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(397, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(399, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(401, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(405, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(406, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(415, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(418, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(420, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 41);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(1, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(3, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(6, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(7, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(8, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(11, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(16, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(21, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(25, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(26, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(27, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(48, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(49, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(53, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(59, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(60, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(61, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(63, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(64, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(76, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(84, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(85, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(87, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(89, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(90, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(91, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(94, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(98, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(101, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(106, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(108, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(112, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(116, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(117, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(125, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(130, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(132, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(134, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(135, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(138, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(139, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(142, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(144, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(145, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(146, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(147, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(150, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(151, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(152, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(155, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(157, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(161, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(162, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(164, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(166, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(167, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(170, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(172, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(176, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(178, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(179, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(180, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(181, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(183, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(184, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(185, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(191, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(192, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(195, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(196, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(197, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(199, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(204, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(205, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(206, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(208, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(210, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(213, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(223, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(224, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(226, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(227, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(228, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(230, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(231, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(234, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(236, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(237, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(240, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(241, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(243, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(248, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(251, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(252, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(253, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(255, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(257, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(258, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(260, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(262, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(267, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(275, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(276, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(277, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(279, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(280, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(283, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(286, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(288, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(293, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(295, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(297, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(298, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(299, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(308, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(309, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(311, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(315, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(325, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(326, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(327, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(328, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(329, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(330, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(334, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(336, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(337, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(338, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(339, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(344, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(345, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(347, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(350, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(352, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(353, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(354, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(361, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(363, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(365, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(367, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(370, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(372, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(373, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(381, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(382, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(383, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(386, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(387, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(390, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(403, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(404, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(410, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(412, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(413, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(416, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(419, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(421, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(422, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(426, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(428, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(430, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(431, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(432, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(434, 42);
INSERT INTO `auto_has_wyposazenie` (`auto_id`, `wyposazenie_id`) VALUES(437, 42);

--
-- Zrzut danych tabeli `marka`
--

INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(1, 'Ford', 'ford');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(2, 'Audi', 'audi');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(3, 'Honda', 'honda');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(4, 'Pontiac', 'pontiac');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(5, 'Opel', 'opel');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(6, 'Renault', 'renault');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(7, 'Nissan', 'nissan');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(8, 'Mercedes', 'mercedes');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(9, 'Volksvagen', 'volksvagen');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(10, 'Fiat', 'fiat');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(11, 'Peugeot', 'peugeot');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(12, 'BMW', 'bmw');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(13, 'Chrysler', 'chrysler');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(14, 'Daewoo', 'daewoo');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(15, 'Mitshubishi', 'mitshubishi');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(16, 'Skoda', 'skoda');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(17, 'Seat', 'seat');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(18, 'Rover', 'rover');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(19, 'Dodge', 'dodge');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(20, 'Saab', 'saab');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(21, 'Citroen', 'citroen');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(22, 'Suzuki', 'suzuki');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(23, 'Jeep', 'jeep');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(24, 'Daihatsu', 'daihatsu');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(25, 'Kia', 'kia');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(26, 'Toyota', 'toyota');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(27, 'Alfa Romeo', 'alfa-romeo');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(28, 'Volvo', 'volvo');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(29, 'Trabant', 'trabant');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(30, 'Hyundai', 'hyundai');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(31, 'Chevrolet', 'chevrolet');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(32, 'Mazda', 'mazda');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(33, 'Łada', 'lada');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(34, 'Subaru', 'subaru');
INSERT INTO `marka` (`marka_id`, `nazwa`, `slug`) VALUES(35, 'Lancia', 'lancia');

--
-- Zrzut danych tabeli `model`
--

INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(1, 'Probe', 1, 'ford-probe');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(2, 'A3', 2, 'audi-a3');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(3, 'VT-800', 3, 'honda-vt-800');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(4, 'Firo', 4, 'pontiac-firo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(5, 'Ascona', 5, 'opel-ascona');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(6, 'Safrane', 6, 'renault-safrane');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(7, 'Terrano', 7, 'nissan-terrano');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(8, 'C-180', 8, 'mercedes-c-180');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(9, 'Polo', 9, 'volksvagen-polo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(10, 'Senator', 5, 'opel-senator');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(11, 'Laurel', 7, 'nissan-laurel');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(12, 'Caravelle', 9, 'volksvagen-caravelle');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(13, '125p', 10, 'fiat-125p');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(14, '806', 11, 'peugeot-806');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(15, 'Kadet', 5, 'opel-kadet');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(16, 'Prelude', 3, 'honda-prelude');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(17, 'Mondeo', 1, 'ford-mondeo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(18, 'Astra', 5, 'opel-astra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(19, 'C-200', 8, 'mercedes-c-200');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(20, '525', 12, 'bmw-525');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(21, 'Vision', 13, 'chrysler-vision');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(22, 'Espace II', 6, 'renault-espace-ii');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(23, 'Zafira', 5, 'opel-zafira');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(24, 'Marea', 10, 'fiat-marea');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(25, 'Nubira', 14, 'daewoo-nubira');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(26, '123', 8, 'mercedes-123');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(27, 'Concerto', 3, 'honda-concerto');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(28, 'E-KLASSE', 8, 'mercedes-e-klasse');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(29, 'Stilo', 10, 'fiat-stilo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(30, 'Pajero Long', 15, 'mitshubishi-pajero-long');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(31, '240 SX', 7, 'nissan-240-sx');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(32, 'Superb', 16, 'skoda-superb');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(33, '635', 12, 'bmw-635');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(34, 'PT Cruiser', 13, 'chrysler-pt-cruiser');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(35, 'Ibiza', 17, 'seat-ibiza');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(36, '45', 18, 'rover-45');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(37, '730', 12, 'bmw-730');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(38, 'Stratus', 19, 'dodge-stratus');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(39, '416', 18, 'rover-416');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(40, 'Dynasty', 19, 'dodge-dynasty');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(41, 'Space Wagon', 15, 'mitshubishi-space-wagon');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(42, '75', 18, 'rover-75');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(43, '9000', 20, 'saab-9000');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(44, 'Xsara Picasso', 21, 'citroen-xsara-picasso');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(45, 'Neon', 13, 'chrysler-neon');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(46, 'Cinquecento', 10, 'fiat-cinquecento');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(47, '105', 16, 'skoda-105');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(48, 'Colt', 15, 'mitshubishi-colt');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(49, 'Escort', 1, 'ford-escort');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(50, 'Accord', 3, 'honda-accord');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(51, '820', 18, 'rover-820');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(52, 'Grand', 22, 'suzuki-grand');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(53, '400', 18, 'rover-400');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(54, '19', 6, 'renault-19');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(55, 'Toledo II', 17, 'seat-toledo-ii');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(56, 'Stratus', 13, 'chrysler-stratus');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(57, 'Grand Cherokee', 23, 'jeep-grand-cherokee');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(58, 'Passat', 9, 'volksvagen-passat');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(59, 'Golf II', 9, 'volksvagen-golf-ii');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(60, '728', 12, 'bmw-728');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(61, 'Sierra', 1, 'ford-sierra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(62, 'Caddy', 9, 'volksvagen-caddy');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(63, 'Skyline', 7, 'nissan-skyline');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(64, '735', 12, 'bmw-735');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(65, 'Neon', 19, 'dodge-neon');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(66, 'Move', 24, 'daihatsu-move');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(67, 'Almera', 7, 'nissan-almera');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(68, 'Clarus', 25, 'kia-clarus');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(69, 'RAV4', 26, 'toyota-rav4');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(70, '328', 12, 'bmw-328');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(71, 'Nexia', 14, 'daewoo-nexia');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(72, '170', 8, 'mercedes-170');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(73, 'Xsara II', 21, 'citroen-xsara-ii');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(74, '316I', 12, 'bmw-316i');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(75, '325', 12, 'bmw-325');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(76, '300T', 13, 'chrysler-300t');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(77, 'Tipo', 10, 'fiat-tipo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(78, 'Kangoo', 6, 'renault-kangoo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(79, 'Leon', 17, 'seat-leon');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(80, 'GTV', 27, 'alfa-romeo-gtv');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(81, '940', 28, 'volvo-940');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(82, '601', 29, 'trabant-601');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(83, 'Xsara Break', 21, 'citroen-xsara-break');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(84, '155', 27, 'alfa-romeo-155');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(85, 'Matiz', 14, 'daewoo-matiz');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(86, 'ML', 8, 'mercedes-ml');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(87, '210', 8, 'mercedes-210');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(88, 'C-KLASSE', 8, 'mercedes-c-klasse');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(89, '11', 6, 'renault-11');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(90, 'Laguna', 6, 'renault-laguna');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(91, '320I', 12, 'bmw-320i');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(92, 'Picnic', 26, 'toyota-picnic');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(93, 'Fusion', 1, 'ford-fusion');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(94, 'Trans Sport', 4, 'pontiac-trans-sport');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(95, '106', 11, 'peugeot-106');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(96, 'Record', 5, 'opel-record');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(97, 'Atos', 30, 'hyundai-atos');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(98, 'Tico', 14, 'daewoo-tico');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(99, 'LE Baron', 13, 'chrysler-le-baron');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(100, 'Carisma', 15, 'mitshubishi-carisma');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(101, 'XM', 21, 'citroen-xm');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(102, 'Tempra', 10, 'fiat-tempra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(103, 'Thalia', 6, 'renault-thalia');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(104, 'Space Star', 15, 'mitshubishi-space-star');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(105, 'Celica', 26, 'toyota-celica');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(106, '518', 12, 'bmw-518');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(107, 'Taurus', 1, 'ford-taurus');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(108, 'C4', 2, 'audi-c4');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(109, '200', 8, 'mercedes-200');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(110, 'Bora', 9, 'volksvagen-bora');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(111, 'Clio', 6, 'renault-clio');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(112, '623', 18, 'rover-623');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(113, '124', 8, 'mercedes-124');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(114, 'Croma', 10, 'fiat-croma');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(115, 'Bravo', 10, 'fiat-bravo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(116, '100', 7, 'nissan-100');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(117, 'Puma', 1, 'ford-puma');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(118, 'Scenic', 6, 'renault-scenic');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(119, '21', 6, 'renault-21');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(120, 'Alhambra', 17, 'seat-alhambra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(121, 'Lancer', 15, 'mitshubishi-lancer');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(122, '270', 8, 'mercedes-270');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(123, 'V70', 28, 'volvo-v70');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(124, 'Espace', 6, 'renault-espace');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(125, 'Camaro', 31, 'chevrolet-camaro');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(126, 'Sunny', 7, 'nissan-sunny');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(127, 'Evanda', 31, 'chevrolet-evanda');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(128, 'Swift', 22, 'suzuki-swift');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(129, '605', 11, 'peugeot-605');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(130, '740', 28, 'volvo-740');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(131, 'Town Country', 13, 'chrysler-town-country');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(132, 'CRV', 3, 'honda-crv');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(133, 'Camry', 26, 'toyota-camry');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(134, 'Seicento', 10, 'fiat-seicento');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(135, '205', 11, 'peugeot-205');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(136, 'Panda', 10, 'fiat-panda');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(137, 'Uno', 10, 'fiat-uno');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(138, 'Primera', 7, 'nissan-primera');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(139, 'AX', 21, 'citroen-ax');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(140, 'CRX', 3, 'honda-crx');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(141, 'Arosa', 17, 'seat-arosa');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(142, '414', 18, 'rover-414');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(143, 'Silvia', 7, 'nissan-silvia');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(144, 'Vento', 9, 'volksvagen-vento');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(145, 'Expedition', 1, 'ford-expedition');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(146, 'Serena', 7, 'nissan-serena');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(147, 'Lantra', 30, 'hyundai-lantra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(148, '121', 32, 'mazda-121');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(149, 'Espace III', 6, 'renault-espace-iii');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(150, 'Palio', 10, 'fiat-palio');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(151, '306', 11, 'peugeot-306');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(152, 'Golf', 9, 'volksvagen-golf');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(153, 'Tigra', 5, 'opel-tigra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(154, 'Ka', 1, 'ford-ka');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(155, '320', 12, 'bmw-320');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(156, 'B4', 2, 'audi-b4');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(157, '520', 12, 'bmw-520');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(158, 'Vectra', 5, 'opel-vectra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(159, 'Xedos', 32, 'mazda-xedos');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(160, 'Charade', 24, 'daihatsu-charade');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(161, 'Galant', 15, 'mitshubishi-galant');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(162, '900', 20, 'saab-900');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(163, 'Pajero', 15, 'mitshubishi-pajero');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(164, 'A6', 2, 'audi-a6');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(165, 'Corsica', 31, 'chevrolet-corsica');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(166, 'Toledo', 17, 'seat-toledo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(167, 'Lupo', 9, 'volksvagen-lupo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(168, '218', 18, 'rover-218');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(169, '850', 28, 'volvo-850');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(170, '214', 18, 'rover-214');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(171, 'C15', 21, 'citroen-c15');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(172, '164', 27, 'alfa-romeo-164');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(173, 'Sorento', 25, 'kia-sorento');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(174, '530', 12, 'bmw-530');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(175, 'Niva', 33, 'lada-niva');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(176, 'Scorpio', 1, 'ford-scorpio');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(177, '406', 11, 'peugeot-406');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(178, 'Legacy', 34, 'subaru-legacy');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(179, 'Country', 9, 'volksvagen-country');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(180, 'Saxo', 21, 'citroen-saxo');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(181, 'Felicia', 16, 'skoda-felicia');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(182, 'Polonez', 14, 'daewoo-polonez');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(183, 'ZX', 21, 'citroen-zx');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(184, 'Accent', 30, 'hyundai-accent');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(185, '2107', 33, 'lada-2107');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(186, 'B3', 2, 'audi-b3');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(187, 'BX', 21, 'citroen-bx');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(188, 'Omega', 5, 'opel-omega');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(189, '300M', 13, 'chrysler-300m');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(190, '340', 28, 'volvo-340');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(191, 'Xsara', 21, 'citroen-xsara');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(192, 'HRV', 3, 'honda-hrv');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(193, 'Ulysse', 10, 'fiat-ulysse');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(194, 'Thema', 35, 'lancia-thema');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(195, 'Cherokee', 23, 'jeep-cherokee');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(196, '520I', 12, 'bmw-520i');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(197, 'Samara', 33, 'lada-samara');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(198, 'Galloper', 30, 'hyundai-galloper');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(199, 'S40', 28, 'volvo-s40');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(200, '626', 32, 'mazda-626');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(201, 'Polonez Caro', 14, 'daewoo-polonez-caro');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(202, '80', 2, 'audi-80');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(203, '190', 8, 'mercedes-190');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(204, 'Coupe', 2, 'audi-coupe');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(205, 'Jetta', 9, 'volksvagen-jetta');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(206, 'Sintra', 5, 'opel-sintra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(207, 'Rocky', 24, 'daihatsu-rocky');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(208, 'A4', 2, 'audi-a4');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(209, 'Liberty', 23, 'jeep-liberty');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(210, 'Grand Voyager', 13, 'chrysler-grand-voyager');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(211, 'CX', 21, 'citroen-cx');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(212, 'Previa', 26, 'toyota-previa');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(213, 'Sportage', 25, 'kia-sportage');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(214, '200', 18, 'rover-200');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(215, 'Siena', 10, 'fiat-siena');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(216, 'Micra', 7, 'nissan-micra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(217, 'Brava', 10, 'fiat-brava');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(218, 'Calibra', 5, 'opel-calibra');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(219, 'Santa', 30, 'hyundai-santa');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(220, 'Sharan', 9, 'volksvagen-sharan');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(221, 'C2', 21, 'citroen-c2');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(222, 'Spider', 27, 'alfa-romeo-spider');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(223, 'A-KLASSE', 8, 'mercedes-a-klasse');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(224, '323', 12, 'bmw-323');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(225, '440', 28, 'volvo-440');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(226, 'MX6', 32, 'mazda-mx6');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(227, 'Explorer', 1, 'ford-explorer');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(228, 'Musso', 14, 'daewoo-musso');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(229, '100', 2, 'audi-100');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(230, '405', 11, 'peugeot-405');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(231, 'Starlet', 26, 'toyota-starlet');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(232, 'Chamade', 6, 'renault-chamade');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(233, 'Taunus', 1, 'ford-taunus');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(234, 'Sonata', 30, 'hyundai-sonata');
INSERT INTO `model` (`model_id`, `nazwa`, `marka_id`, `slug`) VALUES(235, 'V40', 28, 'volvo-v40');

--
-- Zrzut danych tabeli `wyposazenie`
--

INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(1, 'ABS', 'system antypoślizgowy', 'abs');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(2, 'AF', 'aluminiowe felgi', 'af');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(3, 'ASR', 'system blokujący poślizg kół przy starcie', 'asr');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(4, 'AL', 'autoalarm', 'al');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(5, 'AUT', 'automatyczna skrzynia biegów', 'aut');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(6, 'B', 'benzyna', 'b');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(7, 'TB', 'turbobenzyna', 'tb');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(8, 'BT', 'białe tablice', 'bt');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(9, 'G', 'gaz', 'g');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(10, 'D', 'diesel', 'd');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(11, 'TD', 'turbodiesel', 'td');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(12, 'CZ', 'centralny zamek', 'cz');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(13, 'ES', 'elektryczne szyby', 'es');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(14, 'ESx2', 'dwie elektryczne szyby', 'esx2');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(15, 'ESx4', 'cztery elektryczne szyby', 'esx4');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(16, 'EL', 'elektryczne lusterka', 'el');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(17, 'EW', 'elektroniczny wtrysk', 'ew');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(18, 'H', 'hak holowniczy', 'h');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(19, 'IMM', 'immobiliser', 'imm');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(20, 'K', 'klimatyzacja', 'k');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(21, 'AK', 'automatyczna klimatyzacja', 'ak');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(22, 'KP', 'komputer pokładowy', 'kp');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(23, 'MTL', 'Multilock', 'mtl');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(24, 'PP', 'poduszka powietrzna', 'pp');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(25, 'PPx2', 'dwie poduszki powietrzne', 'ppx2');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(26, 'PPx4', 'cztery poduszki powietrzne', 'ppx4');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(27, 'KT', 'katalizator', 'kt');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(28, 'R', 'radio', 'r');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(29, 'RM', 'radiomagnetofon', 'rm');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(30, 'RMCD', 'radiomagnetofon z CD', 'rmcd');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(31, 'SP', 'spojler', 'sp');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(32, 'ESC', 'elektryczny szyberdach', 'esc');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(33, 'SZ', 'szyberdach', 'sz');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(34, 'WK', 'wspomaganie kierownicy', 'wk');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(35, 'EWK', 'elektryczne wspomaganie kierownicy', 'ewk');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(36, '4x4', 'napęd na cztery koła', '4x4');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(37, 'RK', 'regulacja kierownicy', 'rk');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(38, 'RŚ', 'regulacja świateł', 'rs');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(39, 'BSB', 'blokada skrzyni biegów', 'bsb');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(40, 'MPI', 'wtrysk wielopunktowy', 'mpi');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(41, 'REL', 'relingi', 'rel');
INSERT INTO `wyposazenie` (`wyposazenie_id`, `skrot`, `opis`, `slug`) VALUES(42, 'BD', 'bagażnik dachowy', 'bd');

SET FOREIGN_KEY_CHECKS=1;
