set names utf8;
drop database if exists football2002;
create database football2002 default character set utf8 collate utf8_polish_ci;
grant all on football2002.* to admin@localhost identified by 'password';
flush privileges;
use football2002;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- liga
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `liga`;


CREATE TABLE `liga`
(
	`liga_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`slug` VARCHAR(128),
	PRIMARY KEY (`liga_id`),
	UNIQUE KEY `liga_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- klub
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `klub`;


CREATE TABLE `klub`
(
	`klub_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`slug` VARCHAR(128),
	`liga_id` INTEGER,
	PRIMARY KEY (`klub_id`),
	UNIQUE KEY `klub_U_1` (`slug`(128)),
	INDEX `FI_klub_liga` (`liga_id`),
	CONSTRAINT `fk_klub_liga`
		FOREIGN KEY (`liga_id`)
		REFERENCES `liga` (`liga_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- mecz
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `mecz`;


CREATE TABLE `mecz`
(
	`mecz_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`gospodarz` INTEGER,
	`gosc` INTEGER,
	`kolejka` INTEGER,
	`gol1` INTEGER,
	`gol2` INTEGER,
	`data` DATETIME,
	PRIMARY KEY (`mecz_id`),
	INDEX `FI_mecz_klub1` (`gospodarz`),
	CONSTRAINT `fk_mecz_klub1`
		FOREIGN KEY (`gospodarz`)
		REFERENCES `klub` (`klub_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_mecz_klub2` (`gosc`),
	CONSTRAINT `fk_mecz_klub2`
		FOREIGN KEY (`gosc`)
		REFERENCES `klub` (`klub_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- tabela
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `tabela`;


CREATE TABLE `tabela`
(
	`tabela_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`liga_id` INTEGER,
	`klub_id` INTEGER,
	`punkty` INTEGER,
	`bramkistracone` INTEGER,
	`bramkizdobyte` INTEGER,
	`mecze` INTEGER,
	`zwyciestwa` INTEGER,
	`remisy` INTEGER,
	`przegrane` INTEGER,
	PRIMARY KEY (`tabela_id`),
	INDEX `FI_tabela_liga1` (`liga_id`),
	CONSTRAINT `fk_tabela_liga1`
		FOREIGN KEY (`liga_id`)
		REFERENCES `liga` (`liga_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_tabela_klub1` (`klub_id`),
	CONSTRAINT `fk_tabela_klub1`
		FOREIGN KEY (`klub_id`)
		REFERENCES `klub` (`klub_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
