set names utf8;
drop database if exists danebinarne;
create database danebinarne default character set utf8 collate utf8_polish_ci;
grant all on danebinarne.* to admin@localhost identified by 'password';
flush privileges;
use danebinarne;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- plik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `plik`;


CREATE TABLE `plik`
(
	`plik_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`slug` VARCHAR(128),
	`dane` LONGBLOB,
	`typmime` VARCHAR(128),
	PRIMARY KEY (`plik_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 15 Gru 2009, 13:03
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `danebinarne`
--

--
-- Zrzut danych tabeli `plik`
--

INSERT INTO `plik` (`plik_id`, `slug`, `dane`, `typmime`) VALUES(1, 'dane', 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, 'application/pdf');

SET FOREIGN_KEY_CHECKS=1;
