<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'noth/Skrot.php';
Propel::init('noth-conf.php');


require_once 'mimetypes.inc.php';
require_once 'vh-array.inc.php';


GrupaPeer::doDeleteAll();
ImgPeer::doDeleteAll();
MenuPeer::doDeleteAll();
PlikPeer::doDeleteAll();
PuPeer::doDeleteAll();
SkrotPeer::doDeleteAll();
SkrotyPeer::doDeleteAll();

//ilustracje
$plks = glob('dane/ilustracje/*.png');
foreach ($plks as $plk) {

    $dane_img = array(
        'img'  => file_get_contents($plk),
        'slug' => preg_replace('/\.png$/', '', basename($plk))
    );

    ImgPeer::insertIfNotExists($dane_img);

}



//download
$plks = glob('dane/download/*.*');
foreach ($plks as $plk) {

    $path_parts = pathinfo($plk);

    $dane_plik = array(
        'typmime' => get_mimetype_on_ext($path_parts['extension']),
        'dane'    => file_get_contents($plk),
        'slug'    => basename($plk)
    );

    PlikPeer::insertIfNotExists($dane_plik);
}



//menu
$plk = file_get_contents('dane/menu/00lista.log');
$d = string2HArray($plk);
foreach ($d['items'] as $tmp) {

    $nazwapliku = $tmp[2];

    $dane_menu = array(
        'slug'  => $tmp[0],
        'tytul' => $tmp[1],
        'tresc' => file_get_contents('dane/menu/' . $nazwapliku)
    );

    MenuPeer::insertIfNotExists($dane_menu);
}


//podrcznik uytkownika
$plk = file_get_contents('dane/pu/00lista.log');
$d = string2HArray($plk);
foreach ($d['items'] as $tmp) {

    $nazwapliku = $tmp[2];
    $dane_pu = array(
        'slug'  => $tmp[0],
        'tytul' => $tmp[1],
        'tresc' => file_get_contents('dane/pu/' . $nazwapliku)
    );
    
    PuPeer::insertIfNotExists($dane_pu);
}




//skrty
$plk = file_get_contents('dane/skroty/00lista.log');
$d = string2HArray($plk);
foreach ($d['items'] as $tmp) {

    $nazwapliku = $tmp[2];
    
    $dane_skroty = array(
        'slug'  => $tmp[0],
        'tytul' => $tmp[1],
        'tresc' => file_get_contents('dane/skroty/' . $nazwapliku)
    );
    
    $skroty = SkrotyPeer::insert($dane_skroty);

    $grupy_tmp = preg_split('/\r?\n@\r?\n/', $dane_skroty['tresc']);
    foreach ($grupy_tmp as $tmp_grupa) {
    
        $dane_grupa = array(
            'skroty_id'  => $skroty->getSkrotyId()
        );
    
        $grupa = GrupaPeer::insert($dane_grupa);
        
        $tmp_skroty = string2HArray($tmp_grupa);
        
        foreach ($tmp_skroty['items'] as $tmp_skrot) {
            $dane_skrotu = array(
                'grupa_id' => $grupa->getGrupaId(),
                'skrot'    => $tmp_skrot[0],
                'opis'     => $tmp_skrot[1],
                'kod'      => $tmp_skrot[2],
            );
            
            SkrotPeer::insert($dane_skrotu);

        }
    }        
}