<?php

header('Content-Type: application/xml');

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();

$options = array(
    'addDecl'        => true,
    'indent'         => '    ',
    'rootName'       => 'warzywa-i-owoce',
    'encoding'       => 'utf-8',
    'defaultTagName' => array('owoce' => 'owoc', 'warzywa' => 'warzywo')
);

$serializer->setOptions($options);

$dane = array(
    'owoce' => array(
        'gruszka',
        'jabłko',
        'śliwka',
        'czereśnia'
    ),
    'warzywa' => array(
        'marchewka',
        'pietruszka',
        'cebula',
        'ogórek'
    ),    
    
);

$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

echo $wynik;
