<?php

set_time_limit(0);
header('Content-Type: text/plain');

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'autokomis/Auto.php';
require_once 'slugs.inc.php';
require_once 'wskaznik-postepu.class.php';
require_once 'Excel/reader.php';

Propel::init('autokomis-conf.php');

AutoPeer::doDeleteAll();
ModelPeer::doDeleteAll();
MarkaPeer::doDeleteAll();
WyposazeniePeer::doDeleteAll();

$con = Propel::getConnection('autokomis');
$con->exec('set names cp1250');


$data = new Spreadsheet_Excel_Reader();
$data->read('dane/auta.xls');

$wsk = new WskaznikPostepu(
    'wstawianie samochodow',
    $data->sheets[0]['numRows'],
    20
);

/*
 * WYPOSAŻENIE
 */
for ($i = 1; $i <= $data->sheets[1]['numRows']; $i++) {
    $skrot = trim($data->sheets[1]['cells'][$i][1]);
    $opis = trim($data->sheets[1]['cells'][$i][2]);    
    
    $dane_wyposazenie = array(
        'skrot' => $skrot,
        'opis' => $opis,
        'slug' => string2slug($skrot, '-', 'windows-1250')
    );
    
    $wyp = WyposazeniePeer::insertIfNotExists($dane_wyposazenie);
}



/*
 * AUTA
 */
for ($i = 2; $i <= $data->sheets[0]['numRows']; $i++) {

    $wsk->next();

    $marka = ucwords(trim($data->sheets[0]['cells'][$i][1]));
    $model = ucwords(trim($data->sheets[0]['cells'][$i][2]));
    $rocznik = trim($data->sheets[0]['cells'][$i][3]);    
    $cena = trim($data->sheets[0]['cells'][$i][4]);    
    $pojemnosc = trim($data->sheets[0]['cells'][$i][5]);    
    $przebieg = trim($data->sheets[0]['cells'][$i][6]);
    if (isset($data->sheets[0]['cells'][$i][7])) {
        $kolor = $data->sheets[0]['cells'][$i][7];
    } else {
        $kolor = '';
    }
    if (isset($data->sheets[0]['cells'][$i][8])) {
        $typ = $data->sheets[0]['cells'][$i][8];
    } else {
        $typ = '';
    }
    if (isset($data->sheets[0]['cells'][$i][9])) {
        $paliwo = $data->sheets[0]['cells'][$i][9];
    } else {
        $paliwo = '';
    }    
    if (isset($data->sheets[0]['cells'][$i][10])) {
        $wyposazenie = $data->sheets[0]['cells'][$i][10];
    } else {
        $wyposazenie = '';
    }        
    if (isset($data->sheets[0]['cells'][$i][11])) {
        $uwagi = $data->sheets[0]['cells'][$i][11];
    } else {
        $uwagi = '';
    }           
    
    
    
    /*
     * MARKA
     */
    $dane_marka = array(
        'nazwa' => $marka,
        'slug' => string2slug($marka, '-', 'windows-1250')
    );
    $objMarka = MarkaPeer::insertIfNotExists($dane_marka);
    
    
    /*
     * MODEL
     */
    $dane_model = array(
        'nazwa' => $model,
        'slug' => string2slug($marka . ' ' . $model, '-', 'windows-1250'),
        'marka_id' => $objMarka->getMarkaId()
    );
    $objModel = ModelPeer::insertIfNotExists($dane_model);
    

    /*
     * AUTO
     */
    $dane_auto = array(
        'rocznik' => $rocznik,
        'cena' => $cena,
        'pojemnosc' => $pojemnosc,
        'przebieg' => $przebieg,
        'kolor' => $kolor,
        'typ' => $typ,
        'paliwo' => $paliwo,
        'uwagi' => $uwagi,
        'slug' => string2slug(
            $objMarka->getNazwa() . ' ' .
            $objModel->getNazwa() . ' ' .
            $typ . ' ' .
            $rocznik . ' ' .
            $kolor . ' ' .
            $pojemnosc,
            '-', 'windows-1250'
        ),
        'model_id' => $objModel->getModelId()
    );
    
    $objAuto = AutoPeer::insert($dane_auto);


    /*
     * WYPOSAŻENIE
     */
    if ($wyposazenie) {
        $el = explode(',', $wyposazenie);
        foreach ($el as $elementwyposazenia) {
            $tmp = trim($elementwyposazenia);

            $objWyp = WyposazeniePeer::retrieveBySkrot($tmp);

            if ($objWyp) {
                $ahw = new AutoHasWyposazenie();
                $ahw->setAuto($objAuto);
                $ahw->setWyposazenie($objWyp);
                $ahw->save();
            }
        }

    } 
    
}








