<?php

require 'autokomis/om/BaseMarkaPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'marka' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    autokomis
 */
class MarkaPeer extends BaseMarkaPeer {

    public static function insertIfNotExists($dane)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $dane['slug']);
        $tmp = parent::doSelectOne($c);
        if (!$tmp) {
            $tmp = new Marka();
            $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
            $tmp->save();
        }
        return $tmp;
    }
    
    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        $criteria->addAscendingOrderByColumn(MarkaPeer::NAZWA);
        return parent::doSelect($criteria, $con);
    }

    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }


} // MarkaPeer
