<?php

/**
 * Base class that represents a row from the 'waluta' table.
 *
 * 
 *
 * @package    kursywalut.om
 */
abstract class BaseWaluta extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        WalutaPeer
	 */
	protected static $peer;

	/**
	 * The value for the waluta_id field.
	 * @var        int
	 */
	protected $waluta_id;

	/**
	 * The value for the nazwa field.
	 * @var        string
	 */
	protected $nazwa;

	/**
	 * The value for the przelicznik field.
	 * @var        string
	 */
	protected $przelicznik;

	/**
	 * The value for the kod field.
	 * @var        string
	 */
	protected $kod;

	/**
	 * The value for the slug field.
	 * @var        string
	 */
	protected $slug;

	/**
	 * @var        array Kurs[] Collection to store aggregation of Kurs objects.
	 */
	protected $collKurss;

	/**
	 * @var        Criteria The criteria used to select the current contents of collKurss.
	 */
	private $lastKursCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseWaluta object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [waluta_id] column value.
	 * 
	 * @return     int
	 */
	public function getWalutaId()
	{
		return $this->waluta_id;
	}

	/**
	 * Get the [nazwa] column value.
	 * 
	 * @return     string
	 */
	public function getNazwa()
	{
		return $this->nazwa;
	}

	/**
	 * Get the [przelicznik] column value.
	 * 
	 * @return     string
	 */
	public function getPrzelicznik()
	{
		return $this->przelicznik;
	}

	/**
	 * Get the [kod] column value.
	 * 
	 * @return     string
	 */
	public function getKod()
	{
		return $this->kod;
	}

	/**
	 * Get the [slug] column value.
	 * 
	 * @return     string
	 */
	public function getSlug()
	{
		return $this->slug;
	}

	/**
	 * Set the value of [waluta_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Waluta The current object (for fluent API support)
	 */
	public function setWalutaId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->waluta_id !== $v) {
			$this->waluta_id = $v;
			$this->modifiedColumns[] = WalutaPeer::WALUTA_ID;
		}

		return $this;
	} // setWalutaId()

	/**
	 * Set the value of [nazwa] column.
	 * 
	 * @param      string $v new value
	 * @return     Waluta The current object (for fluent API support)
	 */
	public function setNazwa($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->nazwa !== $v) {
			$this->nazwa = $v;
			$this->modifiedColumns[] = WalutaPeer::NAZWA;
		}

		return $this;
	} // setNazwa()

	/**
	 * Set the value of [przelicznik] column.
	 * 
	 * @param      string $v new value
	 * @return     Waluta The current object (for fluent API support)
	 */
	public function setPrzelicznik($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->przelicznik !== $v) {
			$this->przelicznik = $v;
			$this->modifiedColumns[] = WalutaPeer::PRZELICZNIK;
		}

		return $this;
	} // setPrzelicznik()

	/**
	 * Set the value of [kod] column.
	 * 
	 * @param      string $v new value
	 * @return     Waluta The current object (for fluent API support)
	 */
	public function setKod($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->kod !== $v) {
			$this->kod = $v;
			$this->modifiedColumns[] = WalutaPeer::KOD;
		}

		return $this;
	} // setKod()

	/**
	 * Set the value of [slug] column.
	 * 
	 * @param      string $v new value
	 * @return     Waluta The current object (for fluent API support)
	 */
	public function setSlug($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->slug !== $v) {
			$this->slug = $v;
			$this->modifiedColumns[] = WalutaPeer::SLUG;
		}

		return $this;
	} // setSlug()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->waluta_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->nazwa = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->przelicznik = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->kod = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->slug = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 5; // 5 = WalutaPeer::NUM_COLUMNS - WalutaPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Waluta object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WalutaPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = WalutaPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->collKurss = null;
			$this->lastKursCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WalutaPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			WalutaPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WalutaPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
			WalutaPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			if ($this->isNew() ) {
				$this->modifiedColumns[] = WalutaPeer::WALUTA_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = WalutaPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setWalutaId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += WalutaPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collKurss !== null) {
				foreach ($this->collKurss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = WalutaPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collKurss !== null) {
					foreach ($this->collKurss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WalutaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getWalutaId();
				break;
			case 1:
				return $this->getNazwa();
				break;
			case 2:
				return $this->getPrzelicznik();
				break;
			case 3:
				return $this->getKod();
				break;
			case 4:
				return $this->getSlug();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = WalutaPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getWalutaId(),
			$keys[1] => $this->getNazwa(),
			$keys[2] => $this->getPrzelicznik(),
			$keys[3] => $this->getKod(),
			$keys[4] => $this->getSlug(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WalutaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setWalutaId($value);
				break;
			case 1:
				$this->setNazwa($value);
				break;
			case 2:
				$this->setPrzelicznik($value);
				break;
			case 3:
				$this->setKod($value);
				break;
			case 4:
				$this->setSlug($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WalutaPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setWalutaId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setNazwa($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setPrzelicznik($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setKod($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setSlug($arr[$keys[4]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(WalutaPeer::DATABASE_NAME);

		if ($this->isColumnModified(WalutaPeer::WALUTA_ID)) $criteria->add(WalutaPeer::WALUTA_ID, $this->waluta_id);
		if ($this->isColumnModified(WalutaPeer::NAZWA)) $criteria->add(WalutaPeer::NAZWA, $this->nazwa);
		if ($this->isColumnModified(WalutaPeer::PRZELICZNIK)) $criteria->add(WalutaPeer::PRZELICZNIK, $this->przelicznik);
		if ($this->isColumnModified(WalutaPeer::KOD)) $criteria->add(WalutaPeer::KOD, $this->kod);
		if ($this->isColumnModified(WalutaPeer::SLUG)) $criteria->add(WalutaPeer::SLUG, $this->slug);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(WalutaPeer::DATABASE_NAME);

		$criteria->add(WalutaPeer::WALUTA_ID, $this->waluta_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getWalutaId();
	}

	/**
	 * Generic method to set the primary key (waluta_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setWalutaId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Waluta (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setNazwa($this->nazwa);

		$copyObj->setPrzelicznik($this->przelicznik);

		$copyObj->setKod($this->kod);

		$copyObj->setSlug($this->slug);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getKurss() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addKurs($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setWalutaId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Waluta Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     WalutaPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new WalutaPeer();
		}
		return self::$peer;
	}

	/**
	 * Clears out the collKurss collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addKurss()
	 */
	public function clearKurss()
	{
		$this->collKurss = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collKurss collection (array).
	 *
	 * By default this just sets the collKurss collection to an empty array (like clearcollKurss());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initKurss()
	{
		$this->collKurss = array();
	}

	/**
	 * Gets an array of Kurs objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Waluta has previously been saved, it will retrieve
	 * related Kurss from storage. If this Waluta is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Kurs[]
	 * @throws     PropelException
	 */
	public function getKurss($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(WalutaPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collKurss === null) {
			if ($this->isNew()) {
			   $this->collKurss = array();
			} else {

				$criteria->add(KursPeer::WALUTA_ID, $this->waluta_id);

				KursPeer::addSelectColumns($criteria);
				$this->collKurss = KursPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(KursPeer::WALUTA_ID, $this->waluta_id);

				KursPeer::addSelectColumns($criteria);
				if (!isset($this->lastKursCriteria) || !$this->lastKursCriteria->equals($criteria)) {
					$this->collKurss = KursPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastKursCriteria = $criteria;
		return $this->collKurss;
	}

	/**
	 * Returns the number of related Kurs objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Kurs objects.
	 * @throws     PropelException
	 */
	public function countKurss(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(WalutaPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collKurss === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(KursPeer::WALUTA_ID, $this->waluta_id);

				$count = KursPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(KursPeer::WALUTA_ID, $this->waluta_id);

				if (!isset($this->lastKursCriteria) || !$this->lastKursCriteria->equals($criteria)) {
					$count = KursPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collKurss);
				}
			} else {
				$count = count($this->collKurss);
			}
		}
		$this->lastKursCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Kurs object to this object
	 * through the Kurs foreign key attribute.
	 *
	 * @param      Kurs $l Kurs
	 * @return     void
	 * @throws     PropelException
	 */
	public function addKurs(Kurs $l)
	{
		if ($this->collKurss === null) {
			$this->initKurss();
		}
		if (!in_array($l, $this->collKurss, true)) { // only add it if the **same** object is not already associated
			array_push($this->collKurss, $l);
			$l->setWaluta($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Waluta is new, it will return
	 * an empty collection; or if this Waluta has previously
	 * been saved, it will retrieve related Kurss from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Waluta.
	 */
	public function getKurssJoinTabela($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(WalutaPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collKurss === null) {
			if ($this->isNew()) {
				$this->collKurss = array();
			} else {

				$criteria->add(KursPeer::WALUTA_ID, $this->waluta_id);

				$this->collKurss = KursPeer::doSelectJoinTabela($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(KursPeer::WALUTA_ID, $this->waluta_id);

			if (!isset($this->lastKursCriteria) || !$this->lastKursCriteria->equals($criteria)) {
				$this->collKurss = KursPeer::doSelectJoinTabela($criteria, $con, $join_behavior);
			}
		}
		$this->lastKursCriteria = $criteria;

		return $this->collKurss;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collKurss) {
				foreach ((array) $this->collKurss as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collKurss = null;
	}

} // BaseWaluta
