<?php

require 'kursywalut/om/BaseWaluta.php';


/**
 * Skeleton subclass for representing a row from the 'waluta' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    kursywalut
 */
class Waluta extends BaseWaluta {

	/**
	 * Initializes internal state of Waluta object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
    public function __toString()
    {
        return $this->getNazwa();
    }
    
    public function podajKursy($criteria = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        $criteria->addJoin(WalutaPeer::WALUTA_ID, KursPeer::WALUTA_ID);
        $criteria->addJoin(KursPeer::TABELA_ID, TabelaPeer::TABELA_ID);
        $criteria->addAscendingOrderByColumn(TabelaPeer::DATAPUBLIKACJI);
        
        $tmp = $this->getKurss($criteria);
        $wynik = array();
        foreach ($tmp as $wartosc) {
            $wynik[] = $wartosc->getKurssredni();
        }
        
        return $wynik;

    }


} // Waluta
