<?php


/**
 * This class adds structure of 'rozdzial' table to 'phppp' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    phppp.map
 */
class RozdzialMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'phppp.map.RozdzialMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(RozdzialPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(RozdzialPeer::TABLE_NAME);
		$tMap->setPhpName('Rozdzial');
		$tMap->setClassname('Rozdzial');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('ROZDZIAL_ID', 'RozdzialId', 'INTEGER', true, null);

		$tMap->addForeignKey('CZESC_ID', 'CzescId', 'INTEGER', 'czesc', 'CZESC_ID', true, null);

		$tMap->addColumn('TYTUL', 'Tytul', 'VARCHAR', false, 255);

		$tMap->addColumn('NUMER', 'Numer', 'INTEGER', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', false, 45);

	} // doBuild()

} // RozdzialMapBuilder
