<?php


/**
 * This class adds structure of 'projekt' table to 'phppp' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    phppp.map
 */
class ProjektMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'phppp.map.ProjektMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(ProjektPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(ProjektPeer::TABLE_NAME);
		$tMap->setPhpName('Projekt');
		$tMap->setClassname('Projekt');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('PROJEKT_ID', 'ProjektId', 'INTEGER', true, null);

		$tMap->addForeignKey('ROZDZIAL_ID', 'RozdzialId', 'INTEGER', 'rozdzial', 'ROZDZIAL_ID', true, null);

		$tMap->addColumn('TYTUL', 'Tytul', 'VARCHAR', false, 255);

		$tMap->addColumn('NUMER', 'Numer', 'INTEGER', false, null);

		$tMap->addColumn('NUMERPELNY', 'Numerpelny', 'VARCHAR', false, 20);

		$tMap->addColumn('FOLDER', 'Folder', 'VARCHAR', false, 45);

		$tMap->addColumn('PLIK', 'Plik', 'VARCHAR', false, 45);

		$tMap->addColumn('DANE', 'Dane', 'INTEGER', false, null);

		$tMap->addColumn('PREVIEW', 'Preview', 'INTEGER', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', false, 45);

	} // doBuild()

} // ProjektMapBuilder
