<?php



class WskaznikRozdzialu extends Pointer 
{

    function getFirst()
    {
        $c = new Criteria();
        $c->setLimit(1);                                
        $c->addAscendingOrderByColumn(RozdzialPeer::SLUG);
        if ($tmp = RozdzialPeer::doSelectOne($c)) {
            $this->ptr_first = $tmp;
            if ($this->ptr_current && ($this->ptr_first->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_first = false;
            }
        }
    }
    
    
    function getPrevious()
    {
        if ($this->ptr_current) {
            $c = new Criteria();
            $c->setLimit(1);                                
            $c->addDescendingOrderByColumn(RozdzialPeer::SLUG);
            $c->add(RozdzialPeer::SLUG, $this->ptr_current->getSlug(), Criteria::LESS_THAN);
            if ($tmp = RozdzialPeer::doSelectOne($c)) {
                $this->ptr_previous = $tmp;
            }            
        };
    }    
    
    function getNext()
    {
        if ($this->ptr_current) {
            $c = new Criteria();
            $c->setLimit(1);                                
            $c->addAscendingOrderByColumn(RozdzialPeer::SLUG);
            $c->add(RozdzialPeer::SLUG, $this->ptr_current->getSlug(), Criteria::GREATER_THAN);
            if ($tmp = RozdzialPeer::doSelectOne($c)) {
                $this->ptr_next = $tmp;
            }            
        }
    }        
    
    
    function getLast()
    {
        $c = new Criteria();
        $c->setLimit(1);                                
        $c->addDescendingOrderByColumn(RozdzialPeer::SLUG);
        if ($tmp = RozdzialPeer::doSelectOne($c)) {
            $this->ptr_last = $tmp;
            if ($this->ptr_current && ($this->ptr_last->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_last = false;
            }
        }                    
    }    


}