
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- img
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `img`;


CREATE TABLE `img`
(
	`img_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`slug` VARCHAR(128),
	`svg` LONGBLOB,
	`png` LONGBLOB,
	`minipng` LONGBLOB,
	`has_preview` INTEGER default 0,
	PRIMARY KEY (`img_id`),
	UNIQUE KEY `img_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- tag
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `tag`;


CREATE TABLE `tag`
(
	`tag_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tag` VARCHAR(255),
	`imgs_count` INTEGER default 0,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`tag_id`),
	UNIQUE KEY `tag_U_1` (`slug`(128)),
	UNIQUE KEY `tag_U_2` (`tag`(255))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- img_has_tag
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `img_has_tag`;


CREATE TABLE `img_has_tag`
(
	`img_id` INTEGER  NOT NULL,
	`tag_id` INTEGER  NOT NULL,
	PRIMARY KEY (`img_id`,`tag_id`),
	CONSTRAINT `fk_img_has_tag_img`
		FOREIGN KEY (`img_id`)
		REFERENCES `img` (`img_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_img_has_tag_tag` (`tag_id`),
	CONSTRAINT `fk_img_has_tag_tag`
		FOREIGN KEY (`tag_id`)
		REFERENCES `tag` (`tag_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
