<?php


/**
 * This class adds structure of 'dvd' table to 'sklep' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    sklep.map
 */
class DvdMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'sklep.map.DvdMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(DvdPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(DvdPeer::TABLE_NAME);
		$tMap->setPhpName('Dvd');
		$tMap->setClassname('Dvd');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('DVD_ID', 'DvdId', 'INTEGER', true, null);

		$tMap->addColumn('NUMER', 'Numer', 'INTEGER', false, null);

		$tMap->addColumn('LICZBAFOTEK', 'Liczbafotek', 'INTEGER', false, null);

		$tMap->addColumn('LICZBAKATEGORII', 'Liczbakategorii', 'INTEGER', false, null);

		$tMap->addColumn('DATAWYDANIA', 'Datawydania', 'VARCHAR', false, 128);

		$tMap->addColumn('WYDANIE', 'Wydanie', 'VARCHAR', false, 45);

		$tMap->addColumn('OKLADKA', 'Okladka', 'BLOB', false, null);

		$tMap->addColumn('OKLADKA_PRINT', 'OkladkaPrint', 'BLOB', false, null);

	} // doBuild()

} // DvdMapBuilder
