<?php


function search_files(
    $ADirName         = './',
    $AExt             = '/.*/',
    $ARecursive       = true
)
{

    if (substr($ADirName, strlen($ADirName) - 1, 1) != '/') {
        $ADirName .= '/';
    }
    
    if (($handle = opendir($ADirName)) !== false) {
        $files = array();
        while (false !== ($next = readdir($handle))) {
            if ($next != '.' && $next != '..') {
                $tmp = $ADirName . $next;
                if (is_dir($tmp)) {
                    $tmp  .= '/';
                    $next .= '/';
                    if ($ARecursive) {
                        $recfiles = search_files(
                            $tmp, $AExt,
                            $ARecursive
                        );
                        if ($recfiles) {
                            $files = array_merge($files, $recfiles);
                        };
                    };
                } else if (is_file($tmp) && preg_match($AExt, $next)) {
                       $files[] = $tmp;
                }
            };
        };
        closedir($handle);
        return $files;
    } else {
        return false;
    }
}
