<?php

/**
 * Base class that represents a row from the 'artykul' table.
 *
 * 
 *
 * @package    artykulymi.om
 */
abstract class BaseArtykul extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        ArtykulPeer
	 */
	protected static $peer;

	/**
	 * The value for the artykul_id field.
	 * @var        int
	 */
	protected $artykul_id;

	/**
	 * The value for the tytul field.
	 * @var        string
	 */
	protected $tytul;

	/**
	 * The value for the lid field.
	 * @var        string
	 */
	protected $lid;

	/**
	 * The value for the start field.
	 * @var        int
	 */
	protected $start;

	/**
	 * The value for the stop field.
	 * @var        int
	 */
	protected $stop;

	/**
	 * The value for the slug field.
	 * @var        string
	 */
	protected $slug;

	/**
	 * The value for the rubryka_id field.
	 * @var        int
	 */
	protected $rubryka_id;

	/**
	 * The value for the podrubryka_id field.
	 * @var        int
	 */
	protected $podrubryka_id;

	/**
	 * The value for the numer_id field.
	 * @var        int
	 */
	protected $numer_id;

	/**
	 * The value for the liczbastron field.
	 * @var        int
	 */
	protected $liczbastron;

	/**
	 * @var        Rubryka
	 */
	protected $aRubryka;

	/**
	 * @var        Podrubryka
	 */
	protected $aPodrubryka;

	/**
	 * @var        Numer
	 */
	protected $aNumer;

	/**
	 * @var        array ArtykulHasAutor[] Collection to store aggregation of ArtykulHasAutor objects.
	 */
	protected $collArtykulHasAutors;

	/**
	 * @var        Criteria The criteria used to select the current contents of collArtykulHasAutors.
	 */
	private $lastArtykulHasAutorCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseArtykul object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [artykul_id] column value.
	 * 
	 * @return     int
	 */
	public function getArtykulId()
	{
		return $this->artykul_id;
	}

	/**
	 * Get the [tytul] column value.
	 * 
	 * @return     string
	 */
	public function getTytul()
	{
		return $this->tytul;
	}

	/**
	 * Get the [lid] column value.
	 * 
	 * @return     string
	 */
	public function getLid()
	{
		return $this->lid;
	}

	/**
	 * Get the [start] column value.
	 * 
	 * @return     int
	 */
	public function getStart()
	{
		return $this->start;
	}

	/**
	 * Get the [stop] column value.
	 * 
	 * @return     int
	 */
	public function getStop()
	{
		return $this->stop;
	}

	/**
	 * Get the [slug] column value.
	 * 
	 * @return     string
	 */
	public function getSlug()
	{
		return $this->slug;
	}

	/**
	 * Get the [rubryka_id] column value.
	 * 
	 * @return     int
	 */
	public function getRubrykaId()
	{
		return $this->rubryka_id;
	}

	/**
	 * Get the [podrubryka_id] column value.
	 * 
	 * @return     int
	 */
	public function getPodrubrykaId()
	{
		return $this->podrubryka_id;
	}

	/**
	 * Get the [numer_id] column value.
	 * 
	 * @return     int
	 */
	public function getNumerId()
	{
		return $this->numer_id;
	}

	/**
	 * Get the [liczbastron] column value.
	 * 
	 * @return     int
	 */
	public function getLiczbastron()
	{
		return $this->liczbastron;
	}

	/**
	 * Set the value of [artykul_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setArtykulId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->artykul_id !== $v) {
			$this->artykul_id = $v;
			$this->modifiedColumns[] = ArtykulPeer::ARTYKUL_ID;
		}

		return $this;
	} // setArtykulId()

	/**
	 * Set the value of [tytul] column.
	 * 
	 * @param      string $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setTytul($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->tytul !== $v) {
			$this->tytul = $v;
			$this->modifiedColumns[] = ArtykulPeer::TYTUL;
		}

		return $this;
	} // setTytul()

	/**
	 * Set the value of [lid] column.
	 * 
	 * @param      string $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setLid($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->lid !== $v) {
			$this->lid = $v;
			$this->modifiedColumns[] = ArtykulPeer::LID;
		}

		return $this;
	} // setLid()

	/**
	 * Set the value of [start] column.
	 * 
	 * @param      int $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setStart($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->start !== $v) {
			$this->start = $v;
			$this->modifiedColumns[] = ArtykulPeer::START;
		}

		return $this;
	} // setStart()

	/**
	 * Set the value of [stop] column.
	 * 
	 * @param      int $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setStop($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->stop !== $v) {
			$this->stop = $v;
			$this->modifiedColumns[] = ArtykulPeer::STOP;
		}

		return $this;
	} // setStop()

	/**
	 * Set the value of [slug] column.
	 * 
	 * @param      string $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setSlug($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->slug !== $v) {
			$this->slug = $v;
			$this->modifiedColumns[] = ArtykulPeer::SLUG;
		}

		return $this;
	} // setSlug()

	/**
	 * Set the value of [rubryka_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setRubrykaId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->rubryka_id !== $v) {
			$this->rubryka_id = $v;
			$this->modifiedColumns[] = ArtykulPeer::RUBRYKA_ID;
		}

		if ($this->aRubryka !== null && $this->aRubryka->getRubrykaId() !== $v) {
			$this->aRubryka = null;
		}

		return $this;
	} // setRubrykaId()

	/**
	 * Set the value of [podrubryka_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setPodrubrykaId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->podrubryka_id !== $v) {
			$this->podrubryka_id = $v;
			$this->modifiedColumns[] = ArtykulPeer::PODRUBRYKA_ID;
		}

		if ($this->aPodrubryka !== null && $this->aPodrubryka->getPodrubrykaId() !== $v) {
			$this->aPodrubryka = null;
		}

		return $this;
	} // setPodrubrykaId()

	/**
	 * Set the value of [numer_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setNumerId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->numer_id !== $v) {
			$this->numer_id = $v;
			$this->modifiedColumns[] = ArtykulPeer::NUMER_ID;
		}

		if ($this->aNumer !== null && $this->aNumer->getNumerId() !== $v) {
			$this->aNumer = null;
		}

		return $this;
	} // setNumerId()

	/**
	 * Set the value of [liczbastron] column.
	 * 
	 * @param      int $v new value
	 * @return     Artykul The current object (for fluent API support)
	 */
	public function setLiczbastron($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->liczbastron !== $v) {
			$this->liczbastron = $v;
			$this->modifiedColumns[] = ArtykulPeer::LICZBASTRON;
		}

		return $this;
	} // setLiczbastron()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->artykul_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->tytul = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->lid = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->start = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
			$this->stop = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
			$this->slug = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
			$this->rubryka_id = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
			$this->podrubryka_id = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
			$this->numer_id = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
			$this->liczbastron = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 10; // 10 = ArtykulPeer::NUM_COLUMNS - ArtykulPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Artykul object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->aRubryka !== null && $this->rubryka_id !== $this->aRubryka->getRubrykaId()) {
			$this->aRubryka = null;
		}
		if ($this->aPodrubryka !== null && $this->podrubryka_id !== $this->aPodrubryka->getPodrubrykaId()) {
			$this->aPodrubryka = null;
		}
		if ($this->aNumer !== null && $this->numer_id !== $this->aNumer->getNumerId()) {
			$this->aNumer = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ArtykulPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = ArtykulPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->aRubryka = null;
			$this->aPodrubryka = null;
			$this->aNumer = null;
			$this->collArtykulHasAutors = null;
			$this->lastArtykulHasAutorCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ArtykulPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			ArtykulPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ArtykulPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
			ArtykulPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aRubryka !== null) {
				if ($this->aRubryka->isModified() || $this->aRubryka->isNew()) {
					$affectedRows += $this->aRubryka->save($con);
				}
				$this->setRubryka($this->aRubryka);
			}

			if ($this->aPodrubryka !== null) {
				if ($this->aPodrubryka->isModified() || $this->aPodrubryka->isNew()) {
					$affectedRows += $this->aPodrubryka->save($con);
				}
				$this->setPodrubryka($this->aPodrubryka);
			}

			if ($this->aNumer !== null) {
				if ($this->aNumer->isModified() || $this->aNumer->isNew()) {
					$affectedRows += $this->aNumer->save($con);
				}
				$this->setNumer($this->aNumer);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = ArtykulPeer::ARTYKUL_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ArtykulPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setArtykulId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += ArtykulPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collArtykulHasAutors !== null) {
				foreach ($this->collArtykulHasAutors as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aRubryka !== null) {
				if (!$this->aRubryka->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aRubryka->getValidationFailures());
				}
			}

			if ($this->aPodrubryka !== null) {
				if (!$this->aPodrubryka->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aPodrubryka->getValidationFailures());
				}
			}

			if ($this->aNumer !== null) {
				if (!$this->aNumer->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aNumer->getValidationFailures());
				}
			}


			if (($retval = ArtykulPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collArtykulHasAutors !== null) {
					foreach ($this->collArtykulHasAutors as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ArtykulPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getArtykulId();
				break;
			case 1:
				return $this->getTytul();
				break;
			case 2:
				return $this->getLid();
				break;
			case 3:
				return $this->getStart();
				break;
			case 4:
				return $this->getStop();
				break;
			case 5:
				return $this->getSlug();
				break;
			case 6:
				return $this->getRubrykaId();
				break;
			case 7:
				return $this->getPodrubrykaId();
				break;
			case 8:
				return $this->getNumerId();
				break;
			case 9:
				return $this->getLiczbastron();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = ArtykulPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getArtykulId(),
			$keys[1] => $this->getTytul(),
			$keys[2] => $this->getLid(),
			$keys[3] => $this->getStart(),
			$keys[4] => $this->getStop(),
			$keys[5] => $this->getSlug(),
			$keys[6] => $this->getRubrykaId(),
			$keys[7] => $this->getPodrubrykaId(),
			$keys[8] => $this->getNumerId(),
			$keys[9] => $this->getLiczbastron(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ArtykulPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setArtykulId($value);
				break;
			case 1:
				$this->setTytul($value);
				break;
			case 2:
				$this->setLid($value);
				break;
			case 3:
				$this->setStart($value);
				break;
			case 4:
				$this->setStop($value);
				break;
			case 5:
				$this->setSlug($value);
				break;
			case 6:
				$this->setRubrykaId($value);
				break;
			case 7:
				$this->setPodrubrykaId($value);
				break;
			case 8:
				$this->setNumerId($value);
				break;
			case 9:
				$this->setLiczbastron($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ArtykulPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setArtykulId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setTytul($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setLid($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setStart($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setStop($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setSlug($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setRubrykaId($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setPodrubrykaId($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setNumerId($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setLiczbastron($arr[$keys[9]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(ArtykulPeer::DATABASE_NAME);

		if ($this->isColumnModified(ArtykulPeer::ARTYKUL_ID)) $criteria->add(ArtykulPeer::ARTYKUL_ID, $this->artykul_id);
		if ($this->isColumnModified(ArtykulPeer::TYTUL)) $criteria->add(ArtykulPeer::TYTUL, $this->tytul);
		if ($this->isColumnModified(ArtykulPeer::LID)) $criteria->add(ArtykulPeer::LID, $this->lid);
		if ($this->isColumnModified(ArtykulPeer::START)) $criteria->add(ArtykulPeer::START, $this->start);
		if ($this->isColumnModified(ArtykulPeer::STOP)) $criteria->add(ArtykulPeer::STOP, $this->stop);
		if ($this->isColumnModified(ArtykulPeer::SLUG)) $criteria->add(ArtykulPeer::SLUG, $this->slug);
		if ($this->isColumnModified(ArtykulPeer::RUBRYKA_ID)) $criteria->add(ArtykulPeer::RUBRYKA_ID, $this->rubryka_id);
		if ($this->isColumnModified(ArtykulPeer::PODRUBRYKA_ID)) $criteria->add(ArtykulPeer::PODRUBRYKA_ID, $this->podrubryka_id);
		if ($this->isColumnModified(ArtykulPeer::NUMER_ID)) $criteria->add(ArtykulPeer::NUMER_ID, $this->numer_id);
		if ($this->isColumnModified(ArtykulPeer::LICZBASTRON)) $criteria->add(ArtykulPeer::LICZBASTRON, $this->liczbastron);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ArtykulPeer::DATABASE_NAME);

		$criteria->add(ArtykulPeer::ARTYKUL_ID, $this->artykul_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getArtykulId();
	}

	/**
	 * Generic method to set the primary key (artykul_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setArtykulId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Artykul (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setTytul($this->tytul);

		$copyObj->setLid($this->lid);

		$copyObj->setStart($this->start);

		$copyObj->setStop($this->stop);

		$copyObj->setSlug($this->slug);

		$copyObj->setRubrykaId($this->rubryka_id);

		$copyObj->setPodrubrykaId($this->podrubryka_id);

		$copyObj->setNumerId($this->numer_id);

		$copyObj->setLiczbastron($this->liczbastron);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getArtykulHasAutors() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addArtykulHasAutor($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setArtykulId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Artykul Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     ArtykulPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ArtykulPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Rubryka object.
	 *
	 * @param      Rubryka $v
	 * @return     Artykul The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setRubryka(Rubryka $v = null)
	{
		if ($v === null) {
			$this->setRubrykaId(NULL);
		} else {
			$this->setRubrykaId($v->getRubrykaId());
		}

		$this->aRubryka = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Rubryka object, it will not be re-added.
		if ($v !== null) {
			$v->addArtykul($this);
		}

		return $this;
	}


	/**
	 * Get the associated Rubryka object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Rubryka The associated Rubryka object.
	 * @throws     PropelException
	 */
	public function getRubryka(PropelPDO $con = null)
	{
		if ($this->aRubryka === null && ($this->rubryka_id !== null)) {
			$this->aRubryka = RubrykaPeer::retrieveByPK($this->rubryka_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aRubryka->addArtykuls($this);
			 */
		}
		return $this->aRubryka;
	}

	/**
	 * Declares an association between this object and a Podrubryka object.
	 *
	 * @param      Podrubryka $v
	 * @return     Artykul The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setPodrubryka(Podrubryka $v = null)
	{
		if ($v === null) {
			$this->setPodrubrykaId(NULL);
		} else {
			$this->setPodrubrykaId($v->getPodrubrykaId());
		}

		$this->aPodrubryka = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Podrubryka object, it will not be re-added.
		if ($v !== null) {
			$v->addArtykul($this);
		}

		return $this;
	}


	/**
	 * Get the associated Podrubryka object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Podrubryka The associated Podrubryka object.
	 * @throws     PropelException
	 */
	public function getPodrubryka(PropelPDO $con = null)
	{
		if ($this->aPodrubryka === null && ($this->podrubryka_id !== null)) {
			$this->aPodrubryka = PodrubrykaPeer::retrieveByPK($this->podrubryka_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aPodrubryka->addArtykuls($this);
			 */
		}
		return $this->aPodrubryka;
	}

	/**
	 * Declares an association between this object and a Numer object.
	 *
	 * @param      Numer $v
	 * @return     Artykul The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setNumer(Numer $v = null)
	{
		if ($v === null) {
			$this->setNumerId(NULL);
		} else {
			$this->setNumerId($v->getNumerId());
		}

		$this->aNumer = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Numer object, it will not be re-added.
		if ($v !== null) {
			$v->addArtykul($this);
		}

		return $this;
	}


	/**
	 * Get the associated Numer object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Numer The associated Numer object.
	 * @throws     PropelException
	 */
	public function getNumer(PropelPDO $con = null)
	{
		if ($this->aNumer === null && ($this->numer_id !== null)) {
			$this->aNumer = NumerPeer::retrieveByPK($this->numer_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aNumer->addArtykuls($this);
			 */
		}
		return $this->aNumer;
	}

	/**
	 * Clears out the collArtykulHasAutors collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addArtykulHasAutors()
	 */
	public function clearArtykulHasAutors()
	{
		$this->collArtykulHasAutors = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collArtykulHasAutors collection (array).
	 *
	 * By default this just sets the collArtykulHasAutors collection to an empty array (like clearcollArtykulHasAutors());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initArtykulHasAutors()
	{
		$this->collArtykulHasAutors = array();
	}

	/**
	 * Gets an array of ArtykulHasAutor objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Artykul has previously been saved, it will retrieve
	 * related ArtykulHasAutors from storage. If this Artykul is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array ArtykulHasAutor[]
	 * @throws     PropelException
	 */
	public function getArtykulHasAutors($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ArtykulPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collArtykulHasAutors === null) {
			if ($this->isNew()) {
			   $this->collArtykulHasAutors = array();
			} else {

				$criteria->add(ArtykulHasAutorPeer::ARTYKUL_ID, $this->artykul_id);

				ArtykulHasAutorPeer::addSelectColumns($criteria);
				$this->collArtykulHasAutors = ArtykulHasAutorPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(ArtykulHasAutorPeer::ARTYKUL_ID, $this->artykul_id);

				ArtykulHasAutorPeer::addSelectColumns($criteria);
				if (!isset($this->lastArtykulHasAutorCriteria) || !$this->lastArtykulHasAutorCriteria->equals($criteria)) {
					$this->collArtykulHasAutors = ArtykulHasAutorPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastArtykulHasAutorCriteria = $criteria;
		return $this->collArtykulHasAutors;
	}

	/**
	 * Returns the number of related ArtykulHasAutor objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related ArtykulHasAutor objects.
	 * @throws     PropelException
	 */
	public function countArtykulHasAutors(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ArtykulPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collArtykulHasAutors === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(ArtykulHasAutorPeer::ARTYKUL_ID, $this->artykul_id);

				$count = ArtykulHasAutorPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(ArtykulHasAutorPeer::ARTYKUL_ID, $this->artykul_id);

				if (!isset($this->lastArtykulHasAutorCriteria) || !$this->lastArtykulHasAutorCriteria->equals($criteria)) {
					$count = ArtykulHasAutorPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collArtykulHasAutors);
				}
			} else {
				$count = count($this->collArtykulHasAutors);
			}
		}
		$this->lastArtykulHasAutorCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a ArtykulHasAutor object to this object
	 * through the ArtykulHasAutor foreign key attribute.
	 *
	 * @param      ArtykulHasAutor $l ArtykulHasAutor
	 * @return     void
	 * @throws     PropelException
	 */
	public function addArtykulHasAutor(ArtykulHasAutor $l)
	{
		if ($this->collArtykulHasAutors === null) {
			$this->initArtykulHasAutors();
		}
		if (!in_array($l, $this->collArtykulHasAutors, true)) { // only add it if the **same** object is not already associated
			array_push($this->collArtykulHasAutors, $l);
			$l->setArtykul($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Artykul is new, it will return
	 * an empty collection; or if this Artykul has previously
	 * been saved, it will retrieve related ArtykulHasAutors from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Artykul.
	 */
	public function getArtykulHasAutorsJoinAutor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ArtykulPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collArtykulHasAutors === null) {
			if ($this->isNew()) {
				$this->collArtykulHasAutors = array();
			} else {

				$criteria->add(ArtykulHasAutorPeer::ARTYKUL_ID, $this->artykul_id);

				$this->collArtykulHasAutors = ArtykulHasAutorPeer::doSelectJoinAutor($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(ArtykulHasAutorPeer::ARTYKUL_ID, $this->artykul_id);

			if (!isset($this->lastArtykulHasAutorCriteria) || !$this->lastArtykulHasAutorCriteria->equals($criteria)) {
				$this->collArtykulHasAutors = ArtykulHasAutorPeer::doSelectJoinAutor($criteria, $con, $join_behavior);
			}
		}
		$this->lastArtykulHasAutorCriteria = $criteria;

		return $this->collArtykulHasAutors;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collArtykulHasAutors) {
				foreach ((array) $this->collArtykulHasAutors as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collArtykulHasAutors = null;
			$this->aRubryka = null;
			$this->aPodrubryka = null;
			$this->aNumer = null;
	}

} // BaseArtykul
